;initialize all the other needed things

;initialize DirectDraw

		segment .data USE32

		dllname db "ddraw.dll",0
		functionname db "DirectDrawCreate",0

		segment .code USE32

		EXTERN LoadLibraryA
		IMPORT LoadLibraryA kernel32.dll
		EXTERN GetProcAddress
		IMPORT GetProcAddress kernel32.dll

		push dword dllname
		call [LoadLibraryA]
		push dword functionname
		push eax
		call [GetProcAddress]

		segment .data USE32

		 OurDirectDrawInterface   dd 0
		 OurPrimarySurface        dd 0
		 OurBackbufferSurface     dd 0

		segment .code USE32

;create a DirectDraw interface
		push dword 0
		push dword OurDirectDrawInterface
		push dword 0
		call eax
		or eax,eax ;success ?
		jnz near WM_QUIT_received

;setting up DirectDraw:

;you already know them: the macros for simplifying COM calling

		%macro DXfunction_ 2 
		 mov edi,[%1] ;edi = DD-Objekt(adresse)
		 mov edi,[edi]   ;edi = VTable(adresse)
		 mov edi,[edi+%2] ; callziel
		  push dword [%1]
		  call edi
		%endmacro

		%macro DXfunction 4 "Error" , "DirectX function failed" 
		 mov edi,[%1] ;edi = DD-Objekt(adresse)
		 mov edi,[edi]   ;edi = VTable(adresse)
		 mov edi,[edi+%2] ; callziel
		  push dword [%1]
		  call edi
		or eax,eax
		jz %%noerrmsg
		 push dword MB_ICONHAND + MB_OK
		 push dword %%MessageBoxTitle
	  	 push dword %%MessageBoxContent
		 push dword 0
		 call [MessageBoxA]
		 jmp WM_QUIT_received

		%%noerrmsg:

		segment .data USE32

		%%MessageBoxTitle:
		 db "DirectX Function Call Failed" ,0
		%%MessageBoxContent:
		 db %3, " : ", %4 ,0

		segment .code USE32

		%endmacro


;1. set the Cooperative Level (it is quite uncooperative for fullscreen). 

		push dword DDSCL_EXCLUSIVE + DDSCL_FULLSCREEN 
		push dword [Windowhandle]
		DXfunction OurDirectDrawInterface, DDSETCOOPERATIVELEVEL ,"OurDirectDrawInterface", "DDSETCOOPERATIVELEVEL"

;set needed video mode (only posible if DDSCL_EXCLUSIVE is set)
                push dword 0  ;no flag indicating standard mode 13hex (only useful for 320*200*8 mode)
                push dword 0  ;use std refresh rate (you may change this, but your monitor may not like it, so better use the default)
                push dword 32 ;32 bit mode
                push dword 480 ;y
                push dword 640 ;x
		DXfunction OurDirectDrawInterface, DDSETDISPLAYMODE ,"OurDirectDrawInterface", "DDSETDISPLAYMODE"

;2. create a primary surface with backbuffer

		segment .data USE32

		SurfaceDescription:
		times DDSURFACEDESC_size db 0

		segment .code USE32

;set up the DDSURFACEDESC structure for telling DirectDraw that a 
;PrimarySurface with a backbuffers (you may use 1 or 3 or 4 or ... as well) is needed 
		mov dword [SurfaceDescription+DDSURFACEDESC.dwSize],DDSURFACEDESC_size
		mov dword [SurfaceDescription+DDSURFACEDESC.ddssurfCaps],DDSCAPS_PRIMARYSURFACE + DDSCAPS_FLIP + DDSCAPS_COMPLEX
		mov dword [SurfaceDescription+DDSURFACEDESC.dwsurfFlags],DDSD_BACKBUFFERCOUNT + DDSD_CAPS
		mov dword [SurfaceDescription+DDSURFACEDESC.dwBackBufferCount], 2 ;triple buffering

		push dword 0
		push dword OurPrimarySurface
		push dword SurfaceDescription
		DXfunction OurDirectDrawInterface, DDCREATESURFACE, "OurDirectDrawInterface", "DDCREATESURFACE"

;get the backbuffer surface object (it was implicitly created with the front buffer)

		mov dword [SurfaceDescription+DDSURFACEDESC.ddssurfCaps], DDSCAPS_BACKBUFFER

		push dword OurBackbufferSurface
		push dword SurfaceDescription+DDSURFACEDESC.ddssurfCaps
		DXfunction OurPrimarySurface, DDSGETATTACHEDSURFACE, "OurDirectDrawInterface", "DDSGETATTACHEDSURFACE"


; alloc mem for storing the data (remember: coders art is the best ;-)

segment .data USE32

 mempos dd 0 ;position of system mem backbuffer
 
 file1 db "back.raw",0
 file2 db "sun.raw",0
 file3 db "moon.raw",0
 file4 db "boat.raw",0

 thisdoesnotinterestme dd 0

segment .code USE32


push dword  (640*480*4)*2+(64*64*4)*3  ;size of memory block requested
push dword LMEM_FIXED ;we need the memory now, so let win32 map it to a 
                      ;fixed position so that we can access it. In this
                      ;case, the function returns the pointer to the mem
call [LocalAlloc]
mov [mempos],eax

;load files (see rdfile_n.inc)

mov dword [filename],file1
mov dword [filesize],640*480*3
mov dword [buffrpos],640*480*5
call loadfile2mem
mov dword [filename],file2
mov dword [filesize],64*64*3
mov dword [buffrpos],(640*480*4)*2 + 64*64 
call loadfile2mem
mov dword [filename],file3
mov dword [filesize],64*64*3
mov dword [buffrpos],(640*480*4)*2 + 64*64*5
call loadfile2mem
mov dword [filename],file4
mov dword [filesize],64*64*3
mov dword [buffrpos],(640*480*4)*2 + 64*64*9
call loadfile2mem

; gfx loaded; copy back.raw 2 the mem backbuffer, convert 24->32bit

mov edi,[mempos]
lea esi,[edi+640*480*5]
mov ecx,640*480
wrpl:
 lodsd
 dec esi
 bswap eax
 shr eax,8
 mov [edi+640*480*4],eax
 stosd
dec ecx
jnz wrpl

mov edi,[mempos]
lea esi,[edi+(640*480*4)*2 + 64*64]
lea edi,[edi+(640*480*4)*2]
mov ecx,64*64
wrpl2:
 lodsd
 dec esi
 bswap eax
 shr eax,8
 stosd
dec ecx
jnz wrpl2

mov edi,[mempos]
lea esi,[edi+(640*480*4)*2 + 64*64*5]
lea edi,[edi+(640*480*4)*2 + 64*64*4]
mov ecx,64*64
wrpl3:
 lodsd
 dec esi
 bswap eax
 shr eax,8
 stosd
dec ecx
jnz wrpl3

mov edi,[mempos]
lea esi,[edi+(640*480*4)*2 + 64*64*9]
lea edi,[edi+(640*480*4)*2 + 64*64*8]
mov ecx,64*64
wrpl4:
 lodsd
 dec esi
 bswap eax
 shr eax,8
 stosd
dec ecx
jnz wrpl4



;calculate time between 2 refreshes
;note that this value does not calculate the time between to
;"real" refreshes, but the average (-> multitasking !) time between
;the refreshes with all drawing involved.

;if the threads are started just before determining the average
;time between 2 flips, the value will be too high due to the additional
;time the thread creation consumes
;If they are started after getting the time, we do not have the
;missing flips due to the running threads included, so the value will
;be too low.

call flippage
call flippage       ;for better accuracy
call [timeGetTime]  
 push eax            ;save time of 0st flip
 mov ecx,16
 measureloop:
  push ecx
  call updatescreen
  pop ecx
 dec ecx
 jnz measureloop 
 call [timeGetTime]
 mov ecx,eax         ;time of 16th flip 
 pop eax
 sub ecx,eax       ; ecx = time in milliseconds for 16 flips
xor edx,edx
mov eax,1000*128  ; get refreshes per second (128 = 1 sec)
div ecx           ; eax=refresh rate (in Hz) * 128 / 16
mov ecx,eax
xor eax,eax       ; calculate value to add for moving the sun sprite
mov edx,1         ; so that 4 sec = 1 cycle of movement 
div ecx           ; eax = value for 16 refreshes in ...
shl eax,7 -3 -2   ; -3 due to the multiplier 128/16 above, -2 wg. 4 sec
mov [addpos],eax

; start 1st thread

push dword thread1id
push dword 0           ;start thread immediately
push dword 0           ;a parameter for the thread (not used here)
push dword thread1loop ;the start of the threads code
push dword 0           ;default stack size (it grows if needed, remember ?)
push dword 0           ;security attributes ? nah, not here ;-]
call [CreateThread]
mov [thread1handle],eax

; start 2nd thread

push dword thread2id
push dword 0 ;start thread immediately
push dword 0 ;a parameter for the thread (not used here)
push dword thread2 ;the start of the threads code
push dword 0 ;default stack size (it grows if needed, remember ?)
push dword 0 ;security attributes ? nah, not here ;-]
call [CreateThread]
mov [thread2handle],eax

; start 3rd thread

push dword thread3id
push dword 0 ;start thread immediately
push dword 0 ;a parameter for the thread (not used here)
push dword thread34 ;the start of the threads code
push dword 0 ;default stack size (it grows if needed, remember ?)
push dword 0 ;security attributes ? nah, not here ;-]
call [CreateThread]
mov [thread3handle],eax

;start it again -> 4th thread , this is NOT a restart, but more like
;a duplicate of the thread execution environment

push dword thread4id
push dword 0 ;start thread immediately
push dword 0 ;a parameter for the thread (not used here)
push dword thread34 ;the start of the threads code
push dword 0 ;default stack size (it grows if needed, remember ?)
push dword 0 ;security attributes ? nah, not here ;-]
call [CreateThread]
mov [thread4handle],eax
