#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <ddraw.h>
#include <stdlib.h>

static IDirectDraw          *dd        = 0;
static IDirectDraw2         *dd2       = 0;
static IDirectDrawSurface   *ddSurface = 0;
static DWORD                 ThreadId  = 0;
static HWND                  WindowHandle;
static CRITICAL_SECTION      cr;


DWORD WINAPI mymain (void * argument);


void CloseDirectDraw (void)
{
        EnterCriticalSection (&cr);
        if (ddSurface)  ddSurface->Release();
        if (dd2)        dd2->Release();
        if (dd)         dd->Release();
        LeaveCriticalSection (&cr);
}


int InitDirectDraw (HWND Window, int width, int height, int bits)
{
        EnterCriticalSection (&cr);

        if (DirectDrawCreate (NULL, &dd, 0)!= DD_OK) goto error;

        if (dd->SetCooperativeLevel
                (Window, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN |
                 DDSCL_ALLOWREBOOT)!=DD_OK) goto error;

        if (dd->QueryInterface
                (IID_IDirectDraw2, (void **) &dd2)!=DD_OK) goto error;

        if (dd2->SetDisplayMode (width, height, bits, 0, 0)!=DD_OK)
            goto error;

        DDSURFACEDESC Surface;
        memset (&Surface, 0, sizeof (Surface));
        Surface.dwSize            = sizeof( Surface );
        Surface.dwFlags           = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
        Surface.dwBackBufferCount = 1;
        Surface.ddsCaps.dwCaps    = DDSCAPS_PRIMARYSURFACE |
                                    DDSCAPS_FLIP |
                                    DDSCAPS_COMPLEX;

        if (dd2->CreateSurface(&Surface, &ddSurface, 0)!=DD_OK) goto error;
        LeaveCriticalSection (&cr);
        return 1;

    error:
        LeaveCriticalSection (&cr);
        CloseDirectDraw();
        return 0;
}



long CALLBACK WindowProc( HWND hWnd, UINT message,
                          WPARAM wParam, LPARAM lParam )
{
    switch (message)
    {
        case WM_ACTIVATE:
          if (wParam== WA_ACTIVE)   ShowCursor (0);
          if (wParam== WA_INACTIVE) ShowCursor (1);
        break;

        case WM_PAINT:
          if (!dd)
          {
              InitDirectDraw (hWnd, 320, 240, 8);
              CreateThread (0, 0, mymain, 0, 0, &ThreadId);
          }
        break;

        case WM_DESTROY:
        case WM_KEYDOWN:
            PostQuitMessage( 0 );
        break;
    }
    return DefWindowProc( hWnd, message, wParam, lParam );
}




int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInst,
                   LPSTR lpCmdLine, int nCmdShow)
{
    InitializeCriticalSection (&cr);

    HINSTANCE instance = hInstance;

    WNDCLASS wc;
    memset (&wc, 0, sizeof (wc));
    wc.style         = CS_BYTEALIGNCLIENT;
    wc.lpfnWndProc   = WindowProc;
    wc.hInstance     = instance;
    wc.hbrBackground = (HBRUSH) GetStockObject (BLACK_BRUSH);
    wc.lpszClassName = "HugiSucks";
    RegisterClass( &wc );

    WindowHandle =
       CreateWindowEx( WS_EX_TOPMOST,                 // styleex
                       "HugiSucks",                   // classname
                       "",                            // caption (title)
                       WS_POPUP,                      // style
                       0,                             // left
                       0,                             // top
                       GetSystemMetrics(SM_CXSCREEN), // right
                       GetSystemMetrics(SM_CYSCREEN), // bottom
                       0,                             // parent window (none)
                       0,                             // menu (none)
                       instance,                      // instance handle
                       0 );                           // useless thing


    if (!WindowHandle) exit (1);
    ShowWindow( WindowHandle, SW_SHOW);


    MSG message;
    while ( GetMessage( &message, 0, 0, 0 ) )
    {
      TranslateMessage( &message );
      DispatchMessage( &message );
    }

    if (ThreadId)
      TerminateThread ((HANDLE) ThreadId, 0);

    CloseDirectDraw();
    UnregisterClass("HugiSucks", hInstance);
    return 0;
}



DWORD WINAPI mymain (void * argument)
{
    char * temp = new char[320*240];

    for (int frames=0; frames<3200; frames++)
    {
            // draw an ugly pattern...
            int i=0;
            for (int y=0; y<240; y++)
            for (int x=0; x<320; x++)
            {
                temp[i++] =((x+frames)^y);
            }

            // and show it..
            EnterCriticalSection (&cr);
            if (ddSurface->IsLost()!=DD_OK)
                    ddSurface->Restore();

            DDSCAPS caps;
            caps.dwCaps = DDSCAPS_BACKBUFFER;
            IDirectDrawSurface * backbuffer;
            ddSurface-> GetAttachedSurface(&caps, &backbuffer);

            if (backbuffer->IsLost()!=DD_OK)
               backbuffer->Restore();

            DDSURFACEDESC sd;
            memset (&sd, 0, sizeof (DDSURFACEDESC));
            sd.dwSize = sizeof (sd);
            backbuffer->Lock (0, &sd, DDLOCK_SURFACEMEMORYPTR  | DDLOCK_WAIT ,0);

            char  *source = (char *) test;
            char  *dest   = (char *) sd.lpSurface;

            for (register int y=0; y<240; y++)
            {
                      memcpy (dest, source, 320);
                      dest   += sd.lPitch;
                      source += 320;
            }

            backbuffer->Unlock (sd.lpSurface);
            ddSurface->Flip (0, DDFLIP_WAIT );
            LeaveCriticalSection (&cr);

    }
    SendMessage (WindowHandle, WM_CLOSE, 0, 0);
    return 0;
}

