;----------------------------------------------------------------------------
;Mdok:         0       320x175                 6       360x175
;               1       320x200                 7       360x200
;               2       320x240                 8       360x240
;               3       320x350                 9       360x350
;               4       320x400                 a       360x400
;               5       320x480                 b       360x480
;
;Vltozik:              AX,BX,CX,DX,SI,DI,ES, nhny flag s sok-sok
;                       VGA regiszter.
;
;Az eredeti program rja:                (C) 8-02-1992 Per Ole Klemetsrud
;                                         Hertug Skulesgt. 15c
;                                         0652 Oslo, Norway
;
;Fordtotta s kiegsztette:             Klmn Tams a.k.a. Derceto/Unicorn
;                                         (cmem a The Guide-ban)
;
;----------------------------------------------------------------------------
model   small,pascal
        .code
PUBLIC  GuruMode
GuruMode        proc    near     mode:byte         ;MODE-ben a md szma
        mov     bl,mode         ;ez most BL-be kerl
        mov     bh,0
        mov     ax,0013h
        int     10h             ;Elszr 13h (320*200*256) mdba vltunk

        mov     dx,03c4h        ;Sequencer Register
        mov     cl,[clocktab+bx]   ;cl-be a clocktab megfelel rtke
        cmp     cl,00h          ;Szksg van-e reset-re?
        je      Skip_Reset      ;320*200-nl ill. 320*400-nl nincs

        mov     ax,0100h        ;3c4h port, index 0, (Reset Register)
        out     dx,ax           ;alapllapotba llts

        mov     dx,3c2h         ;Miscellaneous output register
        mov     al,cl           ;cl-be a clocktab-tmb mdnak megfelel
        out     dx,al           ;eleme van

        mov     dx,3c4h         ;Sequencer register 3c4h
        mov     ax,0300h        ;Index 0, (Reset Register)
        out     dx,ax           ;alapllapot megszntetse
Skip_Reset:
        mov     ax,0604h        ;Index 4, Chain 4 feloldsa (a 3. bit 0 lesz)
        out     dx,ax

        mov     ax,0a000h       ;itt most trljk a videobuffert, hogy
        mov     es,ax           ;vltskor ne villanjon, vagy szemeteljen
        xor     di,di           ;
        xor     ah,ah           ;ES:DI=Video Ram, AX=0000
        mov     cx,(0ffffh/2)   ;a teljes video ram = ffff/2 word = 64000 byte
rep     stosw

        mov     dx,03d4h        ;CRT controller regiszterek feltltse
        mov     si,offset [Regtab]
        mov     cx,3
        cmp     bl,5            ;ha a md kisebb vagy egyenl 5-tel,
        jbe     CRT1            ;(320 pixel szles) akkor vzszintes llts
        mov     cx,10           ;nem szksges (3 regisztert kell vltoztatni,
CRT1:   lodsw                   ;egybknt 10-et)
        out     dx,ax
        loop    CRT1            ;szp sorban mindet (ah=rtk, al=index)

        shl     bx,1            ;Most BX-ktszerese kell, mert word-re mutat
        mov     si,[vertab+bx]  ;vertab-tmb mdnak megfelel elemt SI-be
        cmp     si,0            ;ha SI 0 (200 soros mdok) akkor
        je      finish          ;nem kell tbb vltoztats
        cmp     si,1            ;ha SI 1 (400 soros mdok) akkor
        je      Set400          ;csak a dualscan-t kell kikapcsolni

        mov     cx,8            ;CRT controller regiszterek feltltse
CRT2:   lodsw                   ;a fggleges felbonts rtkeivel
        out     dx,ax           ;(8 db regiszter)
        loop    CRT2
finish: ret                     ;kszen is vagyunk

Set400: mov     ax,04009h       ;a pixel csak 1 scanline magas
        out     dx,ax
        ret                     ;kszen is vagyunk
GuruMode        endp

        .data
Regtab  label   word
        dw      00e11h          ;Index 11, rsvdelem kikapcsolsa
        dw      00014h          ;Index 14, dword-md kikapcsolsa
        dw      0e317h          ;Index 17, byte-md bekapcsolsa
;----------------------------------------------------------------------------
;Adat a CRT controllernek a vzszintes 360 pixel belltshoz.
;----------------------------------------------------------------------------
        db      00h,06bh        ;Horizontal Total               107
        db      01h,059h        ;Horizontal Display End          89
        db      02h,05ah        ;Start Horizontal Blanking       90
        db      03h,08eh        ;End Horizontal Blanking
        db      04h,05eh        ;Start Horizontal Retrace        94
        db      05h,08ah        ;End Horizontal Retrace
        db      13h,02dh        ;Offset register                 90

;----------------------------------------------------------------------------
;Adat a CRT controllernek a 480 scanline belltsra, amit eredetileg
;a 12h BIOS md hasznl (640*480). A 240-es md ennek a doublescan-je.
;----------------------------------------------------------------------------
vert480 label   word
        db      009h,01000000b  ;Maximum Scan Line                0
        db      007h,00111110b  ;Overflow register
        db      006h,00bh       ;Vertical Total                 523
        db      010h,0eah       ;Vertical Retrace Start         490
        db      011h,08ch       ;Vertical Retrace End
        db      015h,0e7h       ;Start Vertical Blanking        487
        db      016h,004h       ;End Vertical Blanking
        db      012h,0dfh       ;Vertical Display End           479
        db      012h,0dfh       ;Safe dummy for neat program flow
;----------------------------------------------------------------------------
;Adat a CRT controllernek a 350 scanline belltsra, amit eredetileg
;a 10h BIOS md hasznl (640*350). A 175-s md ennek a doublescan-je.
;----------------------------------------------------------------------------
vert350 label   word
        db      009h,01000000b  ;Maximum Scan Line                0
        db      007h,00011111b  ;Overflow register
        db      006h,0bfh       ;Vertical Total                 447
        db      010h,083h       ;Vertical Retrace Start         387
        db      011h,085h       ;Vertical Retrace End
        db      015h,063h       ;Start Vertical Blanking        355
        db      016h,0bah       ;End Vertical Blanking
        db      012h,05dh       ;Vertical Display End           349
        db      012h,05dh       ;Safe dummy for neat program flow
;----------------------------------------------------------------------------
;Sync polarities and horizontal clock frequencies for the different modes
;----------------------------------------------------------------------------
clocktab        label   byte
        db      0a3h, 000h, 0e3h, 0a3h, 000h, 0e3h
        db      0a7h, 067h, 0e7h, 0a7h, 067h, 0e7h

vertab  dw      vert350+2,0000h, vert480+2, vert350, 0001h, vert480
        dw      vert350+2,0000h, vert480+2, vert350, 0001h, vert480

END