unit VideoManager;  { 1995/01/26 }

{ verzi: 1.1    (c) Nmeth Akos 1995

  1995/02/04:    80386-os utastsok beptse, de mkdik 80286-oson is
                 palettaeljrsok a tbbszrsre gyorstva              }

interface

uses Crt;

type
  PalType = Array[0..255] of Array[0..2] of Byte;
  PPalType = ^PalType;
var
  GraphicsOn: Boolean;
  SavedVideoMode: Byte;
  Buffer: Pointer;
  BufSeg: Word;
  Font: Pointer;
  FontSeg,
  FontOfs: Word;

function GetBlockWidth(P: Pointer): Byte;
function GetBlockHeight(P: Pointer): Byte;
procedure PutBlock(X, Y: Integer; P: Pointer);
procedure InitGraph;
Procedure CloseGraph;
procedure PutPixel(X, Y: Integer; Color: Byte);
function GetPixel(X, Y: Integer): Byte;
procedure SetPalette(Number, Red, Green, Blue: Byte);
procedure GetPalette(Number: Byte; var Red, Green, Blue: Byte);
procedure SetAllPalette(Palette: Pointer);
procedure GetAllPalette(Palette: Pointer);
procedure ClearBuffer;
procedure CopyBuffer;
procedure NewCopy;
procedure Error(S: String);
procedure VLine(X, Y, Y1: Integer; Color: Byte);
procedure HLine(X, Y, X1: Integer; Color: Byte);
procedure Line(X1, Y1, X2, Y2, Color: Integer);
procedure PutChar(X, Y: Integer;Color: Byte; C: Char);
procedure PutString(X, Y: Integer; C: Byte; S: String);
procedure SetCharType(P: Pointer);
procedure HALFFAT;
procedure SIMPLE;
procedure Box(X, Y, X1, Y1: Integer; Color: Byte);
procedure Bar(X, Y, X1, Y1: Integer; Color: Byte);
function Adj(P: Pointer):Pointer;
function IsVGA: Boolean;

implementation

procedure PutChar(X, Y: Integer;Color: Byte; C: Char); assembler;
{7 * 8 - as keszlet }
var
  RealX,
  RealY: Integer;
  AddPointer: Integer;
  FontPointer: Byte;
  BeginX,
  BeginY,
  FinishX,
  FinishY: Byte;
asm
       CMP X, -7
       JLE @@7
       CMP Y, -8
       JLE @@7
       CMP X, 319
       JGE @@7
       CMP Y, 200
       JGE @@7
       MOV ADDPOINTER, 320
       MOV BEGINX, 0
       MOV BEGINY, 0
       MOV FINISHX, 7
       MOV FINISHY, 8
       MOV AX, X
       MOV REALX, AX
       MOV AX, Y
       MOV REALY, AX
       CMP X, 0
       JGE @@4
       MOV REALX, 0
       MOV AX, 0
       SUB AX, X
       MOV BEGINX, AL
@@4:   CMP Y, 0
       JGE @@5
       MOV REALY, 0
       MOV AX, 0
       SUB AX, Y
       MOV BEGINY, AL
@@5:   MOV AX, X
       ADD AX, 7
       CMP AX, 319
       JLE @@8
       MOV BX, 319
       SUB BX, X
       MOV FINISHX, BL
@@8:   MOV AX, Y
       ADD AX, 8
       CMP AX, 199
       JLE @@6
       MOV BX, 200
       SUB BX, Y
       MOV FINISHY, BL
@@6:   MOV AL, FINISHX
       SUB AL, BEGINX
       MOV FONTPOINTER, AL
       MOV AH, 0
       MOV BX, 320
       SUB BX, AX
       MOV ADDPOINTER, BX
       PUSH DS
       MOV AX, BufSeg
       MOV ES, AX
       MOV AX, 320
       MUL REALY
       ADD AX, REALX
       MOV DI, AX
       XOR AX, AX
       MOV AL, C
       MOV CX, 8
       MUL CX
       ADD AX, FONTOFS
       MOV SI, AX
       MOV AX, FONTSEG
       MOV DS, AX
       MOV DL, BEGINY
       XOR CX, CX
       MOV CL, DL
       ADD SI, CX
@@1:   MOV DH, BEGINX
       MOV AL, [SI]
       CMP BEGINX, 0
       JE @@3
       MOV CL, BEGINX
       SHL AL, CL
@@3:   SHL AL, 1
       JNC @@2
       MOV CH, COLOR
       MOV BYTE PTR ES:[DI], CH
@@2:   INC DI
       INC DH
       CMP DH, FINISHX
       JNAE @@3
       INC DL
       INC SI
       ADD DI, ADDPOINTER
       CMP DL, FINISHY
       JNE @@1
       POP DS
@@7:
end;

procedure PutString(X, Y: Integer; C: Byte; S: String);
var
  I: Integer;
begin
  For I := 0 to Length(S) - 1 do
    PutChar(X + I * 7, Y, C, S[I + 1]);
end;

procedure InitGraph;
var I: Integer;
begin
  asm
    MOV AX, $0F00
    INT $10
    MOV SavedVideoMode, AL
    MOV AL, $13
    MOV AH, $00
    INT $10
  end;
  Buffer := nil;
  GraphicsOn := true;
  GetMem(Buffer, 64000);
  If Buffer = nil then Error('InitGraph: Not enough memory to allocate system buffer');
  BufSeg := Seg(Buffer^);
end;

Procedure CloseGraph;
begin
  asm
    MOV AH, $00
    MOV AL, SavedVideoMode
    INT $10
  end;
  GraphicsOn := false;
  If Buffer <> nil then FreeMem(Buffer, 64000);
end;

procedure Error(S: String);
begin
  If GraphicsOn then CloseGraph;
  WriteLn(S + ', program halted');
  Halt;
end;

function GetBlockWidth(P: Pointer): Byte; assembler;
asm
    MOV ES, [BP+08]
    MOV DI, [BP+06]
    MOV AL, ES:[DI]
end;

function GetBlockHeight(P: Pointer): Byte; assembler;
asm
    MOV ES, [BP+08]
    MOV DI, [BP+06]
    INC DI
    MOV AL, ES:[DI]
end;

procedure PutBlock(X, Y: Integer; P: Pointer); assembler;
var
  BlockSeg: Word;
  BlockOfs: Word;
  BlockWidth: Byte;
  BlockHeight: Byte;
  AddPointer,
  AddPointer2: Word;
  Width,
  BeginX,
  BeginY,
  FinishX,
  FinishY: Byte;
  Temp: Word;
  X1,
  Y1: Integer;
  RealX,
  RealY: Word;
  RealOfs: Word;
  RealAddr: Word;
asm
     LES SI, P
     MOV AL, ES:[SI]
     MOV BLOCKWIDTH, AL
     INC SI
     MOV AL, ES:[SI]
     MOV BLOCKHEIGHT, AL
     MOV BLOCKSEG, ES
     INC SI
     MOV BLOCKOFS, SI
     CMP X, 320
     JGE @@8
     CMP Y, 200
     JGE @@8
     XOR AX, AX
     MOV AL, BLOCKWIDTH
     ADD AX, X
     MOV X1, AX
     CMP AX, 0
     JNG @@8
     XOR AX, AX
     MOV AL, BLOCKHEIGHT
     ADD AX, Y
     MOV Y1, AX
     CMP AX, 0
     JNG @@8
     MOV AX, X
     MOV REALX, AX
     MOV BEGINX, 0
     MOV BEGINY, 0
     CMP X, 0
     JGE @@4
     MOV AX, X
     MOV TEMP, 0
     SUB TEMP, AX
     MOV AX, TEMP
     MOV BEGINX, AL
     MOV REALX, 0
@@4: MOV AX, Y
     MOV REALY, AX
     CMP Y, 0
     JGE @@5
     MOV AX, Y
     MOV TEMP, 0
     SUB TEMP, AX
     MOV AX, TEMP
     MOV BEGINY, AL
     MOV REALY, 0
@@5: MOV AL, BLOCKWIDTH
     MOV FINISHX, AL
     CMP X1, 320
     JNA @@6
     MOV AX, 320
     MOV BX, X
     SUB AX, BX
     MOV FINISHX, AL
@@6: MOV AL, BLOCKHEIGHT
     MOV FINISHY, AL
     CMP Y1, 200
     JNA @@7
     MOV AX, 200
     MOV BX, Y
     SUB AX, BX
     MOV FINISHY, AL
@@7: XOR AX, AX
     MOV AL, BLOCKWIDTH
     XOR BX, BX
     MOV BL, BEGINY
     MUL BX
     XOR BX, BX
     MOV BL, BEGINX
     ADD AX, BX
     ADD AX, BLOCKOFS
     MOV REALOFS, AX
     MOV BL, FINISHX
     SUB BL, BEGINX      { VALOSSZELESSEG KISZAMITASA }
     MOV ADDPOINTER, 320
     XOR AX, AX
     MOV AL, BL
     SUB ADDPOINTER, AX
     XOR CX, CX
     MOV CL, BLOCKWIDTH
     SUB CL, BL
     MOV ADDPOINTER2, CX
     MOV AX, 320         { BLOCK ELSO KEPERNYOPONTJANAK OFFSETTCIMENEK KISZAMITASA }
     MUL REALY
     ADD AX, REALX
     MOV DI, AX
     MOV AX, BUFSEG
     MOV ES, AX          { ES:DI = AZ ELSO PONT MEMORIACIME }
     MOV AH, BEGINX      { AH = OSZLOPMUTATO INICIALIZALASA }
     MOV BH, BEGINY      { BH = SORMUTATO INICIALIZALASA }
     MOV SI, REALOFS
     MOV BL, FINISHX
     MOV CL, BEGINX
     MOV CH, FINISHY
     MOV DX, ADDPOINTER
     PUSH DS
     PUSH BLOCKSEG
     POP DS              { DS:SI = BLOKK ELSO PONTJANAK MEMORIACIME ,
                           EZUTAN VALTOZOT NEM LEHET HASZNALNI, MERT
                           DS ELALLITODOTT }
     CLD                 { MOVSB - NEL SI, DI NOVEKSZIK }
@@1: MOV AL, [SI]        { AKTUALIS BLOKK - PONT }
     CMP AL, 0           { FEKETE ? - ITT ATLLATSZO A BLOKK }
     JE @@3              { IGEN, KIHAGYJUK A MASOLAST }
     MOVSB               { NEM, BLOKK PONT MASOLASA }
     JMP @@2             { KIHAGYJUK A NOVELEST }
@@3: INC SI              { MIVEL NEM VOLT MOVSB, NOVELJUK SI, DI - T }
     INC DI
@@2: INC AH              { OSZLOPMUTATO NOVELESE }
     CMP AH, BL          { OSZLOPMUTATO ELERTE A MAXIMUMOT ? }
     JNe @@1             { NEM, UJABB PONT MASOLASA }
     MOV AH, CL          { IGEN, A KOV. SOR BEALLITASSA }
     ADD DI, DX          { DI A KOV KEPERNYOSORRA ALL }
     ADD SI, ADDPOINTER2
     INC BH              { SORMUTATIO NOVELESE }
     CMP BH, CH          { SORMUTATO ELERTE A MAXIMUMOT ? }
     JNE @@1             { NEM, UJABB SOR MASOLASA }
     POP DS              { IGEN, DS VISSZAALLITASA }
@@8:
end;

procedure SetPalette(Number, Red, Green, Blue: Byte); assembler;
asm
    MOV DX, $03C8
    MOV AL, NUMBER
    OUT DX, AL
    INC DX
    MOV AL, RED
    OUT DX, AL
    MOV AL, GREEN
    OUT DX, AL
    MOV AL, BLUE
    OUT DX, AL
end;

procedure GetPalette(Number: Byte; var Red, Green, Blue: Byte); assembler;
asm
    MOV DX, $03C7
    MOV AL, NUMBER
    OUT DX, AL
    MOV DX, $03C9
    IN AL, DX
    LES DI, RED
    MOV ES:[DI], AL
    IN AL, DX
    LES DI, GREEN
    MOV ES:[DI], AL
    IN AL, DX
    LES DI, BLUE
    MOV ES:[DI], AL
end;

procedure SetAllPalette(Palette: Pointer); assembler;
asm
     PUSH DS
     MOV DX, $03C8
     XOR AL, AL
     OUT DX, AL
     INC DX
     LDS SI, PALETTE
     MOV CX, 768
     CLD
     REP OUTSB
     POP DS
end;

procedure GetAllPalette(Palette: Pointer); assembler;
asm
    MOV DX, $03C7
    XOR AL, AL
    OUT DX, AL
    MOV DX, $03C9
    LES DI, PALETTE
    MOV CX, 768
    CLD
    REP INSB
end;

procedure ClearBuffer; assembler;
asm
     CLD
     MOV AX, BUFSEG
     MOV ES, AX
     XOR AX, AX
     MOV DI, 0
     CMP TEST8086, 2
     JE @@386
     MOV CX, 32000
     REP STOSW
     RET
@@386:
     db 66h
     XOR AX, AX
     MOV CX, 16000
     DB 66H
     REP STOSW
end;

procedure CopyBuffer; assembler;
asm
         MOV DX, $3DA
@@1:     IN AL, DX
         TEST AL, $08
         JNE @@1
@@2:     IN AL, DX
         TEST AL, $08
         JE @@2
         PUSH DS
         MOV AX, BUFSEG
         MOV DS, AX
         MOV SI, 0
         MOV AX, $A000
         MOV ES, AX
         MOV DI, 0
         CLD
         CMP TEST8086, 2
         JE @@386
         MOV CX, 32000
         REP MOVSW
         POP DS
         RET
@@386:   MOV CX, 16000
         DB 66H        { MOVSD 386-os utasts}
         REP MOVSW
         POP DS
end;

procedure NewCopy; assembler;
asm
        MOV DX, $3DA
@@1:    IN AL, DX
        TEST AL, $08
        JNE @@1
@@2:    IN AL, DX
        TEST AL, $08
        JE @@2
        PUSH DS
        CLD
        MOV AX, $A000
        MOV ES, AX
        XOR DI, DI
        XOR SI, SI
        MOV AX, BUFSEG
        MOV DS, AX
        MOV CX, 16000
@SCAN:  XOR AL, AL
        DB 66h
        REPZ CMPSW
        JZ @EXIT
        MOV AX, SI
        MOV BX, DI
        SUB SI, 4
        SUB DI, 4
        DB 66h
        MOVSW
        MOV SI, AX
        MOV DI, BX
        JMP @SCAN
@EXIT:  POP DS
end;


procedure PutPixel(X, Y: Integer; Color: Byte); assembler;
asm
    CMP X, 319
    JA @@END
    CMP Y, 199
    JA @@END
    MOV AX, 320    { pont cme = Y * 320 + X }
    MUL Y
    ADD AX, X
    PUSH DS
    MOV BX, BUFSEG
    MOV DS, BX
    MOV BX, AX
    MOV AL, COLOR
    MOV [BX], AL   { pont kirsa }
    POP DS
@@END:
end;

function GetPixel(X, Y: Integer): Byte; assembler;
asm
    XOR AL, AL
    CMP X, 319
    JA @@END
    CMP Y, 199
    JA @@END
    MOV AX, 320    { pont cme = Y * 320 + X }
    MUL Y
    ADD AX, X
    PUSH DS
    MOV BX, BUFSEG
    MOV DS, BX
    MOV BX, AX
    MOV AL, [BX]   { pont beolvassa }
    POP DS
@@END:
end;

procedure HLine(X, Y, X1: Integer; Color: Byte); assembler;
var
  LineLength: Word;
asm
      CMP Y, 0
      JL @@2
      CMP Y, 199
      JG @@2
      MOV AX, X
      CMP AX, X1
      JL @@1
      XCHG AX, X1
      MOV X, AX
@@1:  CMP X1, 0
      JL @@2
      CMP X, 0
      JG @@3
      MOV X, 0
@@3:  CMP X1, 319
      JL @@4
      MOV X1, 319
@@4:  MOV AX, X1
      SUB AX, X
      MOV LINELENGTH, AX
      MOV AX, 320    { pont cime = Y * 320 + X }
      MUL Y
      ADD AX, X
      MOV BX, BufSeg
      MOV ES, BX
      MOV BX, AX
      MOV CX, 0
      MOV AL, COLOR
@@5:  MOV ES:[BX], AL   { pont kiirasa }
      INC BX
      INC CX
      CMP CX, LINELENGTH
      JNA @@5
@@2:
end;

procedure VLine(X, Y, Y1: Integer; Color: Byte); assembler;
var
  LineLength: Word;
asm
      CMP X, 0
      JL @@2
      CMP X, 319
      JG @@2
      MOV AX, Y
      CMP AX, Y1
      JL @@1
      XCHG AX, Y1
      MOV Y, AX
@@1:  CMP Y1, 0
      JL @@2
      CMP Y, 0
      JG @@3
      MOV Y, 0
@@3:  CMP Y1, 199
      JL @@4
      MOV Y1, 199
@@4:  MOV AX, Y1
      SUB AX, Y
      MOV LINELENGTH, AX
      MOV AX, 320    { pont cime = Y * 320 + X }
      MUL Y
      ADD AX, X
      MOV BX, BufSeg
      MOV ES, BX
      MOV BX, AX
      MOV CX, 0
      MOV AL, COLOR
@@5:  MOV ES: [BX], AL   { pont kiirasa }
      ADD BX, 320
      INC CX
      CMP CX, LINELENGTH
      JNA @@5
@@2:
end;

procedure Line(X1, Y1, X2, Y2, Color: Integer); assembler;
var
  I,
  L,
  _Dx,
  _Dy,
  N,
  M: integer;
asm
     MOV AX, X2
     SUB AX, X1
     CMP AX, 0
     JG @@1
     MOV BX, 0
     SUB BX, AX
     XCHG AX, BX
@@1: MOV _DX, AX
     MOV AX, Y2
     SUB AX, Y1
     CMP AX, 0
     JG @@2
     MOV BX, 0
     SUB BX, AX
     XCHG AX, BX
@@2: MOV _DY, AX
     PUSH X1
     PUSH Y1
     PUSH Color
     CALL PUTPIXEL
     MOV AX, Y1
     CMP AX, Y2
     JL @@3
     MOV N, -1
     JMP @@4
@@3: MOV N, 1
@@4: MOV AX, X1
     CMP AX, X2
     JL @@5
     MOV M, -1
     JMP @@6
@@5: MOV M, 1
@@6: CMP _DX, 0
     JNE @@7
     CMP _DY, 0
     JNE @@7
     JMP @@EXIT
@@7: CMP _DY, 0
     JNE @@VERTICALLINE
     MOV AX, X1
     CMP AX, X2
     JL @@8
     XCHG AX, X2
     MOV X1, AX
@@8: MOV CX, 0
@@9: PUSH X1
     PUSH Y1
     PUSH Color
     CALL PUTPIXEL
     INC X1
     INC CX
     CMP CX, _DX
     JL @@9
     JMP @@EXIT

@@VerticalLine:
     CMP _DX, 0
     JNE @@XCROSSLINE
     MOV AX, Y1
     CMP AX, Y2
     JL @@10
     XCHG AX, Y2
     MOV Y1, AX
@@10:MOV CX, 0
@@11:PUSH X1
     PUSH Y1
     PUSH Color
     CALL PUTPIXEL
     INC CX
     INC Y1
     CMP CX, _DY
     JLE @@11
     JMP @@EXIT

@@XCrossLine:
     MOV AX, _DX
     CMP AX, _DY
     JL @@YCROSSLINE
     MOV AX, _DX
     SHR AX, 1
     MOV I, AX
     MOV L, 0
@@12:MOV AX, I
     ADD AX, _DY
     MOV I, AX
     MOV AX, _DX
     CMP AX, I
     JG @@13
     MOV AX, I
     SUB AX, _DX
     MOV I, AX
     MOV AX, Y1
     ADD AX, N
     MOV Y1, AX
@@13:MOV AX, X1
     ADD AX, M
     MOV X1, AX
     PUSH X1
     PUSH Y1
     PUSH Color
     CALL PUTPIXEL
     INC L
     MOV AX, L
     CMP AX, _DX
     JL @@12
     JMP @@EXIT

@@YCrossLine:
     MOV AX, _DY
     CMP AX, _DX
     JL @@EXIT
     MOV AX, _DY
     SHR AX, 1
     MOV I, AX
     MOV L, 0
@@14:MOV AX, I
     ADD AX, _DX
     MOV I, AX
     MOV AX, _DY
     CMP AX, I
     JG @@15
     MOV AX, I
     SUB AX, _DY
     MOV I, AX
     MOV AX, X1
     ADD AX, M
     MOV X1, AX
@@15:MOV AX, Y1
     ADD AX, N
     MOV Y1, AX
     PUSH X1
     PUSH Y1
     PUSH Color
     CALL PUTPIXEL
     INC L
     MOV AX, L
     CMP AX, _DY
     JL @@14
@@EXIT:
end;

procedure Bar(X, Y, X1, Y1: Integer; Color: Byte);
var
  I: Integer;
begin
  For I := Y to Y1 do
    HLine(X, I, X1, Color);
end;

procedure Box(X, Y, X1, Y1: Integer; Color: Byte);
begin
  HLine(X, Y, X1, Color);
  HLine(X, Y1, X1, Color);
  VLine(X, Y, Y1, Color);
  VLine(X1, Y, Y1, Color);
end;

procedure SetCharType(P: Pointer); assembler;
asm
    LES SI, P
    MOV FONTSEG, ES
    MOV FONTOFS, SI
end;

function IsVGA: Boolean; assembler;
asm
    MOV AX, $1A00
    INT $10
    CMP AL, $1A
    JNE @@NOVGA
    MOV AL, TRUE
    JMP @@END
@@NOVGA:
    MOV AL, FALSE
@@END:
end;

procedure HALFFAT;
begin
 Inline($38/$44/$9A/$A2/$A2/$9A/$44/$38/$7E/$81/$A5/$81/$A5/$99/$81/$7E/$7E/
    $FF/$DB/$FF/$E7/$DB/$FF/$7E/$6C/$FE/$FE/$FE/$7C/$38/$10/$00/$10/$38/$7C/
    $FE/$7C/$38/$10/$00/$38/$7C/$38/$FE/$38/$7C/$44/$C6/$10/$38/$7C/$FE/$7C/
    $38/$7C/$00/$00/$00/$18/$3C/$3C/$18/$00/$00/$FF/$FF/$E7/$C3/$C3/$E7/$FF/
    $FF/$00/$3C/$66/$42/$42/$66/$3C/$00/$FF/$C3/$99/$BD/$BD/$99/$C3/$FF/$07/
    $03/$05/$78/$84/$84/$84/$78/$38/$44/$44/$44/$38/$10/$7C/$10/$3E/$22/$3E/
    $20/$20/$60/$E0/$C0/$7E/$42/$7E/$42/$42/$46/$C6/$C0/$92/$54/$38/$EE/$38/
    $54/$92/$00/$80/$E0/$F8/$FE/$F8/$E0/$80/$00/$02/$0E/$3E/$FE/$3E/$0E/$02/
    $00/$10/$38/$7C/$10/$10/$7C/$38/$10/$CC/$CC/$CC/$CC/$CC/$00/$CC/$00/$7E/
    $DA/$DA/$7A/$1A/$1A/$1A/$00/$3E/$63/$38/$6C/$6C/$38/$CC/$78/$00/$00/$00/
    $00/$7E/$7E/$7E/$00/$10/$38/$7C/$10/$7C/$38/$10/$00/$10/$38/$7C/$FE/$10/
    $10/$10/$00/$10/$10/$10/$FE/$7C/$38/$10/$00/$10/$18/$1C/$FE/$1C/$18/$10/
    $00/$10/$30/$70/$FE/$70/$30/$10/$00/$00/$00/$80/$80/$80/$FE/$00/$00/$00/
    $24/$66/$FF/$66/$24/$00/$00/$00/$10/$38/$7C/$FE/$00/$00/$00/$00/$00/$FE/
    $7C/$38/$10/$00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$38/$38/$38/$38/$38/
    $00/$38/$00/$EC/$EC/$EC/$00/$00/$00/$00/$00/$6C/$6C/$FE/$6C/$FE/$6C/$6C/
    $00/$30/$7C/$C0/$78/$04/$F8/$30/$00/$00/$C6/$0C/$18/$30/$60/$CC/$00/$38/
    $44/$28/$72/$94/$88/$76/$00/$38/$38/$70/$00/$00/$00/$00/$00/$38/$70/$E0/
    $E0/$E0/$70/$38/$00/$E0/$70/$38/$38/$38/$70/$E0/$00/$CC/$78/$30/$FC/$30/
    $78/$CC/$00/$00/$30/$30/$FC/$30/$30/$00/$00/$00/$00/$00/$00/$00/$38/$38/
    $70/$00/$00/$00/$FC/$00/$00/$00/$00/$00/$00/$00/$00/$00/$38/$38/$00/$06/
    $0C/$18/$30/$60/$C0/$00/$00/$78/$EC/$EC/$EC/$EC/$EC/$78/$00/$38/$78/$38/
    $38/$38/$38/$38/$00/$78/$CC/$0C/$18/$70/$E0/$FC/$00/$F8/$0C/$0C/$38/$0C/
    $0C/$F8/$00/$1C/$3C/$6C/$EC/$FC/$0C/$0C/$00/$FC/$E0/$E0/$F8/$0C/$0C/$F8/
    $00/$38/$70/$E0/$F8/$EC/$EC/$78/$00/$FC/$CC/$0C/$18/$30/$30/$30/$00/$78/
    $EC/$EC/$78/$EC/$EC/$78/$00/$78/$EC/$EC/$7C/$0C/$18/$70/$00/$00/$38/$38/
    $00/$00/$38/$38/$00/$00/$38/$38/$00/$38/$38/$70/$00/$1C/$38/$70/$E0/$70/
    $38/$1C/$00/$00/$00/$FC/$00/$00/$FC/$00/$00/$E0/$70/$38/$1C/$38/$70/$E0/
    $00/$78/$EC/$0C/$18/$30/$00/$30/$00/$78/$84/$9C/$A8/$BC/$80/$78/$00/$30/
    $78/$EC/$EC/$FC/$EC/$EC/$00/$F8/$EC/$EC/$F8/$EC/$EC/$F8/$00/$78/$EC/$E0/
    $E0/$E0/$EC/$78/$00/$F0/$E8/$EC/$EC/$EC/$E8/$F0/$00/$FC/$E0/$E0/$F0/$E0/
    $E0/$FC/$00/$FC/$E0/$E0/$F0/$E0/$E0/$E0/$00/$78/$EC/$E0/$E0/$EC/$E4/$78/
    $00/$EC/$EC/$EC/$FC/$EC/$EC/$EC/$00/$38/$38/$38/$38/$38/$38/$38/$00/$1C/
    $1C/$1C/$1C/$1C/$DC/$78/$00/$E4/$E8/$F0/$E0/$F0/$E8/$E4/$00/$E0/$E0/$E0/
    $E0/$E0/$E0/$F8/$00/$C4/$EC/$FC/$FC/$EC/$EC/$EC/$00/$CC/$EC/$FC/$EC/$EC/
    $EC/$EC/$00/$78/$EC/$EC/$EC/$EC/$EC/$78/$00/$F8/$EC/$EC/$F8/$E0/$E0/$E0/
    $00/$78/$EC/$EC/$EC/$FC/$78/$08/$00/$F8/$EC/$EC/$F8/$F8/$EC/$E6/$00/$78/
    $EC/$E0/$78/$0C/$EC/$78/$00/$7C/$38/$38/$38/$38/$38/$38/$00/$EC/$EC/$EC/
    $EC/$EC/$EC/$78/$00/$EC/$EC/$EC/$EC/$EC/$68/$30/$00/$EC/$EC/$EC/$EC/$FC/
    $CC/$84/$00/$00/$E4/$78/$30/$30/$78/$E4/$00/$EC/$EC/$EC/$78/$30/$30/$30/
    $00/$FC/$0C/$1C/$78/$E0/$C0/$FC/$00/$78/$70/$70/$70/$70/$70/$78/$00/$C0/
    $E0/$70/$38/$1C/$0C/$00/$00/$78/$38/$38/$38/$38/$38/$78/$00/$30/$78/$E4/
    $00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$FC/$20/$20/$10/$00/$00/
    $00/$00/$00/$00/$00/$78/$1C/$7C/$DC/$7C/$00/$E0/$E0/$F8/$EC/$EC/$EC/$F8/
    $00/$00/$00/$78/$EC/$E0/$EC/$78/$00/$0C/$0C/$7C/$EC/$EC/$EC/$7C/$00/$00/
    $00/$78/$EC/$FC/$E0/$78/$00/$38/$74/$70/$F8/$70/$70/$70/$00/$00/$00/$7C/
    $EC/$EC/$7C/$0C/$F8/$E0/$E0/$F8/$EC/$EC/$EC/$EC/$00/$00/$38/$00/$38/$38/
    $38/$38/$00/$00/$0C/$00/$0C/$0C/$EC/$EC/$78/$E0/$E0/$EC/$F8/$F0/$F8/$EC/
    $00/$38/$38/$38/$38/$38/$38/$38/$00/$00/$00/$7C/$D4/$D4/$D4/$D4/$00/$00/
    $00/$F8/$EC/$EC/$EC/$EC/$00/$00/$00/$78/$EC/$EC/$EC/$78/$00/$00/$00/$F8/
    $DC/$DC/$F8/$C0/$C0/$00/$00/$7C/$EC/$EC/$7C/$0C/$0C/$00/$00/$FC/$EC/$E0/
    $E0/$E0/$00/$00/$00/$7C/$E0/$78/$1C/$F8/$00/$70/$70/$F8/$70/$70/$74/$38/
    $00/$00/$00/$EC/$EC/$EC/$EC/$7C/$00/$00/$00/$EC/$EC/$EC/$68/$30/$00/$00/
    $00/$84/$B4/$B4/$B4/$48/$00/$00/$00/$E4/$78/$30/$78/$E4/$00/$00/$00/$EC/
    $EC/$EC/$7C/$0C/$F8/$00/$00/$FC/$1C/$78/$E0/$FC/$00/$1C/$38/$38/$F0/$38/
    $38/$1C/$00/$38/$38/$38/$00/$38/$38/$38/$00/$E0/$70/$70/$3C/$70/$70/$E0/
    $00/$24/$FC/$D8/$00/$00/$00/$00/$00/$30/$78/$FC/$FC/$00/$00/$00/$00/$78/
    $EC/$E0/$EC/$78/$1C/$0E/$7C/$EC/$00/$EC/$EC/$EC/$EC/$7C/$00/$0C/$18/$78/
    $EC/$FC/$E0/$78/$00/$78/$84/$30/$08/$38/$48/$3C/$00/$88/$00/$78/$1C/$7C/
    $DC/$7C/$00/$0C/$18/$78/$0C/$7C/$EC/$7C/$00/$0C/$18/$78/$0C/$7C/$EC/$7C/
    $00/$00/$00/$78/$80/$80/$78/$04/$38/$78/$84/$30/$48/$78/$40/$38/$00/$CC/
    $00/$78/$84/$FC/$80/$78/$00/$0C/$18/$78/$EC/$FC/$E0/$78/$00/$50/$00/$20/
    $20/$20/$20/$00/$00/$1C/$38/$38/$38/$38/$38/$38/$00/$00/$1C/$00/$1C/$1C/
    $1C/$1C/$00/$84/$30/$48/$84/$FC/$84/$84/$00/$0C/$18/$78/$EC/$FC/$EC/$EC/
    $00/$18/$30/$F8/$E0/$F0/$E0/$F8/$00/$00/$00/$7C/$10/$7C/$90/$7C/$00/$3C/
    $50/$90/$FC/$90/$90/$9C/$00/$36/$6C/$78/$EC/$EC/$EC/$78/$00/$6C/$00/$78/
    $EC/$EC/$EC/$78/$00/$10/$78/$EC/$EC/$EC/$EC/$78/$00/$36/$6C/$EC/$EC/$EC/
    $EC/$7C/$00/$08/$10/$EC/$EC/$EC/$EC/$78/$00/$24/$48/$EC/$EC/$EC/$EC/$78/
    $00/$84/$78/$EC/$EC/$EC/$EC/$78/$00/$EC/$00/$EC/$EC/$EC/$EC/$78/$00/$10/
    $10/$7C/$80/$80/$7C/$10/$10/$30/$48/$48/$E0/$40/$44/$F8/$00/$CC/$48/$30/
    $FC/$30/$FC/$30/$30/$F0/$88/$88/$F0/$88/$9C/$88/$8C/$08/$14/$10/$38/$10/
    $10/$90/$60/$0C/$18/$78/$0C/$7C/$EC/$7C/$00/$0C/$18/$00/$18/$18/$18/$18/
    $00/$0C/$18/$78/$EC/$EC/$EC/$78/$00/$0C/$18/$EC/$EC/$EC/$EC/$7C/$00/$00/
    $F8/$00/$F8/$84/$84/$84/$00/$FC/$00/$C4/$A4/$94/$8C/$84/$00/$78/$88/$88/
    $7C/$00/$FC/$00/$00/$36/$6C/$78/$EC/$EC/$EC/$78/$00/$20/$00/$20/$40/$80/
    $84/$78/$00/$00/$00/$00/$FC/$80/$80/$00/$00/$00/$00/$00/$FC/$04/$04/$00/
    $00/$82/$84/$88/$9E/$21/$4E/$90/$1E/$82/$84/$88/$92/$26/$4A/$9F/$02/$10/
    $10/$10/$00/$10/$10/$10/$00/$00/$22/$44/$88/$44/$22/$00/$00/$00/$88/$44/
    $22/$44/$88/$00/$00/$22/$88/$22/$88/$22/$88/$22/$88/$55/$AA/$55/$AA/$55/
    $AA/$55/$AA/$6D/$B6/$DB/$6D/$B6/$DB/$6D/$B6/$10/$10/$10/$10/$10/$10/$10/
    $10/$10/$10/$10/$10/$F0/$10/$10/$10/$10/$10/$F0/$10/$F0/$10/$10/$10/$24/
    $24/$24/$24/$E4/$24/$24/$24/$00/$00/$00/$00/$FC/$24/$24/$24/$00/$00/$F0/
    $10/$F0/$10/$10/$10/$24/$24/$E4/$04/$E4/$24/$24/$24/$24/$24/$24/$24/$24/
    $24/$24/$24/$00/$00/$FC/$04/$E4/$24/$24/$24/$24/$24/$E4/$04/$FC/$00/$00/
    $00/$24/$24/$24/$24/$FC/$00/$00/$00/$08/$08/$F8/$08/$F8/$00/$00/$00/$00/
    $00/$00/$00/$F8/$08/$08/$08/$10/$10/$10/$10/$1F/$00/$00/$00/$10/$10/$10/
    $10/$FF/$00/$00/$00/$00/$00/$00/$00/$FF/$10/$10/$10/$10/$10/$10/$10/$1F/
    $10/$10/$10/$00/$00/$00/$00/$FF/$00/$00/$00/$10/$10/$10/$10/$FF/$10/$10/
    $10/$10/$10/$1F/$10/$1F/$10/$10/$10/$24/$24/$24/$24/$27/$24/$24/$24/$24/
    $24/$27/$20/$3F/$00/$00/$00/$00/$00/$3F/$20/$27/$24/$24/$24/$24/$24/$E7/
    $00/$FF/$00/$00/$00/$00/$00/$FF/$00/$E7/$24/$24/$24/$24/$24/$27/$20/$27/
    $24/$24/$24/$00/$00/$FF/$00/$FF/$00/$00/$00/$24/$24/$E7/$00/$E7/$24/$24/
    $24/$10/$10/$FF/$00/$FF/$00/$00/$00/$24/$24/$24/$24/$FF/$00/$00/$00/$00/
    $00/$FF/$00/$FF/$10/$10/$10/$00/$00/$00/$00/$FF/$24/$24/$24/$24/$24/$24/
    $24/$3F/$00/$00/$00/$10/$10/$1F/$10/$1F/$00/$00/$00/$00/$00/$1F/$10/$1F/
    $10/$10/$10/$00/$00/$00/$00/$3F/$24/$24/$24/$24/$24/$24/$24/$FF/$24/$24/
    $24/$10/$10/$FF/$10/$FF/$10/$10/$10/$08/$08/$08/$08/$F8/$00/$00/$00/$00/
    $00/$00/$00/$1F/$10/$10/$10/$FF/$FF/$FF/$FF/$FF/$FF/$FF/$FF/$00/$00/$00/
    $00/$FF/$FF/$FF/$FF/$F0/$F0/$F0/$F0/$F0/$F0/$F0/$F0/$0F/$0F/$0F/$0F/$0F/
    $0F/$0F/$0F/$FF/$FF/$FF/$FF/$00/$00/$00/$00/$00/$00/$62/$94/$88/$94/$62/
    $00/$00/$38/$44/$78/$84/$F8/$80/$80/$00/$FC/$84/$80/$80/$80/$80/$00/$00/
    $FE/$44/$44/$44/$44/$44/$00/$FC/$84/$40/$20/$40/$84/$FC/$00/$00/$00/$7E/
    $88/$88/$88/$70/$00/$00/$42/$42/$42/$42/$7C/$40/$80/$00/$36/$C8/$08/$08/
    $08/$08/$00/$FC/$30/$48/$84/$84/$48/$30/$FC/$38/$44/$82/$FE/$82/$44/$38/
    $00/$38/$44/$82/$82/$44/$44/$C6/$00/$1C/$20/$18/$7C/$84/$84/$78/$00/$00/
    $00/$7C/$92/$92/$7C/$00/$00/$06/$08/$7C/$92/$92/$7C/$20/$C0/$38/$40/$80/
    $F8/$80/$40/$38/$00/$78/$84/$84/$84/$84/$84/$84/$00/$00/$FC/$00/$FC/$00/
    $FC/$00/$00/$10/$10/$7C/$10/$10/$00/$FE/$00/$20/$10/$08/$10/$20/$00/$FC/
    $00/$10/$20/$40/$20/$10/$00/$FC/$00/$0E/$11/$11/$10/$10/$10/$10/$10/$08/
    $08/$08/$08/$08/$88/$88/$70/$10/$10/$00/$FE/$00/$10/$10/$00/$00/$66/$98/
    $00/$66/$98/$00/$00/$30/$48/$48/$30/$00/$00/$00/$00/$00/$00/$00/$18/$18/
    $00/$00/$00/$00/$00/$00/$00/$10/$00/$00/$00/$0F/$08/$08/$08/$88/$48/$28/
    $18/$78/$44/$44/$44/$44/$00/$00/$00/$78/$04/$18/$60/$7C/$00/$00/$00/$00/
    $00/$3C/$3C/$3C/$3C/$00/$00/$38/$44/$92/$AA/$A2/$9C/$40/$3C);
end;

procedure SIMPLE;
begin
 Inline($38/$44/$9A/$A2/$A2/$9A/$44/$38/$7E/$81/$A5/$81/$BD/$99/$81/$7E/$7E/
    $FF/$DB/$FF/$C3/$E7/$FF/$7E/$6C/$92/$82/$82/$44/$28/$10/$00/$10/$28/$44/
    $82/$44/$28/$10/$00/$38/$7C/$38/$FE/$38/$7C/$44/$C6/$10/$38/$7C/$FE/$7C/
    $38/$7C/$00/$00/$00/$18/$3C/$3C/$18/$00/$00/$FF/$FF/$E7/$C3/$C3/$E7/$FF/
    $FF/$00/$3C/$66/$42/$42/$66/$3C/$00/$FF/$C3/$99/$BD/$BD/$99/$C3/$FF/$07/
    $03/$05/$78/$84/$84/$84/$78/$38/$44/$44/$44/$38/$10/$7C/$10/$3E/$22/$3E/
    $20/$20/$60/$E0/$C0/$7E/$42/$7E/$42/$42/$46/$C6/$C0/$92/$54/$38/$EE/$38/
    $54/$92/$00/$80/$E0/$F8/$FE/$F8/$E0/$80/$00/$02/$0E/$3E/$FE/$3E/$0E/$02/
    $00/$10/$38/$7C/$10/$10/$7C/$38/$10/$44/$44/$44/$44/$44/$00/$44/$00/$7E/
    $92/$92/$72/$12/$12/$12/$00/$3E/$63/$38/$6C/$6C/$38/$CC/$78/$00/$00/$00/
    $00/$7E/$7E/$7E/$00/$10/$38/$7C/$10/$7C/$38/$10/$00/$10/$38/$7C/$FE/$10/
    $10/$10/$00/$10/$10/$10/$FE/$7C/$38/$10/$00/$10/$18/$1C/$FE/$1C/$18/$10/
    $00/$10/$30/$70/$FE/$70/$30/$10/$00/$00/$00/$80/$80/$80/$FE/$00/$00/$00/
    $24/$66/$FF/$66/$24/$00/$00/$00/$10/$38/$7C/$FE/$00/$00/$00/$00/$00/$FE/
    $7C/$38/$10/$00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$10/$10/$10/$10/$10/
    $00/$10/$00/$24/$24/$24/$00/$00/$00/$00/$00/$44/$44/$FE/$44/$FE/$44/$44/
    $00/$10/$38/$40/$38/$04/$78/$10/$00/$00/$84/$08/$10/$20/$40/$84/$00/$38/
    $44/$28/$72/$94/$88/$76/$00/$20/$20/$40/$00/$00/$00/$00/$00/$10/$20/$40/
    $40/$40/$20/$10/$00/$20/$10/$08/$08/$08/$10/$20/$00/$84/$48/$30/$FC/$30/
    $48/$84/$00/$00/$30/$30/$FC/$30/$30/$00/$00/$00/$00/$00/$00/$00/$30/$30/
    $60/$00/$00/$00/$FC/$00/$00/$00/$00/$00/$00/$00/$00/$00/$30/$30/$00/$04/
    $08/$10/$20/$40/$80/$00/$00/$78/$84/$84/$84/$84/$84/$78/$00/$10/$30/$10/
    $10/$10/$10/$38/$00/$78/$84/$04/$18/$60/$80/$FC/$00/$78/$84/$04/$38/$04/
    $84/$78/$00/$18/$28/$48/$88/$FC/$08/$08/$00/$FC/$80/$F8/$04/$04/$84/$78/
    $00/$38/$40/$80/$F8/$84/$84/$78/$00/$FC/$84/$04/$08/$10/$10/$10/$00/$78/
    $84/$84/$78/$84/$84/$78/$00/$78/$84/$84/$7C/$04/$08/$70/$00/$00/$10/$10/
    $00/$00/$10/$10/$00/$00/$10/$10/$00/$10/$10/$20/$00/$10/$20/$40/$80/$40/
    $20/$10/$00/$00/$00/$FC/$00/$00/$FC/$00/$00/$20/$10/$08/$04/$08/$10/$20/
    $00/$78/$84/$04/$08/$10/$00/$10/$00/$78/$84/$9C/$A8/$BC/$80/$78/$00/$30/
    $48/$84/$84/$FC/$84/$84/$00/$F8/$84/$84/$F8/$84/$84/$F8/$00/$78/$84/$80/
    $80/$80/$84/$78/$00/$F0/$88/$84/$84/$84/$88/$F0/$00/$FC/$80/$80/$F0/$80/
    $80/$FC/$00/$FC/$80/$80/$F0/$80/$80/$80/$00/$78/$84/$80/$80/$8C/$84/$78/
    $00/$84/$84/$84/$FC/$84/$84/$84/$00/$10/$10/$10/$10/$10/$10/$10/$00/$08/
    $08/$08/$08/$08/$88/$70/$00/$88/$90/$A0/$C0/$A0/$90/$88/$00/$80/$80/$80/
    $80/$80/$80/$F8/$00/$84/$CC/$B4/$84/$84/$84/$84/$00/$C4/$A4/$94/$8C/$84/
    $84/$84/$00/$78/$84/$84/$84/$84/$84/$78/$00/$F8/$84/$84/$F8/$80/$80/$80/
    $00/$78/$84/$84/$84/$94/$78/$08/$00/$F8/$84/$84/$F8/$90/$88/$84/$00/$78/
    $84/$C0/$30/$0C/$84/$78/$00/$F8/$20/$20/$20/$20/$20/$20/$00/$84/$84/$84/
    $84/$84/$84/$78/$00/$84/$84/$84/$84/$84/$48/$30/$00/$84/$84/$84/$84/$B4/
    $CC/$84/$00/$00/$84/$48/$30/$30/$48/$84/$00/$88/$88/$88/$70/$20/$20/$20/
    $00/$FC/$04/$08/$30/$40/$80/$FC/$00/$78/$40/$40/$40/$40/$40/$78/$00/$80/
    $40/$20/$10/$08/$04/$00/$00/$78/$08/$08/$08/$08/$08/$78/$00/$30/$48/$84/
    $00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$00/$FC/$20/$20/$10/$00/$00/
    $00/$00/$00/$00/$00/$78/$04/$7C/$84/$7C/$00/$80/$80/$F8/$84/$84/$84/$F8/
    $00/$00/$00/$78/$84/$80/$84/$78/$00/$04/$04/$7C/$84/$84/$84/$7C/$00/$00/
    $00/$78/$84/$FC/$80/$78/$00/$38/$44/$40/$E0/$40/$40/$40/$00/$00/$00/$7C/
    $84/$84/$7C/$04/$F8/$80/$80/$F8/$84/$84/$84/$84/$00/$00/$10/$00/$10/$10/
    $10/$10/$00/$00/$04/$00/$04/$04/$84/$84/$78/$40/$40/$48/$50/$60/$50/$48/
    $00/$10/$10/$10/$10/$10/$10/$10/$00/$00/$00/$5C/$A4/$A4/$A4/$A4/$00/$00/
    $00/$F8/$84/$84/$84/$84/$00/$00/$00/$78/$84/$84/$84/$78/$00/$00/$00/$F8/
    $84/$84/$F8/$80/$80/$00/$00/$7C/$84/$84/$7C/$04/$04/$00/$00/$7C/$44/$40/
    $40/$40/$00/$00/$00/$7C/$80/$78/$04/$F8/$00/$40/$40/$F0/$40/$40/$44/$38/
    $00/$00/$00/$84/$84/$84/$84/$7C/$00/$00/$00/$84/$84/$84/$48/$30/$00/$00/
    $00/$88/$A8/$A8/$A8/$50/$00/$00/$00/$84/$48/$30/$48/$84/$00/$00/$00/$84/
    $84/$84/$7C/$04/$F8/$00/$00/$FC/$08/$30/$40/$FC/$00/$1C/$20/$20/$C0/$20/
    $20/$1C/$00/$10/$10/$10/$00/$10/$10/$10/$00/$E0/$10/$10/$0C/$10/$10/$E0/
    $00/$24/$D8/$00/$00/$00/$00/$00/$00/$30/$78/$FC/$FC/$00/$00/$00/$00/$78/
    $8C/$80/$8C/$70/$08/$04/$78/$84/$00/$84/$84/$84/$84/$7C/$00/$08/$10/$78/
    $84/$FC/$80/$78/$00/$78/$84/$30/$08/$38/$48/$3C/$00/$88/$00/$78/$04/$7C/
    $84/$7C/$00/$08/$10/$78/$04/$7C/$84/$7C/$00/$08/$10/$78/$04/$7C/$84/$7C/
    $00/$00/$00/$78/$80/$80/$78/$04/$38/$78/$84/$30/$48/$78/$40/$38/$00/$CC/
    $00/$78/$84/$FC/$80/$78/$00/$08/$10/$78/$84/$FC/$80/$78/$00/$50/$00/$20/
    $20/$20/$20/$00/$00/$08/$10/$10/$10/$10/$10/$10/$00/$00/$10/$00/$10/$10/
    $10/$10/$00/$84/$30/$48/$84/$FC/$84/$84/$00/$08/$10/$78/$84/$FC/$84/$84/
    $00/$10/$20/$F8/$80/$F0/$80/$F8/$00/$00/$00/$7C/$10/$7C/$90/$7C/$00/$3C/
    $50/$90/$FC/$90/$90/$9C/$00/$24/$48/$78/$84/$84/$84/$78/$00/$48/$00/$78/
    $84/$84/$84/$78/$00/$10/$78/$84/$84/$84/$84/$78/$00/$28/$50/$84/$84/$84/
    $84/$7C/$00/$08/$10/$84/$84/$84/$84/$78/$00/$24/$48/$84/$84/$84/$84/$78/
    $00/$84/$78/$84/$84/$84/$84/$78/$00/$84/$00/$84/$84/$84/$84/$78/$00/$10/
    $10/$7C/$80/$80/$7C/$10/$10/$30/$48/$48/$E0/$40/$44/$F8/$00/$CC/$48/$30/
    $FC/$30/$FC/$30/$30/$F0/$88/$88/$F0/$88/$9C/$88/$8C/$08/$14/$10/$38/$10/
    $10/$90/$60/$08/$10/$78/$04/$7C/$84/$7C/$00/$08/$10/$00/$10/$10/$10/$10/
    $00/$08/$10/$78/$84/$84/$84/$78/$00/$08/$10/$84/$84/$84/$84/$7C/$00/$00/
    $F8/$00/$F8/$84/$84/$84/$00/$FC/$00/$C4/$A4/$94/$8C/$84/$00/$78/$88/$88/
    $7C/$00/$FC/$00/$00/$28/$50/$78/$84/$84/$84/$78/$00/$20/$00/$20/$40/$80/
    $84/$78/$00/$00/$00/$00/$FC/$80/$80/$00/$00/$00/$00/$00/$FC/$04/$04/$00/
    $00/$82/$84/$88/$9E/$21/$4E/$90/$1E/$82/$84/$88/$92/$26/$4A/$9F/$02/$10/
    $10/$10/$00/$10/$10/$10/$00/$00/$22/$44/$88/$44/$22/$00/$00/$00/$88/$44/
    $22/$44/$88/$00/$00/$22/$88/$22/$88/$22/$88/$22/$88/$55/$AA/$55/$AA/$55/
    $AA/$55/$AA/$6D/$B6/$DB/$6D/$B6/$DB/$6D/$B6/$10/$10/$10/$10/$10/$10/$10/
    $10/$10/$10/$10/$10/$F0/$10/$10/$10/$10/$10/$F0/$10/$F0/$10/$10/$10/$24/
    $24/$24/$24/$E4/$24/$24/$24/$00/$00/$00/$00/$FC/$24/$24/$24/$00/$00/$F0/
    $10/$F0/$10/$10/$10/$24/$24/$E4/$04/$E4/$24/$24/$24/$24/$24/$24/$24/$24/
    $24/$24/$24/$00/$00/$FC/$04/$E4/$24/$24/$24/$24/$24/$E4/$04/$FC/$00/$00/
    $00/$24/$24/$24/$24/$FC/$00/$00/$00/$08/$08/$F8/$08/$F8/$00/$00/$00/$00/
    $00/$00/$00/$F8/$08/$08/$08/$10/$10/$10/$10/$1F/$00/$00/$00/$10/$10/$10/
    $10/$FF/$00/$00/$00/$00/$00/$00/$00/$FF/$10/$10/$10/$10/$10/$10/$10/$1F/
    $10/$10/$10/$00/$00/$00/$00/$FF/$00/$00/$00/$10/$10/$10/$10/$FF/$10/$10/
    $10/$10/$10/$1F/$10/$1F/$10/$10/$10/$24/$24/$24/$24/$27/$24/$24/$24/$24/
    $24/$27/$20/$3F/$00/$00/$00/$00/$00/$3F/$20/$27/$24/$24/$24/$24/$24/$E7/
    $00/$FF/$00/$00/$00/$00/$00/$FF/$00/$E7/$24/$24/$24/$24/$24/$27/$20/$27/
    $24/$24/$24/$00/$00/$FF/$00/$FF/$00/$00/$00/$24/$24/$E7/$00/$E7/$24/$24/
    $24/$10/$10/$FF/$00/$FF/$00/$00/$00/$24/$24/$24/$24/$FF/$00/$00/$00/$00/
    $00/$FF/$00/$FF/$10/$10/$10/$00/$00/$00/$00/$FF/$24/$24/$24/$24/$24/$24/
    $24/$3F/$00/$00/$00/$10/$10/$1F/$10/$1F/$00/$00/$00/$00/$00/$1F/$10/$1F/
    $10/$10/$10/$00/$00/$00/$00/$3F/$24/$24/$24/$24/$24/$24/$24/$FF/$24/$24/
    $24/$10/$10/$FF/$10/$FF/$10/$10/$10/$08/$08/$08/$08/$F8/$00/$00/$00/$00/
    $00/$00/$00/$1F/$10/$10/$10/$FF/$FF/$FF/$FF/$FF/$FF/$FF/$FF/$00/$00/$00/
    $00/$FF/$FF/$FF/$FF/$F0/$F0/$F0/$F0/$F0/$F0/$F0/$F0/$0F/$0F/$0F/$0F/$0F/
    $0F/$0F/$0F/$FF/$FF/$FF/$FF/$00/$00/$00/$00/$00/$00/$62/$94/$88/$94/$62/
    $00/$00/$38/$44/$78/$84/$F8/$80/$80/$00/$FC/$84/$80/$80/$80/$80/$00/$00/
    $FE/$44/$44/$44/$44/$44/$00/$FC/$84/$40/$20/$40/$84/$FC/$00/$00/$00/$7E/
    $88/$88/$88/$70/$00/$00/$42/$42/$42/$42/$7C/$40/$80/$00/$36/$C8/$08/$08/
    $08/$08/$00/$FC/$30/$48/$84/$84/$48/$30/$FC/$38/$44/$82/$FE/$82/$44/$38/
    $00/$38/$44/$82/$82/$44/$44/$C6/$00/$1C/$20/$18/$7C/$84/$84/$78/$00/$00/
    $00/$7C/$92/$92/$7C/$00/$00/$06/$08/$7C/$92/$92/$7C/$20/$C0/$38/$40/$80/
    $F8/$80/$40/$38/$00/$78/$84/$84/$84/$84/$84/$84/$00/$00/$FC/$00/$FC/$00/
    $FC/$00/$00/$10/$10/$7C/$10/$10/$00/$FE/$00/$20/$10/$08/$10/$20/$00/$FC/
    $00/$10/$20/$40/$20/$10/$00/$FC/$00/$0E/$11/$11/$10/$10/$10/$10/$10/$08/
    $08/$08/$08/$08/$88/$88/$70/$10/$10/$00/$FE/$00/$10/$10/$00/$00/$66/$98/
    $00/$66/$98/$00/$00/$30/$48/$48/$30/$00/$00/$00/$00/$00/$00/$00/$18/$18/
    $00/$00/$00/$00/$00/$00/$00/$10/$00/$00/$00/$0F/$08/$08/$08/$88/$48/$28/
    $18/$78/$44/$44/$44/$44/$00/$00/$00/$78/$04/$18/$60/$7C/$00/$00/$00/$00/
    $00/$3C/$3C/$3C/$3C/$00/$00/$38/$44/$92/$AA/$A2/$9C/$40/$3C);
end;

function Adj(P: Pointer): Pointer; assembler;
asm
    MOV AX, [BP+06]
    MOV DX, [BP+08]
    ADD AX, 3
end;

begin
  SetCharType(Adj(@SIMPLE));
end.