; ***************************************************************************
; *  (K) Kopyright 1997-1998 K!Prod, DefCoN Mag Video Librairy, by ArraKiS  *
; *  Feel free to use but do distribute the complete package (V0.30)       *
; *                                                                         *
; *  Thanks to EgoN/K!Prod for all the Info about VESA 2.0                  *
; *  Thanks to Babylon/Revelation for his VESA LIBRARY SOURCE V2.0          *
; *  Now, my ChkVesa and ChkVesaMode are clean and structured!              *
; *  Created (DefCoN #1) : 15/06/97  (V0.1)                                *
; *  Complete Rewrite    : 25/09/97  (V0.2)                                *
; *  Last Update         : 25/06/98  (V0.30)                               * 
; ***************************************************************************
.386P
.Model Flat
locals

;  *** Main Functions ***
   public ChkVESA       ; void ChkVESA(void)
   public ChkVESAMode   ; void ChkVESAMode(dword x, dword y, dword bpp)
   public ChkModeX      ; void ChkModeX(dword x, dword y, dword bpp)
   public InitMode13h   ; void InitMode13h(void)
   public SetMode       ; void SetMode(void)
   public CloseMode     ; void CloseMode(void)
   public VSwpscrLFB    ; void VSwpscrLFB(dword source)
   public VSwpscrBAN    ; void VSwpscrBAN(dword source)
   public VSwpscrM_X    ; void VSwpscrM_X(dword source)
   public ClsVbuf       ; void ClsVbuf(dword BufferVideo)
   public ClsLFB        ; void ClsLFB(void)
   public ClsBAN        ; void ClsBAN(void)
   public ClsM_X        ; void ClsM_X(void)
;   public CopyMem2VideoS ;LFB ; mon dieu mon dieu mon dieu ....
   public ModeText      ; void ModeText(void)
   public WaitVbl       

;  *** Misc Functions ***
   public MemCopy       ; void MemCopy(dword source, dword dest, dword long)
   public lisgif        ; void lisgif(dword source, dword destination)
   public IsVGA         ; int  IsVGA(void)
   public ScreenOn      ; void ScreenOn(void)
   public ScreenOff     ; void ScreenOff(void)
   public CPULine       ; void CPULine(void)
;   public SaveModeInfos ; void SaveModeInfos(dword dest)
;   public RestoreModeInfos ; void RestoreModeInfos(dword Source)


;  *** Palette Functions ***
   public SetColor      ; void SetColor(DWORD Pen, byte  R,byte  G,byte  B)
   public GetPal        ; void GetColor(DWORD Palette)

; *** Beta Reducing palette functions ***
   public Buffer32ToScreen16LFB ; void Buffer32ToScreen16LFB(DWORD Buffer)

;  *** Public Variables ***
   public ReturnCode

   public VESAX_Engaged
   public ModeX_Engaged
   public VESA_SelectMode
   public VESA_SelectModeMaxX
   public VESA_SelectModeMaxY
   public VESA_SelectModeBPP
   public VESA_SelectTrueBPP

   public VESA_MapSize
   public VESA_BPSL
   public VESA_LFB
   public VESA_Address

   public VESA_PMInterf
   public VESA_PMBSwitch  

   public VESA_Form     
   public VESA_Version  
   public VESA_RAM      
   public VESA_RAMo     

   public VESA_NbMode
   public VESA_ModeList

   public VESAChecked
   public KVversion

; *************************************************************************
;                                Main DATAs
; *************************************************************************
.DATA

; accessible depuis le "C"
align 4
KVversion  db '0.30',0

align 4
ReturnCode db 0        ; Code de Retour

align 4
VESA_Seg         dw 0              ; Sauvegarde d'une adresse Mode Reel
VESA_Sel         dw 0              ; Son selecteur pour le modep

align 4
VESA_SelectMode      dw 0  ;(2)        ; Mode Selectionner
VESA_SelectModeMaxX  dw 0  ;(2)
VESA_SelectModeMaxY  dw 0  ;(2)
VESA_SelectModeBPP   db 0  ;(1)
VESA_SelectTrueBPP   db 0  ;(1)
ModeX_Engaged        db 0  ;(1)        ; ModeX
VESAX_Engaged        db 0  ;(1)        ; VesaX 
Flags               db 0,0 ;(3)        ; Not Used Yet
X_Modif_offset       dd 0  ;(4)        ; Offset of CRTC Values
VESA_MapSize         dd 0  ;(4)        ; Taille de l'ecran (?)
VESA_BPSL            dd 0  ;(4)        ; Bytes Per Scan Line
VESA_LFB             dd 0  ;(4)        ; Is LFB availaible ??
VESA_Address         dd 0  ;(4)        ; Pointer to VIDEO RAM (or use this)
VESA_WindowSize      dd 0  ;(4)        ; Taille de la fenetre (default:64Ko)
VESA_BANKTable       dd 128 DUP (0)
VESA_SetBankPtr      dd 0  ;(4)        ; Pointer to BankSwitch function rm&pm
VESA_NbBanks         db 0  ;(1)        ; Nombre de Banks
VESA_CurrentBank     db 0  ;(1)        ; Current used bank
VESA_PMInterf        db 0  ;(1)        ; Protected Mode interface found ?
VESA_PMBSwitch       db 0  ;(1)        ; use P-Mode bank switch ?

VESA_NbPix           dd 0  ;(4)        ; SizeX*SizeY

VESA_Form        db 'PiPo',0       ; Signature VESA
VESA_Version     dw 0              ; Version de VESA
VESA_RAM         dw 0              ; Taille de la RAM Video
VESA_RAMo        dd 0              ; Taille de la RAM Video (en octets!)

VESA_NbMode      dd 0
VESA_ModeList    dw 5*256 dup (0)  ; Video Mode List with :
                 ; Width, Height, bpp, mode number & BipMapping

; Codes d'Erreur renvoy par les procedures (dans ReturnCode)
NoErr          equ 0             ; Tout c'est bien pass
MemAllocErr    equ 1             ; Erreur d'allocation Memoire
DOSintErr      equ 2             ; Erreur d'interruption 
VESAErr        equ 3             ; VESA not supported
MemDeAllocErr  equ 4             ; Erreur d'allocation Memoire
VModeNotFound  equ 5             ; Requested video mode not found
WrongVESAMode  equ 6             ; Wrong VESA mode
MemoryMapErr   equ 7             ; Can't map memory
BankSwitchErr  equ 8             ; Bank Switching not really available (!)
BadWAAttrib    equ 9             ; Bad Window A attributes
MemoryUnMapErr equ 10            ; Can't unmap memory
NoModeSelected equ 11            ; Aucun mode n'a ete recherche...

; non accessible depuis le "C"
RM_Reg STRUC         ; Structure pour les CallBack en Mode Reel
   rEDI    dd 0
   rESI    dd 0
   rEBP    dd 0
           dd 0
   rEBX    dd 0
   rEDX    dd 0
   rECX    dd 0
   rEAX    dd 0
           dw 0
   rES     dw 0
   rDS     dw 0
   rFS     dw 0
   rGS     dw 0
   rIP     dw 0
   rCS     dw 0
   rSP     dw 0
   rSS     dw 0
RM_Reg ENDS

; Inutilis... Trop lourd a utiliser ...
;VideoBuffer STRUC
;   Address        dd 0           ; Adresse du buffer
;   X              dw 0           ; Taille de l'ecran virtuel (X)
;   Y              dw 0           ; Taille de l'ecran virtuel (Y)
;   BPP            dw 0           ; Taille de l'ecran virtuel (BPP)
;VideoBuffer ENDS

VESAInfo    STRUC                ; Structure VESAInfo
   VESAIdent      dd 0           ; Identification VESA
   VESAVersion    dw 0           ; No de version 
   OEMStringPtr   dd 0           ; adresse du nom constructeur
   Capabilities   dd 0           ; ???
   ModeListPtr    dd 0           ; adresse des modes VESA disponibles
   VESARAM        dw 0           ; Nombres de segments de 64 Ko disponibles
   VESABiosRev    dw 0           ; version du bios
   OEMChipPtr     dd 0           ; adresse du nom du CHIP Video
   OEMProdNamePtr dd 0           ; adresse du nom de la carte
   OEMProdRevPtr  dd 0           ; adresse de la version de la carte/chip
   Reserved       db 222 dup(?)  ; Bah, c'est reserve koi ! (par VESA)
   OEMData        db 256 dup(?)  ; Data Area for OEM Strings
VESAInfo    ENDS


; Mandatory information for all VBE revisions
     ModeAttributes      EQU 0   ; DW mode attributes
     WinAAttributes      EQU 2   ; DB window A attributes
     WinBAttributes      EQU 3   ; DB window B attributes
     WinGranularity      EQU 4   ; DW window granularity
     WinSize             EQU 6   ; DW window size
     WinASegment         EQU 8   ; DW window A start segment
     WinBSegment         EQU 10  ; DW window B start segment
     WinFuncPtr          EQU 12  ; DD pointer to window function
     BytesPerScanLine    EQU 16  ; DW bytes per scan line
; Mandatory information for VBE 1.2 and above
     XResolution         EQU 18  ; DW horizontal resolution in pixels or chars
     YResolution         EQU 20  ; DW vertical resolution in pixels or chars
     XCharSize           EQU 22  ; DB character cell width in pixels
     YCharSize           EQU 23  ; DB character cell height in pixels
     NumberOfPlanes      EQU 24  ; DB number of memory planes
     BitsPerPixel        EQU 25  ; DB bits per pixel
     NumberOfBanks       EQU 26  ; DB number of banks
     MemoryModel         EQU 27  ; DB memory model type
     BankSize            EQU 28  ; DB bank size in KB
     NumberOfImagePages  EQU 29  ; DB number of images
     Reserved_           EQU 30  ; DB reserved for page function
; Direct Color fields (required for direct/6 and YUV/7 memory models)
     RedMaskSize         EQU 31  ; DB size of direct color red mask in bits
     RedFieldPosition    EQU 32  ; DB bit position of lsb of red mask
     GreenMaskSize       EQU 33  ; DB size of direct color green mask in bits
     GreenFieldPosition  EQU 34  ; DB bit position of lsb of green mask
     BlueMaskSize        EQU 35  ; DB size of direct color blue mask in bits
     BlueFieldPosition   EQU 36  ; DB bit position of lsb of blue mask
     RsvdMaskSize        EQU 37  ; DB size of direct color reserved mask in bits
     RsvdFieldPosition   EQU 38  ; DB bit position of lsb of reserved mask
     DirectColorModeInfo EQU 39  ; DB direct color mode attributes
; Mandatory information for VBE 2.0 and above
     PhysBasePtr         EQU 40  ; DD physical address for flat frame buffer
     OffScreenMemOffset  EQU 44  ; DD pointer to start of off screen memory
     OffScreenMemSize    EQU 48  ; DW amount of off screen memory in 1k units


align 4
RM_CallBack    RM_Reg ?          ; registres pour l'emulation Int RM

VESA_IsMapped  db 0              ; evite de mapper deux fois de suite
                                 ; la ram video...
VESAChecked   db 0         ; A t-on deja recup les infos VESA generales?

;
; Variable pour le chargeur GIF
;

clr=256  
eof=257  
align 4
  ab_prfx       dw 4096 dup (0)
  ab_suffx      dw 4096 dup (0)   
  abStack       db 1284 dup (0)
  free          dw 0                
  nbbit         dw 0                 
  max           dw 0       
  stackp        dw 0                
  restbits      dw 0                
  restbyte      dw 0                
  casspecial    dw 0               
  act_code      dw 0                
  old_code      dw 0                
  readbyt       dw 0                
  lbyte         dw 0               

VESAX_NbMode    dd 75                                   ; VESAX
VESAX_ModeList  dw 320, 240,  8,  1, 320,200,8
;320x???x8b     dw 320, 256,  8,  2, 320,200,8
                dw 320, 400,  8,  3, 320,200,8
                dw 320, 480,  8,  4, 320,200,8
                dw 320, 512,  8,  5, 320,200,8
                dw 320, 180,  8,  9, 320,240,8  ; 16/9 mode!

;320x???x15b    dw 320, 240, 15,  1, 320,200,15
                dw 320, 256, 15,  2, 320,200,15
                dw 320, 400, 15,  3, 320,200,15
                dw 320, 480, 15,  4, 320,200,15
                dw 320, 512, 15,  5, 320,200,15
                dw 320, 180, 15,  9, 320,240,15  ; 16/9 mode!

;320x???x16b    dw 320, 240, 16,  1, 320,200,16
                dw 320, 256, 16,  2, 320,200,16
                dw 320, 400, 16,  3, 320,200,16
                dw 320, 480, 16,  4, 320,200,16
                dw 320, 512, 16,  5, 320,200,16
                dw 320, 180, 16,  9, 320,240,16 ; 16/9 mode!

;320x???x24b    dw 320, 240, 24,  1, 320,200,24
                dw 320, 256, 24,  2, 320,200,24
                dw 320, 400, 24,  3, 320,200,24
                dw 320, 480, 24,  4, 320,200,24
                dw 320, 512, 24,  5, 320,200,24
                dw 320, 180, 24,  9, 320,240,24 ; 16/9 mode!

;320x???x32b    dw 320, 240, 32,  1, 320,200,32
                dw 320, 256, 32,  2, 320,200,32
                dw 320, 400, 32,  3, 320,200,32
                dw 320, 480, 32,  4, 320,200,32
                dw 320, 512, 32,  5, 320,200,32
                dw 320, 180, 32,  9, 320,240,32 ; 16/9 mode!

;640x???x8b     dw 640, 200,  8,  0, 640,480,8
                dw 640, 240,  8,  1, 640,480,8
                dw 640, 256,  8,  2, 640,480,8
                dw 640, 350,  8,  3, 640,480,8
                dw 640, 400,  8,  4, 640,480,8
                dw 640, 512,  8,  5, 640,480,8
                dw 640, 564,  8,  6, 640,480,8
                dw 640, 600,  8,  7, 640,480,8
                dw 640, 360,  8,  8, 640,480,8     ; Mode 16/9

;640x???x15b    dw 640, 200, 15,  0, 640,480,15
                dw 640, 240, 15,  1, 640,480,15
                dw 640, 256, 15,  2, 640,480,15
                dw 640, 350, 15,  3, 640,480,15
                dw 640, 400, 15,  4, 640,480,15
                dw 640, 512, 15,  5, 640,480,15
                dw 640, 564, 15,  6, 640,480,15
                dw 640, 600, 15,  7, 640,480,15
                dw 640, 360, 15,  8, 640,480,15    ; Mode 16/9

;640x???x16b    dw 640, 200, 16,  0, 640,480,16
                dw 640, 240, 16,  1, 640,480,16
                dw 640, 256, 16,  2, 640,480,16
                dw 640, 350, 16,  3, 640,480,16
                dw 640, 400, 16,  4, 640,480,16
                dw 640, 512, 16,  5, 640,480,16
                dw 640, 564, 16,  6, 640,480,16
                dw 640, 600, 16,  7, 640,480,16
                dw 640, 360, 16,  8, 640,480,16    ; Mode 16/9

;640x???x24b    dw 640, 200, 24,  0, 640,480,24
                dw 640, 240, 24,  1, 640,480,24
                dw 640, 256, 24,  2, 640,480,24
                dw 640, 350, 24,  3, 640,480,24
                dw 640, 400, 24,  4, 640,480,24
                dw 640, 512, 24,  5, 640,480,24
                dw 640, 564, 24,  6, 640,480,24
                dw 640, 600, 24,  7, 640,480,24
                dw 640, 360, 24,  8, 640,480,24    ; Mode 16/9

;640x???x32b    dw 640, 200, 32,  0, 640,480,32
                dw 640, 240, 32,  1, 640,480,32
                dw 640, 256, 32,  2, 640,480,32
                dw 640, 350, 32,  3, 640,480,32
                dw 640, 400, 32,  4, 640,480,32
                dw 640, 512, 32,  5, 640,480,32
                dw 640, 564, 32,  6, 640,480,32
                dw 640, 600, 32,  7, 640,480,32
                dw 640, 360, 32,  8, 640,480,32    ; Mode 16/9

              ; X, Y, BPP, Num, Xbase, Ybase, BPPbase

ModeX_NbMode    dd 44
; X, Y, Bpp, Num  => table: Num * 19*2
ModeX_ModeList dw 320, 224, 8, 0
               dw 320, 240, 8, 1
               dw 320, 256, 8, 2
               dw 320, 270, 8, 3
               dw 320, 282, 8, 4
               dw 320, 300, 8, 5
               dw 320, 360, 8, 6
               dw 320, 400, 8, 7
               dw 320, 448, 8, 8
               dw 320, 480, 8, 9
               dw 320, 512, 8, 10
               dw 320, 540, 8, 11
               dw 320, 564, 8, 12
               dw 320, 600, 8, 13
               dw 360, 200, 8, 14
               dw 360, 224, 8, 15
               dw 360, 240, 8, 16
               dw 360, 256, 8, 17
               dw 360, 270, 8, 18
               dw 360, 282, 8, 19
               dw 360, 300, 8, 20
               dw 360, 360, 8, 21
               dw 360, 400, 8, 22
               dw 360, 448, 8, 23
               dw 360, 480, 8, 24
               dw 360, 512, 8, 25
               dw 360, 540, 8, 26
               dw 360, 564, 8, 27
               dw 360, 600, 8, 28
               dw 400, 200, 8, 29
               dw 400, 224, 8, 30
               dw 400, 240, 8, 31
               dw 400, 256, 8, 32
               dw 400, 270, 8, 33
               dw 400, 282, 8, 34
               dw 400, 300, 8, 35
               dw 400, 360, 8, 36
               dw 400, 400, 8, 37
               dw 400, 448, 8, 38
               dw 400, 480, 8, 39
               dw 400, 512, 8, 40
               dw 400, 540, 8, 41
               dw 400, 564, 8, 42
               dw 400, 600, 8, 43

include CRTC_REG.INC

; *************************************************************************
;                              Main Procedures
; *************************************************************************

.CODE
b equ byte ptr
w equ word ptr
d equ dword ptr

; *************************************************************************
; * void ChkVESA (void)                                                   *
; * Verifie que la carte video soit VESA compatible et initialise toute   *
; * une chier de variables (souvent inutiles d'ailleurs...)               *
; * Entree, Sortie : KeDalle                                              *
; * Code Erreur dans (uchar)ReturnCode (cf ErreurCode)                    *
; *************************************************************************

ChkVESA  proc                             ; thanks to Babylon/Revelation
        push    ebp                       ; Now It's clean...
        mov     ebp,esp                   ; presque PRO mme ;)
        pushad

; On Alloue un bloc de RAM en memoire conventionnel pour la fonction VESA
        mov ax,0100h
        mov bx,32d                        ; Block de 32*16=512 
        int 31h
        jnc @AllocOk
        Mov     [ReturnCode],MemAllocErr  ; Return ErrorCode 
        Mov     [VESAChecked],0
        popad
        mov     esp, ebp
        pop     ebp
        ret
@AllocOk:
        mov [VESA_Sel],dx     ; sauvegarde le selecteur alloue
        mov [VESA_Seg],ax     ; sauvegarde le segment en memoire reel alloue

;        mov     ebx,'2EBV'
        movzx edx,ax
        shl edx,4
        mov   d [EDX],'2EBV'   ; force VBE2 Signature

        mov [RM_CallBack.rES],ax
        mov [RM_CallBack.rEDI],0           ; ES:[EDI] pointe sur le buffer
        mov [RM_CallBack.rEAX],04F00h               ; fonction 4F00h
; inutile es=ds=ss (mais ds#cs)
;        push ds
;        pop es               ; juste au cas ou! ES:EDI pointe sur les regs
        mov edi,offset RM_CallBack
        mov eax,0300h    ; int 31h fonction 0300h -> simulate Real mode int        
        mov ebx,0010h    ; Interruption 10h
        xor ecx,ecx
        int 31h
        jnc     @GetInfoOK
        Mov     [ReturnCode],DOSintErr
        Mov     [VESAChecked],0
        jmp     @EndCheck
@GetInfoOK:

        mov     eax,[RM_CallBack.rEAX]     ; Test if VESA driver found.
        cmp     ax,004Fh
        je      @VESADriverFound
        Mov     [ReturnCode],VESAErr       ; VESA not supported
        Mov     [VESAChecked],0
        jmp     @EndCheck
@VESADriverFound:

; *** Recupere les Infos VESA qui nous interresse (REmerci a babylon)
        mov     fs,[VESA_Sel]
        xor     edi,edi

        mov     eax,d fs:[edi.VESAIdent]
        mov     d [VESA_Form],eax

        mov     ax,w fs:[edi.VESAVersion]
        mov     [VESA_Version],ax

        xor eax,eax
        mov     ax,w fs:[edi.VESARAM]
        shl     eax,6                            
        mov     [VESA_RAM],ax                      ; Taille de la RAM en Ko
        shl     eax,10                           
        mov     [VESA_RAMo],eax    ; Taille de la RAM en octets pour la map


; *** Liste la totalite les Modes VESA de 100h a 200h (REREmerci a babylon)
        mov     [VESA_NbMode],0
        mov     esi,Offset VESA_ModeList
        mov     ebp,100h                        ; first VESA mode
@ModeListLoop:
        mov     eax,04F01h
        mov     [RM_CallBack.rEAX],eax      ; Infos Mode VESA function
        mov     [RM_CallBack.rECX],ebp      ; which VESA mode ? EBP=Mode

        mov     ax,[VESA_Seg]
        mov     [RM_CallBack.rES],ax        ;\ Infos block at ES:DI
        mov     [RM_CallBack.rEDI],0        ;/  DI - Offset 0..

        mov     eax,300h                        ;\
        mov     ebx,10h                         ; |
        xor     ecx,ecx                         ; | DOS interrupt simulation.
        mov     edi,offset RM_CallBack          ; |
        int     31h                             ;/
        jnc     @GetModeInfoOk
        Mov     [ReturnCode],DOSintErr
        Mov     [VESAChecked],0
        jmp     @EndCheck
@GetModeInfoOk:
        mov     eax,[RM_CallBack.rEAX]     ; Test if mode available.
        cmp     ax,004Fh
        jne     @BadVideoMode
        xor     eax,eax
        inc     [VESA_NbMode]
        mov     fs,[VESA_Sel]
        mov     ax,fs:[XResolution]
        mov     [esi],ax
        mov     bx,ax                        ; BackUp Xres
        mov     ax,fs:[YResolution]
        mov     [esi+2],ax

        xor     eax,eax
        mov     al,fs:[BitsPerPixel]         ; Get the BitPerPix field
        mov     [esi+4],ax

        cmp     al,8                         ; Si BPP>8, on calcule
        jbe     @DontAddColorComponents      ; le vrai BPP !!!
        mov    al,fs:[RedMaskSize]           ; Sur Mystique, les modes 15b
        add    al,fs:[GreenMaskSize]         ; repondent 16b en BPP, MAIS
        add    al,fs:[BlueMaskSize]          ; Si on ajoute les composantes
        mov    [esi+4],ax                    ; On retombe sur nos pieds !!!
        add    al,fs:[RsvdMaskSize]          
@DontAddColorComponents:
        mov     [esi+8],ax                   ; BPP "Hard"
        mov     [esi+6],bp
        add     esi,10
@BadVideoMode:
        inc     ebp
        cmp     ebp,0201h              ; on s'arretes juste avant les modes
        jne     @ModeListLoop          ; Speciaux aux cartes S3 ...

; *** On Libere la RAM Utilise 
        mov     eax,0101h
        mov     dx,[VESA_Sel]
        int     31h
        jnc     @FreeMemOk
        mov     [ReturnCode],MemDeAllocErr
        Mov     [VESAChecked],0
        popad
        mov     esp,ebp
        pop     ebp
        ret
@FreeMemOk:
        mov     [ReturnCode],NoErr
        Mov     [VESAChecked],1
        popad
        mov     esp, ebp
        pop     ebp
        ret

@EndCheck:
        mov     eax,0101h
        mov     dx,[VESA_Sel]
        int     31h

        popad
        mov     esp, ebp
        pop     ebp
        ret
ChkVESA     endp


; *************************************************************************
; * void ChkVESAMode(int WIDTH,int HEIGHT,int BitPerPixel)                *
; * Verifie que le mode video desire existe et initialise toute une chier *
; * de variables (souvent inutiles d'ailleurs...)                         *
; * Entree: Largeur, Hauteur, et profondeur de couleur du mode dsir     *
; * Sortie : KeDalle                                                      *
; * Code Erreur dans (uchar)ReturnCode (cf ErreurCode)                    *
; *************************************************************************

ChkVESAMode    Proc
        push    ebp
        mov     ebp,esp
        pushad
        ARG     _WDTH:DWORD, _HGHT:DWORD, _BPP:DWORD

        cmp     [VESA_IsMapped],1
        jne     @NoMap

        mov     eax,0801h
        mov     ebx,[VESA_Address]
        mov     cx,bx
        shr     ebx,16
        int     31h
        jnc     @NoMap
        Mov     [ReturnCode],MemoryUnMapErr    ; Can't unmap memory..
        jmp     @EndInit
@NoMap:
        mov [VESA_IsMapped],0
        mov [VESAX_Engaged],0
        mov [ModeX_Engaged],0

        mov     eax,[_WDTH]
        mov     ebx,[_HGHT]
        mov     ecx,[_BPP]

; je cherche le mode dans la liste VESA ...
        mov     esi,Offset VESA_ModeList
        mov     ebp,[VESA_NbMode]
        or      ebp,ebp
        jnz     @FindModeLoop
        mov     [ReturnCode],VModeNotFound
        jmp     @Ret                      ; liste vide... byebye
@FindModeLoop:
        cmp     ax,[esi]
        jne     @SkipThisMode             ; X pas bon
        cmp     bx,[esi+2]
        jne     @SkipThisMode             ; Y pas bon
        cmp     cx,[esi+4]
        jne     @SkipThisMode             ; BPP pas bon
        mov     dx,[esi+6]                 ; numero du mode
        mov     [VESA_SelectMode],dx       ; Set Graphic Mode
        mov     [VESA_SelectModeMaxX],ax   
        mov     [VESA_SelectModeMaxY],bx   
        mov     [VESA_SelectModeBPP],cl

        mov     cx,[esi+8]       ; On Recup le BPP "Hard"
        mov     [VESA_SelectTrueBPP],cl

        and eax,0FFFFh
        and ebx,0FFFFh
        and ecx,000FFh
        imul    eax,ebx          ;X*Y*BPPHard = mapping size
        mov [VESA_NbPix],eax
        imul    eax,ecx
        shr     eax,3
        mov     [VESA_MapSize],eax     ; Set Mapping Size
        jmp     @VideoModeFound        ; le mode est trouve...

@SkipThisMode:
        add     esi,10
        dec     ebp
        jnz     @FindModeLoop          ; bon, c'est pas le bon... au suivant

; bon, on l'a pas trouve dans la liste VESA... peut etre qu'en VESAX...
        mov     esi,Offset VESAX_ModeList
        mov     ebp,[VESAX_NbMode]
;        or      ebp,ebp
;        jnz     @FindModeLoopVESAX            ; test inutile, la liste N'EST
;        mov     [ReturnCode],VModeNotFound    ; PAS VIDE !
;        jmp     @Ret
@FindModeLoopVESAX:
        cmp     ax,[esi]
        jne     @SkipThisModeVESAX           ; X pas bon
        cmp     bx,[esi+2]
        jne     @SkipThisModeVESAX           ; Y pas bon
        cmp     cx,[esi+4]
        jne     @SkipThisModeVESAX           ; BPP pas bon

        mov     [VESA_SelectModeMaxX],ax     ; cool! je l'ai trouve
        mov     [VESA_SelectModeMaxY],bx     ; on sauve les infos 
        mov     [VESA_SelectModeBPP],cl    

        mov ax,[esi+6]               ; je recupere le numero du mode VESAX
        and eax,0FFFFh               ; et je calcule l'offset des registres
        imul eax,20                  ; CRTC a envoyer ...
        mov [X_Modif_offset],eax    
        mov [VESAX_Engaged],1
        jmp short @SearchEquivalent

@SkipThisModeVESAX:
        add     esi,14
        dec     ebp
        jnz     @FindModeLoopVESAX    ; bon, c'est pas le bon... au suivant
        mov     [ReturnCode],VModeNotFound
        jmp     @Ret                      ; toujours pas trouv ... snif! :(

; Maintenant, je cherche dans la liste VESA son equivalent...
@SearchEquivalent:
        mov     ax,[esi+8]           ; je recup' largeur
        mov     bx,[esi+10]          ; je recup' hauteur
        mov     cx,[esi+12]          ; je recup' bpp

        mov     esi,Offset VESA_ModeList
        mov     ebp,[VESA_NbMode]
        or      ebp,ebp
        jnz     @FindModeLoopV2
        mov     [ReturnCode],VModeNotFound
        jmp     @Ret                      ; liste vide... byebye
@FindModeLoopV2:
        cmp     ax,[esi]
        jne     @SkipThisModeV2           ; X pas bon
        cmp     bx,[esi+2]
        jne     @SkipThisModeV2           ; Y pas bon
        cmp     cx,[esi+4]
        jne     @SkipThisModeV2           ; BPP pas bon

        mov     dx,[esi+6]
        mov     [VESA_SelectMode],dx      ; Set Graphic Mode
        mov     cx,[esi+8]                ; On Recup le BPP "Hard"
        mov     [VESA_SelectTrueBPP],cl
        mov     ax,[VESA_SelectModeMaxX]  ; Je recup les tailles
        mov     bx,[VESA_SelectModeMaxY]  ; X et Y reelles de l'ecran

        xor edx,edx
        and eax,0FFFFh
        and ebx,0FFFFh
        and ecx,000FFh
        imul    eax,ebx
        mov [VESA_NbPix],eax
        imul    eax,ecx
        shr     eax,3
        mov     [VESA_MapSize],eax        ; on calcule la taille de l'ecran
        jmp     short @VideoModeFound           ; le mode est trouve...

@SkipThisModeV2:
        add     esi,10
        dec     ebp
        jnz     @FindModeLoopV2          ; bon, c'est pas le bon... au suivant

; aie aie aie aie aie, le Mode de Base n'existe pas non plus !!!
        mov     [ReturnCode],VModeNotFound
        jmp     @Ret

@VideoModeFound:
; *** Alloc DOS memory block for Mode Info Buffer ***
        mov     eax,100h                 ; Allocate DOS memory block
        mov     ebx,32                   ; 32*16=512 bytes
        int     31h                      ;
        jnc     @DOSAllocOk
        Mov     [ReturnCode],MemAllocErr    ; can't alloc DOS memory
        jmp     @Ret
@DOSAllocOk:
        mov     [VESA_Seg],ax    ; Save segment and selector registers.
        mov     [VESA_Sel],dx    ;

; *** VBE Mode Informations - DOS interrupt *** INITIALIZE VIDEO MODE !!!!
        mov [RM_CallBack.rES],ax      
        mov [RM_CallBack.rEDI],0           ; ES:[EDI] pointe sur le buffer
        mov [RM_CallBack.rEAX],04f01h     ; Infos Mode VESA function
        mov cx,[VESA_SelectMode]
        and ecx,0FFFFh                 ; ECX=CX
        mov [RM_CallBack.rECX],ecx     ; which VESA mode ?

        mov     eax,300h                        ;\
        mov     ebx,010h                        ; |
        xor     ecx,ecx                         ; | DOS interrupt simulation.
        mov     edi,offset RM_CallBack          ; |
        int     31h                             ;/
        jnc     @IntOk
        Mov     [ReturnCode],DOSintErr    ; DOS int failure
        jmp     @EndInit
@IntOk:

        mov     eax,[RM_CallBack.rEAX]     ; Test if mode available.
        cmp     ax,004Fh
        je      @VideoModeOk
        Mov     [ReturnCode],WrongVESAMode    ; Wrong VESA mode (VGA??)
        jmp     @EndInit
@VideoModeOk:

        mov     fs,[VESA_Sel]

        movzx eax,w fs:[BytesPerScanLine]
        mov     [VESA_BPSL],eax

        mov     ax,fs:[ModeAttributes]          ; Test if LFB available
        test    ax,010000000b
        jz      @BankSwitchMethod
; *************************************************************
; ***           LINEAR FRAME BUFFERING AVAILABLE            ***
; *************************************************************
        mov [VESA_LFB],1                ; nous disposons du LFB

        mov     eax,fs:[PhysBasePtr]
; LFB Physical address converted into linear address..
        mov     ecx,eax
        mov     ebx,eax
        shr     ebx,16                  ; BX:CX = Physical address of LFB

; Koi de mieux pour le MAPPING de la RAM VIDEO ????
        mov     eax,[VESA_MapSize]      ; Ne map KE la mmoire ncessaire
;        mov  eax,[VESA_RAMo]            ; Map toute la RAM video
        mov     edi,eax
        mov     esi,eax
        shr     esi,16                  ; SI:DI=size of zone to map in bytes

        mov     eax,0800h                ; DPMI Physical address mapping..
        int     31h
        jnc     @MemMappingOk
        Mov     [ReturnCode],MemoryMapErr    ; Can't map memory..
        jmp     @EndInit
@MemMappingOk:
        shl     ebx,16
        mov     bx,cx
        mov     [VESA_Address],ebx
        or      [VESA_SelectMode],4000h    ; Prepare for Linear Addressing.

        mov [VESA_IsMapped],1
        jmp     @Check32BitInterface   ; Now set all Accelerated Functions.

; A koi ca sert ke je configure le Protected Bank Switching,
; puiske le LFB est disponible ?????????????????????
;        mov     [ReturnCode],NoErr       ; All is ok !!
;        jmp     @Ret

; *************************************************************
; ***                BANK SWITCHING METHOD                  ***
; *************************************************************
@BankSwitchMethod:
        Mov     [VESA_LFB],0

        mov     fs,[VESA_Sel]
        mov     ax,fs:[ModeAttributes]          ; Test if bank switching
        test    ax,01000000b                    ; is really available.
        jz      @Windowing_Supported
        Mov     [ReturnCode],BankSwitchErr      ; BankSwitch not available
        jmp     @EndInit
@Windowing_Supported:

        mov     al,fs:[WinAAttributes]          ; Test if Windows Attributes
        and     al,0101b                        ; are OK.
        cmp     al,0101b
        je      @WinAttributesOk
        Mov     [ReturnCode],BadWAAttrib    ; Bad Window A attributes
        jmp     @EndInit
@WinAttributesOk:

        movzx   eax,w fs:[WinSize]
        shl     eax,10                          ; Get window size.
        mov     [VESA_WindowSize],eax        

; Koi de mieux pour le MAPPING de la RAM VIDEO ????
        mov     eax,[VESA_MapSize]      ; Ne map KE la mmoire ncessaire
;        mov  eax,[VESA_RAMo]            ; Map toute la RAM video

        xor     edx,edx
        mov     ebx,[VESA_WindowSize]
        idiv    ebx                       ; eax=taille_ecran/taille_BANK
        or      edx,edx                   ; si la derniere bank n'est pas
        je      @EndCalcBanks         ; completement inclus on l'inclus
        inc     eax                       ; eax= idem +1
@EndCalcBanks:
        mov     [VESA_NbBanks],AL         ; on garde le nb de bank

; Setup bank numering table..
        Movzx   eax,w fs:[WinSize]
        Movzx   ebx,w fs:[WinGranularity]
        xor     edx,edx
        div     ebx                       ; eax=WinSize / WinGranularity
        xor     edx,edx
        xor     ecx,ecx
@LoopSetUpBank:
        mov     VESA_BANKTable[ECX*4],edx
        add     edx,eax
        inc     ecx
        cmp     ecx,LENGTH VESA_BANKTable
        jb      @LoopSetUpBank

; Window A physical Address converted into 32bits pointer. 0A000h -> 0A0000h
        xor     eax,eax
        mov     ax,fs:[WinASegment]
        shl     eax,4
        mov     [VESA_Address],eax

        mov     eax,Offset IntSetBank          ; Pointer to the standard
        mov     [VESA_SetBankPtr],eax      ; bankswitch function. (real mode)

        mov     [VESA_CurrentBank],0

        mov     edx,VESA_BANKTable[0]
        push    ebx
        call    d [VESA_SetBankPtr]
        pop     ebx

;******************************************************
;*** Now Check for a 32bit bank switch interface !! ***
;******************************************************
@Check32BitInterface:
        mov     [VESA_PMInterf],0  ; firstly suppose there is none.
        mov     [VESA_PMBSwitch],0

; *** Return VBE Protected Mode Interface - DOS interrupt *** check it !!
        mov     [RM_CallBack.rEAX],04F0Ah
        mov     [RM_CallBack.rEBX],0

        mov     eax,300h                        ;\
        mov     ebx,0010h                       ; |
        xor     ecx,ecx                         ; | DOS interrupt simulation.
        mov     edi,offset RM_CallBack          ; |
        int     31h                             ;/
        jnc     @PMIntOk2
        Mov     [ReturnCode],DOSintErr    ; DOS int failure
        jmp     @EndInit
@PMIntOk2:

        mov     eax,[RM_CallBack.rEAX]
        cmp     ax,004Fh
        jne     @No32BitInterface

        movzx   esi,[RM_CallBack.rES]           ; RM pointer->Linear Pointer
        shl     esi,4
        mov     edi,[RM_CallBack.rEDI]
        and     edi,0FFFFh
        add     esi,edi                         ; ESI=Segment*16+Offset

; Check if there's a zero length memory list, it should be that for most video
; card. If memory list have a non-zero length, you are not lucky, because its
; too boring to code that case .. (it runs on 99% of video cards..)
        movzx   edi,w [ESI+06]            ; get port/memory table list
        or      edi,edi
        jz      @UsePmodeInterface        ; No port list.. coool..
        mov     ax,w [esi+edi]
        cmp     ax,0FFFFh
        je      @CheckMemoryList
@CheckPortList:
        add     edi,2
        mov     ax,w [Esi+Edi]                  ; CMP w [ESI+EDI],0FFFFh
        cmp     ax,0FFFFh ; search port list    ; causes problems under my W95!
        jne     @CheckPortList
@CheckMemoryList:
        add     edi,2
        mov     ax,w [Esi+Edi]
        cmp     ax,0FFFFh ; see if mem list is zero
        jne     @NoPMODEBankSwitch
@UsePmodeInterface:
        movzx   eax,w [ESI+00]
        add     eax,esi
        mov     [VESA_SetBankPtr],eax     ; save SetBank code address
        mov     [VESA_PMBSwitch],1
@NoPMODEBankSwitch:

;
; Here I should set all others available
; 32bit functions..
;
        mov     [VESA_PMInterf],1
@No32BitInterface:

        mov     eax,0101h
        mov     dx,[VESA_Sel]
        int     31h
        jnc     @VBE_FreeMem_Ok
        mov     [ReturnCode],MemDeAllocErr
        jmp     @Ret
@VBE_FreeMem_Ok:
        mov     [ReturnCode],NoErr       ; All is ok !!
        jmp     @Ret

@EndInit:
        mov     eax,0101h
        mov     dx,[VESA_Sel]
        int     31h
@Ret:
        mov [ModeX_Engaged],0          ; pour plus tard ....
        popad
        movzx eax,[ReturnCode]
        mov     esp,ebp
        pop     ebp
        ret
ChkVESAMode     Endp


ChkModeX proc
        push    ebp
        mov     ebp,esp
        pushad
        ARG     xWIDTH:DWORD, xHEIGHT:DWORD, xBPP:DWORD

; c'est juste pour le cas ou on est deja mapper une adresse ...
        cmp     [VESA_IsMapped],1
        jne     @xNoMap

        mov     eax,0801h
        mov     ebx,[VESA_Address]
        mov     cx,bx
        shr     ebx,16
        int     31h
        jnc     @xNoMap
        Mov     [ReturnCode],MemoryUnMapErr    ; Can't unmap memory..
        popad
        movzx eax,[ReturnCode]
        mov     esp,ebp
        pop     ebp
        ret
@xNoMap:
        mov [VESA_IsMapped],0
        mov [VESAX_Engaged],0
        mov [ModeX_Engaged],0

        mov     eax,[xWIDTH]
        mov     ebx,[xHEIGHT]
        mov     ecx,[xBPP]


        mov     esi,Offset ModeX_ModeList
        mov     ebp,[ModeX_NbMode]
        or      ebp,ebp
        jnz     @xFindModeLoop
        mov     [ReturnCode],VModeNotFound
        popad
        movzx eax,[ReturnCode]
        mov     esp,ebp
        pop     ebp
        ret

@xFindModeLoop:
        cmp     ax,[esi]
        jne     @xSkipThisMode
        cmp     bx,[esi+2]
        jne     @xSkipThisMode
        cmp     cx,[esi+4]
        jne     @xSkipThisMode
        and eax,0FFFFh
        and ebx,0FFFFh
        and ecx,0FFFFh
        mov [VESA_SelectModeMaxX],ax
        mov [VESA_SelectModeMaxY],bx   
        mov [VESA_SelectModeBPP],cl    
        mov [VESA_SelectTrueBPP],cl
        xor edx,edx
        mov dx,ax
        shr edx,2                   ; en modeX une adr code 4pix
        mov [VESA_BPSL],edx
        xor edx,edx
        imul eax,ebx
        imul eax,ecx
        shr  eax,3
        mov  [VESA_MapSize],eax

        xor edx,edx
        xor eax,eax
        mov ax,[esi+6]
        imul eax,38                   ; mode*19
        mov [X_Modif_offset],eax

        mov [VESA_SelectMode],13h
        mov [VESA_Address],0A0000h
        mov [VESA_WindowSize],64000
        mov [VESA_IsMapped],0
        mov [ModeX_Engaged],1
        mov [ReturnCode],0

        popad
        movzx eax,[ReturnCode]
        mov     esp,ebp
        pop     ebp
        ret

@xSkipThisMode:
        add     esi,8
        dec     ebp
        jnz     @xFindModeLoop
        mov     [ReturnCode],VModeNotFound

        popad
        movzx eax,[ReturnCode]
        mov     esp,ebp
        pop     ebp
        ret
ChkModeX endp

; *************************************************************************
; * IntSetBank   ! Internal function !           !Internal function !     *
; * Enclenche une Bank Video en 0A0000h par l'int 10h ...                 *
; * Entree: numero de bank dans edx                                       *
; * Sortie : KeDalle                                                      *
; *************************************************************************
align 4
IntSetBank Proc
        push ebx eax
        xor ebx,ebx
        mov eax,4F05h
        int 10h
        pop eax ebx
        ret
IntSetBank EndP

; *************************************************************************
; * void SetMode(void)                                                    *
; * Enclenche le mode video VESA/VGA/ModeX                                *
; * Entree, Sortie : KeDalle                                              *
; *************************************************************************

SetMode proc
        push eax ebx
        mov bx,[VESA_SelectMode]
        or bx,bx
        jnz @continuons
        mov [ReturnCode], NoModeSelected
        pop ebx eax
        Ret

@continuons:
        cmp bx,100h
        jl @ItsVGA_VGAX

        mov     eax,4F02h
        Int     10h

        cmp     [VESAX_Engaged],1
        jne     @NoCRTCbidouille

        push esi edx
        mov  esi,offset VESAX_Table       ; Table des registres CRTC
        add  esi,[X_Modif_offset]       ; Offset propre a la resolution
        cld

        lodsb
        or   al,al     
        jz   @PasLaPeine
        mov  dx,3C2h    
        out  dx,al      
@PasLaPeine:
        mov  dx,3D4h
        mov  al,11h
        out  dx,al
        inc  dx
        in   al,dx
        and  al,7Fh
        out  dx,al

        dec  dx
        lodsb
        xor  ecx,ecx
        mov  cl,al
        rep  outsw
        pop edx esi
@NoCRTCbidouille:
; Add For better compatibility - begin
       push dx ax
        mov ax,04F06h
        xor bl,bl
        mov cx,[VESA_SelectModeMaxX]   ; SizeX
        int 10h
       pop ax dx
; Add For better compatibility - end
        mov [ReturnCode], NoErr
        pop ebx eax
        Ret

@ItsVGA_VGAX:
        mov ax,bx
        and eax,0FFh
        int 10h
        cmp     [ModeX_Engaged],1
        je     @CRTCbidouille
        mov [ReturnCode], NoErr
        pop ebx eax
        Ret

@CRTCbidouille:
    push esi edx
    mov  dx,3C6h
    xor  al,al    
    out  dx,al    

    mov  dx,3C4h
    mov  ax,0604h 
    out  dx,ax
    mov  ax,0100h   
    out  dx,ax    

    mov  al,01h
    out  dx,al  
    inc  dx
    in   al,dx 
    mov  ah,al 
    mov  al,01h 
    push ax     
    mov  al,ah  
    or   al,20h 
    out  dx,al  

    mov esi,Offset ModeX_Table
    mov eax,[X_Modif_offset]
    add esi,eax                 ; esi pointe sur les reg crtc
    xor eax,eax

    cld
    lodsb    
    or   al,al     
    jz   @PasLaPeine2
    mov  dx,3C2h   
    out  dx,al     
@PasLaPeine2:

    mov  dx,3C4h  
    mov  ax,0300h  
    out  dx,ax   

    mov  dx,3D4h   
    mov  al,11h     
    out  dx,al    
    inc  dx       
    in   al,dx
    and  al,7Fh
    out  dx,al

    dec  dx        
    lodsb          
    xor  ecx,ecx   
    mov  cl,al     
    rep  outsw     

    mov  ax,[VESA_SelectModeMaxX]
    shr  ax,3
    mov  ah,al
    mov  al,13h
    out  dx,ax

    mov  dx,3C4h  
    mov  ax,0F02h 
    out  dx,ax     
    mov  edi,[VESA_Address]
    xor  eax,eax    
    mov  ecx,[VESA_MapSize]     ; taille en byte de l'ecran
    shr ecx,4                   ; /4(plan)/4(dword)
    rep  stosd      

    mov  dx,3C4h 
    pop  ax       
    out  dx,ax    
    mov  dx,3C6h 
    mov  al,0FFh  
    out  dx,al    
    mov [ReturnCode], NoErr
    pop edx esi ebx eax
    ret
SetMode endp

; *************************************************************************
; * void CloseMode(void)                                                  *
; * DEinitialise le mode et de map la memoire video si necessaire         *
; * Entree, Sortie : KeDalle                                              *
; *************************************************************************

CloseMode    Proc
        cmp [VESA_IsMapped],1
        jne     @NoNeed
        Mov     [ReturnCode],NoErr
        pushad

        mov     eax,0801h            ; UnMap Memory
        mov     ebx,[VESA_Address]
        mov     cx,bx
        shr     ebx,16
        int     31h
;        jnc     @NoNeed
;        Mov     [ReturnCode],MemoryUnMapErr    ; Can't unmap memory..

        popad
@NoNeed:
        mov [VESA_IsMapped],0
        Ret
CloseMode    Endp

IsVGA proc
  push ebx
  mov eax,01A00h
  int 10h
  cmp al, 1Ah
  jne @IsVGAErr
  cmp bl, 7
  jb  @IsVGAErr
  cmp bl, 0FFh
  jnz @IsVGAOK
@IsVGAErr:
  xor eax,eax
  pop ebx
  ret
@IsVGAOK:
  xor eax,eax
  inc eax
  ret
IsVga endp

; *************************************************************************
; * void InitMode13h(void)                                                *
; * Initialise le mode VGA 13h et configure tout le merdier               *
; * Entree, Sortie : KeDalle                                              *
; *************************************************************************

InitMode13h proc
         mov [VESA_SelectMode],13h
         mov [VESA_SelectModeMaxX],320
         mov [VESA_SelectModeMaxY],200
         mov [VESA_SelectModeBPP],8
         mov [VESA_SelectTrueBPP],8
         mov [VESA_MapSize],64000
         mov [VESA_BPSL],320
         mov [VESA_LFB],1              ; mode13h dans UNE bank donc lineaire
         mov [VESA_PMInterf],0
         mov [VESA_Address],0A0000h
         mov [VESA_WindowSize],64000
         mov [VESA_IsMapped],0
         mov [ModeX_Engaged],0         ; pour plus tard
         mov [ReturnCode],0
         ret
InitMode13h endp

; *************************************************************************
; * void MemCopy(dword source, dword dest, dword long)                    *
; * Copie long octets de source vers dest                                 *
; * Entree: Source, destination et longueur                               *
; * Sortie : KeDalle                                                      *
; *************************************************************************

align 4
MemCopy proc
        push    ebp
        mov     ebp,esp
        pushad
        ARG     Source:DWORD, Destination:DWORD, Longueur: DWORD

        mov esi,[Source]        ; Source
        mov edi,[Destination]   ; Destination
        mov ecx,[Longueur]      ; Longueur
        mov ebx,ecx        ; A verifier !!!!
        shr ecx,2               ; nombre de DWORDs a copier
        rep movsd               ; deplacer ecx DWORDs
        mov ecx,ebx             ; puis ebx BYTEs
        and ecx,011b            ; restant a copier
        rep movsb               

        popad
        mov     esp,ebp
        pop     ebp
        ret
MemCopy endp

; *************************************************************************
; * void lisgif(dword source, dword destination                           *
; * Decompresse un buffer contenant les datas d'un fichier GIF            *
; * Entree : source, destination                                          *
; * Sortie : KeDalle                                                      *
; *************************************************************************

align 4
lisgif proc
  push    ebp
  mov     ebp,esp
  pusha
  ARG     Source:DWORD, Destination:DWORD
  mov esi,[Source]
  mov edi,[Destination]
  xor ebx,ebx
  xor edx,edx
  xor ecx,ecx
  xor eax,eax

  mov w [lbyte],0                 ;dernier code lu 0
  mov w [free],258                ;premire entre libre 258
  mov w [nbbit],9                 ;nb de bits d'un code = 9 
  mov w [max],511                 ;donc maximum d'entres = 511
  mov w [stackp],0                ;pointeur sur dbut
  mov w [restbits],0              ;pas de bits restants
  mov al,[esi]
  mov [restbyte],ax             ;rien  chercher
  inc esi

@mainloop:                      ;boucle pour chaque code
  call GetLogByte               ;lit un code
  cmp ax,eof                    ;signature fin de fichier ?
  jne @no_abandon
  jmp @abandon                  ;oui, abandonne
@no_abandon:
  cmp ax,clr                    ;code clr  ?
  jne @no_clear
  jmp @clear                    ;oui efface l'alphabet
@no_clear:
  mov w readbyt,ax              ;sauve le code actuel
  cmp ax,w free                 ;est-il dj dans l'alphabet ? (<free)
  jb @code_in_ab                ;oui, passe au traitement 
  mov ax,w old_code             ;non, donc cas spcial, transmettre 
  mov w act_code,ax             ;au traitement la dernire chane
  xor ebx,ebx
  mov bx,w stackp
  mov cx,w casspecial    ;et accrocher le premier caractre (toujours concret)
  mov w abStack[ebx],cx          ;gre la pile
  inc w stackp                  ;en consquence
@code_in_ab:                    ;code disponible dans l'alphabet :
  cmp ax,clr                    ;< code clr ?
  jb @concret                   ;oui, caractre concret
@fillstack_loop:                ;sinon passe au dcodage
  xor ebx,ebx
  mov bx,w act_code             ;le code est un pointeur dans l'alphabet
  shl ebx,1                      ;Word Array (!)
  push ebx
  mov ax,w ab_suffx[ebx]         ;cherche le suffixe, qui est concret
  xor ebx,ebx
  mov bx,w stackp               ;le place sur la pile
  shl ebx,1                      ;considre comme Word Array
  mov w abStack[ebx],ax
  inc w stackp
  pop ebx
  mov ax,w ab_prfx[ebx]          ;cherche le prfixe
  mov w act_code,ax             ;le prend comme code courant
  cmp ax,clr;> code clr 
  ja @fillstack_loop            ;poursuit le dcodage
@concret:                       ;plus que des caractres concrets sur la pile
  xor ebx,ebx
  mov bx,w stackp               ;empile le dernier code
  shl bx,1                      ;comme Word Array
  mov w abStack[ebx],ax
  mov w casspecial,ax           ;en prend note aussi pour le cas spcial 
  inc w stackp                  ;fait progresser le pointeur
  mov bx,w stackp               ;prpare la lecture de la pile
  dec bx                        ;dcrmente le pointeur
  shl bx,1                      ;sur Word Array 
@readstack_loop:                ;traite la pile
  mov ax,w abStack[ebx]          ;prend un caractre
  stosb                         ;et l'crit dans la mmoire de  destination

  dec bx                        ;pointeur de pile sur l'lment suivant
  dec bx
  jns @readstack_loop           ;fini ? non on poursuit
  mov w stackp,0                ;rinitialise le pointeur de pile
  xor ebx,ebx
  mov bx,w free              ;met  jour l'alphabet
  shl bx,1                      ; la position "free" 
  mov ax,w old_code             ;crit le dernier code dans prfixe
  mov w ab_prfx[ebx],ax
  mov ax,w act_code             ;et le code courant dans suffixe
  mov w ab_suffx[ebx],ax
  mov ax,w readbyt              ;le code  lu est le plus rcent
  mov w old_code,ax
  inc w free           ;met  jour la dernire position libre dans l'alphabet 
  mov ax,w free
  cmp ax,w max                  ;dj satur ??
  ja @no_mainloop
  jmp @mainloop                 ;non, on continue
@no_mainloop:
  cmp b nbbit,12                ;nombre de bits dj gal  12 ?
  jb @no_mainloop2
  jmp @mainloop                 ;oui, alors on recommence simplement
@no_mainloop2:
  inc w nbbit                   ;sinon on l'augmente
  mov cl,b nbbit                ;nouveau maximum d'entres
  mov ax,1                      ;1 dcal de nbbit vers la gauche
  shl ax,cl
  dec ax                        ;puis dcrment
  mov w max,ax                  ;enregistre le maximum 
  jmp @mainloop                 ;revient  la boucle principale
@clear:                         ;rinitialise l'alphabet:
  mov w nbbit,9                 ;nbbit reprend la valeur de dpart
  mov w max,511                 ;le maximum d'entres est 511
  mov w free,258                ;premire place libre = 258
  call GetLogByte               ;lit le code suivant
  mov w casspecial,ax           ;le note pour le cas spcial
  mov w old_code,ax             ;et comme ancien code
  stosb                         ;passe directement en mmoire car concret

@noovl2:
  jmp @mainloop                 ;retour  la boucle principale

@abandon:                       ;abandon par code Eof
  popa
  mov     esp,ebp
  pop    ebp
  ret
lisgif endp

align 4
GetLogByte proc
  push edi
  xor edi,edi
  xor eax,eax
  xor ebx,ebx
  xor ecx,ecx
  xor edx,edx
  
  mov ax,w nbbit                ;lit la taille en bits du code
  mov di,ax                     ;et la sauvegarde 
  mov dx,w restbits             ;dcale lbyte de 8-restbits vers la droite
  mov cx,8
  sub cx,dx                     ;calcule la diffrence
  mov ax,w lbyte
  shr ax,cl                     ;et lance le dcalage 
  mov w act_code,ax             ;sauve le code 
  sub di,dx                     ;restbits dj lus -> soustraire
@nextbyte:
  mov al,[esi]
  inc esi

  xor ah,ah
  mov w lbyte,ax                ;le met en lByte pour le prochain code
  dec w restbyte                ;octet trait
  jnz @suite
  push ax
  mov al,[esi]
  mov restbyte,ax
  inc esi
  pop ax

@suite:
  mov bx,1                      ;masque les bits restants dans l'octet
  mov cx,di                     ;fixe le nombre de bits
  shl bx,cl                     ;dcale 1 du nombre de bits
  dec bx                        ;et dcrmente
  and ax,bx                     ;masque le code 

  mov cx,dx                     ;effectue le dcalage recherch
  shl ax,cl                     ;de restbits vers la gauche 
  add w act_code,ax             ;ajoute le rsultat

  sbb dx,w nbbit                ;diminue le nombre restbits 
  add dx,8                      ;de ce qui dpasse 8 bits
  jns @positif
  add dx,8
@positif:
  sub di,8                      ;jusqu' 8 bits cherchs -> soustraire
  jle @fini                     ;<= 0 -> tout est fini
  add dx,w nbbit         ;sinon augmente restbits du nombre de bits manquants
  sub dx,8
  jmp @nextbyte                 ;et on continue

@fini:
  mov w restbits,dx   ;sauve le nombre de bits restants pour le prochain appel
  mov ax,w act_code   ;et charge ax
  pop edi
  ret
GetLogByte Endp

; *************************************************************************
; * void ModeText(void)                                                   *
; * Enclenche le Mode 3 (80x25x4b)                                        *
; * Entree, Sorite : Kedalle                                              *
; *************************************************************************

ModeText proc
        mov eax,3
        int 10h
        ret
ModeText endp

; *************************************************************************
; * void VSwpscrLFB(dword source)                                         *
; * Copie le buffer source vers l'ecran en utilisant le LFB               *
; * Entree: Source                                                        *
; * Sortie : KeDalle                                                      *
; *************************************************************************

align 4
VSwpscrLFB  proc
        push    ebp
        mov     ebp,esp
        push edi
        push esi
        push ecx
        ARG     Source:DWORD

        mov esi,[Source]
        mov edi,[VESA_Address]
        mov ecx,[VESA_MapSize]
        shr ecx,2                      ; ecx=longueur d'1 ecran 640*480/4
        rep movsd                      ; Copie en double word

        pop ecx
        pop esi
        pop edi
        mov esp,ebp
        pop ebp
        ret
VSwpscrLFB endp

; *************************************************************************
; * void VSwpscrBAN(dword source)                                         *
; * Copie le buffer source vers l'ecran en utilisant les BANKS            *
; * Entree: Source                                                        *
; * Sortie : KeDalle                                                      *
; *************************************************************************

align 4
VSwpscrBAN  proc
        push    ebp
        mov     ebp,esp
        pushad
        ARG     Source:DWORD

        mov esi,[Source]
        mov eax,[VESA_MapSize]
        shr eax,2                      ; eax=longueur d'1 ecran 640*480/4
        xor edx,edx

align 4
@loopy:
        cmp eax,16384
        jng @RestePeu
        push edx
        call SetBank
        pop edx
        mov edi,[VESA_Address]
        mov ecx,16384
        rep movsd
        inc edx
        sub eax,16384
        jmp short @loopy
align 4
@RestePeu:
        push edx
        call SetBank
        pop edx
        mov edi,[VESA_Address]
        mov ecx,eax
        rep movsd

        popad
        mov esp,ebp
        pop ebp
        ret
VSwpscrBAN endp


align 4
VSwpscrM_X proc
        push    ebp
        mov     ebp,esp
        pushad
        ARG     Source:DWORD

        mov ebx,[VESA_MapSize]
        shr ebx,2                   ; un plan=larg/4

        mov esi,[Source]
        mov edi,[VESA_Address]

        mov ecx,ebx
        mov dx,03C4h
        mov ax,0102h
        out dx,ax     ; enable writes to plane #0
align 4
@CopyPlan1:
        movsb
        add esi,3
        dec ecx
        jnz @CopyPlan1
  
        mov esi,[Source]
        mov edi,[VESA_Address]
        inc esi
        mov ecx,ebx
        shl ah,1
        out dx,ax     ; enable writes to plane #1
align 4
@CopyPlan2:
        movsb
        add esi,3
        dec ecx
        jnz @CopyPlan2

        mov esi,[Source]
        mov edi,[VESA_Address]
        add esi,2
        mov ecx,ebx
        shl ah,1
        out dx,ax     ; enable writes to plane #2
align 4
@CopyPlan3:
        movsb
        add esi,3
        dec ecx
        jnz @CopyPlan3

        mov esi,[Source]
        mov edi,[VESA_Address]
        add esi,3
        mov ecx,ebx
        shl ah,1
        out dx,ax     ; enable writes to plane #3
align 4
@CopyPlan4:
        movsb
        add esi,3
        dec ecx
        jnz @CopyPlan4
  
        popad
        mov esp,ebp
        pop ebp
        ret
VSwpscrM_X endp



; *************************************************************************
; * void SetBank(dword bank)                                              *
; * Enclenche la bank numero "bank"                                       *
; * Entree: Bank                                                          *
; * Sortie : KeDalle                                                      *
; *************************************************************************

align 4
SetBank      Proc
        push    ebp
        mov     ebp,esp
        pushad
        ARG     BANKNUM:DWORD
        mov     edx,[BANKNUM]
        cmp     [VESA_CurrentBank],dl
        je      @BankOk
        and     edx,01fh
        mov     VESA_CurrentBank,dl
        mov     edx,VESA_BANKTable[edx*4]
        call    dword ptr [VESA_SetBankPtr]
align 4
@BankOk:
        popad
        mov     esp,ebp
        pop     ebp
        RET
SetBank      endp


align 4
ClsVbuf proc
        push    ebp
        mov     ebp,esp
        ARG     BufferVideo:DWORD

        push edi eax ecx
        mov edi,[BufferVideo]
        mov ecx,[VESA_MapSize] 
        xor eax,eax                    ; eax=0000000h
        shr ecx,2                      ; ecx=longueur d'1 ecran 640*480/4
        rep stosd                      ; efface l'ecran
        pop ecx eax edi

        mov     esp,ebp
        pop     ebp
        RET
ClsVbuf endp

align 4
ClsLFB proc
        push edi eax ecx
        mov edi,[VESA_Address]
        mov ecx,[VESA_MapSize] 
        xor eax,eax                    ; eax=0000000h
        shr ecx,2                      ; ecx=longueur d'1 ecran 640*480/4
        rep stosd                      ; efface l'ecran
        pop ecx eax edi
        ret
ClsLFB endp

align 4
ClsBAN proc
        pushad
        mov ebx,[VESA_MapSize] 
        shr ebx,2
        xor eax,eax              ; eax=00000000h
        xor edx,edx

align 4
@loopyCLS:
        cmp ebx,16384
        jng @RestePeuCLS
        push edx
        call SetBank
        pop edx
        mov edi,[VESA_Address]
        mov ecx,16384
        rep stosd
        inc edx
        sub ebx,16384
        jmp short @loopyCLS
align 4
@RestePeuCLS:
        push edx
        call SetBank
        pop edx
        mov edi,[VESA_Address]
        mov ecx,ebx
        rep stosd

        popad
ClsBAN endp

align 4
ClsM_X proc
        pushad

        mov al,02h
        mov ah,00Fh
        mov dx,3C4h
        out dx,ax
        mov edi,[VESA_Address]
        mov ecx,[VESA_MapSize]   ; un byte accede a 4 plan 
        shr ecx,4                ; donc un dword a 4*4 pixels (/16)
        xor eax,eax              ; eax=00000000h
        rep  stosd

        popad
        ret
ClsM_X endp


;LigSuivEcr dd 0
;LigSuivBuf dd 0
;BufLarg    dd 0
;BufHaut    dd 0
;LenA      dd 0
;LenB      dd 0
;LenC      dd 0
;;CopyMem2VideoS(enreg.Address, enreg.X, enreg.Y, Xs, Ys, Ws, Hs, Xd, Yd);
;CopyMem2VideoS proc
;        push    ebp
;        mov     ebp,esp
;        pushad
;ARG BufAdr:DWORD,Wb:DWORD,Hb:DWORD,Xs:DWORD,Ys:DWORD,Ws:DWORD,Hs:DWORD,Xd:DWORD,Yd:DWORD
;
;
;        mov esi,[BufAdr]             ; On recupere l'adresse du buffer
;        mov ebx,[Wb]
;        add esi,[Xs]                 ; buffer+Xsource
;        mov eax,[Ys]
;        mul ebx
;        add esi,eax                  ; buffer+Xsource+Ysource*LargBuffer
;
;        mov edi,[VESA_Address]       ; On Recupere l'adresse video
;        mov ebx,[VESA_BPSL]
;        add edi,[Xd]                 ; video+Xdest
;        mov eax,[Yd]
;        mul ebx
;        add edi,eax                  ; video+Xdest+Ydest*LargEcran
;
;; Clip (b)  (edx,ecx)
;        xor edx,edx
;        mov dx,[VESA_SelectModeMaxX]
;        sub edx,[Xd]
;        cmp edx,[Ws]
;        jl @LargOk
;        mov edx,[Ws]
;@LargOk:
;        mov [BufLarg],edx
;        mov dx,[VESA_SelectModeMaxY]
;        sub edx,[Yd]
;        cmp edx,[Hs]
;        jl @HautOk
;        mov edx,[Hs]
;@HautOk:
;        mov [BufHaut],edx
;; Clip (e)
;
;; optimizations (b)
;        mov [LenA],0
;        mov edx,[BufLarg]
;        mov ecx,edi             ; je recup l'adresse de debut
;        and ecx,011b            ; multiple de 4 ??
;        jz @NoOpt01             ; oui, bon alors tout va bien ...
;        xor ecx,011b            ; NAN! bon, on compte combien il manque
;        inc ecx                 ; pour tomber sur un multiple de 4 ...
;        mov [LenA],ecx
;        sub edx,ecx             ; on y enleve a la longueur
;@NoOpt01:                       ; Maintenant, l'adr est un multiple de 4 !!!
;        mov ecx,edx
;        shr edx,2
;        mov [LenB],edx
;        and ecx,011b
;        mov [LenC],ecx
;
;; ESI pointe sur le coin haut gauche du buffer
;; EDI pointe sur le coin haut gauche de la memoire Video 
;
;        mov ebx,[VESA_BPSL]
;        sub ebx,[BufLarg]
;        mov [LigSuivEcr],ebx
;
;        mov eax,[Wb]
;        sub eax,[BufLarg]
;        mov [LigSuivBuf],eax
;
;        mov edx,[BufHaut]
;        mov ebx,[LigSuivEcr]
;@AffLine2:
;        mov ecx,[LenA]
;        or ecx,ecx
;        jz @LenANulle
;        rep movsb               ; et les affiche 1 a 1
;@LenANulle:
;        mov ecx,[LenB]
;        or ecx,ecx
;        jz @LenBNulle
;        rep movsd               ; et les affiche 4 a 4
;@LenBNulle:
;        mov ecx,[LenC]
;        or ecx,ecx
;        jz @LenCNulle
;        rep movsb               ; et les affiche 1 a 1
;@LenCNulle:
;        add esi,eax             ; passe a la ligne suivante [LigSuivBuf]
;        add edi,ebx             ; passe a la ligne suivante [LigSuivEcr]
;        dec edx                 ; une de moins !!!
;        jnz @AffLine2           ; fini ou pas ?
;
;        popad
;        mov     esp,ebp
;        pop    ebp
;        ret                     ; On rentre chez nous ....
;CopyMem2VideoS endp


align 4
WaitVbl proc
        push edx eax
        mov   dx,3DAh
@label1:
        in    al,dx
        and   al,08h
        jnz   @label1
@label2:
        in    al,dx
        and   al,08h
        jz    @label2
        pop eax edx
        ret
WaitVbl endp


; *************************************************************************
; * Misc Functions                                                        *
; *************************************************************************

ScreenOff proc
   push edx eax
   mov edx,03C4h
   xor eax,eax
   inc eax
   out dx,al
   inc edx
   in al,dx
   or al,00100000b            ; 32
   out dx,al
   pop eax edx
   ret
ScreenOff endp

ScreenOn proc
   push edx eax
   mov edx,03C4h
   xor eax,eax
   inc eax
   out dx,al
   inc edx
   in al,dx
   and al,11011111b            ; not 32
   out dx,al
   pop eax edx
   ret
ScreenOn endp

CPULine proc
   push eax edx
   mov edx,03DAh
@CPULineWait1:
   in al,dx
   test al,1
   jnz @CPULineWait1
@CPULineWait2:
   in al,dx
   test al,1
   jz @CPULineWait2
   mov edx,03C8h
   xor eax,eax
   out dx,al
   inc edx
   mov eax,20h
   out dx,al
   out dx,al
   out dx,al
   mov edx,03DAh
@CPULineWait3:
   in al,dx
   test al,1
   jnz @CPULineWait3
@CPULineWait4:
   in al,dx
   test al,1
   jz @CPULineWait4
   mov edx,3C8h
   xor eax,eax
   out dx,al
   inc edx
   out dx,al
   out dx,al
   out dx,al
   mov edx,3DAh
@CPULineWait5:
   in al,dx
   test al,8
   jnz @CPULineWait5
@CPULineWait6:
   in al,dx
   test al,8
   jz @CPULineWait6
   pop edx eax
   ret
CPULine endp

; *************************************************************************
; * Palette Functions                                                     *
; *************************************************************************

align 4
SetColor proc
        push    ebp
        mov     ebp,esp
        push eax edx
        ARG     Pen:DWORD,Red:DWORD,Green:DWORD,Blue:DWORD

        mov   eax,[Pen]
        mov   edx,03C8h
        out   dx, al
        inc   edx
        mov   eax,[Red]
        out   dx, al
        mov   eax,[Green]
        out   dx, al
        mov   eax,[Blue]
        out   dx, al

        pop edx eax
        mov esp,ebp
        pop ebp
        ret
SetColor endp

align 4
GetPal proc
        push    ebp
        mov     ebp,esp
        push edi edx ecx eax
        ARG     Palette:DWORD

        xor ecx,ecx
        mov edi,[Palette]
        mov dx,03C7h
@GetPalLoop:
        mov al,cl 
        out dx, al
        add dx, 2
        cld

        in al, dx
        stosb
        in al, dx
        stosb
        in al, dx
        stosb

        sub dx,2
        inc cx
        cmp cx,255
        jle @GetPalLoop

        pop eax ecx edx edi
        mov esp,ebp
        pop ebp
        ret
GetPal endp

;SaveModeInfos proc
;        push    ebp
;        mov     ebp,esp
;        push edi esi ecx
;        ARG     infosPointer:DWORD
;
;        mov esi,offset VESA_SelectMode    ; premiere info du "block"
;        mov edi,[infosPointer]
;        mov ecx,568 ;/4                      ; last-first+length(last)
;        rep movsb
;
;        pop ecx esi edi
;        mov esp,ebp
;        pop ebp
;        ret
;SaveModeInfos endp

;RestoreModeInfos proc
;        push    ebp
;        mov     ebp,esp
;        push edi esi ecx
;        ARG     infosPointer:DWORD
;
;        mov esi,[infosPointer]
;        mov edi,offset VESA_SelectMode    ; premiere info du "block"
;        mov ecx,568 ;/4                     ; last-first+length(last)
;        rep movsb
;
;        pop ecx esi edi
;        mov esp,ebp
;        pop ebp
;        ret
;RestoreModeInfos endp

Buffer32ToScreen16LFB proc       ; RVBx(8888) -> RVB (565)
   push    ebp
   mov     ebp,esp
   pushad
   ARG  Buffer:DWORD

   xor edx,edx
   mov esi,[Buffer]              ; Source
   mov edi,[VESA_Address]        ; Destination (en Video)
   mov ecx,[VESA_NbPix]

@@MainReduce:
    mov eax,[ESI] ;lodsd         ; Charge UN pixel 32b du buffer
    mov bl,al                    ; (B) car eax=xRVB
    shr eax,8                    ; eax=xxRV
    shr bl,3                     ; (B) sur 6bits
    mov bh,ah                    ; (R)
    and ax,011111100b            ; eax=V (6bits <- de 2)
    and bh,011111000b            ; reduction du nb de couleurs -> 6bits
    shl ax,3                     ; ax=xxxxxVVVVVVxxxxx
    or  ax,bx                    ; ax=BBBBBVVVVVVRRRRR
    mov [EDI],ax ;stosw          ; pose ax
    add esi,4
    add edi,2
    dec ecx
    jnz @@MainReduce

   popad
   mov esp,ebp
   pop ebp
   ret
Buffer32ToScreen16LFB endp

end
