//---DIRECTGEM---------------------------------------------------------------
//
//---------------------------------------------------------------------------

#include "gemmath.h"

float RemapEase(float t, float a, float b)
{
	D3DVALUE 			k;
	D3DVALUE			s = a + b;

	if (s == 0.0)
		return t;

	if (s > 1.0)
	{
		a = a/s;
		b = b/s;
	}

	k = 1.0/(2.0-a-b);

	if (t < a)
		return ((k/a)*t*t);
	else
	{
		if (t < 1.0-b)
			return (k*(2*t-a));
		else
		{
			t = 1.0-t;
			return (1.0-(k/b)*t*t);
		}
	}
}


void CalculateVectorKey( GEM_KEY* key )
{
	GEM_VECTOR		g1 = key->next->_vec - key->_vec;
	GEM_VECTOR		g2 = key->_vec - key->prev->_vec;
	GEM_VECTOR		t0;
	GEM_VECTOR		t1;

 	
	D3DVALUE		delta = (key->next->frame - key->prev->frame);
	D3DVALUE		deltaT1 = (key->next->frame - key->frame) / delta;
	D3DVALUE		deltaT2 = (key->frame - key->prev->frame) / delta;

	t0 = (1-key->tension)*(1-key->continuity)*(1-key->bias)*g1 +
		 (1-key->tension)*(1+key->continuity)*(1+key->bias)*g2;

	t1 = (1-key->tension)*(1+key->continuity)*(1-key->bias)*g1 +
		 (1-key->tension)*(1-key->continuity)*(1+key->bias)*g2;

	key->t0 = deltaT1*t0;
	key->t1 = deltaT2*t1;

}


void CalculateFirstVectorKey(GEM_KEY* key)
{
	GEM_VECTOR		g1 = key->next->_vec - key->_vec; 

	key->t0 = (g1*1.5-key->next->t1*0.5)*(1-key->tension);
	key->t1 = GEM_VECTOR(0,0,0);    	
}


void CalculateLastVectorKey(GEM_KEY* key)
{
	GEM_VECTOR		g1 = key->_vec - key->prev->_vec;

	key->t0 = GEM_VECTOR(0,0,0);
	key->t1 = (g1*1.5 - key->prev->t0*0.5)*(1-key->tension);	
}
	
void Init2KeysVectorSpline(GEM_TRACK* track)
{
	GEM_KEY*		key = track->keyList;
	GEM_VECTOR		g1 = key->next->_vec - key->_vec;

	key->t0 = g1*(1-key->continuity);
	key->t1 = GEM_VECTOR(0,0,0);
		
	key->next->t0=GEM_VECTOR(0,0,0);
	key->next->t1=g1*(1-key->next->continuity);
}


void InitVectorSpline(GEM_TRACK* track)
{
	GEM_KEY*		key = track->keyList;

	if( !key || !key->next )
		return;

	key=key->next;

	if( !key->next )
		Init2KeysVectorSpline( track );
	else
	{
		for( ; key->next ; key=key->next )
			CalculateVectorKey( key );

		CalculateLastVectorKey( key );
		CalculateFirstVectorKey( track->keyList );
	}
}

GEM_VECTOR VectorSpline( GEM_TRACK* track, DWORD frame )
{
	GEM_KEY*		key = track->keyList;
	D3DVALUE		h[4];
	D3DVALUE		t, t2, t3;
	GEM_VECTOR		v;

	if( !key->next )
		return key->_vec;

	for( ; key->next && key->next->frame<frame; key = key->next );

	if( !key->next )
		return key->_vec;

	t=((D3DVALUE)frame - (D3DVALUE)key->frame)/((D3DVALUE)key->next->frame - (D3DVALUE)key->frame);
	RemapEase( t, key->easefrom, key->easeto );

	t2 = t*t;
	t3 = t2*t;

	h[0] = 2*t3 - 3*t2 + 1.0f;
	h[1] = -2*t3 + 3*t2;
	h[2] = t3 - 2*t2 + t;
	h[3] = t3 - t2;

	v = h[0]*key->_vec + h[1]*key->next->_vec + h[2]*key->t0 + h[3]*key->next->t1;

	return v;
}

/*
void CalculateFirstQuatKey(GEM_KEY* key)
{
	GEM_QUATERNION		q1 = UnityInverse(key->_qtr)*key->next->_qtr;	
	GEM_QUATERNION		log1 = ln(q1);
	GEM_QUATERNION		log2 = ln(q1);

	GEM_QUATERNION		t0;
	GEM_QUATERNION		t1;

	t0 = 0.5*(1-key->tension)*(1-key->continuity)*(1-key->bias)*log1 +
		 0.5*(1-key->tension)*(1+key->continuity)*(1+key->bias)*log2;						

	t1 = 0.5*(1-key->tension)*(1+key->continuity)*(1-key->bias)*log1 +
		 0.5*(1-key->tension)*(1-key->continuity)*(1+key->bias)*log2;						

	t0 = 0.5*(t0 - log1);
	t1 = 0.5*(log2 - t1);

	key->an=key->_qtr*exp(t0);
	key->bn=key->_qtr*exp(t1);
}

void CalculateLastQuatKey(GEM_KEY* key)
{
	GEM_QUATERNION		q2 = UnityInverse(key->prev->_qtr)*key->_qtr;
	GEM_QUATERNION		log1 = ln(q2);
	GEM_QUATERNION		log2 = ln(q2);

	GEM_QUATERNION		t0;
	GEM_QUATERNION		t1;

	t0 = 0.5*(1-key->tension)*(1-key->continuity)*(1-key->bias)*log1 +
		 0.5*(1-key->tension)*(1+key->continuity)*(1+key->bias)*log2;						

	t1 = 0.5*(1-key->tension)*(1+key->continuity)*(1-key->bias)*log1 +
		 0.5*(1-key->tension)*(1-key->continuity)*(1+key->bias)*log2;						

	t0 = 0.5*(t0 - log1);
	t1 = 0.5*(log2 - t1);

	key->an=key->_qtr*exp(t0);
	key->bn=key->_qtr*exp(t1);
}


void Init2KeysQuatSpline(GEM_TRACK* track)
{
	GEM_KEY*		key = track->keyList;

	CalculateFirstQuatKey( key );
	CalculateLastQuatKey( key->next );
}


void CalculateQuatKey(GEM_KEY* key)
{

	
	GEM_QUATERNION		q1 = UnityInverse(key->_qtr)*key->next->_qtr;
	GEM_QUATERNION		q2 = UnityInverse(key->prev->_qtr)*key->_qtr;
	GEM_QUATERNION		log1 = ln(q1);
	GEM_QUATERNION		log2 = ln(q2);

	D3DVALUE			delta = (key->next->frame - key->prev->frame);
	if( delta==0.0f ) 
		delta = 1.0f;

	D3DVALUE			deltaT1 = (key->next->frame - key->frame) / delta;
	D3DVALUE			deltaT2 = (key->frame - key->prev->frame) / delta;

	GEM_QUATERNION		t0;
	GEM_QUATERNION		t1;

	t0 = 0.5*(1-key->tension)*(1-key->continuity)*(1-key->bias)*log1 +
		 0.5*(1-key->tension)*(1+key->continuity)*(1+key->bias)*log2;						

	t1 = 0.5*(1-key->tension)*(1+key->continuity)*(1-key->bias)*log1 +
		 0.5*(1-key->tension)*(1-key->continuity)*(1+key->bias)*log2;						

	t0 = 0.5*(t0 - log1);
	t1 = 0.5*(log2 - t1);

	key->an=deltaT1*key->_qtr*exp(t0);
	key->bn=deltaT2*key->_qtr*exp(t1);
}

void InitQuatSpline(GEM_TRACK* track)
{
	GEM_KEY*		key = track->keyList;

	if( !key || !key->next )
		return;

	key=key->next;
	
	//make all quaternions to have acute angles (q and -q represent the same rot)
	for( GEM_KEY* tmp = track->keyList ; tmp->next; tmp = tmp->next )
		if( Dot( tmp->_qtr, tmp->next->_qtr)<0.0f )
			tmp->next->_qtr = -tmp->next->_qtr;

	if( !key->next)
		Init2KeysQuatSpline( track);
	else
	{
		for( ; key->next ; key = key->next )					
			CalculateQuatKey( key );

		CalculateFirstQuatKey( track->keyList );
		CalculateLastQuatKey( key );
	}
}

GEM_QUATERNION QuatSpline(GEM_TRACK* track, DWORD frame)
{
	GEM_KEY*		key = track->keyList;
	D3DVALUE		t;
	GEM_QUATERNION	q;

	if( !key->next )
		return key->_qtr;

	for( ; key->next && key->next->frame<frame; key = key->next );

	if( !key->next )
		return key->_qtr;

	t=((D3DVALUE)frame - (D3DVALUE)key->frame)/((D3DVALUE)key->next->frame - (D3DVALUE)key->frame);
	RemapEase( t, key->easefrom, key->easeto );

	q = Squad( key->_qtr, key->an, key->next->bn, key->next->_qtr, t );
	return q;
}
*/



void CalculateQuatKey(GEM_KEY *key)
{
	GEM_QUATERNION		q0, q1, q2;
	GEM_QUATERNION		g1, g2, g3;

 q0=key->prev->_qtr;
 q1=key->_qtr;
 q2=key->next->_qtr;

 g1=Slerp(q1,q0,-(1+key->bias)/3.0);
 g2=Slerp(q1,q2, (1-key->bias)/3.0);

 g3=Slerp(g1,g2,0.5*(1+key->continuity));
 key->bn=Slerp(q1,g3,key->tension-1);

 g3=Slerp(g1,g2,0.5*(1-key->continuity));
 key->an=Slerp(q1,g3,1-key->tension);

}


void CalculateFirstQuatKey(GEM_KEY *key)
{
	GEM_QUATERNION		q0, q1;

 q0=key->_qtr;
 q1=key->next->_qtr;

 key->an=Slerp(q0,q1,(1-key->tension)*(1+key->continuity*key->bias)/3.0);
 key->bn=GEM_QUATERNION(0,0,0,0);

}


void CalculateLastQuatKey(GEM_KEY *key)
{
	GEM_QUATERNION		qn, qn_1;

	qn=key->_qtr;
	qn_1=key->prev->_qtr;

	key->an=GEM_QUATERNION(0,0,0,0);
	key->bn=Slerp(qn,qn_1,(1-key->tension)*(1-key->continuity*key->bias)/3.0);

}


void Init2KeysQuatSpline(GEM_TRACK *track)
{
	GEM_KEY*			key = track->keyList;
	GEM_QUATERNION		q0, q1;

 q0=key->_qtr;
 q1=key->next->_qtr;

 key->an=Slerp(q0,q1,(1-key->tension)*(1+key->continuity*key->bias)/3.0);
 key->bn=GEM_QUATERNION(0,0,0,0);

 key->next->an=GEM_QUATERNION(0,0,0,0);
 key->next->bn=Slerp(q1,q0,(1-key->tension)*(1-key->continuity*key->bias)/3.0);

}



void InitQuatSpline(GEM_TRACK* track)
{
	GEM_KEY*		key = track->keyList;

	if( !key || !key->next )
		return;

	key=key->next;
	
	//make all quaternions to have acute angles (q and -q represent the same rot)
	for( GEM_KEY* tmp = track->keyList ; tmp->next; tmp = tmp->next )
		if( Dot( tmp->_qtr, tmp->next->_qtr)<0.0f )
			tmp->next->_qtr = -tmp->next->_qtr;

	if( !key->next)
		Init2KeysQuatSpline( track);
	else
	{
		for( ; key->next ; key = key->next )					
			CalculateQuatKey( key );

		CalculateFirstQuatKey( track->keyList );
		CalculateLastQuatKey( key );
	}
}


GEM_QUATERNION QuatSpline(GEM_TRACK *track, DWORD frame)
{
	D3DVALUE			t;
	GEM_KEY*			key = track->keyList;
	GEM_QUATERNION		q0, q1, q2;

	if (!key || !key->next)
		return key->_qtr;

	for ( ; key->next && key->next->frame<frame ; key=key->next);

	if (!key->next)
		return key->_qtr;

	t=((float)frame-(float)key->frame)/((float)key->next->frame-(float)key->frame);

	t=RemapEase(t,key->easefrom,key->next->easeto);

	q0 = Slerp(key->_qtr,key->an,t);
	q1 = Slerp(key->an,key->next->bn,t);
	q2 = Slerp(key->next->bn,key->next->_qtr,t);

	q0 = Slerp(q0,q1,t);
	q1 = Slerp(q1,q2,t);

	q0 = Slerp(q0,q1,t);


	return q0;
}



void CalculateFloatKey( GEM_KEY* key )
{
	D3DVALUE		g1 = key->next->_val - key->_val;
	D3DVALUE		g2 = key->_val - key->prev->_val;
	D3DVALUE		v0;
	D3DVALUE		v1;

 	
	D3DVALUE		delta = (key->next->frame - key->prev->frame);
	D3DVALUE		deltaT1 = (key->next->frame - key->frame) / delta;
	D3DVALUE		deltaT2 = (key->frame - key->prev->frame) / delta;

	v0 = (1-key->tension)*(1-key->continuity)*(1-key->bias)*g1 +
		 (1-key->tension)*(1+key->continuity)*(1+key->bias)*g2;

	v1 = (1-key->tension)*(1+key->continuity)*(1-key->bias)*g1 +
		 (1-key->tension)*(1-key->continuity)*(1+key->bias)*g2;

	key->v0 = deltaT1*v0;
	key->v1 = deltaT2*v1;

}


void CalculateFirstFloatKey(GEM_KEY* key)
{
	D3DVALUE		g1 = key->next->_val - key->_val; 

	key->v0 = (g1*1.5-key->next->v1*0.5)*(1-key->tension);
	key->v1 = 0;    	
}


void CalculateLastFloatKey(GEM_KEY* key)
{
	D3DVALUE		g1 = key->_val - key->prev->_val;

	key->v0 = 0;
	key->v1 = (g1*1.5 - key->prev->v0*0.5)*(1-key->tension);	
}
	
void Init2KeysFloatSpline(GEM_TRACK* track)
{
	GEM_KEY*		key = track->keyList;
	D3DVALUE		g1 = key->next->_val - key->_val;

	key->v0 = g1*(1-key->continuity);
	key->v1 = 0;
	
	key->next->v0 = 0;
	key->next->v1 = g1*(1-key->next->continuity);	
}


void InitFloatSpline(GEM_TRACK* track)
{
	GEM_KEY*		key = track->keyList;

	if( !key || !key->next )
		return;

	key=key->next;

	if( !key->next )
		Init2KeysFloatSpline( track );
	else
	{
		for( ; key->next ; key=key->next )
			CalculateFloatKey( key );

		CalculateLastFloatKey( key );
		CalculateFirstFloatKey( track->keyList );
	}
}

D3DVALUE FloatSpline( GEM_TRACK* track, DWORD frame )
{
	GEM_KEY*		key = track->keyList;
	D3DVALUE		h[4];
	D3DVALUE		t, t2, t3;
	FLOAT			a;

	if( !key->next )
		return key->_val;

	for( ; key->next && key->next->frame<frame; key = key->next );

	if( !key->next )
		return key->_val;

	t=((D3DVALUE)frame - (D3DVALUE)key->frame)/((D3DVALUE)key->next->frame - (D3DVALUE)key->frame);
	RemapEase( t, key->easefrom, key->easeto );

	t2 = t*t;
	t3 = t2*t;

	h[0] = 2*t3 - 3*t2 + 1.0f;
	h[1] = -2*t3 + 3*t2;
	h[2] = t3 - 2*t2 + t;
	h[3] = t3 - t2;

	a = h[0]*key->_val + h[1]*key->next->_val + h[2]*key->v0 + h[3]*key->next->v1;

	return a;
}



	
