#ifndef __GEMUTIL_H_
#define __GEMUTIL_H_

#include "gemmath.h"
#include "gem.h"

void InitQuatSpline(GEM_TRACK* track);
void InitVectorSpline(GEM_TRACK* track);
void InitFloatSpline(GEM_TRACK* track);
GEM_VECTOR VectorSpline(GEM_TRACK* track, DWORD frame);
GEM_QUATERNION QuatSpline(GEM_TRACK* track, DWORD frame);
D3DVALUE FloatSpline(GEM_TRACK* track, DWORD frame);

void AddKey(GEM_KEY* key, GEM_TRACK* track);
void AddObject(GEM_OBJECT* object, GEM_SCENE* scene);
void AddKeyframer(GEM_KEYFRAMER* keyframer, GEM_SCENE* scene);
D3DVALUE LensToFOV(D3DVALUE lens);
void CalculateNormals(GEM_MESH* mesh);
void PrepareKeyframer(GEM_SCENE* s);
void LinkHierarchy(GEM_SCENE* s);
void AddElement(GEM_ELEMENT* elem, GEM_MESH* mesh);
int  InitAllLights(GEM_SCENE* scene, LPDIRECT3DDEVICE3 pd3dDevice);
int InitAllCameras(GEM_SCENE* scene, D3DVALUE aspect, D3DVALUE nearZ=10.0f, D3DVALUE farZ=10000.f);

#endif /*__GEMUTIL_H_*/