//---DIRECTGEM----------------------------------------------------------------
//	gem.h header file for DIRECTGEM engine
//
//
//----------------------------------------------------------------------------

#ifndef __GEM_H_
#define __GEM_H_

#define STRICT
#define D3D_OVERLOADS

#include	<d3d.h>
#include	<ddraw.h>

enum _GEM_ERROR
{
	gem_error_ok=0,
	gem_error_file_open,
	gem_error_bad_file,
	gem_error_invalid_track,
	gem_error_invalid_frame,
	gem_error_memory,
	gem_error_invalid_hierarchy,
	gem_error_invalid_object,
	gem_error_invalid_scene,
	gem_error_invalid_texture,
	gem_error_no_viewport,
	gem_error_scene_not_initialized,
	gem_error_null_pointer,
	gem_error_invalid_device,
	gem_error_no_active_camera,
	gem_error_forcedw = 0xFFFFFFFF

}; //GEM_ERROR;


#define	MESH						1	
#define	LIGHT						2
#define	MATERIAL					4
#define	CAMERA						8


#define	CAMERATRACK					1
#define	CAMERATRGTRACK				2
#define	MESHTRACK					4
#define	LIGHTTRACK					8
	

#define MAIN_CHUNK					0x4D4D
#define VERSION_CHUNK  				0x0002
#define EDITOR_CHUNK  				0x3D3D
#define KEYFRAMER_CHUNK				0xB000
#define OBJECT_CHUNK    			0x4000
#define TRIMESH_CHUNK      			0x4100
#define VERTICES_CHUNK        		0x4110
#define FACES_CHUNK        			0x4120
#define FACES_MATERIAL_CHUNK		0x4130
#define MAPPING_COORDS_CHUNK		0x4140
#define LOCAL_COORDS_CHUNK			0x4160
#define LIGHT_CHUNK      			0x4600
#define SPOTLIGHT_CHUNK        		0x4610
#define CAMERA_CHUNK      			0x4700
#define MATERIAL_CHUNK 				0xAFFF
#define MATERIAL_NAME_CHUNK			0xA000
#define MAP_FILENAME_CHUNK			0xA300
#define TEXTURE_MAP1_CHUNK			0xA200
#define TEXTURE_MAP2_CHUNK			0xA33A
#define BUMP_MAP_CHUNK      		0xA230
#define SPECULAR_MAP_CHUNK			0xA204
#define AMBIENT_TRACK_CHUNK    		0xB001
#define MESH_TRACK_CHUNK    		0xB002
#define CAMERA_TRACK_CHUNK    		0xB003
#define CAMERA_TARGET_TRACK_CHUNK   0xB004
#define OMNILIGHT_TRACK_CHUNK    	0xB005
#define SPOTLIGHT_TRG_TRACK_CHUNK	0xB006
#define SPOTLIGHT_TRACK_CHUNK    	0xB007
#define FRAMES_CHUNK    			0xB008
#define OBJECT_INFO_CHUNK      		0xB010
#define OBJECT_PIVOT_CHUNK      	0xB013
#define MORF_ANGEL_TRACK_CHUNK      0xB015
#define POSITION_TRACK_CHUNK      	0xB020
#define ROTATION_TRACK_CHUNK      	0xB021
#define SCALE_TRACK_CHUNK      		0xB022
#define FOV_TRACK_CHUNK      		0xB023
#define ROLL_TRACK_CHUNK      		0xB024
#define COLOR_TRACK_CHUNK      		0xB025
#define MORPH_TRACK_CHUNK      		0xB026
#define HOTSPOT_TRACK_CHUNK      	0xB027
#define FALLOFF_TRACK_CHUNK      	0xB028
#define HIDE_TRACK_CHUNK      		0xB029
#define HIERARCHY_CHUNK      		0xB030


struct	GEM_TEXTURE
{

	LPDIRECTDRAWSURFACE4	pddsSurface;
	LPDIRECT3DTEXTURE2		pd3dTexture;

	HBITMAP					hbBitmap;
	LPVOID					pBuffer;
	TCHAR					name[80];

	DWORD					dwStage;
	BOOL					bPalettized;

	DDSURFACEDESC			ddsd;

	GEM_TEXTURE				*next, *prev;


	~GEM_TEXTURE();

};



class GEM_QUATERNION
{
public:

	D3DVALUE	w, x, y, z;	

	GEM_QUATERNION(D3DVALUE a = 0) : w(a), x(a), y(a), z(a)
	{
	}

	GEM_QUATERNION(D3DVALUE _w, D3DVALUE _x, D3DVALUE _y, D3DVALUE _z) : w(_w), x(_x), y(_y), z(_z)
	{
	}

	GEM_QUATERNION(GEM_QUATERNION& q) : w(q.w), x(q.x), y(q.y), z(q.z)
	{
	}
};


class GEM_VECTOR
{
public:
	D3DVALUE	x, y, z;

	GEM_VECTOR(D3DVALUE a = 0) : x(a), y(a), z(a)
	{
	}

	GEM_VECTOR(D3DVALUE a, D3DVALUE b, D3DVALUE c) : x(a), y(b), z(c)
	{
	}

	GEM_VECTOR(GEM_VECTOR& v) : x(v.x), y(v.y), z(v.z)
	{
	}

	GEM_VECTOR(D3DVECTOR& v) : x(v.dvX), y(v.dvY), z(v.dvZ)
	{
	}

};


class GEM_MATRIX
{
public:

	D3DVALUE	MATRIX[4][4];

	GEM_MATRIX()
	{
	}

	GEM_MATRIX(GEM_MATRIX& mat)
	{
		for( int i = 0 ; i<4 ; i++ )
			for( int j=0 ; j<4; j++ )
				MATRIX[i][j] = mat.MATRIX[i][j];
	}

	GEM_MATRIX(D3DMATRIX& mat)
	{
		MATRIX[0][0]=mat._11; MATRIX[0][1]=mat._12; MATRIX[0][2]=mat._13; MATRIX[0][3]=mat._14;
		MATRIX[1][0]=mat._12; MATRIX[1][1]=mat._22; MATRIX[1][2]=mat._23; MATRIX[1][3]=mat._24;
		MATRIX[2][0]=mat._13; MATRIX[2][1]=mat._32; MATRIX[2][2]=mat._33; MATRIX[2][3]=mat._34;
		MATRIX[3][0]=mat._14; MATRIX[3][1]=mat._42; MATRIX[3][2]=mat._43; MATRIX[3][3]=mat._44;
	}

	D3DVALUE& operator() (int row, int col)
	{
		return MATRIX[row-1][col-1];
	}

	GEM_MATRIX& operator= (GEM_MATRIX& mat)
	{
		if( this==&mat )
			return *this;

		for( int i=0 ; i<4 ; i++ )
			for( int j=0 ; j<4 ;  j++)
				MATRIX[i][j]=mat( i+1, j+1 );

		return *this;
	}

};


class GEM_OBJECT
{
public:

	LPVOID			object;
	TCHAR			name[80];
	WORD			type;

	GEM_OBJECT*		next;
	GEM_OBJECT*		prev;
};


class GEM_MAP
{
public:

	TCHAR			filename[80];
};


class GEM_MATERIAL
{
public:

	TCHAR			name[80];

	GEM_MAP*		texture1;
	GEM_MAP*		texture2;
	GEM_MAP*		reflection;
	GEM_MAP*		bump;
};

class GEM_LIGHT
{
public:

	GEM_VECTOR		position;
	LPDIRECT3DLIGHT	pd3dLight;

};

class GEM_CAMERA
{
public:

	GEM_VECTOR		position;
	GEM_VECTOR		target;

	D3DVALUE		fov;
	D3DVALUE		roll;

	GEM_MATRIX		mtxView;
	GEM_MATRIX		mtxProjection;

	D3DVALUE		aspect;
	D3DVALUE		nearZ;
	D3DVALUE		farZ;
};


class GEM_ELEMENT
{
public:
	
	GEM_MATERIAL*	mat;

	WORD			number;
	WORD*			idx;

	GEM_ELEMENT*	next;
	GEM_ELEMENT*	prev;
	
};

class GEM_FACE
{
public:
	WORD		indices[3];
	WORD		used;
};

class GEM_MESH
{
public:

	WORD			faceNbr;
	WORD			vertexNbr;

	GEM_FACE*		faces;
	D3DVERTEX*		vertices;
	GEM_ELEMENT*	elemList;
	
	GEM_MATRIX		mtxTransform;
};

class GEM_KEY
{
public:

	GEM_QUATERNION		_qtr;
	GEM_VECTOR			_vec;
	D3DVALUE			_val;
	GEM_MESH*			_obj;	
		

	DWORD				frame;

	D3DVALUE			tension;
	D3DVALUE			bias;
	D3DVALUE			continuity;
	D3DVALUE			easefrom;
	D3DVALUE			easeto;

	GEM_VECTOR			t0;	//vector spline tangent vector outgoing
	GEM_QUATERNION		an;	//squad a coeff
	D3DVALUE			v0; //float spline tangent outgoing

	GEM_VECTOR			t1; //vector spline tangent vector incoming
	GEM_QUATERNION		bn; //squad b coeff
	D3DVALUE			v1; //float spline tangent invoming 
	

	GEM_KEY*			next;
	GEM_KEY*			prev;
};

class GEM_TRACK
{
public:

	GEM_KEY*			keyList;

	WORD				flags;	
};


class GEM_MESH_TRACK
{
public:

	GEM_TRACK*			rotation;
	GEM_TRACK*			position;
	GEM_TRACK*			scale;
	GEM_TRACK*			morph;
	GEM_TRACK*			hide;
};


class GEM_LIGHT_TRACK
{
public:

	GEM_TRACK*			position;
	GEM_TRACK*			color;
};


class GEM_CAMERA_TRACK
{
public:

	GEM_TRACK*			position;
	GEM_TRACK*			fov;
	GEM_TRACK*			roll;
};


class GEM_CAMERATRG_TRACK
{
public:

	GEM_TRACK*			position;
};

class GEM_KEYFRAMER
{
public:

	DWORD				type;
	LPVOID				track;

	TCHAR				objName[80];
	LPVOID				obj;

	WORD				hierarchy;
	WORD				link;
	GEM_KEYFRAMER*		parent;

	GEM_VECTOR			pivot;

	GEM_KEYFRAMER*		next;
	GEM_KEYFRAMER*		prev;
};

class GEM_SCENE
{
public:

	GEM_KEYFRAMER*		keyframerList;
	GEM_OBJECT*			objectList;

	DWORD				startFrame;
	DWORD				endFrame;
	DWORD				version;

	LPDIRECT3DDEVICE3	pd3dDevice;
	GEM_CAMERA*			camera;
	LPDIRECT3DTEXTURE2	ptexLightText;

	DWORD				flags;
};


HRESULT AddTexture(TCHAR* name, DWORD stage = 0);
HRESULT UpdateTexture(TCHAR* name, LPDIRECT3DDEVICE3 pd3dDevice);
HRESULT UpdateAllTextures(LPDIRECT3DDEVICE3 pd3dDevice);
LPDIRECT3DTEXTURE2 GetTexture(TCHAR* name);
LPDIRECTDRAWSURFACE4 GetSurface(TCHAR* name);
HRESULT RemoveTexture(TCHAR* name);


GEM_OBJECT*	FindObject(GEM_SCENE* scene, TCHAR* name);
//GEM_OBJECT* FindFirst(GEM_SCENE* scene, DWORD type);
//GEM_OBJECT* FindNext(GEM_SCENE* scene, GEM_OBJECT* object);


int TransformScene(GEM_SCENE* scene, DWORD frame);
int RenderScene(GEM_SCENE* scene, DWORD frame);
int SetActiveCamera(GEM_SCENE* scene, GEM_CAMERA* camera);
int InitScene(GEM_SCENE* scene, LPDIRECT3DDEVICE3 pd3dDevice, D3DVALUE aspect, D3DVALUE nearZ=10.0f, D3DVALUE farZ=10000.0f, DWORD flags=0);
int CloseScene(GEM_SCENE* scene);
int ReleaseScene(GEM_SCENE* scene);
int SetLightTexture(GEM_SCENE* scene, LPDIRECT3DTEXTURE2 ptextTexture);

int Read3DS(TCHAR* name, GEM_SCENE* scene);


#endif /* __GEM_H_ */


	






	



	

