//---DIRECTGEM------------------------------------------------------------------
//
//
//------------------------------------------------------------------------------

#include "gemmath.h"
#include <math.h>

D3DVALUE Length(GEM_VECTOR& v)
{
	return sqrt(v.x*v.x + v.y*v.y + v.z*v.z);
}

GEM_VECTOR Normalize(GEM_VECTOR& v)
{
	D3DVALUE		len = sqrt(v.x*v.x + v.y*v.y + v.z*v.z);

	if( !len )
		return v;

	return GEM_VECTOR( v.x/len, v.y/len, v.z/len );
}


D3DVALUE Dot(GEM_VECTOR& v, GEM_VECTOR& u)
{
	return v.x*u.x + v.y*u.y + v.z*u.z;
}

GEM_VECTOR Cross(GEM_VECTOR& v, GEM_VECTOR& u)
{
	GEM_VECTOR		tmp;

	tmp.x = v.y*u.z - v.z*u.y;	
	tmp.y = v.z*u.x - v.x*u.z;
	tmp.z = v.x*u.y - v.y*u.x;	

	return tmp;
}

GEM_VECTOR Lerp(GEM_VECTOR& v, GEM_VECTOR& u, D3DVALUE t)
{
	GEM_VECTOR		tmp;
	D3DVALUE		_1t = 1-t;
	
	tmp.x = _1t*v.x + t*u.x;
	tmp.y = _1t*v.y + t*u.y;
	tmp.z = _1t*v.z + t*u.z;

	return tmp;	
}

GEM_VECTOR operator- (GEM_VECTOR& v)
{
	return GEM_VECTOR( -v.x, -v.y, -v.z );
}

GEM_VECTOR operator- (GEM_VECTOR& v, GEM_VECTOR& u)
{
	return GEM_VECTOR( v.x-u.x, v.y-u.y, v.z-u.z );
}

GEM_VECTOR operator+ (GEM_VECTOR& v, GEM_VECTOR& u)
{
	return GEM_VECTOR( v.x+u.x, v.y+u.y, v.z+u.z );
}

GEM_VECTOR operator* (D3DVALUE a, GEM_VECTOR& v)
{
	return GEM_VECTOR( a*v.x, a*v.y, a*v.z );
}

GEM_VECTOR operator* (GEM_VECTOR& v, D3DVALUE a)
{
	return GEM_VECTOR( a*v.x, a*v.y, a*v.z );
}

D3DVECTOR GetD3DVECTOR(GEM_VECTOR& v)
{
	D3DVECTOR		d3dvec;

	d3dvec.dvX = v.x;
	d3dvec.dvY = v.y;
	d3dvec.dvZ = v.z;

	return d3dvec;
}
