/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Last changed: 02/Apr/99                                                                             *
 *                                                                                                     *
 * bmp2html: convert a BMP image to a HTML document                                                    *
 *                                                                                                     *
 * Hello folks!                                                                                        *
 * This is my contribution to the TG99 Useless Util Compo :)                                           *
 * Yeah, I think this program is pretty useless, and I hope you agree with me, hehe                    *
 * It's maybe cool yes, but still useless                                                              *
 *                                                                                                     *
 * So, how the hell do you make an HTML-document of a BMP-image?                                       *
 * The old way would be like: <img src=image.bmp>, but that's the *old* way!                           *
 *                                                                                                     *
 * What this puppet do, is to read the data of a bmp-image, and create a HTML-file                     *
 * where it constantly change the color of the fonts according to the bmp-image                        *
 * Two characters represents one pixel.                                                                *
 * You can also use any string you want (known as the 'fillstring') to fill the HTML-file              *
 *                                                                                                     *
 * Some limitations:                                                                                   *
 *    - input file must be a 24-bit bitmap                                                             *
 *    - no spaces or tabs are allowed in the fillstring. Why? Cuz the image would look like            *
 *      a cheese, and the browser will wrap the lines                                                  *
 *    - be careful with large images, as the HTML-document of it would be almost 10 times larger       *
 *                                                                                                     *
 * The C-code have been tested on Linux 2.0.x, Linux 2.2.x, DOS 7.0 and Win32                          *
 * The output HTML-document have been tested on Netscape Navigator 4.08, IE5 and Opera 3.50            *
 * Works best with Opera, since it got *zoom*, but is not optimized for - in any way                   *
 *                                                                                                     *
 * You need monospace fonts and at least 100 characters per line, or turn off word-wrap,               *
 * in order to view this code correctly. Also, get yourself a nice IDE to make reading easier          *
 *                                                                                                     *
 * Good luck, and have fun! ;-)                                                                        *
 *                                                                                                     *
 * Regards,                                                                                            *
 *   Soul Toucher (Willy Nyland), st78@online.no                                                       *
 *                                                                                                     *
 *                                                                                                     *
 * PS: you may redistribute the program as much as you want, and you may also change it to your needs, *
 *     but remember to give me credit for writing the original                                         *
 *                                                                                                     *
 * - Evilness comes from stupidity -                                                                   *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* Start transmission	*/

#include <stdio.h>						/* The standard stuff			*/
#include <string.h>						/* Needed for strcmp()			*/

#define VERSION		"1.0"					/* You know, the program version	*/
#define MAXFILL		100					/* Max chars in the fillstring		*/


/* Global variables
 * Everyone and their mother can use them
 */
FILE	*bmpfile, *htmlfile;					/* Now we know of these files		*/
char	fillstr[MAXFILL];					/* The fillstring			*/


/* Some self-defined functions
 * More details before each function
 * Take a look, if you got some time to spare
 */
void get_fillstr(void);						/* Get fillstring from stdin		*/
void bmp2html(char *infile, char *outfile);			/* The acctual converter		*/
void html_headers(char *pagetitle);				/* Put HTML-headers			*/
void confirm_large(int width, int height);			/* Ask for confirmation on large files	*/
void check_args(int args, char *infile, char *outfile);		/* Check command-line arguments		*/


/* OK, now to the program
 * Not so much really, since most works are done in functions
 * But you see in short how this darn thing works, hehe
 */
int main(int argc, char *argv[])
{
	check_args(argc, argv[1], argv[2]);			/* Check if the arguments are OK	*/
	get_fillstr();						/* Ask for a fill-string, and store it	*/
	bmp2html(argv[1], argv[2]);				/* Do the dirty work			*/
	return 0;						/* If everything went fine, return a 0	*/
}								/*  (which mean "success")		*/


/* Promth the user for a fillstring
 * and save it in the global variable (array) 'fillstr'
 * OK, but what the heck is this bloody "fillstring"???
 * It's simply what you want to fill the HTML-page with
 */
void get_fillstr(void)						/* Take nothing, give nothing :)	*/
{
	int fc;							/* Character counter for the fillstring	*/

	while (1) {						/* Endless loop				*/
		printf("Enter a fill-string (with no spaces and max %d characters): ", MAXFILL);
		for (fc=0; (fillstr[fc] = getchar()) != '\n' && fc < MAXFILL-1; fc++)
			;					/* Read fillstring from keyboard, count */
								/*  up chars, stop when newline or	*/
								/*  MAXFILL is reached			*/
		fillstr[fc] = '\0';				/* Put a string terminator at the end	*/
		if (!(strstr(fillstr, " ")) && !(strstr(fillstr, "\t")))
								/* If spaces and tabs are not found:	*/
			if (fc > 1)				/*   Make sure string is not blank	*/
				break;				/*   Break out of the loop		*/
	}
}


/* The converter
 *
 * Probably the most interresting part, but also the biggest one.
 * You should have some knowledge on the bmp-format in order to
 * understand what's really happening.
 *
 * I'll try to make it short;
 * offset 18-21 (byte 18th to 21th) tells the width of the bitmap
 * offset 22-25 tells the height
 * Since the data is stored in reverse order, we have to multiply
 * byte 19 with 256, and not byte 18. Same goes for 22 and 23.
 * As you probably have noticed, we don't read all four bytes,
 * just two. That's because I don't expect an image to be larger
 * than 65535 pixels in any direction. It would output a _huge_
 * HTML-document anyway. So only two bytes are enough, for now.
 *
 * Next, the bitmap data starts at the lower left corner.
 * Then it goes to right, then up.
 * Since HTML reads from upper left and ends in lower right, we
 * have to read the last line in the bitmap first, then moving up.
 *
 * Hope this makes sense to you :)
 *
 * The function expect two arguments; 'infile' and 'outfile'
 * It simply read from 'infile' and output in 'outfile'
 * Pretty obvious, heh?
 */
void bmp2html(char *infile, char *outfile)
{
	int width,							/* Width of bitmap		*/
	    height,							/* Height of bitmap		*/
	    wc,								/* Width counter		*/
	    hc,								/* Heitht counter		*/
	    fc,								/* Fillstring counter		*/
	    r,								/* Red				*/
	    g,								/* Green			*/
	    b;								/* Blue				*/

									/* We don't need to open infile	*/
									/*  cuz it was already done by	*/
									/*  our little check_args()	*/
									
	fseek(bmpfile, 18, 0);						/* Get width of bitmap		*/
	width = getc(bmpfile) + 256*getc(bmpfile);
	fseek(bmpfile, 22, 0);						/* Get height of bitmap		*/
	height = getc(bmpfile) + 256*getc(bmpfile);
	
	if (width > 150 && height > 150)				/* If the bitmap is large:	*/
		confirm_large(width, height);				/*  ask for a confirmation	*/
	
	printf("\nCreating HTML-document, filling it with \"%s\"\n", fillstr);
	htmlfile = fopen(outfile, "w");					/* Open HTML-doc for writing	*/
	html_headers(infile);						/* Print HTML-headers, with the */
									/*  name of input file as title */
	fseek(bmpfile, -3*width - width%2, 2);				/* Start at the beginning of    */
									/*  last line			*/
	for (fc=0, hc=1; hc <= height; hc++) {				/* Start counter at 1 and loop	*/
									/*  until 'hc' = 'height'	*/
		for (wc=1; wc <= width; wc++, fc++) {			/* Start counter at 1 and loop	*/
									/*  until 'wc' = 'width'	*/
			b = getc(bmpfile);				/* Get blue  (#----XX)		*/
			g = getc(bmpfile);				/* Get green (#--XX--)		*/
			r = getc(bmpfile);				/* Get red   (#XX----)		*/
			fprintf(htmlfile, "<font color=#");
			if (r < 16)					/* If value of r, g or b are	*/
				fprintf(htmlfile, "0");			/*  less than 16, it will print	*/
			fprintf(htmlfile, "%X", r);			/*  only a character, but we	*/
			if (g < 16)					/*  anyway need 2, so an extra	*/
				fprintf(htmlfile, "0");			/*  0 had to be printed	first	*/
			fprintf(htmlfile, "%X", g);			/* Then, print the value of	*/
			if (b < 16)					/*  each color in hex		*/
				fprintf(htmlfile, "0");			/* The values of r, g and b are	*/
			fprintf(htmlfile, "%X>", b);			/*  printed in the reverse	*/
									/*  order as we got them	*/
			if (fillstr[fc] == '\0')			/* Check if we're at the end	*/
				fc = 0;					/*  of the fillstring, if so	*/
									/*  rewind back to the start	*/
			putc(fillstr[fc], htmlfile);			/* Put current char of fillstr	*/
			fc++;						/* Count up fillstr counter	*/
			if (fillstr[fc] == '\0')			/* Check for end again		*/
				fc = 0;
			putc(fillstr[fc], htmlfile);			/* Put the next char		*/
                        fprintf(htmlfile, "</font>");                   /* Print font terminator        */
		}
									/* When a line is done:		*/
		fprintf(htmlfile, "\n");				/* Put a newline		*/
		fseek(bmpfile, -6*width - width%2, 1);			/* Rewind back to next line	*/
	}								/*  (heh, what a wierd way to	*/
									/*  say it) :-)			*/
									
									/* When all is lines are done:	*/
	fprintf(htmlfile, "\n</pre></b></font>\n</body>\n</html>");     /* Print all terminators	*/
	fclose(bmpfile);						/* Close input file		*/
	fclose(htmlfile);						/* Close output file		*/
	printf("\nAll done! '%s' created\n", outfile);			/* Tell user the work is done	*/

}									/* Pwew, that's all :)		*/


/* Print HTML-headers
 * Pure and simple :)
 * Since I expect you have knowledge on HTML, I won't be
 * explaining much.
 * Not so much to explain anyway, hehe
 *
 * The argument 'pagetitle' is the title to set
 */
void html_headers(char *pagetitle)
{
	fprintf(htmlfile, "<html>\n"					/* Print all the usual stuff	*/
			  "<head>\n"
			  "<center>\n"
			  "<title>%s</title>\n", pagetitle);		/* Set title according to the	*/
        fprintf(htmlfile, "</head>\n"					/*  funtion argument 'pagetitle'*/
        		  "<body\n"
			  "  bgcolor = #000000\n"
			  "  text    = #FFFFFF\n"
			  "  link    = #0000FF\n"
			  "  vlink   = #000080\n"
			  "  alink   = #FF0000\n"
			  ">\n<font size=\"-5\"><b><pre>\n\n");
}									/* Well, let's hope the headers	*/
									/*  are up now :-)		*/

/* Ask for a confirmation on large file
 * Estimate the output file-size, and see if the user
 * got scared of the huge size, and quit.
 *
 * 'w' are width, and 'h' are height.
 * We need them to estimate the output filesize
 */
void confirm_large(int w, int h)
{
	int n;

	fprintf(stderr, "Warning: Input file is %dx%d pixels large\n"	/* Print the warning and	*/
			"         The output file would be %dkB\n\n"	/*  calculate filesize		*/
			"Are you darn sure you want to do this? (Y/N) ", w, h, 29*w*h/1024);
									/* Why exactly 29, you may ask?	  */
									/*  well, count for yourself: :-) */
									/*  <font color=#FFFFFF>XX</font> */
									
	n = getchar();                                                  /* Get a char from keyboard	*/
	if (n == 'Y' || n == 'y')					/* If it's a Yes, go on		*/
		fprintf(stderr, "\nOK, you have been warned. This is gonna take awhile...\n");
	else {								/* Else, get out of here	*/
		fprintf(stderr, "\nCoward! :-)\n\n");			/* Print a nice little message	*/
		fclose(bmpfile);					/* Close input-file		*/
									/* Why not close output file	*/
									/*  as well? Simply because it	*/
									/*  is not opened yet :)	*/
		exit(0);						/* Adios!			*/
	}
}


/* Check command-line arguments
 * We need to check the command-line arguments before we do anything else
 * If we don't verify them, it could get real messy
 *
 * 'args' is the number of arguments  _
 * 'infile' is the input file          \ Did I really need to
 * 'outfile' is the output file       _/ explain this?
 */
void check_args(int args, char *infile, char *outfile)
{
	if (args < 3) {							/* If too few arguments		*/
									/* Print a short usage		*/
		fprintf(stderr, "bmp2html %s, by Soul Toucher (st78@online.no)\n\n", VERSION);
		fprintf(stderr, "Usage: bmp2html [InputFile] [OutputFile]\n"
				"Ex:    bmp2html me.bmp me.html\n");
		exit(1);						/* And get out of here		*/
	}
	if (!(bmpfile = fopen(infile, "rb"))) {				/* If input file is not found	*/
									/* Print an error-message	*/
		fprintf(stderr, "Error: the file '%s' was not found\n", infile);
		exit(1);						/* Run away before it blows	*/
	}
	if (getc(bmpfile) != 'B' && getc(bmpfile) != 'M') {             /* Check if bmpfile is really	*/
									/*  a bitmap			*/
		fprintf(stderr, "Error: '%s' is not a bitmap file\n", infile);
		fclose(bmpfile);					/* Close the file		*/
		exit(1);						/* Run for the exit		*/
	}
	fseek(bmpfile, 28, 0);						/* Go to offset 28 (28th byte)	*/
	if (getc(bmpfile) != 24) {					/* Check if infile is 24-bit	*/
		fprintf(stderr, "Error: '%s' is not a 24-bit bitmap\n", infile);
		fclose(bmpfile);					/* Close file			*/
		exit(1);						/* Go away			*/
	}
	if (!(strcmp(infile,outfile))) {				/* Compare infile with outfile	*/
									/* If equal, tell the user they	*/
									/*  can't do that		*/
		fprintf(stderr, "Error: target and source are the same\n");
		fclose(bmpfile);					/* Take cover!			*/
		exit(1);
	}
}									/* If everything went fine,     */
									/*  go on			*/
/* End of transmission	(just about time) */