Title  Nibbles game by Kim Runholt, Denmark.
;      Entry in the 1998 hugi size coding competition.
;      Date of completion: April 27th. 1998.
;      Binary size: 88 bytes.

;  To build:
;     tasm -m nibbles
;     tlink -t nibbles

;  Control the snake with keys '2','4','6' and '8' on the numpad.

Page 100,120

Ideal                           ;Compile with TASM
Model Tiny
P386

CodeSeg
Org 100h

Proc main
    mov al,13h                  ;ah==0
    int 10h                     ;set mode 13h

    push 0A000h
    pop ds                      ;ds=VGAseg

    mov cx,0C0Ch                ;drawing color

    mov si,320                  ;used several times

        ;draw frame

    mov bx,si;                  ;top and bottom
  horiz:
    dec bx
    mov [Byte bx],cl            ;top line
    mov [Byte 320*199+bx],cl    ;bottom line
    jnz horiz

    mov bx,320*200-1            ;sides
  vert:
    mov [Word bx],cx
    sub bx,si;                  ;si==320
    jnc vert

    mov bx,3DAh                 ;set initial position

    mov dx,bx                   ;is used in delay

  newdirection:

        ;calculate direction

    mov di,1
    test al,4                   ;horizontal or vertical? (2/8=V,4/6=H)
    jnz h
    mov di,si;                  ;si==320
  h:
    test al,2                   ;positive or negative? (2/6=P,4/8=N)
    jnz movesnake
    neg di

  movesnake:

    add bx,di                   ;move forward
    xor [Byte bx],cl            ;put pixel
    jz exit                     ;collision?

        ;delay

                                ;dx==3DAh
  delay_l1:
    in al,dx
    test al,8
    jne delay_l1
  delay_l2:
    in al,dx
    test al,8
    je delay_l2

    mov ah,01h
    int 16h                     ;get keyboard status

    jz movesnake                ;if no keypress, move on

    xor ax,ax
    int 16h                     ;get keypress in al

    jmp newdirection

   exit:
     mov ax,0003h
     int 10h                    ;return to mode 3

     ret                        ;exit to DOS
EndP main

End main
