; 62 Byte Nibbles game by Andrew Nicolle (aka raven/tektonic)
; coded 28 May 1998 for hugi size coding compo

; USAGE: Guide the growing worm using arrow keys or keypad

; ===< Contact Info >===
; Email: andrewn@cobweb.com.au
; Web:   http://www.cobweb.com.au/~andrewn

; History: 27/4/98 - 121 bytes
;          29/4/98 - 89 bytes
;           1/5/98 - 82 bytes
;          16/5/98 - 78 bytes
;          17/5/98 - 73 bytes
;          18/5/98 - 68 bytes
;          20/5/98 - 63 bytes
;          28/5/98 - 62 bytes

Ideal
model tiny
p286


CODESEG
ORG 100h

START:

       mov     al,13h
       int     10h        ; set 320x200x256

       push    0A000h
       pop     es

       stosw              ; Wrap di to 0 (assuming di=fffeh at start)
       mov     cl,199
border:                   ; draw left and right edges of border
       stosb
       add     di,318
       stosb
       loop    border
       mov     cx,2177    ; ensure wrap around edge of video mem
       rep     stosb      ; draw top & bottom of border
                          ; worm will be 1 pixel from left border after this
wormloop:
       mov     cx,1       ; move worm left/right (+/- 1)
       test    al,1       ; check scancode for left/right or up/down
       jnz     leftright
       mov     cx,320     ; move worm up/down (+/- 320)
leftright:
       and     al,32h     ; check scancode bits for left/up (negative offset)
                          ; (and al,32h so we don't move up at start)
       jnz     cmpworm
       neg     cx         ; change direction (left or up)
cmpworm:
       in      al,60h     ; read from keyboard
       das                ; ok since carry cleared after and al,32h
       jnc     wormloop   ; jump if key hit
       add     di,cx      ; move worm
       mov     ah,0bh
       int     10h           ; wait for vertical retrace (side effect of this)
       sub     [es:di],ah    ; Draw a pixel
       jc      leftright     ; see if hit border or another worm segment
done:
       mov     ax,3
       int     10h           ; return to text mode
       ret

END START
