;(C) 13.04.1998 A.Liskow *** Oppfa / DSS ***
;mailto:alexander.liskow@metronet.de
;nibbles competition at adok.home.pages.de

.model tiny
.code
.286

org 100h                                ;to build com file

nibbles:                                ;program start

  mov al, 13h                           ;switch to screen mode
  int 10h                               ;320x200

  push 0A000h                           ;set es to base vga address
  pop es

  mov ah, al
  mov cx, 1088                          ;draw horizontal frame lines
  mov di, 63680
  rep stosw

  mov di, 319                           ;draw vertical frame lines
  mov cl, 200
  leftnright:
    stosw
    add di, 318
  loop leftnright

  shr di, 1                             ;set snake's start to center of screen
  mov dx, 3DAh                          ;set dx to vga status port address

  mainloop:                             ;start main loop
    rt1:                                ;wait for vertical display period
      in al, dx
      test al, 8
    jne rt1
    rt2:                                ;wait for vertical retrace period
      in al, dx
      test al, 8
    je rt2

    stosb                               ;put snake's head

    mov ah, 01h
    int 16h                             ;check for key in buffer
    jz nokey                            ;no key pressed

    xor ah, ah                          ;get key from buffer
    int 16h

    cmp al, 38h                         ;check if 8 is pressed
    jne left
    mov bx, -321
    left:
      cmp al, 34h                       ;check if 4 is pressed
      jne right
      mov bx, -2
    right:
      cmp al, 36h                       ;check if 6 is pressed
      jne down
      xor bx, bx
    down:
      cmp al, 32h                       ;check if 2 is pressed
      jne nokey
      mov bx, 319
    nokey:
      add di, bx                        ;add new pixel index to actual pos.
      mov cl, es : [di]                 ;get colour of next position
  jcxz mainloop                         ;if colour is black go on drawing

    mov ax, 3                           ;set standard text mode
    int 10h
    ret                                 ;terminate program

end nibbles                             ;program end