#include <mem.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#define PLASMAS 4

#define UP 0
#define LEFT 1
#define RIGHT 2
#define DOWN 3

void setpalette(char color, char red, char green, char blue);
void retrace(void);

char *vga=(char *)0xA0000;

void main(int argc, char *argv[]){
	char COLOR1=50;
	char COLOR2=51;
	char COLOR3=52;
	char COLOR4=53;
	char debug=0,nomonster=0;
	char *plsmatab;
	char *testi;
	plsmatab=(char *)malloc(256000);
	testi=(char *)malloc(64000);
	memset(testi,0,64000);
	int x,y,i,j;
	for (i=1;i<argc;i++) if (stricmp(argv[i],"debug")==0) debug=1;
	for (i=1;i<argc;i++) if (stricmp(argv[i],"nomonster")==0) nomonster=1;
	
	long loffs;
	char color;
	
	for (y=0,loffs=0;y<400;y++){
		for (x=0;x<640;x++,loffs++){
			color=sin(sqrt(((y-200)*(y-200))+((x-320)*(x-320)))/50.0)*42.0+43;
			plsmatab[loffs]=color;
		}
	}
	int xoffs[PLASMAS],yoffs[PLASMAS];
	long offs1,offs2,offs3,offs4;
	_asm mov ax,13h
	_asm int 10h
	
	for (i=0;i<64;i++) setpalette(i,i,0,0);
	for (i=0;i<64;i++) setpalette(i+64,63-i,0,i);
	for (i=0;i<64;i++) setpalette(i+128,0,i,63-i);
	for (i=0;i<64;i++) setpalette(i+192,0,63-i,0);
	if (nomonster==0){
		setpalette(COLOR1,63,63,63);
		setpalette(COLOR2,63,63,63);
		setpalette(COLOR3,63,63,63);
		setpalette(COLOR4,63,63,63);
	} else{
		COLOR1=255;
		COLOR2=255;
		COLOR3=255;
		COLOR4=255;
	}
	for (y=0;y<200;y++){
		for (x=0;x<320;x++){
			if (x==0 || x==319 || y==0 || y==199){
				vga[y*320+x]=255;
				testi[y*320+x]=255;
			}
		}
	}
	short wormx=160;
	short wormy=100;
	short direction=UP;
	char ch;
	char crash=0;
	for (i=0;ch!=27&&crash==0;i++){
		if (testi[(wormy<<8)+(wormy<<6)+wormx]==255){
			crash=1;
			goto pois;
		}
		if (testi[(wormy<<8)+(wormy<<6)+wormx]==254){
			crash=1;
			goto pois;
		}
		if (nomonster==0){
			if (testi[(wormy<<8)+(wormy<<6)+wormx]==COLOR1){
				crash=1;
				goto pois;
			}
			if (testi[(wormy<<8)+(wormy<<6)+wormx]==COLOR2){
				crash=1;
				goto pois;
			}
			if (testi[(wormy<<8)+(wormy<<6)+wormx]==COLOR3){
				crash=1;
				goto pois;
			}
			if (testi[(wormy<<8)+(wormy<<6)+wormx]==COLOR4){
				crash=1;
				goto pois;
			}
		}
		for (j=1;j<64;j++) setpalette(j,j,0,0);
		for (j=0;j<64;j++) setpalette(j+64,63-j,0,j);
		for (j=0;j<64;j++) setpalette(j+128,0,j,63-j);
		for (j=0;j<64;j++) setpalette(j+192,0,63-j,0);
		if (nomonster==0){
			setpalette(COLOR1,63,63,63);
			setpalette(COLOR2,63,63,63);
			setpalette(COLOR3,63,63,63);
			setpalette(COLOR4,63,63,63);
		}
		setpalette(254,sin(i/9.3)*31+31,sin(i/8.2)*31+31,sin(i/10.1)*31+31);
		setpalette(255,(((i/5)%15)-7)*(((i/5)%15)-7),(((i/5)%15)-7)*(((i/5)%15)-7),(((i/5)%15)-7)*(((i/5)%15)-7));
		if (nomonster==0){
			COLOR1=sin(i/137.0)*50+100;
			COLOR2=sin(i/137.0)*50+101;
			COLOR3=sin(i/137.0)*50+102;
			COLOR4=sin(i/137.0)*50+103;
		}
		vga[(wormy<<8)+(wormy<<6)+wormx]=254;
		testi[(wormy<<8)+(wormy<<6)+wormx]=254;
		if (kbhit()) ch=getch();
		else ch=0;
		switch(ch){
			case '8':
				direction=UP;
				break;
			case '4':
				direction=LEFT;
				break;
			case '6':
				direction=RIGHT;
				break;
			case '2':
				direction=DOWN;
				break;
		}
		switch(direction){
			case UP:
				wormy--;
				break;
			case LEFT:
				wormx--;
				break;
			case RIGHT:
				wormx++;
				break;
			case DOWN:
				wormy++;
				break;
		}
		for (j=0;j<PLASMAS;j++){
			if (nomonster==0){
				xoffs[j]=sin(i/(361.0+j*17)+j*2.7)*160.0+160;
				yoffs[j]=sin(i/(347.0+j*10)+j*1.3)*100.0+100;
			} else{
				xoffs[j]=sin(i/(61.0+j*17)+j*2.7)*160.0+160;
				yoffs[j]=sin(i/(47.0+j*10)+j*1.3)*100.0+100;
			}
		}
		offs1=(yoffs[0]<<9)+(yoffs[0]<<7)+xoffs[0];
		offs2=(yoffs[1]<<9)+(yoffs[1]<<7)+xoffs[1];
		offs3=(yoffs[2]<<9)+(yoffs[2]<<7)+xoffs[2];
		offs4=(yoffs[3]<<9)+(yoffs[3]<<7)+xoffs[3];
		_asm{
			mov ax,ds
			mov es,ax
			mov edi,0A0000h
			add edi,321
			mov cx,198
			rol ecx,16
			mov ebx,plsmatab
			mov esi,testi
			add esi,321
yloop:
			mov cx,318
xloop:
			mov edx,offs1
			mov al,[ebx+edx]
			mov edx,offs2
			add al,[ebx+edx]
			mov edx,offs3
			add al,[ebx+edx]
			
			mov dl,[esi]
			cmp dl,254
			jz noplasma
			
yesplasma:
			mov [edi],al
			mov [esi],al
			jmp mesta
			
noplasma:
			sub al,COLOR1
			js mesta
			sub al,4
			js yesplasma
mesta:
			
			inc ebx
			inc edi
			inc esi

			dec cx
			jnz xloop

			add ebx,322
			add edi,2
			add esi,2

			ror ecx,16
			dec cx
			jz yloopp
			rol ecx,16
			jmp yloop
yloopp:
		}
		if (debug) setpalette(0,0,0,0);
		retrace();
		if (debug) setpalette(0,63,0,0);
		pois:
		;
	}
	_asm mov ax,3h
	_asm int 10h
	printf("\nThis plasma was made by Itchi / THP\n\n");
	free(plsmatab);
	free(testi);
}

void setpalette(char color, char red, char green, char blue){
	_asm{
		xor ah,ah
		mov dx,3c8h
		mov al,color
		out dx,al
		inc dx
		mov al,red
		out dx,al
		mov al,green
		out dx,al
		mov al,blue
		out dx,al
	}
}

void retrace(void){
	_asm{
		mov     dx,3DAh
WaitVR1:
		in      al,dx
		test    al,8
		jne     WaitVR1
WaitVR2:
		in      al,dx
		test    al,8
		je      WaitVR2
	}
}
