;ENTRY56R.ASM	12-04-1998	      HC05 sort filter coding entry @ 38h = 56d
;
;Find and output first sort-order line that has not been sent already, mark it
;done and repeat until all output
;
				.RADIX 16
;
ONLY	SEGMENT
			ASSUME CS:ONLY,SS:ONLY,DS:ONLY,ES:ONLY
				ORG 100
;******************************************************************************
;*		      Copyright (C) Lawrence E. Boothby 1998		      *
;*		     Contract programming <boothbyl@reed.edu>		      *
;*									      *
;* EXECUTION ENVIRONMENT ASSUMPTIONS:					      *
;*		Entry SP=FFFE (full segment available to load program)	      *
;*		BX = 0000 = sti handle, Direction flag = 0		      *
;*		DX = CS and not loaded high so can use CS:CS for buffer	      *
;* INPUT ASSUMPTIONS:							      *
;*		Max input file length = 30,000 = 7530h			      *
;*		At least one CR,LF pair, no final ^Z			      *
;*		Alphabet = 0Ah,0Dh, 20h-0FFh				      *
;******************************************************************************
START:		MOV	AH,3F		;read CX bytes from handle BX = sti
		MOV	CX,SP		;anything >= 7530h = 30,000d bytes
		;DX = CS		 anything >= OFFSET BUFFER
		INT	21h
		;JC	 EXIT		;to handle read error
		XCHG	CX,AX		;get input length into CX
		MOV	AX,020A		;get AX = function AH=02, AL = LF
		MOV	DI,CS		;-->buffer
		;(keeping constant initialization outside of loop)
	;------------------------------------------------------------------:
	; Find 1st sort order line that has not yet been sent		   :
	;------------------------------------------------------------------:
FIND_MIN:	DB 60h	;PUSHA		;save CX,DI
UPDATE:		MOV	SI,DI		;SI-->current sort-order 1st
NXT_CMP:	CMP	[DI],AH
		JZ	TRY_NXT		;no compare with lines already output
DO_CMP:		DB 60h	;PUSHA		;save SI-->min so far, DI-->next, CX
		MOV	CL,0FF
		REPZ	CMPSB
		DB 61h	;POPA		;restore SI, DI, CX
		JA	UPDATE		;DI-->line that is before SI-->line
TRY_NXT:	REPNZ	SCASB
		INC	CX		;this construction is one byte less
		LOOP	NXT_CMP		;than:	DO_JCXZ: JCXZ
					;		 ;some code
					;		 JMP SHORT DO_JCXZ
	;------------------------------------------------------------------:
	; Output this line and mark it sent				   :
	;------------------------------------------------------------------:
		MOV	BX,SI		;save -->start of line
NXT_CHR:	MOV	DL,[SI]		;get character
		INC	SI
		INT	21		;send this character, returns AL<-DL
		CMP	AL,0Ah		;was this terminal LF?
		JNZ	NXT_CHR
		MOV	[BX],AH		;flag line done (AX=020A)
		DB 61h	;POPA		;restore CX,DI
	;------------------------------------------------------------------:
	; Find first remaining line that has not been sent ( [DI] != 02 )  :
	;------------------------------------------------------------------:
NXT_LINE:	CMP	BYTE PTR [DI],AH	;AH=02 = already output
		JNZ	FIND_MIN
		REPNZ	SCASB
		INC	CX
		LOOP	NXT_LINE
EXIT:		RET			;case no more remaining
;*******************************************************************************
BUFFER	LABEL	BYTE
ONLY	ENDS
	END START
