;ENTRY53r.ASM	11-26-1998	      HC05 sort filter coding entry @ 35h = 53d
;a faster coding of ENTRY_53.ASM
				.RADIX 16
;
ONLY	SEGMENT
			ASSUME CS:ONLY,SS:ONLY,DS:ONLY,ES:ONLY
				ORG 100
;******************************************************************************
;*		      Copyright (C) Lawrence E. Boothby 1998		      *
;*		     Contract programming <boothbyl@reed.edu>		      *
;*									      *
;* EXECUTION ENVIRONMENT ASSUMPTIONS:					      *
;*		BX = 0000 = sti handle, Direction flag = 0		      *
;*									      *
;* INPUT ASSUMPTIONS:							      *
;*		Max input file length = 30,000 = 7530h			      *
;*		At least one CR,LF pair, no final ^Z			      *
;*		Alphabet = 0Ah,0Dh, 20h-0FFh				      *
;******************************************************************************
START:		MOV	AH,3F		;read CX bytes from handle BX
		MOV	CX,SP		;anything >= 7530h = 30,000d bytes
		MOV	DX,020A		;anything >= OFFSET BUFFER
		INT	21h
		;JC	 EXIT		;to handle read error
		XCHG	BP,AX		;get input length into BP
		XCHG	DX,AX		;get AX<--DX=020A = function AH=02, LF
		;(keeping constant initialization outside of loop)
	;------------------------------------------------------------------:
	; Find lowest sort order line that has not yet been output	   :
	;------------------------------------------------------------------:
FIND_MIN:	MOV	DI,AX		;-->start of line to do
		MOV	CX,BP		;-->number of bytes remaining
UPDATE:		MOV	SI,DI		;SI-->current sort-order 1st
DO_CMP:		DB 60h	;PUSHA		;save SI-->min so far, DI-->next, CX
		MOV	CL,0FF
		REPZ	CMPSB
		DB 61h	;POPA		;restore SI-->, DI-->, CX
		JA	UPDATE		;DI-->line that is before SI-->line
		REPNZ	SCASB
		INC	CX		;this construction is one byte less
		LOOP	DO_CMP		;than:	DO_JCXZ: JCXZ
					;		 ;some code
					;		 JMP SHORT DO_JCXZ
	;------------------------------------------------------------------:
	; Output this line and delete it from data left to sort		   :
	;------------------------------------------------------------------:
		MOV	CX,DI		;-->EOF
		MOV	DI,SI		;save start of this line
NXT_CHR:	MOV	DL,[SI]		;get character
		INC	SI
		DEC	BP		;update length left to sort
		INT	21		;send this character, returns AL<-DL
		CMP	AL,0Ah		;was this terminal LF?
		JNZ	NXT_CHR
		SUB	CX,SI
		REP	MOVSB		;delete line sent from data to sort
		OR	BP,BP
		JNZ	FIND_MIN
EXIT:		RET			;case no more remaining
;*******************************************************************************
BUFFER	LABEL	BYTE
ONLY	ENDS
	END START
