;ENTRY52R.ASM	12-04-1998	      HC05 sort filter coding entry @ 34h = 52d
;
				.RADIX 16
;
ONLY	SEGMENT
			ASSUME CS:ONLY,SS:ONLY,DS:ONLY,ES:ONLY
				ORG 100
;******************************************************************************
;*		      Copyright (C) Lawrence E. Boothby 1998		      *
;*		     Contract programming <boothbyl@reed.edu>		      *
;*									      *
;* EXECUTION ENVIRONMENT ASSUMPTIONS:					      *
;*		BX = 0000 = sti handle, Direction flag = 0		      *
;*		DX=CS=DS=ES=SS, more than offset BUFFER			      *
;*		(not loaded high or from system above an application)	      *
;* INPUT ASSUMPTIONS:							      *
;*		Max input file length = 30,000 = 7530h			      *
;*		At least one CR,LF pair, no final ^Z			      *
;*		Alphabet = 0Ah,0Dh, 20h-0FFh				      *
;******************************************************************************
START:		MOV	AH,3F		;read CX bytes from handle BX=00 = sti
		MOV	CX,SP		;anything >= 7530h = 30,000d bytes
		;DX = CS		;anything >= OFFSET BUFFER
		INT	21h
		;JC	 EXIT		;to handle read error
		XCHG	CX,AX		;get input length into CX
		MOV	AX,020A		;= function AH=02 and LF
		;(keeping constant initialization outside of loop)
	;------------------------------------------------------------------:
	; Find lowest sort order line that has not yet been output	   :
	;------------------------------------------------------------------:
FIND_MIN:	MOV	DI,CS		;-->start of line to do
		PUSH	CX		;-->number of bytes remaining to sort
UPDATE:		MOV	SI,DI		;SI-->current sort-order 1st
DO_CMP:		DB 60h	;PUSHA		;save SI-->min so far, DI-->next, CX
		MOV	CL,0FF
		REPZ	CMPSB
		DB 61h	;POPA		;restore SI-->, DI-->, CX
		JA	UPDATE		;DI-->line that is before SI-->line
		REPNZ	SCASB		;(1st comparison is with self)
		INC	CX		;this construction is one byte less
		LOOP	DO_CMP		;than:	DO_JCXZ: JCXZ
		POP	CX		;		 ;some code
		MOV	[DI],BL ;flag EOF ;		 JMP SHORT DO_JCXZ
	;------------------------------------------------------------------:
	; Output this line and delete it from data left to sort		   :
	;------------------------------------------------------------------:
		MOV	DI,SI		;save start of this line
NXT_CHR:	MOV	DL,[SI]		;get character
		INC	SI
		INT	21		;send this character, returns AL<-DL
		DEC	CX		;update bytes remaining
		CMP	AL,0Ah		;was this terminal LF?
		JNZ	NXT_CHR
NXT_MOVE:	CMP	[SI],BL		;remove hole (from line just output)
		MOVSB
		JNZ	NXT_MOVE	;while not EOF
		INC	CX
		LOOP	FIND_MIN
EXIT:		RET			;case no more remaining
;******************************************************************************;
BUFFER	LABEL	BYTE
ONLY	ENDS
	END START
