#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char *buffer[15000]; // 15000 = max lines

// compare function for qsort
int comp(const void *a, const void *b)
{
        // order reversed since we print in reverse order
        return strcmp(*(char **)b, *(char **)a);
}

void myexit(int exitcode)
{
        // flush stdin and stdout
        fflush(stdin);
        fflush(stdout);

        // free allocated mem
        for (int i = 0; i < 15000; i++) if (buffer[i] != NULL) free(buffer[i]);

        // exit :)
        exit(exitcode);
}

void main()
{
        char inbuffer[256];  // 256   = max line length + 1
        int i;

        // init ptr buffer
        for (i = 0; i < 15000; i++) buffer[i] = NULL;

        // read lines into buffer
        i = 0;
        while (gets(inbuffer))
        {
                buffer[i] = (char *)malloc(strlen(inbuffer) + 1);
                if (buffer[i] == NULL) myexit(-1);
                strcpy(buffer[i], inbuffer);
                i++;
        }

        // sort lines
        qsort(buffer, i, sizeof(char *), comp);

        // output sorted lines
        while (i--) puts(buffer[i]);
        myexit(0);
}
