;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;=  This is Blue's entry to the Hugi-Size-Coding-Competition #5              =
;-                                                                           -
;=  contact me via e-mail: blue@cs.tu-berlin.de                              =
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;=  use TASM to compile it ...                                               =
;-                                                                           -
;=  Size-History: 69->65->60->56->53->49->47                                 =
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
IDEAL
P386
;-----------------------------------------------------------------------------
; Code ...
;-----------------------------------------------------------------------------
SEGMENT CompoCode PARA PUBLIC USE16
ASSUME  cs:CompoCode,ds:CompoCode
ORG 100h

Main:
 mov   cx,800Ah                 ; mov   cx,30000
 mov   dh,02h                   ; dx points to data-buffer
 mov   ah,3Fh
 int   21h                      ; read redirected data 
 xchg  cx,ax                    ; cx now holds number of read bytes
                                ; al holds 0Ah
 
 SortLoop:                      ; lets sort strings ...
  mov   si,dx                   ; si points to minimal string
  mov   di,dx                   ; di points to actual string
  push  cx                      ; cx holds number of bytes left 
 
  SearchLoop:                   ; we are looking for the minimal string 
   pusha
   repz  cmpsb                  ; compare both strings
   popa
   jbe   NoNewMin               ; new minimal string ?
    mov   si,di                 ; -> save address
   NoNewMin:                    
   repnz scasb                  ; search for end of actual string
   inc   cx
  loop  SearchLoop              ; search trough whole text
  
  pop   cx              
  mov   di,si 

  PrintLoop:                    ; going to print the found minimal string ...
   pusha
   lodsb                        ; load character
   xchg  ax,dx                  ; dl holds character; ah holds 02h
   int   21h                    ; print character
   rep   movsb                  ; delete character from text 
   cmp   al,0Ah                 ; reached end of string ?
   popa  
  loopne PrintLoop              ; repeat until whole string printed
  inc   cx
 loop  SortLoop                 ; repeat until whole text processed
 ret

ENDS CompoCode
;-----------------------------------------------------------------------------
END Main
;-----------------------------------------------------------------------------