#include <stdio.h>
#include <conio.h>
#include <dos.h>


#define BAR_CHAR   219
#define BAR_COLOR  10
#define BAR_LEN    10
#define BAR_MOV    5
#define BALL_CHAR  220
#define BALL_COLOR 9


struct ITEM_POSITION
{
  char x;
  char y;
  char x_old;
  char y_old;
};

struct BALL_MOVEMENT
{
  signed char x;
  signed char y;
};

struct BALL
{
  struct ITEM_POSITION pos;
  struct BALL_MOVEMENT mov;
};


void screen3_init(void)
{
  asm {
    mov ax,3
    int 0x10
  }
}


void textmode_char_print(char chr,char attr,char xpos,char ypos)
{
  unsigned int offs = ypos*160+xpos*2;

  asm {
    mov ax,0xb800
    mov es,ax
    mov bx,offs
    mov al,chr
    mov es:[bx],al
    inc bx
    mov al,attr
    mov es:[bx],al
  }
}


void display_bar(struct ITEM_POSITION bar)
{
  char i;

  for(i=0;i<BAR_LEN;i++)
  {
    textmode_char_print(' ',BAR_COLOR,bar.x_old+i,bar.y);
  }
  for(i=0;i<BAR_LEN;i++)
  {
    textmode_char_print(BAR_CHAR,BAR_COLOR,bar.x+i,bar.y);
  }
}


signed char key_get(unsigned char *ascii,unsigned char *scan)
{
  union REGS regs;

  regs.h.ah=1;
  int86(0x16,&regs,&regs);
  if(regs.x.flags&64)
  {
    return(0);
  }
  else
  {
    *ascii=regs.h.al;
    *scan=regs.h.ah;
    regs.h.ah=0;
    int86(0x16,&regs,&regs);
    return(-1);
  }
}


void main()
{
  struct ITEM_POSITION bar1,bar2;
  struct BALL          ball;
  unsigned char        won  = 0,ascii,scan;

  screen3_init();

  bar1.x=0;     bar1.y=0;
  bar2.x=0;     bar2.y=24;
  bar1.x_old=0; bar1.y_old=0;
  bar2.x_old=0; bar2.y_old=24;
  ball.pos.x=2; ball.pos.y=2;
  ball.mov.x=1; ball.mov.y=1;

  while(!won)
  {
    display_bar(bar1);
    display_bar(bar2);
    textmode_char_print(' ',BALL_COLOR,ball.pos.x_old,ball.pos.y_old);
    textmode_char_print(BALL_CHAR,BALL_COLOR,ball.pos.x,ball.pos.y);

    if(key_get(&ascii,&scan))
    {
      switch( ascii )
      {
        case '4': if(bar1.x>0){bar1.x_old=bar1.x;bar1.x-=BAR_MOV;} break;
        case '6': if(bar1.x<80-BAR_LEN){bar1.x_old=bar1.x;bar1.x+=BAR_MOV;} break;
        case 'a': if(bar2.x>0){bar2.x_old=bar2.x;bar2.x-=BAR_MOV;} break;
        case 'd': if(bar2.x<80-BAR_LEN){bar2.x_old=bar2.x;bar2.x+=BAR_MOV;} break;
        default:
        switch( scan)
        {
          case 75: if(bar1.x>0){bar1.x_old=bar1.x;bar1.x-=BAR_MOV;} break;
          case 77: if(bar1.x<80-BAR_LEN){bar1.x_old=bar1.x;bar1.x+=BAR_MOV;} break;
        }
      }
    }

    switch( ball.pos.x )
    {
      case 0:
      case 79: ball.mov.x=(-(signed)ball.mov.x);
    }

    switch( ball.pos.y )
    {
      case 0:  won=2;break;
      case 1:  if( (ball.pos.x>=bar1.x) && (ball.pos.x<=bar1.x+BAR_LEN-1) )
               {
                 ball.mov.y=(-(signed)ball.mov.y);
               }
               break;
      case 23: if( (ball.pos.x>=bar2.x) && (ball.pos.x<=bar2.x+BAR_LEN-1) )
               {
                 ball.mov.y=(-(signed)ball.mov.y);
               }
               break;
      case 24: won=1;
    }

    ball.pos.x_old=ball.pos.x;
    ball.pos.y_old=ball.pos.y;
    ball.pos.x+=ball.mov.x;
    ball.pos.y+=ball.mov.y;

    asm {
       mov cx,5;
    }
      delay_l0:
    asm {
       mov dx,3dah
    }
      delay_l1:
    asm {
       in al,dx
       test al,8
       jne delay_l1
    }
      delay_l2:
    asm {
       in al,dx
       test al,8
       je delay_l2
       loop delay_l0
    }
  }

  screen3_init();

  printf("Player %u has won.",won);
}
