/***********************************************************************************
 * WinMain.cpp          -       Startup code for this application
 *
 * Author:              Ron Bakker        (madrigal@gmx.net)
 * Description:         Starfield screensaver
 * Date:                04-03-1998
 ***********************************************************************************/

#include <windows.h>

#include "glidesystem.h"
#include "fxdemo.h"
#include "wndproc.h"
#include "error.h"

BOOL EndOfExcercise = FALSE;

static char    ApplicationTitle[] = "Save3dfx";
static char    ApplicationClass[] = "Save3dfxClass";
HINSTANCE       ApplicationInstance;
HWND            ApplicationWindowHandle;

/***********************************************************************************
 * Register             - Registers a window class
 ***********************************************************************************/
BOOL RegisterWindowClass (void)
{
    WNDCLASS wc;

    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = Save3dfxWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = sizeof(DWORD);
    wc.hInstance = NULL;
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
    wc.lpszMenuName = NULL;
    wc.lpszClassName = ApplicationClass;
    if (!RegisterClass(&wc))
        return FALSE;
    return TRUE;
}

/***********************************************************************************
 * InitWindows          - Initializes a window
 ***********************************************************************************/
BOOL InitWindows (void)
{
    RegisterWindowClass ();
    // Create a full screen window
    ApplicationWindowHandle =
        CreateWindow(ApplicationClass, ApplicationTitle, WS_POPUP, 0, 0,
                     GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN),
                     NULL, NULL, NULL, NULL);
    if (!ApplicationWindowHandle)
        return FALSE;
    // we want it shown if it exists
    ShowWindow (ApplicationWindowHandle, SW_SHOW);
    return TRUE;
}

/***********************************************************************************
 * DoMessageLoop        - Windows Message Loop
 ***********************************************************************************/
MSG DoMessageLoop (void)
{
    MSG msg;
    
    while (!EndOfExcercise)
    // while no mouse or keyboard input...
    {
            GetMessage( &msg, NULL, 0, 0 );
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            RenderFxScene();
    }
    return msg;
}

/***********************************************************************************
 * WinMain              - Windows Main Procedure
 ***********************************************************************************/
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG message;        // Windows message structure


    if (strcmp(_strlwr(lpCmdLine), "/s") == 0)
    {
        // only one instance allowed
        if (hPrevInstance)
            WinError ("Application may only run once");
            
        ApplicationInstance = hInstance;

        // make our i/o-window
        if (!InitWindows()) // Creates a window to cover other windows and to capture our input
            WinError("Could not initialize window");       

        #ifndef __DEBUG_TEST__        
        if (!InitGlide())   // Initialize the hardware and glide settings
            WinError ("Could not initialize Glide");
        #endif
        if (!InitFxDemo())  // Initializes the basic screensaver structures
            WinError ("Could not initialize demo structures");
            
        message = DoMessageLoop();     // Windows message processing loop
        
        CloseFxDemo();      // De-allocates resources
        
        #ifndef __DEBUG_TEST__        
        ShutDownGlide();    // Shut down glide and let windows re-gain full controll
        #endif
    }
    else
    {
        // temporary message ... I've been too busy
        // Here should the preferences dialog be. (with reading and writing the registry of course)
        MessageBox (NULL, "Preferences are not available in this version", "Notice", MB_OK);
    }

    return message.wParam;      // return with the message from the message-loop
} 

