/***********************************************************************************
 * GlideSystem.cpp      -       Glide system functions
 *
 * Author:              Ron Bakker        (madrigal@gmx.net)
 * Description:         Starfield screensaver
 * Date:                04-03-1998
 ***********************************************************************************/

#include <assert.h>             // for failure checking
#include <glide.h>              // set your compiler path right!

GrHwConfiguration hwconfig;             // holds configuration of the system
GrScreenResolution_t resolution = GR_RESOLUTION_640x480;       // resolution wanted

/***********************************************************************************
 * InitGlide         - Initialize Glide
 ***********************************************************************************/
int InitGlide (void)
{
    // initialize glide
    grGlideInit();
    // look for valid hardware
    assert( grSstQueryHardware( &hwconfig ) );
    // select the 1st valid hardware found
    grSstSelect( 0 );
    // open the screen
    assert( grSstWinOpen( 0,
                      resolution,
                      GR_REFRESH_60Hz,
                      GR_COLORFORMAT_ABGR,
                      GR_ORIGIN_LOWER_LEFT,
                      2, 1 ) );
    // it went well
    return FXTRUE;
}

/***********************************************************************************
 * ShutDownGlide     - Close Glide
 ***********************************************************************************/
void ShutDownGlide (void)
{
    // Close Glide
    grGlideShutdown();
}
