// PicCel.cpp: implementation of the CPicCel class.
//
//////////////////////////////////////////////////////////////////////

#include "Stdafx.h"

#include "PicCel.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CPicCel::CPicCel(CImage* m_cimage, int offsetx, int offsety,unsigned int textid)
{
	m_Red=255;m_Green=255, m_Blue=255;
	m_TexEnvMode=GL_DECAL;
	m_angleX=0;
	m_angleY=0;
	m_angleZ=0;
	m_distance=0;
	m_offsetx=(float)offsetx;
	m_offsety=(float)offsety;

	m_textureid=textid;	
	// copy part of full image into texturemap
	GLubyte r,g,b,a;		
	for (int j=0; j<TEX_HEIGHT;j++)
		for (int i=0;i<TEX_WIDTH;i++) {
		
			{
				
				r=0;g=0;b=0;
				a=255; // alpha (transparancy)
				// bounds checking is performed by CImage class				
				// if x or y is out of bounds, rgb values are not set
				
				m_cimage->GetRGB(i+(offsetx*TEX_WIDTH), j+(offsety*TEX_HEIGHT) ,&r,&g,&b);
				
				rgbaImage[j][i][0] = r;
				rgbaImage[j][i][1] = g;
				rgbaImage[j][i][2] = b;
				// make black pixels fully transparant
				// well, I tried, but looks bad, so commented it...
				//if (r ==0&& g==0 && b==0) {
				//		a=0;
				//}
				rgbaImage[j][i][3] = a;	
			};
	};
	glGenTextures(1,&m_textureid);
	glBindTexture(GL_TEXTURE_2D,m_textureid);
	glPixelStorei(GL_UNPACK_ALIGNMENT,1);
	GLenum gluerr;
	if ((gluerr=gluBuild2DMipmaps(GL_TEXTURE_2D,4,TEX_WIDTH,TEX_HEIGHT,GL_RGBA,GL_UNSIGNED_BYTE,(GLvoid*) (rgbaImage)))) {
		return;
	};
	glTexImage2D(GL_TEXTURE_2D,0,4,TEX_WIDTH,TEX_HEIGHT,0,GL_RGBA,GL_UNSIGNED_BYTE,(GLvoid*) (rgbaImage));	
	
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);

	BOOL bLinear = AfxGetApp()->GetProfileInt("Config", "Bilinear", TRUE);
	if (bLinear) {
		glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR); 
		glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	} else {
		glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
		glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
	
	}
	glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,(float)m_TexEnvMode);//GL_DECAL/GL_MODULATE
	glEnable(GL_TEXTURE_2D);

	glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST);//FASTEST);

}

CPicCel::~CPicCel()
{
	glDeleteTextures(1,&m_textureid);
}

void CPicCel::Render()
{

		glPushMatrix();

			glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,(float)m_TexEnvMode);
		glTranslatef(m_offsetx,m_offsety,m_distance);
		
		glRotatef(m_angleX,1,0,0);
		glRotatef(m_angleY,0,1,0);
		glRotatef(m_angleZ,0,0,1);
		//use this texture
		glBindTexture(GL_TEXTURE_2D,m_textureid);

		glBegin(GL_QUADS);
			glTexCoord2f(0,0);
			glColor3f(m_Red, m_Green, m_Blue);
			glVertex3f(-0.5f, -0.5f, 0.5f);
			glTexCoord2f(1,0);
			glColor3f(m_Red, m_Green, m_Blue);
			glVertex3f(0.5f, -0.5f, 0.5f);
			glTexCoord2f(1,1);//0.9375);
			glColor3f(m_Red, m_Green, m_Blue);
			glVertex3f(0.5f, 0.5f, 0.5f);
			glTexCoord2f(0,1);//0.9375);
			glColor3f(m_Red, m_Green, m_Blue);
            glVertex3f(-0.5f, 0.5f, 0.5f);
        glEnd();

		glPopMatrix();
}
