/*
 * TTT's Modern Dreams - Screensaver
 *	Copyright (c) 1998 Tauno Taipaleenmki <tataipal@mail.student.oulu.fi>,
 *	All rights reserved.
 *
 *         FILE : LOAD.CPP
 *      PURPOSE : Object loading
 *		VERSION : 1.00
 * LAST CHANGED : 28/02/1998
 *
 * NOTES:
 * The fileformat of the objects is as follows:
 *
 * Name                 len         Description
 * --------------------------------------------
 * nvrt                 4           Number of vertices
 * npolys               4           Number of polygons
 * vertices             24*nvrt     Vertex coordinates (x,y,z) and a
 *                                  vertex normal vector (nx,ny,nz)
 * polygons             12*npolys   Indices into the vertex list
 */

//
// Load an object
//
int Load_Object(int index)
{
    char                buf[2048];
    char                filename[ 4096 ];
    FILE                *file;
    int                 c,i;

    lstrcpy(filename, data_directory);
    if (filename[ lstrlen(filename) - 1] != '\\')
        lstrcat(filename, "\\");
    lstrcat(filename, object_names[index]);

// Free old object
    if (final_vertices)
        free( final_vertices );
    if (face_list)
        free( face_list );
    if (vertex_list)
        free( vertex_list );

// Load new object
    file = fopen(filename, "rb");
    if (!file) {
        sprintf(buf, " ERROR: Unable to load object %s. Please read the installation instructions.", filename);
        MessageBox(NULL, buf, "TTT's Modern Dreams - Screensaver", MB_OK | MB_APPLMODAL );
        return 0;
    }
    fread(&NUM_VERTICES, 1, 4, file);
    fread(&NUM_POLYGONS, 1, 4, file);
    if ((NUM_VERTICES <= 0) || (NUM_POLYGONS <= 0)) {
        MessageBox( NULL, " ERROR: Unable to load object.", "TTT's Modern Dreams - ScreenSaver", MB_OK | MB_APPLMODAL );
        fclose(file);
        return 0;
    }

    final_vertices  = (GrVertex *)malloc( NUM_VERTICES * sizeof(GrVertex) );
    face_list       =  (polygon *)malloc( NUM_POLYGONS * sizeof(polygon) );
    vertex_list     =   (vertex *)malloc( NUM_VERTICES * sizeof(GrVertex) );
    if (!final_vertices || !face_list || !vertex_list) {
        MessageBox( NULL, " ERROR: Not enough memory to load object. Free some memory and try again.", "TTT's Modern Dreams - ScreenSaver", MB_OK | MB_APPLMODAL );
        fclose(file);
        NUM_VERTICES = 0;
        NUM_POLYGONS = 0;
        if (final_vertices)
            free( final_vertices );
        if (face_list)
            free( face_list );
        if (vertex_list)
            free( vertex_list );
        return 0;
    }
    for(i=0;i<NUM_VERTICES;i++) {
        fread(&vertex_list[i].x, 1, 4, file);
        fread(&vertex_list[i].y, 1, 4, file);
        fread(&vertex_list[i].z, 1, 4, file);
        fread(&vertex_list[i].nx, 1, 4, file);
        fread(&vertex_list[i].ny, 1, 4, file);
        fread(&vertex_list[i].nz, 1, 4, file);
    }
    for(i=0;i<NUM_POLYGONS;i++) {
        fread(&face_list[i].v1, 1, 4, file);
        fread(&face_list[i].v2, 1, 4, file);
        fread(&face_list[i].v3, 1, 4, file);
    }
    fclose(file);

    return 1;
}

