/* Copyright 1998 by Scott Franke [druid-]
    sfranke@scf.usc.edu
    http://www-scf.usc.edu/~sfranke/glj

	This is a utility written for "druid-'s Stonehenge" release version 1.00
	Written for Operation 3DFX's Second programming contest.
*/

#define FLAG_VERT 0x01;
#define FLAG_NORM 0x02;
#define FLAG_TEX  0x04;

typedef float	vect3_t[3];
typedef float	vect2_t[2];

typedef unsigned short int int3_t[3];
typedef unsigned short int int2_t[2];

typedef struct {
	int3_t coord;
	int3_t norm;
	int3_t tex;
} tri_t;

typedef struct {
	unsigned char version;
	unsigned char flags;
	unsigned short int num_vert;
	unsigned short int num_tri;
	unsigned short int num_norm;
	unsigned short int num_tex;
	char texname[9];

	vect3_t *verts;
	tri_t   *tris;
	vect3_t *norms;
	vect2_t *tex;

	vect3_t v_max;
	vect3_t v_min;
} model_t;

typedef struct {
	int3_t *new_vert;
	int3_t *new_norm;
	int2_t *new_tex;
} data_t;
