/* Copyright 1998 by Scott Franke [druid-]
    sfranke@scf.usc.edu
    http://www-scf.usc.edu/~sfranke/glj

	This is a source file for "druid-'s Stonehenge" release version 1.00
	Written for Operation 3DFX's Second programming contest.
*/	

#include "demo.h"

// Terrain 1.2

void vectSet(vect3_t v, GLfloat x, GLfloat y , GLfloat z)
{
	v[0] = x; v[1] = y; v[2] = z;
}

void vectSub(vect3_t a, vect3_t b, vect3_t result)
{
	int i;
	for(i=0;i<3;i++)
		result[i] = b[i] - a[i];
}

void vectAdd(vect3_t a, vect3_t b, vect3_t result)
{
	int i;
	for(i=0;i<3;i++)
		result[i] = a[i] + b[i];
}

void vectScale(vect3_t v, GLfloat s)
{
	int i;
	for(i=0;i<3;i++)
		v[i] *= s;
}

GLfloat vectDist(vect3_t a, vect3_t b)
{
	GLfloat magnitude;
	vect3_t v;
	vectSub(a, b, v);
	magnitude = sqrt(v[0] * v[0] +
					v[1] * v[1] +
					v[2] * v[2]);
	return magnitude;
}


void cpVect(vect3_t a, vect3_t b)
{
	a[0]=b[0];
	a[1]=b[1];
	a[2]=b[2];
}

void normalize(vect3_t v)
{
	GLfloat d;
	d = sqrt(v[0]*v[0]+v[1]*v[1]+v[2]*v[2]);
	if(d == 0.0)
	{
		return;
	}
	v[1] /= d; v[2] /= d; v[3] /= d;
}

void normcrossprod(vect3_t v1, vect3_t v2, vect3_t out)
{
	out[0] = v1[1]*v2[2] - v1[2]*v2[1];
	out[1] = v1[2]*v2[0] - v1[0]*v2[2];
	out[2] = v1[0]*v2[1] - v1[1]*v2[0];
	normalize(out);
}

void crossprod(vect3_t v1, vect3_t v2, vect3_t out)
{
	out[0] = v1[1]*v2[2] - v1[2]*v2[1];
	out[1] = v1[2]*v2[0] - v1[0]*v2[2];
	out[2] = v1[0]*v2[1] - v1[1]*v2[0];
}

GLfloat dotprod(vect3_t v1, vect3_t v2)
{
	GLfloat value;
	int i;

	value = 0;
	for(i=0;i<3;i++)
		value += v1[i] * v2[i];

	return value;
}
