/* Copyright 1998 by Scott Franke [druid-]
    sfranke@scf.usc.edu
    http://www-scf.usc.edu/~sfranke/glj

	This is a source file for "druid-'s Stonehenge" release version 1.00
	Written for Operation 3DFX's Second programming contest.
*/	

/* Other important files...*/
#include <windows.h>
#include <mmsystem.h>
#include <winuser.h>
#include <gl\gl.h>
#include <gl\glu.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

/*Global Defines and Variables */

#define TEX_CONSOLE			1
#define TEX_FLARES			2

#define TEXMODE_RA			0
#define TEXMODE_GA			1
#define TEXMODE_BA			2
#define TEXMODE_SOLID		3

#define MODE_CONSOLE			0
#define MODE_PLAYBACK		1
#define MODE_INTERACTIVE	2

#define P_WHITE				0
#define P_WHITE_VERT			1
#define P_WHITE_HORZ			2
#define P_WHITE_DIAG			3
#define P_YELLOW				4
#define P_ORANGE				5
#define P_FIRE_BRIGHT		6
#define P_FIRE_DIM			7
#define P_GREEN				8
#define P_BLUE					9
#define P_BLUE_HORZ			10
#define P_ORANGE_HORZ		11

#define PE_FIREBALL			0
#define PE_SPRAY				1
#define PE_SPARKS				2
#define PE_CYCLONE			3
#define PE_FSPARKS			4
#define PE_EXP1				5
#define PE_EXP2				6

#define LITE_PARALLEL		0
#define LITE_OMNI				1

#define MAX_PARTICLES		50

#define PI						3.1415926
#define DEGTORAD				0.01745329

static HWND  hwnd;
static HGLRC glRC;
static HDC   hDC;
static BOOL  done = 0;

static GLfloat viewHeight;

static float version = 0.35;

typedef GLfloat vect3_t[3];
typedef GLfloat	vect3_t[3];
typedef GLfloat	vect2_t[2];

typedef unsigned short int int3_t[3];
typedef unsigned short int int2_t[2];

typedef struct
{
	GLfloat x,y;
	GLfloat oldx,oldy;
}mouse_t;

typedef struct{
	BOOL up;
	BOOL down;
	BOOL left;
	BOOL right;
	BOOL jump;
}keys_t;

/* CONSOLE STRUCTURES */

typedef struct
{
	int active;
	char buffer[16][30];
	int col;
} console_t;

/* PARTICLE STRUCTURES */

typedef struct
{
	GLfloat pos[3];
	GLfloat vel[3];
	GLfloat scale;

	GLfloat extra;					// PE_CYCLONE: rotation
	int pType;
	GLfloat timer;
	int inuse;

} particle_t;

typedef particle_t *particle_tp;

typedef struct
{
		/* System Information */
	vect3_t old_pos;
	vect3_t new_pos;
	vect3_t pos;
	
		/* Particle Information */
	vect3_t acc;
	vect3_t ivel;
	GLfloat randomness;
		/* For scripting, etc */
	GLfloat time;
	GLfloat timer;
	double newtime, oldtime;

		/* lifetime for each point */
	int life;

	int peType;
	int spawn;
	int front, num;
	GLfloat scale;

	int inuse;
	int active;
	int psys_id;

	particle_t parts[MAX_PARTICLES];

} psystem_t;

typedef psystem_t *psystem_tp;

/* BINARY SEARCH TREE STRUCTURES */

typedef struct node_t *node_tp;

typedef struct node_t
{
	int psysNum;
	int pNum;
	GLfloat zval;

	node_tp left, right;
} node_t;

/* OBJECT FORMAT STRUCTURES */

typedef struct {
	int3_t coord;
	int3_t norm;
	int3_t tex;
} tri_t;

typedef struct {
	unsigned char version;
	unsigned char flags;
	unsigned short int num_vert;
	unsigned short int num_tri;
	unsigned short int num_norm;
	unsigned short int num_tex;
	char texname[9];

	vect3_t *verts;
	tri_t   *tris;
	vect3_t *norms;
	vect2_t *tex;
	vect3_t *light;

	vect3_t v_max;
	vect3_t v_min;

	GLfloat scale;

	vect3_t pos;
	vect3_t rot;

		/* updating by script commands */
	vect3_t old_pos;
	vect3_t old_rot;
	vect3_t new_pos;
	vect3_t new_rot;
		/* for syncing to script */
	double oldtime;
	double newtime;

	GLfloat tex_tile;

	int tex_id;
	int hm_id;
	int lit;		//0=notlit, 1=static, 2=dynamic
	int inuse;
	int active;
} model_t;

typedef model_t model_tp;

typedef struct {
	int3_t *new_vert;
	int3_t *new_norm;
	int2_t *new_tex;
} data_t;

model_t newmodel;

/* SCRIPTING STRUCTS */

typedef struct {
	vect3_t pos;
	vect3_t rot;

	vect3_t old_pos;
	vect3_t old_rot;
	vect3_t new_pos;
	vect3_t new_rot;
	double oldtime;
	double newtime;
	double time;

	GLfloat grav;

		/* screen blend */
	vect3_t col;
	vect3_t old_col;
	vect3_t new_col;
	int	  flash;
	int	  oldflash;
	int	  newflash;

		/* other mode switches */
	int mode;
	int sky;
	int fps;
} viewport_t;

typedef struct {
	float	time;
	int	cmd;
	float	fparam [3];
	long	iparam [3];
	char	cparam [20];
} event_t;

typedef struct {
	double timebegin;
	double timepause;
	double nextthink;
	int paused;
	event_t events[700];
	int total;
	int current;
	double curtime;

	int scrnum;

	double num_tri;
} script_t;

typedef struct {
	int type;
	vect3_t pos;
	vect3_t col;
	int falloff;
		/* updating for script commands */
	vect3_t old_pos;
	vect3_t old_col;
	vect3_t new_pos;
	vect3_t new_col;
		/* linear transformations */
	double oldtime;
	double newtime;
} light_t;
/* ==============IMPORTANT VARIABLES============== */

/* global structure bins */

  psystem_t	psystems[20];
  model_tp	models[20];
  int		textures[21];
  light_t   lights[5];

  script_t script;
  viewport_t viewport;
  console_t console;

  node_tp treeRoot;

  mouse_t mouse;
  keys_t keys;

  GLubyte pic[256][256][4];
  GLubyte bufferpic[256][256][3];

/* And their respective counters */

  int		num_psys;
  int		num_mdl;
  int		num_tex;
  int		num_light;

/* State variables */
  int		dLight;	// lights changed this frame?
  int		dModelL; // model's lighting recalced?

/* ==============FUNCTIONS============== */

	/* Basic functions */
void drawScene(GLfloat);

	/* Console functions */
void initConsole(void);
void drawConsole(void);
void writeChar(int row, int col, char letter);
void writeString(int row, int col, char *string);
void consoleIn(WPARAM wParam);
void consoleAdvance(void);
void consoleProcess(void);
void consoleScroll(void);
void consoleOut(char *);
void consoleAlert(char *);

	/* Particle System Functions */
void psystemRender(int);
void psystemRemove(int);
void psystemAnimate(int, GLfloat);
void psystemAdd(int, vect3_t, vect3_t, vect3_t, int, GLfloat, GLfloat);
void updatePsys(int, GLfloat);

	/* Particle Functions */
void particleRender(int, int);
void particleAnimate(int, int, GLfloat);
void particleAdd(psystem_tp);
void particleRemove(particle_tp, psystem_tp);

	/* Misc Vector Functions */
void vectSet(vect3_t, GLfloat, GLfloat, GLfloat);
void vectSub(vect3_t, vect3_t, vect3_t);
void vectAdd(vect3_t, vect3_t, vect3_t);
void vectScale(vect3_t, GLfloat);
GLfloat vectDist(vect3_t, vect3_t);
void cpVect(vect3_t, vect3_t);
void normalize(vect3_t);
void normcrossprod(vect3_t, vect3_t, vect3_t);
void crossprod(vect3_t, vect3_t, vect3_t);
GLfloat dotprod(vect3_t, vect3_t);

	/* Texture Functions */
void loadpic (char *, int, int, int);

	/* BSP Functions */
void treeAdd(int, int);
void treeRender(node_tp);

	/* Hubris Model Functions */
void loadHM(char [], model_t *);
void drawHM(model_t *);
void updateHM(model_t *);
void lightHM(model_t *);

	/* Light functions */
void updateLight(int);

	/* Sky Functions */
void drawSky(void);

	/* Script Functions */
void processScript (double);
void loadScript (char *);
	/* Script command functions */
void cmd_pvp(GLfloat, GLfloat, GLfloat);
void cmd_mvp(int, GLfloat, GLfloat, GLfloat);
void cmd_ovp(int, GLfloat, GLfloat, GLfloat);
void cmd_bvp(int, int, GLfloat, GLfloat, GLfloat);

void cmd_ltx(char *, int, int);
void cmd_ctx(void);

void cmd_lhm(char *, int, int, int, GLfloat);
void cmd_rhm(int);
void cmd_phm(int, GLfloat, GLfloat, GLfloat);
void cmd_mhm(int, int, GLfloat, GLfloat, GLfloat);
void cmd_ohm(int, int, GLfloat, GLfloat, GLfloat);

void cmd_aps(int, int, int, GLfloat, GLfloat, GLfloat);
void cmd_sps(int, GLfloat, GLfloat, GLfloat);
void cmd_pps(int, GLfloat, GLfloat, GLfloat);
void cmd_mps(int, int, GLfloat, GLfloat, GLfloat);
void cmd_rps(int);
void cmd_nps(int);

void cmd_apl(GLfloat, GLfloat, GLfloat);
void cmd_aol(GLfloat, GLfloat, GLfloat, int);
void cmd_slc(int, int, GLfloat, GLfloat, GLfloat);
void cmd_ml (int, int, GLfloat, GLfloat, GLfloat);
void cmd_rl(void);

void cmd_sky(int);

void cmd_sgv(GLfloat);

	/* Other misc stuff */
void updateViewport(void);
