/* Copyright 1998 by Scott Franke [druid-]
    sfranke@scf.usc.edu
    http://www-scf.usc.edu/~sfranke/glj

	This is a source file for "druid-'s Stonehenge" release version 1.00
	Written for Operation 3DFX's Second programming contest.
*/	

/* druid-'s GLJournal distribution:
	http://www-scf.usc.udu/~sfranke/glj/
	-=Major=- Project 01 - druid-'s Stonehenge (DEMO)
		-Hubris Engine Version 0.31b
		-Uses hubris model format (.hm)
			Visual C++ 5 Project

  by Scott Franke [druid-]
	sfranke@scf.usc.edu
*/

#include "demo.h"

/* Fps counter */
static float itime;
static float fps;
static int counter;

void drawScene( GLfloat dTime ) {
	int i, j;
	char temp[15];

    glClear(GL_DEPTH_BUFFER_BIT);
	
	glPushMatrix();
			/* Initial rotation for viewport */
		glRotatef(-viewport.rot[0]/DEGTORAD,1.0f,0.0f,0.0f);
		glRotatef(-viewport.rot[1]/DEGTORAD,0.0f,1.0f,0.0f);

			/* Render sky */
		if(viewport.sky>2)
		{
			glDepthMask(GL_FALSE);
			glDisable(GL_FOG);
				drawSky();
			glEnable(GL_FOG);
			glDepthMask(GL_TRUE);
		}
		else /* Need to erase the screen */
			glClear(GL_COLOR_BUFFER_BIT);

			/* Translate into viewspace */
		glTranslatef(-viewport.pos[0], -viewport.pos[1], -viewport.pos[2]);

			/* Update all lights */
		dLight = 0;
		dModelL = 0;
		if(!script.paused)
			for(i=0;i<num_light;i++)
				if(lights[i].newtime!=lights[i].oldtime)
				{
					updateLight(i);
					dLight = 1;
				}

			/* Render any necessary models */
		if(num_mdl)
			for(i=0;i<20;i++)
				if(models[i].active)
				{
					if(!script.paused)
						updateHM(&models[i]);
					drawHM(&models[i]);
				}

			/* Sort and render any particles */
		if(num_psys)
		{
			glBindTexture(GL_TEXTURE_2D, TEX_FLARES);
			glEnable(GL_TEXTURE_2D);
			glBlendFunc(GL_ONE, GL_ONE);
				treeRoot = NULL;
				for(i=0;i<20;i++)
				{
					if(psystems[i].active)
					{
						updatePsys(i, dTime);
						for(j=0;j<MAX_PARTICLES;j++)
							if(psystems[i].parts[j].inuse)
								treeAdd(i, j);
					}
				}
				treeRender(treeRoot);
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		}

	glPopMatrix();

	if(console.active || viewport.fps || viewport.flash)
	{
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glOrtho(0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 1.0f);
		glMatrixMode(GL_MODELVIEW);
		glDepthFunc(GL_ALWAYS);

			/* Viewport blending */
		if(viewport.flash)
		{
			glDisable(GL_TEXTURE_2D);
			glColor4f(viewport.col[0], viewport.col[1], viewport.col[2], (GLfloat)(viewport.flash)/100.0f);
			glBegin(GL_QUADS);
				glVertex2f(0.0f, 0.0f);
				glVertex2f(1.0f, 0.0f);
				glVertex2f(1.0f, 1.0f);
				glVertex2f(0.0f, 1.0f);
			glEnd();
			glEnable(GL_TEXTURE_2D);
		}

		if(console.active)
			drawConsole();

		if(viewport.fps)
		{
			glColor4f(1.0f,1.0f,1.0f,1.0f);
			if(!console.active)
			{
				glBindTexture(GL_TEXTURE_2D, TEX_CONSOLE);
				glEnable(GL_TEXTURE_2D);
			}

				/* Do counter mumbo-jumbo */
			counter++;
			if(counter > 5)
			{
				fps = timeGetTime() - itime;
				fps = (5 * 1000) / (timeGetTime() - itime);
				counter = 0;
				itime = timeGetTime();
			}
			sprintf(temp, "FPS: %f", fps);
			writeString(-3,-1,temp);
		}

		/* Back to normal viewing */
		glMatrixMode(GL_PROJECTION);
		glDepthFunc(GL_LEQUAL);
		glLoadIdentity();
		glFrustum(-4.0f, 4.0f, -2.704225f, 2.704225f, 4.0f, 4096.0f);  //GLQuake Mode
		glMatrixMode(GL_MODELVIEW);
	}

	glFlush();
	SwapBuffers( hDC );			
}

void init(void) {
	GLuint stTex[2] = {TEX_CONSOLE, TEX_FLARES};

	initConsole();
	viewport.mode = MODE_INTERACTIVE;
	glViewport(0, 0, 640, 480);

    /* set viewing projection */
    glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glFrustum(-4.0f, 4.0f, -2.704225f, 2.704225f, 4.0f, 4096.0f);  //GLQuake Mode

    /* position viewer */
	glMatrixMode(GL_MODELVIEW);

	glCullFace(GL_BACK);
	glFrontFace(GL_CCW);
	glEnable(GL_CULL_FACE);

	glEnable(GL_FOG);
	{
		GLint fogMode;
		GLfloat fogColor[4] = {0.0f, 0.0f, 0.0f, 0.0f};

		fogMode = GL_EXP2;
		glFogi(GL_FOG_MODE, fogMode);
		glFogf(GL_FOG_START, 200.0f);
		glFogf(GL_FOG_END,   4000.0f);
		glFogf(GL_FOG_DENSITY,   0.001f);
		glFogfv(GL_FOG_COLOR, fogColor);
		glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
	}

	glDepthFunc(GL_LEQUAL);
	glEnable(GL_DEPTH_TEST);

	glClearDepth(1.0);
	glShadeModel(GL_SMOOTH);

	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);

    glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_NEAREST);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	glBindTexture(GL_TEXTURE_2D, TEX_CONSOLE);
	loadpic("console.raw", 256, 256, TEXMODE_RA);
	glTexImage2D(GL_TEXTURE_2D, 0, 4, 256, 256, 0, GL_RGBA,
		     GL_UNSIGNED_BYTE, &pic[0][0][0]);

	glBindTexture(GL_TEXTURE_2D, TEX_FLARES);
	loadpic("flares.raw", 256, 256, TEXMODE_RA);
	glTexImage2D(GL_TEXTURE_2D, 0, 4, 256, 256, 0, GL_RGBA,
		     GL_UNSIGNED_BYTE, &pic[0][0][0]);

	glEnable(GL_TEXTURE_2D);

	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);

	loadHM("frac.hm", &newmodel);
}

void initvars( void )
{
	int i;
	for(i=0;i<20;i++)
	{
		models[i].inuse = 0;
		psystems[i].inuse = 0;
	}

	for(i=0;i<3;i++)
	{
		viewport.pos[i] = 0.0f;
		viewport.rot[i] = 0.0f;
	}
	viewport.time = 0;
	viewport.sky = 0;
	viewport.fps = 1;
	viewport.mode = MODE_CONSOLE;
	viewport.flash = 0;
	console.active = 1;
	script.total = 0;
	script.current = 0;
	script.paused = 1;

	for(i=0;i<8;i++)
		textures[i] = 1;
}

void idleFunc(GLfloat deltaTime)
{
	int i;

//	viewport.rot[1] += ((GLfloat)(mouse.x-mouse.oldx))/100;
//	viewport.rot[0] -= ((GLfloat)(mouse.y-mouse.oldy))/100;

//	viewport.rot[1] = ((320-mouse.x)/320)*3;
//	viewport.rot[0] = ((240-mouse.y)/240)*3;

//	mouse.oldx = mouse.x;
//	mouse.oldy = mouse.y;
}

void updateViewport(void)
{
	double timefrac;
	int i;

	if(viewport.newtime==viewport.oldtime)
		return;
	if(viewport.newtime<=script.curtime)
	{
		for(i=0;i<3;i++)
		{
			viewport.pos[i] = viewport.new_pos[i];
			viewport.rot[i] = viewport.new_rot[i];	
			viewport.old_pos[i] = viewport.pos[i];
			viewport.old_rot[i] = viewport.rot[i];
			viewport.old_col[i] = viewport.col[i];
		}
		viewport.oldflash = viewport.flash;
		return;
	}

	timefrac = (script.curtime - viewport.oldtime) / (viewport.newtime - viewport.oldtime);

	for(i=0;i<3;i++)
	{
		viewport.pos[i] = (viewport.new_pos[i] - viewport.old_pos[i]) * timefrac + viewport.old_pos[i];
		viewport.rot[i] = (viewport.new_rot[i] - viewport.old_rot[i]) * timefrac + viewport.old_rot[i];
		viewport.col[i] = (viewport.new_col[i] - viewport.old_col[i]) * timefrac + viewport.old_col[i];
	}
	viewport.flash = (viewport.newflash - viewport.oldflash) * timefrac + viewport.oldflash;
}

HGLRC setupGL( void ) {
    static PIXELFORMATDESCRIPTOR pfd = {
        sizeof(PIXELFORMATDESCRIPTOR),  // size of this pfd
        1,                              // version number
        PFD_DRAW_TO_WINDOW              // support window
        |  PFD_SUPPORT_OPENGL           // support OpenGL
        |  PFD_DOUBLEBUFFER ,           // double buffered
        PFD_TYPE_RGBA,                  // RGBA type
        16,                             // 16-bit color depth
        0, 0, 0, 0, 0, 0,               // color bits ignored
        0,                              // no alpha buffer
        0,                              // shift bit ignored
        0,                              // no accumulation buffer
        0, 0, 0, 0,                     // accum bits ignored
        32,                             // 16-bit z-buffer      
        0,                              // no stencil buffer
        0,                              // no auxiliary buffer
        PFD_MAIN_PLANE,                 // main layer
        0,                              // reserved
        0, 0, 0                         // layer masks ignored
    };
    int  pixelFormat;
    HGLRC rv = 0;

    pixelFormat = ChoosePixelFormat(hDC, &pfd);
    if ( pixelFormat ) {
        if ( SetPixelFormat(hDC, pixelFormat, &pfd) ) {
            rv = wglCreateContext( hDC );
            if ( rv ) {
                if ( !wglMakeCurrent( hDC, rv ) ) {
                    wglDeleteContext( rv );
                    rv = 0;
                }
            }
        }
    }
    return rv;
}

LONG WINAPI MainWndProc ( HWND    hWnd,
                          UINT    uMsg,
                          WPARAM  wParam,
                          LPARAM  lParam ) {
    LONG    lRet = 1;

    switch ( uMsg ) {
    case WM_CREATE:
        hDC  = GetDC( hWnd );
        glRC = setupGL();
        if ( !glRC ) {
            MessageBox( 0, "Failed to Create OpenGL Rendering Context.",
				"3dFX Test", MB_ICONERROR );
            DestroyWindow( hWnd );
        }
        break;
    case WM_SIZE:
        break;
    case WM_CLOSE:
        DestroyWindow( hWnd );
        break;
    case WM_DESTROY:
        PostQuitMessage( 0 );
    case WM_QUIT:
        done = TRUE;
        break;
/*    case WM_PAINT:
        drawScene();
        break;
	case WM_MOUSEMOVE:
		mouse.x = LOWORD(lParam);
		mouse.y = HIWORD(lParam);
		break;*/
	case WM_KEYDOWN:
		switch(viewport.mode)
		{
/*		case MODE_INTERACTIVE:
	        switch (wParam) {
			case VK_ESCAPE:
				done = TRUE;
				PostQuitMessage(0);
				break;
			case VK_SPACE:
				keys.jump = TRUE;
				break;
			case 'E':
				keys.up = TRUE;
				break;
			case 'D':
				keys.down = TRUE;
				break;
			case 'S':
				keys.left = TRUE;
				break;
			case 'F':
				keys.right = TRUE;
				break;
			case VK_INSERT:
				console.active = 1;
				viewport.mode = MODE_CONSOLE;
				script.paused = 1;
				break;
			}
			break;
*/		case MODE_CONSOLE:
			if(wParam == VK_INSERT)
			{
				console.active = 0;
				viewport.mode = MODE_PLAYBACK;
				script.paused = 0;
			}
			break;
		case MODE_PLAYBACK:
			if(wParam == VK_INSERT)
			{
				console.active = 1;
				viewport.mode = MODE_CONSOLE;
				script.paused = 1;
			}
			break;
		}
		break;
	case WM_CHAR:
		if(console.active)
			consoleIn(wParam);
		break;
/*	case WM_KEYUP:
        switch (wParam) {
		case VK_SPACE:
			keys.jump = FALSE;
			break;
		case 'E':
			keys.up = FALSE;
			break;
		case 'D':
			keys.down = FALSE;
			break;
		case 'S':
			keys.left = FALSE;
			break;
		case 'F':
			keys.right = FALSE;
			break;
		}
		break;
*/	default:
        lRet = DefWindowProc (hWnd, uMsg, wParam, lParam);
        break;
    }
    return lRet;
}

int WINAPI WinMain ( HINSTANCE hInstance, 
                     HINSTANCE hPrevInstance, 
                     LPSTR lpCmdLine, 
                     int nCmdShow ) {
	WNDCLASS   wc;
    MSG msg;
	DEVMODE devmode;
	BOOL modeswitch;
	int i;
	LONG result;
//	GLuint stTex[2] = {TEX_CONSOLE, TEX_FLARES};
	GLfloat thisTimeGetTime, lastTimeGetTime, deltaTime, nextDraw, nextInput, dTimeFrame;

    wc.style         = 0;
    wc.lpfnWndProc   = (WNDPROC)MainWndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInstance;
    wc.hIcon         = LoadIcon (hInstance, "demo");
    wc.hCursor       = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wc.lpszMenuName  = "demo";
    wc.lpszClassName = "demo";

    
    if ( !RegisterClass( &wc ) ) {
        MessageBox( 0, "Couldn't Register Window Class", "Land2", MB_ICONERROR );
    }
    
    hwnd = CreateWindow ("demo",
                         "demo",
						 WS_CLIPSIBLINGS | 
                         WS_CLIPCHILDREN,
                         0,
						 0,
						 640, 480,
                         NULL,
                         NULL,
                         hInstance,
                         NULL);
    if (!hwnd) {
        MessageBox( 0, "Couldn't Create Window", "Land2", MB_ICONERROR);
    }

    ShowWindow( hwnd, SW_SHOWDEFAULT );
	UpdateWindow(hwnd);
	SetFocus (hwnd);
/*			// UNCOMMENT THIS TO HAVE IT SWITCH TO FULLSCREEN
	devmode.dmBitsPerPel=0;
	i=0;
	do
	{
		modeswitch = EnumDisplaySettings(NULL, i, &devmode);
		i++;
	}
	while((devmode.dmBitsPerPel!=16) && 
			(devmode.dmPelsWidth != 640) && 
				(devmode.dmPelsHeight != 480) &&
					(i<50) );

	if(!modeswitch)
	{
		MessageBox(0, "Fullscreen 16-bit not supported", "Init", MB_ICONERROR);
		return 0;
    }
	else
	{
		result = ChangeDisplaySettings(&devmode, CDS_FULLSCREEN);
		if(result!=DISP_CHANGE_SUCCESSFUL)
		{
			//Might be running in Windows95, let's try without the hertz change
			devmode.dmBitsPerPel = 16;
			devmode.dmPelsWidth  = 640;
			devmode.dmPelsHeight = 480;
			devmode.dmFields     = DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT;
			result = ChangeDisplaySettings(&devmode, CDS_FULLSCREEN);
			if(result!=DISP_CHANGE_SUCCESSFUL)
			{
				if(result==DISP_CHANGE_RESTART)
 					MessageBox(0, "Must restart to get Fullscreen 16-bit", "Init", MB_ICONERROR);
				else if(result==DISP_CHANGE_BADMODE)
					MessageBox(0, "Fullscreen 16-bit not supported", "Init", MB_ICONERROR);
				else if(result==DISP_CHANGE_FAILED)
					MessageBox(0, "Hardware failed to change to 640x480x16bit", "Init", MB_ICONERROR);
				return 0;
			}
		}
    }
*/
	init();
	initvars();

	lastTimeGetTime = timeGetTime();
	deltaTime = nextInput = nextDraw = dTimeFrame = 0;
	itime = 0;
	fps = 0;
	counter = 0;
	script.scrnum = 0;
	loadScript("intro.hs");
	script.paused = 0;
	console.active = 0;
	viewport.fps = 0;

	timeBeginPeriod(1);
	srand(timeGetTime());
    while( !done ) {
        while( PeekMessage( &msg, 0, 0, 0, PM_REMOVE ) ) {
			TranslateMessage( &msg );
			DispatchMessage( &msg );
			if(msg.message == WM_QUIT)
				done = 1;
		}
		thisTimeGetTime = timeGetTime();

		if(thisTimeGetTime - lastTimeGetTime < 5)
			continue;

		deltaTime = (GLfloat)(thisTimeGetTime - lastTimeGetTime);
		dTimeFrame += deltaTime;
		lastTimeGetTime = thisTimeGetTime;

		if (script.total>0)
		{
			if(!script.paused)
				script.curtime += deltaTime;
			if((!script.paused) && (script.current < script.total) &&
					(script.nextthink <= script.curtime))
				processScript(deltaTime);
		}
		if(dTimeFrame > 15)
		{
			updateViewport();
			drawScene(dTimeFrame);
			dTimeFrame = 0;
		}
	}
	timeEndPeriod(1);

	ChangeDisplaySettings(NULL, 0);

	return msg.wParam;
}
