/* Copyright 1998 by Scott Franke [druid-]
    sfranke@scf.usc.edu
    http://www-scf.usc.edu/~sfranke/glj

	This is a source file for "druid-'s Stonehenge" release version 1.00
	Written for Operation 3DFX's Second programming contest.
*/	#include "demo.h"

/*
	console.h
*/

void initConsole(void)
{
	int i, j;

	console.active = 0;
	console.col = 1;
	
	for(i=0;i<8;i++)
		for(j=0;j<20;j++)
			console.buffer[i][j] = '\0';
	console.buffer[0][0] = ']';

}

void drawConsole(void)
{
	int i;
	char buf[20];

	glDisable(GL_TEXTURE_2D);
	glBegin(GL_QUADS);
			/* Border */
		glColor4f(0.2f,0.2f,0.6f,0.3f);
		glVertex3f(0.0f, 0.52f, -0.5f);
		glVertex3f(0.0f, 0.05f, -0.5f);
		glVertex3f(1.0f, 0.05f, -0.5f);
		glVertex3f(1.0f, 0.52f, -0.5f);
			/* Terminal Area */
		glColor4f(0.0f,0.0f,0.0f,0.6f);
		glVertex3f(0.01f, 0.51f, -0.5f);
		glVertex3f(0.01f, 0.06f, -0.5f);
		glVertex3f(0.99f, 0.06f, -0.5f);
		glVertex3f(0.99f, 0.51f, -0.5f);
	glEnd();

	glBindTexture(GL_TEXTURE_2D, TEX_CONSOLE);
	glEnable(GL_TEXTURE_2D);
	glColor4f(1.0f, 1.0f, 1.0f, 0.8f);
	for(i=0;i<15;i++)
		writeString(i,0,console.buffer[i]);

	glColor4f(0.0f,1.0f,0.0f,0.8);
	sprintf(buf, "Hubris v%f3", version);
	writeString(15,42,buf);

}

void writeChar(int row, int col, char letter)
{

	GLfloat box[4];
	GLfloat poly[4];

	box[0] = (GLfloat) ((((letter - 33) % 16) * 16)) / 256.0f;
	box[1] = (GLfloat) ((((letter - 33) / 16) * 24)) / 256.0f;
	box[2] = (box[0]*256.0f + 15) / 256.0f;
	box[3] = (box[1]*256.0f + 23) / 256.0f;

	if(box[2] > 1.0f)
		box[2] = 1.0f;

	poly[0] = 0.018f + 0.018f * (col);
	poly[1] = 0.08f + 0.027f * (row);
	poly[2] = poly[0] + 0.018f;
	poly[3] = poly[1] + 0.027f;

	glBegin(GL_QUADS);
		glTexCoord2f(box[0], box[1]);
		glVertex2f(poly[0], poly[3]);
		glTexCoord2f(box[0], box[3]);
		glVertex2f(poly[0], poly[1]);
		glTexCoord2f(box[2], box[3]);
		glVertex2f(poly[2], poly[1]);
		glTexCoord2f(box[2], box[1]);
		glVertex2f(poly[2], poly[3]);
	glEnd();

}

void writeString(int row, int col, char *string)
{
	int i;

	i=0;

	while(string[i]!='\0')
	{
		if((string[i] >= 33) && (string[i] < 127))
			writeChar(row, col + i, string[i]);
		i++;
	}

}

void consoleAdvance(void)
{
	int i;
	for(i=15;i>0;i--)
		strcpy(console.buffer[i],console.buffer[i-1]);
	console.buffer[0][0] = '\0';
}

	/* scrolls all but current line */
void consoleScroll(void)
{
	int i;
	for(i=15;i>0;i--)
		strcpy(console.buffer[i],console.buffer[i-1]);
	console.buffer[0][1] = '\0';
}

void consoleOut(char *string)
{
	consoleScroll();
	strcpy(console.buffer[1],string);
}

void consoleAlert(char *string)
{
	consoleScroll();
	strcpy(console.buffer[1],string);
	viewport.mode = MODE_CONSOLE;
	console.active = 1;
	script.paused = 1;
}

void consoleIn(WPARAM wParam)
{
	int i;

	switch(wParam)
	{
	case '\b':
		if(console.col>1)
		{
			console.buffer[0][console.col] = '\0';
			console.buffer[0][console.col-1] = '_';
			console.col--;
		}
		break;
	case '\n':
		console.buffer[0][console.col] = '\0';
		consoleAdvance();
		consoleProcess();
		console.col = 1;
		console.buffer[0][0] = ']';
		console.buffer[0][1] = '_';
		console.buffer[0][2] = '\0';
		break;
	case '\r':
		console.buffer[0][console.col] = '\0';
		consoleAdvance();
		consoleProcess();
		console.col = 1;
		console.buffer[0][0] = ']';
		console.buffer[0][1] = '_';
		console.buffer[0][2] = '\0';
		break;
	case '\t':
		console.buffer[0][console.col]=' ';
		for(i=0;i<5;i++)
			console.buffer[0][++console.col]=' ';
		console.col++;
		console.buffer[0][console.col] = '_';
		break;
	case '\x1B':							// Escape
		console.col=0;
		console.buffer[0][console.col]='_';
		break;
	default:
		if(console.col > 27)
			break;
		console.buffer[0][console.col] = wParam;
		console.col++;
		console.buffer[0][console.col] = '_';
		console.buffer[0][console.col+1] = '\0';
		break;
	}

}

void consoleProcess(void)
{
	char cmd[30], buf[30];
	strcpy(cmd, &console.buffer[1][1]);

		/* Exit the console */
	if(!strcmp(cmd,"exit"))
	{
		console.active = 0;
		viewport.mode = MODE_PLAYBACK;
		script.paused = 0;
	}

		/* Toggle fps display */
	else if(!strcmp(cmd,"fps"))
		viewport.fps = !viewport.fps;

		/* check some variables */
	else if(!strcmp(cmd,"paused"))
	{
		sprintf(buf,"== %d", script.paused);
		consoleOut(buf);
	}
	else if(!strcmp(cmd,"current"))
	{
		sprintf(buf,"== %d", script.current);
		consoleOut(buf);
	}
	else if(!strcmp(cmd,"nextthink"))
	{
		sprintf(buf,"== %d", script.nextthink);
		consoleOut(buf);
	}
	else if(!strcmp(cmd,"begin"))
	{
		sprintf(buf,"== %d", script.timebegin);
		consoleOut(buf);
	}
	else if(!strcmp(cmd,"curtime"))
	{
		sprintf(buf,"== %f", script.curtime);
		consoleOut(buf);
	}
	else if(!strcmp(cmd,"numtri"))
	{
		sprintf(buf,"== %f", script.num_tri);
		consoleOut(buf);
	}
	else if(!strcmp(cmd,"numsys"))
	{
		sprintf(buf,"== %d", num_psys);
		consoleOut(buf);
	}
	else if(!strcmp(cmd,"dlit"))
	{
		sprintf(buf,"== %d", dLight);
		consoleOut(buf);
	}
	else if(!strcmp(cmd,"dmdl"))
	{
		sprintf(buf,"== %d", dModelL);
		consoleOut(buf);
	}


		/* Quit the whole program */
	else if(!strcmp(cmd,"quit"))
	{
		done = TRUE;
		PostQuitMessage(0);
	}
	else if (!strcmp(cmd,"lhs"))
	{
		loadScript("test.hs");
	}

	else
	{
		consoleOut("== Invalid command");
	}
}

