/*
    SnartFag - The Gaffer Experience.

    Code/Graphics by Jestyr and Black Fox, Sound by Black Fox [9+10/7/1998]
    Coded at Coven98 for the Blitz Competition.

 */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include <i86.h>
#include "usmplay.h"
#include "defs.h"
#include "gfx.h"

#define GAFNOJAW "GAFNOJAW.RAW"
#define GAFJAW "GAFJAW.RAW"
#define GAFPAL "GAF.PAL"
#define GAFNOEYE "GAFNOEYE.RAW"
#define GAFEYE "GAFEYES.RAW"
#define MODULE "F-FARSE2.XM"



long scale, foo, angle, foo2, scale2, angle2, blah;
long deltay;


void init();
void deInit();
void drawjaw(int x, int y);
void drawhead(int x, int y);
void draweyeless(int x, int y);
void draweyes(int x, int y);

USM *music;
BYTE *buf1, *buf2;
BYTE *vidMem = (BYTE *)0xa0000;
BYTE *headall;
BYTE *jaw;
BYTE *eyes;
BYTE *head;
BYTE pal[768], pal2[768];
BYTE *vidBuf;
BYTE *image;
int sintab[256], costab[256];
long xscale[320], yscale[200];

void main()
{
    int hx, hy, jx, jy, ex, ey;
    int angle, blah;
    int i, j, k, a;
    int x1, y1, xt, yt, x, y, z;

    printf("\n\nThe Gaffer Experience\n");

    init();

    clear(vidBuf, 16000, 0);

    hx = 125; // 125
    hy = 210; // 57
    jx = 125;
    jy = 210;
    ex = 125;
    ey = 210;
    angle = -90;
    blah = 0;

    setpal(254, 8, 10, 30);
    setpal(255, 8, 10, 20);

    for (j = 0; j < 200; j++)
    for (i = 0; i < 320; i++)
    {
        k = (rand() % 2) + 254;

        image[i+(j*320)] = k;
    }

    flip(image, vidBuf);
    flip(vidBuf, vidMem);

    delay(2000);

    // pop up
    while (hy > 146)
    {
        flip(image, vidBuf);
        draweyes(ex, ey);
        draweyeless(hx, hy);
        hy--;
        ey--;
        jy--;
        wfr();
        flip(vidBuf, vidMem);
        clear(vidBuf, 16000, 0);
    }

    hy++;
    ey++;
    jy++;

    delay(450);

    // look left
    while (angle != -180)
    {
        flip(image, vidBuf);
        draweyes(ex, ey);
        draweyeless(hx, hy);
        ex = (3*cos(angle*PI/180)) + 125;
        ey = (1*sin(90*PI/180)) + 146;
        angle -= 2;
        wfr();
        flip(vidBuf, vidMem);
        clear(vidBuf, 16000, 0);
    }

    angle = -180;

    delay(450);

    // look right
    while (angle != 0)
    {
        flip(image, vidBuf);
        draweyes(ex, ey);
        draweyeless(hx, hy);
        ex = (3*cos(angle*PI/180)) + 125;
        ey = (1*sin(90*PI/180)) + 146;
        angle += 2;
        wfr();
        flip(vidBuf, vidMem);
        clear(vidBuf, 16000, 0);
    }

    delay(450);

    // look centre
    while (angle != -90)
    {
       flip(image, vidBuf);
        draweyes(ex, ey);
        draweyeless(hx, hy);
        ex = (3*cos(angle*PI/180)) + 125;
        ey = (1*sin(90*PI/180)) + 146;
        angle -= 2;
        wfr();
        flip(vidBuf, vidMem);
        clear(vidBuf, 16000, 0);
    }

    angle = -89;
    ex = 125;
    ey = 146;

    delay(450);
    // move up more
    while (hy > 57)
    {
        flip(image, vidBuf);
        draweyes(ex, ey);
        draweyeless(hx, hy);
        drawjaw(jx, jy-1);
        hy--;
        ey--;
        jy--;
        wfr();
        flip(vidBuf, vidMem);
        clear(vidBuf, 16000, 0);
    }

    hy = ey = jy = 57;
    x = 0;
    y = 0;
    blah = 0;

    angle = 1;

//    while (inp(0x60) != 1) {
      for (int bleh=0;bleh<550;bleh++) {

        flip(image, vidBuf);
        drawhead(hx+x, hy+y);
        drawjaw(jx+x, jy+y);

        jx = (1*cos(90*PI/180)) + 125;
        jy = (6*sin(angle*PI/180)) + 57;

        angle += 6;
        if (angle > 180) angle = angle-180;

        wfr();
        flip(vidBuf, vidMem);
        clear(vidBuf, 16000, 0);
    }

    int jigglex=0;
    int jiggley=0;
      for (bleh=0;bleh<100;bleh++) {
        clear(vidBuf, 16000, 0);

        flip(image, vidBuf);
        drawhead(hx+x+(jigglex-2), hy+y+jiggley);
        drawjaw(jx+x+(jigglex-2), jy+y+jiggley);

        jigglex=rand()%4;
        jiggley=rand()%4;
        jx = (1*cos(90*PI/180)) + 125;
        jy = (6*sin(angle*PI/180)) + 57;

        angle += 6;
        if (angle > 180) angle = angle-180;

        wfr();
        flip(vidBuf, vidMem);
    }


    for (i = 0; i < 256; i++) setpal(i, i >> 2, i >> 2, i >> 2);
        flip(vidBuf, image);


    delay(1200);

    for (bleh=0;bleh<300;bleh++) {

      for (int bloh=1;bloh<63999;bloh++) {
          vidBuf[bloh]=(image[bloh-1]+image[bloh+1])/2;
      }
      wfr();
      flip(vidBuf, vidMem);
      flip(vidBuf, image);

    }
    clear(image, 16384, 0);
    FILE *fp = fopen("texture.raw", "rb");
    fread(image, 1, 256*256, fp);
    fclose(fp);

    clear(vidBuf, 16000, 0);
    for (i = 0; i < 210; i++)
    for (j = 0; j < 90; j++)
    if (image[i+j*256]) vidBuf[i+(j*320)+55+(55*320)] = image[i+(j*256)];

    flip(vidBuf, vidMem);

    delay(1200);

    for (bleh=0;bleh<300;bleh++) {

      for (int bloh=1;bloh<63999;bloh++) {
          vidBuf[bloh]=(vidBuf[bloh-1]+vidBuf[bloh+1])/2;
//          vidBuf[bloh]=(vidBuf[bloh-1]+vidBuf[bloh+1])/2;
      }
      wfr();
      flip(vidBuf, vidMem);

    }

    deInit();
    printf("\nWe hope you enjoyed ");
    printf("\"The Gaffer Experience\"\n");
    printf("Code+gfx: Jestyr + Black Fox\n");
    printf("Sound: Black Fox\n");
    printf("Loss of sleep: Greater than necessary\n");
    printf("Unofficial award for most earned/needed sleep: Jestyr\n");
    printf("\nCoven98 blitzcompo (Theme: \"Gaffer\")\n");
    printf("\n\"No time for the in-out, love, we're just here to read the meter\"\n");


}

void drawhead(int x, int y)
{
    int i, j, k, a, b, c, d;

    if (x > 319) return;
    if (y > 199) return;
    if ((x + 74) < 0) return;
    if ((y + 92) < 0) return;

    a = 0;
    if (x < 0) a = -x;
    b = 0;
    if (y < 0) b = -y;
    c = 75;
    if ((x + 74) > 319) c = 320-x;
    d = 93;
    if ((y + 92) > 199) d = 200-y;

    for (j = b; j < d; j++)
    for (i = a; i < c; i++)
    {
         k = i+(j*75);
         if (headall[k]) vidBuf[(x+i)+((y+j)*320)] = headall[k];
    }
}

void drawjaw(int x, int y)
{
    int i, j, k, a, b, c, d;

    x += 13;
    y += 63;

    if (x > 319) return;
    if (y > 199) return;
    if ((x + 33) < 0) return;
    if ((y + 27) < 0) return;

    a = 0;
    if (x < 0) a = -x;
    b = 0;
    if (y < 0) b = -y;
    c = 34;
    if ((x + 33) > 319) c = 320-x;
    d = 28;
    if ((y + 27) > 199) d = 200-y;

    for (j = b; j < d; j++)
    for (i = a; i < c; i++)
    {
         k = i+(j*34);
         if (jaw[k]) vidBuf[(x+i)+((y+j)*320)] = jaw[k];
    }
}

void draweyeless(int x, int y)
{
    int i, j, k, a, b, c, d;

    if (x > 319) return;
    if (y > 199) return;
    if ((x + 74) < 0) return;
    if ((y + 92) < 0) return;

    a = 0;
    if (x < 0) a = -x;
    b = 0;
    if (y < 0) b = -y;
    c = 75;
    if ((x + 74) > 319) c = 320-x;
    d = 93;
    if ((y + 92) > 199) d = 200-y;

    for (j = b; j < d; j++)
    for (i = a; i < c; i++)
    {
         k = i+(j*75);
         if (head[k]) vidBuf[(x+i)+((y+j)*320)] = head[k];
    }
}

void draweyes(int x, int y)
{
    int i, j, k, a, b, c, d;

    x += 9;
    y += 32; //31

    if (x > 319) return;
    if (y > 199) return;
    if ((x + 52) < 0) return;
    if ((y + 26) < 0) return;

    a = 0;
    if (x < 0) a = -x;
    b = 0;
    if (y < 0) b = -y;
    c = 53;
    if ((x + 52) > 319) c = 320-x;
    d = 27;
    if ((y + 26) > 199) d = 200-y;

    for (j = b; j < d; j++)
    for (i = a; i < c; i++)
    {
         k = i+(j*53);
         if (eyes[k]) vidBuf[(x+i)+((y+j)*320)] = eyes[k];
    }
  }

void init()
{
    headall = (BYTE *)malloc(75*93);
    jaw = (BYTE *)malloc(34*28);
    vidBuf = (BYTE *)malloc(65536);
    head = (BYTE *)malloc(75*93);
    eyes = (BYTE *)malloc(53*27);
    image = (BYTE *)malloc(65536);
    buf1 = (BYTE *)malloc(64000);
    buf2 = (BYTE *)malloc(64000);

    if ((!headall) || (!jaw) || (!vidBuf) || (!head) || (!eyes) || (!image))
    {
        printf("  ** Unable to initialise The Experience!\n");
        printf("    -- Insufficient RAM\n");
        exit(1);
    }

    for (int i = 0; i < 256; i++)
    {
        sintab[i] = sin(i*PI/128)*20 + 65;
        costab[i] = cos(i*PI/128)*30 + 65;
    }

    // load appendages
    FILE *fp = fopen(GAFNOJAW, "rb");
    if (!fp)
    {
        printf("  ** Unable to initialise The Experience!\n");
        printf("    -- Could not load The Head\n");
        exit(1);
    }
    fread(headall, 1, 75*93, fp);
    fclose(fp);

    fp = fopen(GAFJAW, "rb");
    if (!fp)
    {
        printf("  ** Unable to initialise The Experience!\n");
        printf("    -- Could not load The Jaw\n");
        exit(1);
    }
    fread(jaw, 1, 34*28, fp);
    fclose(fp);

    fp = fopen(GAFPAL, "rb");
    if (!fp)
    {
        printf("  ** Unable to initialise The Experience!\n");
        printf("    -- Could not load palette file\n");
        exit(1);
    }
    fread(pal, 1, 768, fp);
    fclose(fp);

    fp = fopen(GAFNOEYE, "rb");
    if (!fp)
    {
        printf("  ** Unable to initialise The Experience!\n");
        printf("    -- Could not load The Eyeless Face\n");
        exit(1);
    }
    fread(head, 1, 75*93, fp);
    fclose(fp);

    fp = fopen(GAFEYE, "rb");
    if (!fp)
    {
        printf("  ** Unable to initialise The Experience!\n");
        printf("    -- Could not load The Eyes\n");
        exit(1);
    }
    fread(eyes, 1, 53*27, fp);
    fclose(fp);

    HardwareInit(_psp); // This must be the first function call !
    USS_Setup();

    music = XM_Load(LM_File, 0x020202020, MODULE);
//    USS_SetAmpli(400);      // sound amplification for mixed device

    setmode(0x13);

    USMP_StartPlay(music);
    outp(0x3c8, 0);
    for (i = 0; i < 768; i++) outp(0x3c9, pal[i] >> 2);
}

void deInit()
{
    USMP_StopPlay();
    USMP_FreeModule(music);

    setmode(0x03);
    free(headall);
    free(head);
    free(jaw);
    free(vidBuf);
    free(image);
    free(eyes);
}















