varying float frag_occlusion;
varying float light_influence;
uniform sampler2D tex_diffuse;
varying vec2 texcoord;

void main(void)
{
  vec3 diff = texture2D(tex_diffuse, texcoord.xy).rgb;
  vec3 light = (1.0 - frag_occlusion) * (light_influence * 0.5 + 0.5);
  light.b *= 0.3;

  gl_FragColor.a = 1.0;
  gl_FragColor.rgb = light * diff * 0.7;
  gl_FragColor.b *= 0.65;
}