from core.gl import *

#import pygame
#from pygame.locals import *

from core import *
from splash import Splash
from math import sqrt, pi, cos, sin


def drawFilledRing(innerradius, radius, x, y,  sides, start=0, end = pi):

    rot = start;
    deltar = end - start;

    r = deltar / sides;
    for i in xrange(sides):
    
        x0 = cos(rot + i * r) * innerradius + x 
        y0 = sin(rot + i * r) * innerradius + y
        x1 = cos(rot + i * r + r) * innerradius + x
        y1 = sin(rot + i * r + r) * innerradius + y
        x2 = cos(rot + i * r) * radius + x
        y2 = sin(rot + i * r) * radius + y
        x3 = cos(rot + i * r + r) * radius + x
        y3 = sin(rot + i * r + r) * radius + y

        glVertex2f(x0, y0)
        glVertex2f(x1, y1)
        glVertex2f(x3, y3)
        glVertex2f(x2, y2)


class Rainbow(Splash):

    def __init__(self, system):
        Splash.__init__(self, system)
        self.song = "lang huxley - pooping rainbows.ogg"

    def drawFrame(self, time, delta):

        time *= .7

        colors = [
            (.5, 0, .5),
            (0, 0, .5),
            (0, 0, 1),
            (0, 1, 0),
            (1, 1, 0),
            (1, .5, 0),
            (1, 0, 0)
            ]

        glBlendFunc(GL_SRC_ALPHA, GL_ONE)
        glEnable(GL_BLEND)
       

        glDisable(GL_DEPTH_TEST)
 
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(-1,1,-.75,.75,0.1,1000)
 
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)

        glEnable(GL_POLYGON_SMOOTH)
        glBegin(GL_QUADS)

        thickness = 0.025
#        if time > pi and time < pi + pi /4:
#            thickness += sin(time*4) * 0.01;

        radius = .4
        sides = 40


        start = 0
        end = min(time, pi)


        intensity0 = 1
        if time > pi + pi/2:
            intensity0 = max(0, 1.0 - (time-(pi + pi/2)))


        # draw stripes and reflection
        for i in xrange(7):
            color = colors[i]

            intensity = intensity0
            color = (color[0] * intensity, color[1] * intensity, color[2] * intensity)
            
            intensity = .25 + cos(time*2) * .05
            darkColor = (color[0] * intensity, color[1] * intensity, color[2] * intensity)
           
            glColor3f(*color)
            drawFilledRing(radius + i*thickness, radius + (i+1)*thickness, 0, 0 ,sides, start, end)
            #reflection
            glColor3f(*darkColor)
            drawFilledRing(radius + i*thickness, radius + (i+1)*thickness, 0, 0 ,sides, -start, -end)
        
        glColor3f(1,1,1)
        if time > pi+pi/8 and time < pi + pi*2 /8:
            a = sin((time - pi/8)*8)*2
            drawFilledRing(.01*a,.02*a, sqrt(2)*.275, sqrt(2)*.275, 10, 0, pi*2)
        glEnd()



        glDisable(GL_POLYGON_SMOOTH)
        

        glColor3f(0,0,0)
        glBegin(GL_LINES)


        for i in xrange(10):
            y = cos(cos(i*.49)*time*.315+i*10*.132)*.3 - .3
            glVertex2f(-1,y)
            glVertex2f(1,y)

        glEnd()
      
        glDisable(GL_BLEND)
