
uniform float hue;
uniform vec2 center;      // texture center, like (0.2132123, 0.5)
uniform sampler2D tex;   

uniform float xscale;

varying vec2 xy;   // -0.5 .. +0.5

const vec4 togray = vec4 (0.30, 0.45, 0.25, 0);
const vec3 sepia  = vec3 (1.2, 0.8, 0.4);

void main()
{
  vec4 col;
  vec2 uv;

/*
  float a = xy.x * 3.14159265358979;
  uv = vec2( abs(xy.y) * cos(a) , xy.y * sin(a) ); 
*/

  float a = atan( xy.y, xy.x );
  float r = length( xy);
  
  uv.y = xy.y;
  uv.x = abs(a) / 3.14159265358979;
  
  uv.x *= xscale;
  
  col =    texture2D ( tex, center + uv        );
  col +=   texture2D ( tex, center + uv * 0.66 ); 
//  col +=   texture2D ( tex, center + uv * 0.33 ); 

  col *= 0.7;

  gl_FragColor.rgb = mix ( sepia * dot(col,togray) , col.rgb , hue );

  return;
  
}


