float4x4 matProjection; 

float radius = 1.f;
float2 offset = (1.f/800.f, 1.f/450.f);


texture tex0; 
texture tex1; 

sampler2D base = sampler_state
{
	texture = (tex0);
	AddressU = Clamp; AddressV = Clamp;
	MagFilter = Linear; MinFilter = Linear; MipFilter = Linear;
};

sampler2D low = sampler_state
{
	texture = (tex1);
	AddressU = Clamp; AddressV = Clamp;
	MagFilter = Linear; MinFilter = Linear; MipFilter = Linear;
};

void vs_guassian(in float4 ipos : POSITION,
				 in float2 itex : TEXCOORD0,
				 out float4 opos : POSITION,
				 out float2 otex : TEXCOORD0,
				 out float2 rf : TEXCOORD1,
				 out float2 lf : TEXCOORD2,
				 out float2 otex2 : TEXCOORD2)
{
	opos = mul(ipos, matProjection);
	otex = itex;//+offset/2.f;
	offset*=radius;
	rf.x = otex.x+offset.x;
	rf.y = otex.y+offset.y;
	lf.x = otex.x-offset.x;
	lf.y = otex.y-offset.y;
}

float4 ps_blur(in float2 itex : TEXCOORD0,
				   in float2 rf : TEXCOORD1,
				   in float2 lf : TEXCOORD2,
				   in float2 itex2 : TEXCOORD3) : COLOR0
{ 
	float4 q = tex2D(base, itex);
	float4 p = tex2D(low, itex) + 
			   tex2D(low, float2(rf.x, itex.y)) + 
			   tex2D(low, float2(lf.x, itex.y)) +
			   tex2D(low, float2(itex.x, rf.y)) +
			   tex2D(low, float2(itex.x, lf.y)) +
			   tex2D(low, float2(lf.x, lf.y)) +
			   tex2D(low, float2(rf.x, lf.y)) + 
			   tex2D(low, float2(rf.x, rf.y)) +
			   tex2D(low, float2(lf.x, rf.y));
	//return p/9.f;
	return lerp(q, (p/9.f), clamp(pow(radius, 4.f), 0.f, 1.f)); 
}

void vs_glow(in float4 ipos : POSITION,
				 in float2 itex : TEXCOORD0,
				 out float4 opos : POSITION,
				 out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matProjection);
	otex = itex;//+offset/2.f;
}

void vs_glow_op(in float4 ipos : POSITION,
				 in float2 itex : TEXCOORD0,
				 out float4 opos : POSITION,
				 out float2 otex : TEXCOORD0,
				 out float2 otex2 : TEXCOORD1)
{
	opos = mul(ipos, matProjection);
	otex = itex;//+offset/2.f;
	otex2 = itex;
	otex2.y = 1.f-otex.y;
}

float4 ps_glow(in float2 itex : TEXCOORD0) : COLOR0
{ 
	float4 q = tex2D(base, itex);
	float4 p = tex2D(low, itex);
	return saturate(q+ (p*radius));
}

float4 ps_glow_op(in float2 itex : TEXCOORD0,
				  in float2 itex2 : TEXCOORD1) : COLOR0
{ 
	float4 q = tex2D(base, itex2);
	float4 p = tex2D(low, itex); //upsidedown
	return saturate(q+ (p*radius));
}

technique guassian
{
	pass blur
	{
		vertexshader = compile vs_2_0 vs_guassian();
		pixelshader  = compile ps_2_0 ps_blur();
	}

	pass glow
	{
		vertexshader = compile vs_2_0 vs_glow();
		pixelshader  = compile ps_2_0 ps_glow();
	}

	pass blurglow
	{
		vertexshader = compile vs_2_0 vs_glow_op();
		pixelshader  = compile ps_2_0 ps_glow_op();
	}
}
