/*
 * Decompiled with CFR 0.152.
 */
package k2dp;

import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;
import k2dp.Effect3D;
import k2dp.MiniFontPlotter;
import k2dp.PyramidModel;

public class Pyramid
implements Effect3D {
    World world;
    Mesh pyramid1;
    Camera cam;
    Transform pyrTx = new Transform();
    Transform camTx = new Transform();
    int rSize = 5;
    Mesh[] meshes = new Mesh[999];
    int[] palette = new int[256];
    MiniFontPlotter miniFont;
    Background bg = new Background();
    float rot1 = 0.0f;
    float rot2 = 0.0f;
    Random rnd = new Random(47298L);
    float crx = 0.0f;
    float cry = 0.0f;
    float crz = 0.0f;
    float rot = 0.0f;
    float accel = 0.0f;
    int steps = 0;
    int colStart = 0;
    Transform tx = new Transform();
    int r;
    int g;
    int b;
    int color2;
    static /* synthetic */ Class class$0;

    public Pyramid(int width, int height, MiniFontPlotter miniFont) throws Exception {
        this.miniFont = miniFont;
        this.world = PyramidModel.getRoot();
        this.pyramid1 = PyramidModel.createPyramid1();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("k2dp.Pyramid");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Image img = Image.createImage((InputStream)clazz.getResourceAsStream("/palette.png"));
        img.getRGB(this.palette, 0, 1, 0, 0, 1, 256);
        this.cam = new Camera();
        this.cam.setPerspective(60.0f, (float)width / (float)height, 0.1f, 100.0f);
        this.world.addChild((Node)this.cam);
        this.world.setActiveCamera(this.cam);
        this.initTransform();
        this.pushCam();
    }

    private void moveCam() {
        this.rot1 = (float)((double)this.rot1 - 1.3);
        this.rot2 = (float)((double)this.rot2 + 1.2);
        if (this.steps > 0) {
            --this.steps;
        } else {
            this.pushCam();
        }
        this.camTx.postRotate(this.rot, this.crx, this.cry, this.crz);
        this.rot -= this.accel;
        this.colStart = (this.colStart + 1) % 256;
    }

    private void initTransform() {
        int count = 0;
        int x = -5;
        while (x < 5) {
            int y = -5;
            while (y < 5) {
                int z = -5;
                while (z < 5) {
                    if (x != 0 || y != 0 || z != 0) {
                        Mesh m = new Mesh(this.pyramid1.getVertexBuffer(), this.pyramid1.getIndexBuffer(0), this.pyramid1.getAppearance(0));
                        Transform tx = new Transform();
                        tx.setIdentity();
                        tx.postTranslate((float)x * 2.0f, (float)y * 2.0f, (float)z * 2.0f);
                        tx.postRotate(this.rot1, 0.0f, 1.0f, 0.0f);
                        m.setTransform(tx);
                        this.world.addChild((Node)m);
                        this.meshes[count++] = m;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private void rotTransform() {
        int count = 0;
        int cidx = this.colStart;
        int x = -5;
        while (x < 5) {
            int y = -5;
            while (y < 5) {
                int z = -5;
                while (z < 5) {
                    int color = this.palette[cidx];
                    cidx = (cidx + 1) % 256;
                    if (x != 0 || y != 0 || z != 0) {
                        Mesh m = this.meshes[count++];
                        m.getAppearance(0).getMaterial().setColor(2048, color);
                        m.getTransform(this.tx);
                        this.tx.setIdentity();
                        this.tx.postTranslate((float)x * 2.0f, (float)y * 2.0f, (float)z * 2.0f);
                        this.tx.postRotate(this.rot1, 0.0f, 1.0f, 0.0f);
                        m.setTransform(this.tx);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private void rotTransform2() {
        boolean count = false;
        int cidx = this.colStart;
        int color = this.palette[cidx];
        cidx = (cidx + 3) % 256;
        Mesh m = this.meshes[0];
        m.getAppearance(0).getMaterial().setColor(2048, color);
    }

    private void pushCam() {
        this.crx = this.rnd.nextFloat() - 0.5f;
        this.cry = this.rnd.nextFloat() - 0.5f;
        this.crz = this.rnd.nextFloat() - 0.5f;
        this.steps = this.rnd.nextInt(50) + 50;
        this.accel = 0.03f + this.rnd.nextFloat() * 0.01f;
        this.rot = this.rnd.nextFloat() * 4.0f + 0.5f;
    }

    public void paint(Graphics3D g3d) {
        this.moveCam();
        this.cam.setTransform(this.camTx);
        this.world.setActiveCamera(this.cam);
        this.rotTransform2();
        g3d.render(this.world);
    }

    public void paint2D(Graphics g) {
        this.miniFont.paint2D(g);
    }

    public void setEffect(int type) {
        switch (type) {
            case 5: {
                this.pushCam();
            }
        }
    }
}

