Type
  Vertex = Record
    x, y, z : Longint;
  End;
  VertexList = Array[0..1000] of Vertex;
  PVertexList = ^VertexList;
  Point = Record
    x, y : Integer;
  End;
  PointList = Array[0..1000] of Point;
  PPointList = ^PointList;
  LineDef = Record
    From, Too : Integer;
  End;
  LineList = Array[0..1000] of LineDef;
  PLineList = ^LineList;
  VecRec = Record
    LocalCoords : PVertexList;
    Lines : PLineList;
    NumVerticies : Integer;
    NumLines : Integer;
  End;

Var
  NumVerticies, NumLines : Integer;
  LocalCoords, WorldCoords : PVertexList;
  ScreenCoords : PPointList;
  LineDefs : PLineList;
  Vectors : Array[0..3] of VecRec;

Procedure LoadVectors(FileName : String);
{ load the vector objects }

Var
  Diskfile : File;
  Count, Count2 : Integer;
  MaxVert : Integer;
  DOSEOF : Longint;

Begin
  MaxVert := 0;
  Assign(Diskfile, Filename);
  Reset(Diskfile, 1);
  For Count := 0 to 3 do
    Begin
      BlockRead(Diskfile, Vectors[Count].NumVerticies, 2);
      BlockRead(Diskfile, Vectors[Count].NumLines, 2);
      If Vectors[Count].NumVerticies > MaxVert
        Then MaxVert := Vectors[Count].NumVerticies;
      GetMem(Vectors[Count].LocalCoords, Vectors[Count].NumVerticies * 12);
      GetMem(Vectors[Count].Lines, Vectors[Count].NumLines * 4);
      BlockRead(Diskfile, Vectors[Count].LocalCoords^, Vectors[Count].NumVerticies * 12);
      BlockRead(Diskfile, Vectors[Count].Lines^, Vectors[Count].NumLines* 4);
    End;
  Close(Diskfile);
  GetMem(WorldCoords, 12 * MaxVert);
  GetMem(ScreenCoords, 4 * MaxVert);
End;

Function LoadVectorObject(FileName : String) : Boolean;

Var
  Diskfile : File;
  ReadIn : Word;

Begin
  Assign(Diskfile, FileName);
  {$I-}
  Reset(Diskfile, 1);
  {$I-}
  If IOResult <> 0
    Then Begin
      LoadVectorObject := False;
      Exit;
    End;
  BlockRead(Diskfile, NumVerticies, Sizeof(NumVerticies), ReadIn);
  If ReadIn <> Sizeof(NumVerticies)
    Then Begin
      LoadVectorObject := False;
      Exit;
    End;
  BlockRead(Diskfile, NumLines, Sizeof(NumLines), ReadIn);
  If ReadIn <> Sizeof(NumLines)
    Then Begin
      LoadVectorObject := False;
      Exit;
    End;
  GetMem(LocalCoords, NumVerticies * Sizeof(Vertex));
  GetMem(WorldCoords, NumVerticies * Sizeof(Vertex));
  GetMem(ScreenCoords, NumVerticies * Sizeof(Point));
  GetMem(LineDefs, NumLines * Sizeof(LineDef));
  BlockRead(Diskfile, LocalCoords^, NumVerticies * Sizeof(Vertex), Readin);
  If ReadIn < (NumVerticies * Sizeof(Vertex))
    Then Begin
      LoadVectorObject := False;
      Exit;
    End;
  BlockRead(Diskfile, LineDefs^, NumLines * Sizeof(LineDef), Readin);
  If ReadIn < (NumLines * Sizeof(LineDef))
    Then Begin
      LoadVectorObject := False;
      Exit;
    End;
  Close(Diskfile);
  LoadVectorObject := True;
End;