{ TEXTRO     OTM/95               }
{ Source code to textmode vectors }
{ coded by Phred/OTM              }
{ email: achalfin@uceng.uc.edu    }


{$M 38000,0,655360}
{$R-,S-}
Uses Crt;

Var
  CharCount : Integer;

{$G+}
{$F+}
{$L Matrix.Obj}
Procedure InitRotationMatrix(X, Y, Z : Integer); External;
Procedure Rotate(Var Local, World; NumPoints : Word; Xt, Yt, Zt : Longint); External;

{$L Project.Obj}
Procedure Project2d(Var World, Screen; NumPoints : Word); External;
{$F-}


Procedure TextVectors;

{$I Vector.Inc}
{$I Textrix.Inc}

Procedure Fill386(Var Dest; Amount : Word); Assembler;
{ does a dword fill. Does not fill extra bytes }

Asm
  Les  di,Dest
  Mov  cx,Amount
  Shr  cx,2
  db 66h; Xor  ax,ax
  db 66h; Rep  Stosw
End;

Procedure DoVector(Num : Integer);
{ does a vector animation }


Var
  Xa, Ya, Za : Integer;
  Count, Count2 : Integer;
  Frame : Integer;
  Pixel : Boolean;
  MaxDist : Integer;

Begin
  Xa := 0;
  Ya := 0;
  Za := 0;
  Case Num of
    0 : MaxDist := 260;
    1 : MaxDist := 300;
    2 : MaxDist := 350;
    3 : MaxDist := 350;
  End;
  If Num = 1
    Then Pixel := True
    Else Pixel := False;
  For Count := 63 downto 0 do
    Begin
      SetRGB($03, 63-Count, 0, 63-Count);
      SetRGB($0a, 63-Count, 0, 63-Count);

      CharCount := 0;
      Fill386(CharSet, Sizeof(CharSet));
      Fill386(Buffer, 80*25*2);
      InitRotationMatrix(Xa, Ya, Za);
      Rotate(Vectors[Num].LocalCoords^, WorldCoords^, Vectors[Num].NumVerticies, 0, 0, MaxDist+Count*3);
      Project2d(WorldCoords^, ScreenCoords^, Vectors[Num].NumVerticies);
      If Pixel
        Then Begin
          For Count2 := 0 to (Vectors[Num].NumVerticies - 1) do
            PutPixel(ScreenCoords^[Count2].x, ScreenCoords^[Count2].y);
        End
        Else Begin
          For Count2 := 0 to (Vectors[Num].NumLines - 1) do
            Begin
              With Vectors[Num].Lines^[Count2] do
                Line(ScreenCoords^[From].x, ScreenCoords^[From].y,
                    ScreenCoords^[Too].x, ScreenCoords^[Too].y, Buffer, CharSet);
            End;
        End;
      VSync;
      SetCharSet(CharSet[0], CharSet[256], 6, 7);
      Copy386(Buffer, Mem[$B800:0], 80*25*2);
      Xa := (Xa + 1) And 511;
      Ya := (Ya + 2) And 511;
      Za := (Za + 4) And 511;
    End;
  Frame := 0;
  Repeat
    CharCount := 0;
    Fill386(CharSet, Sizeof(CharSet));
    Fill386(Buffer, 80*25*2);
    InitRotationMatrix(Xa, Ya, Za);
    Rotate(Vectors[Num].LocalCoords^, WorldCoords^, Vectors[Num].NumVerticies, 0, 0, MaxDist+Count*3);
    Project2d(WorldCoords^, ScreenCoords^, Vectors[Num].NumVerticies);
    If Pixel
        Then Begin
          For Count2 := 0 to (Vectors[Num].NumVerticies - 1) do
            PutPixel(ScreenCoords^[Count2].x, ScreenCoords^[Count2].y);
        End
        Else Begin
          For Count2 := 0 to (Vectors[Num].NumLines - 1) do
            Begin
              With Vectors[Num].Lines^[Count2] do
                Line(ScreenCoords^[From].x, ScreenCoords^[From].y,
                    ScreenCoords^[Too].x, ScreenCoords^[Too].y, Buffer, CharSet);
            End;
        End;
    VSync;
    SetCharSet(CharSet[0], CharSet[256], 6, 7);
    Copy386(Buffer, Mem[$B800:0], 80*25*2);
    Xa := (Xa + 1) And 511;
    Ya := (Ya + 2) And 511;
    Za := (Za + 4) And 511;
    Frame := Frame + 1;
  Until Frame = 400;     { Do 400 Frames }
  For Count := 0 to 63 do
    Begin
      SetRGB($03, 63-Count, 0, 63-Count);
      SetRGB($0a, 63-Count, 0, 63-Count);

      CharCount := 0;
      Fill386(CharSet, Sizeof(CharSet));
      Fill386(Buffer, 80*25*2);
      InitRotationMatrix(Xa, Ya, Za);
      Rotate(Vectors[Num].LocalCoords^, WorldCoords^, Vectors[Num].NumVerticies, 0, 0, MaxDist+Count*3);
      Project2d(WorldCoords^, ScreenCoords^, Vectors[Num].NumVerticies);
      If Pixel
        Then Begin
          For Count2 := 0 to (Vectors[Num].NumVerticies - 1) do
            PutPixel(ScreenCoords^[Count2].x, ScreenCoords^[Count2].y);
        End
        Else Begin
          For Count2 := 0 to (Vectors[Num].NumLines - 1) do
            Begin
              With Vectors[Num].Lines^[Count2] do
                Line(ScreenCoords^[From].x, ScreenCoords^[From].y,
                    ScreenCoords^[Too].x, ScreenCoords^[Too].y, Buffer, CharSet);
            End;
        End;
      VSync;
      SetCharSet(CharSet[0], CharSet[256], 6, 7);
      Copy386(Buffer, Mem[$B800:0], 80*25*2);
      Xa := (Xa + 1) And 511;
      Ya := (Ya + 2) And 511;
      Za := (Za + 4) And 511;
    End;

End;

Var
  Count : Integer;
  Palette : Array[0..767] of Byte;

Begin
  Port[$3c7] := 0;
  For Count := 0 to 767 do
    Palette[Count] := Port[$3c9];
  LoadVectors('Vector.Dat');
  Set400TextMode;    { Set 400 Scan Lines }
  SetCharWidth(8);   { Set 8-bit Char width }
  SelectCharMap(6, 7);  { Use Character Maps 6 and 7 }

  For Count := 0 to 3 do
    DoVector(Count);

  SelectCharMap(0, 0);   { Return to the origional character map }
  SetCharWidth(9);       { Return to 9-bit textmode }
  Port[$3c8] := 0;
  For Count := 0 to 767 do
    Port[$3c9] := Palette[Count];
  For Count := 0 to 80*25-1 do
    Mem[$B800:Count*2+1] := 7;
End;


Begin
  TextVectors;
End.