unit types;
interface
const maxItems = 255;                   { max items per menu }
      MAXMENUS = 255;                   { max number of menus}
      progName = 'eBUILD';              { program name (duh) }
      progVer = '1.7';                 { program version }
      progSize = 26704;                 { size of the executeable }
                                        { need to store file name data }

(* item format *)
type itemHeader = record
   start,                               { where in file to start reading }
   stop : longint;                      { where in file to stop reading }
   hi,                                  { the hilighted option string }
   lo,                                  { the normal option string }
   author,                              { the authors name }
   title : string[80];                  { the title of the item }
   fade,                                { should we fade the screen? }
   autoScroll ,                         { should we auto scroll? }
   showHeader : boolean;                { should we show the header }
   id,                                  { article id number }
   action,                              { what does this item do? }
   x,                                   { x location for the option }
   y : byte;                            { y location for the option }
end;

(* header format *)
type headerHeader = record
   start,
   stop : longInt;
   line,
   authorX,
   authorY,
   titleX,
   titleY,
   percentX,
   percentY,
   percentLen : byte;
   percentHi,
   percentLo : string[10];
end;

(* menu format *)
type menuHeader = record
   id,
   fallback,
   count : byte;
   start,
   stop : longint;
   fade : boolean;
   articles : array[1..maxItems] of ^itemHeader;
end;

(* system format *)
type sysRec = record
   doSlice,
   hiColor,
   cycle,
   doCursor : boolean;
   fadedelay,
   scrolldelay : byte;
   name,
   issue : string[40];
end;

(* the overall format *)
type magHeader = record
   system : sysRec;
   introHeader,
   exitHeader : itemHeader;
   header : headerHeader;
   menus : byte;
end;

(* filename list format *)
type fileNames = record
    name : array[1..maxItems] of ^string;
end;

implementation
end.
