;Player-testcode

;start = 10	;Starting position

fade  = 0	;0 = normal
		;1 = use master volume

CIA = 1		;0 = disabled
		;1 = enabled

system = 1	;0 = killer
		;1 = friendly

channels = 4	;amount of channels to be played

use = -1 	;The Usecode


	include Player.i

	section	Player5.0A,code

	movem.l	d0-a6,-(sp)
	lea	$dff000,a6
	ifeq	system
	move	$1c(a6),-(sp)
	move	#$7fff,$9a(a6)
	move	#$e000,$9a(a6)
	move	2(a6),-(sp)
	move	#$7ff,$96(a6)
	endc

	lea	P50_data,a0
	sub.l	a1,a1
	moveq	#0,d0		;Auto Detect
	bsr	P50_motuuli+P50_InitOffset
	tst	d0
	bne	P50_exit

P50_sync
	ifeq	CIA
	move.l	4(a6),d0
	andi.l	#$1ff00,d0
	cmp.l	#$8100,d0
	bne.b	P50_sync

P50_sync2
	move.l	4(a6),d0
	andi.l	#$1ff00,d0
	cmp.l	#$8200,d0
	bne.b	P50_sync2

	move	#$fff,$180(a6)
	bsr	P50_motuuli+P50_MusicOffset
	clr	$180(a6)

	moveq	#0,d0
	move	6(a6),d0
	sub.l	#$8200,d0
	cmp.l	P50_raster(pc),d0
	ble.b	P50_kosj
	move	d0,P50_raster+2
P50_kosj
	tst	P50_raster2+2
	bne.b	P50_doing
	move	d0,P50_raster2+2
	bra.b	P50_doneg
P50_doing
	add.l	P50_raster2(pc),d0
	asr.l	#1,d0
	move.l	d0,P50_raster2
P50_doneg
	addq.l	#1,P50_frames

	ifne	fade
	btst	#10,$16(a6)
	bne.b	P50_jid
	move	P50_diri(pc),d0
	sub	d0,P50_motuuli+P50_MasterVolume
	bne.b	P50_judo
	neg	P50_diri
	bra.b	P50_jid
P50_judo
	cmp	#64,P50_motuuli+P50_MasterVolume
	bne.b	P50_jid
	neg	P50_diri
	endc

P50_jid
	endc

	btst	#6,$bfe001
	bne	P50_sync

P50_exit
	bsr	P50_motuuli+P50_EndOffset

	ifeq	system
	move	(sp)+,d7
	bset	#15,d7
	move	#$7ff,$96(a6)
	move	d7,$96(a6)

	move	(sp)+,d7
	bset	#15,d7
	move	#$7fff,$9a(a6)
	move	d7,$9a(a6)
	endc
	movem.l	(sp)+,d0-a6

	movem.l	P50_raster(pc),d0-d2
	move.l	P50_positionbase(pc),a0
	move.l	P50_patternbase(pc),a1
	move.l	P50_spos(pc),a2
	rts

P50_IRQsave	dc	0
P50_DMAsave	dc	0
P50_raster	dc.l	0
P50_raster2	dc.l	0
P50_frames	dc.l	0
P50_diri	dc	1

*********************************
*        Player v5.0A 		*
*      All in one-version	*
*     MC68000/68010-version	*
*        Version 503.1		*
*     1992 Jarno Paananen	*
*     All rights reserved	*
*********************************


******** START OF BINARY FILE **************

P50_motuuli
	bra	P50_Init
	ifeq	CIA
	bra	P50_Music
	else
	rts
	rts
	endc
	bra	P50_End
	rts				;no P50_SetRepeat
	rts

P50_master	dc	64		;Master volume (0-64)
P50_Tempo	dc	1		;Use tempo? 0=no,non 0=yes
P50_play	dc	1		;Stop flag (0=stop)

P50_Temp0Offset
	dc.l	P50_temp0-P50_motuuli
P50_Temp1Offset
	dc.l	P50_temp1-P50_motuuli
P50_Temp2Offset
	dc.l	P50_temp2-P50_motuuli
P50_Temp3Offset
	dc.l	P50_temp3-P50_motuuli

P50_getnote	macro
	moveq	#$7e,d0
	and.b	(a5),d0
	beq.b	.nonote\@
	ifne	P50_vib
	clr.b	P50_VibPos(a5)
	endc

	ifne	P50_ft
	add	P50_Fine(a5),d0
	endc
	move	d0,P50_Note(a5)
	move	(a2,d0),P50_Period(a5)

.nonote\@
	endm

	ifne	CIA

	ifeq	system
P50_intti
	movem.l	d0-a6,-(sp)
	tst.b	$bfdd00
	move.b	#$7e,$bfdd00

	lea	$dff000,a6
;	move	#$fff,$180(a6)
	bsr	P50_Music
;	move	#0,$180(a6)
	move	#$2000,$9c(a6)
	movem.l	(sp)+,d0-a6
	rte

	else
P50_lev6server
	movem.l	d2-d7/a2-a6,-(sp)
	lea	$dff000,a6
	lea	P50_cn(pc),a3
	move	P50_server(pc),d0
	bne.b	P50_eieka
	pea	P50_ohi(pc)
	bra	P50_Music
P50_eieka
	subq	#1,d0
	beq	P50_dmason
	bra	P50_setrepeat
P50_ohi	movem.l	(sp)+,d2-d7/a2-a6
	moveq	#1,d0
	rts
	endc
	endc

;
; Call P50_Init to initialize the playroutine	
; D0 --> Timer detection (for CIA-version)	
; A0 --> Address to the module			
; A1 --> Address to samples/0			
; A6 --> Customchip baseaddress ($DFF000)	
; D0 <-- 0 if succeeded			
; 		Uses A0-A5/D0-D6		
;


P50_Init
	cmp.l	#"P50A",(a0)+
	beq.b	.modok
	subq.l	#4,a0

.modok	basereg	P50_cn,a3
	lea	P50_cn(pc),a3

	ifne	CIA
	move	d0,-(sp)
	endc

	move.l	a1,d0
	bne.b	.redirect

	moveq	#0,d0
	move	(a0),d0
	lea	(a0,d0.l),a1
.redirect
	lea	4(a0),a2
	lea	P50_Samples(pc),a4
	moveq	#0,d1
	move.b	3(a0),d1
	subq	#1,d1
	moveq	#0,d4
P50_lopos
	move.l	a1,(a4)+
	move	(a2)+,d4
	bpl.b	P50_kook
	neg	d4
	asl	#4,d4
	lea	P50_Samples-16(pc),a5
	move.l	(a5,d4),d6
	move.l	d6,-4(a4)
	move	4(a5,d4),d4
	sub.l	d4,a1
	sub.l	d4,a1
	bra.b	P50_jatk

P50_kook
	move.l	a1,d6
P50_jatk
	move	d4,(a4)+
	moveq	#0,d2
	move.b	(a2)+,d2
	moveq	#0,d3
	move.b	(a2)+,d3
	moveq	#0,d0
	move	(a2)+,d0
	bmi.b	.norepeat

	move	d4,d5
	sub	d0,d5
	add.l	d0,d0
	move.l	d6,a5
	lea	(a5,d0.l),a5
	move.l	a5,(a4)+
	move	d5,(a4)+
	bra.b	P50_gene
.norepeat
	move.l	d6,(a4)+
	move	#1,(a4)+
P50_gene
	move	d3,(a4)+
	mulu	#74,d2
	move	d2,(a4)+
	add.l	d4,a1
	add.l	d4,a1
	dbf	d1,P50_lopos

	lea	P50_temp0(pc),a1
	lea	P50_temp1(pc),a2
	lea	P50_temp2(pc),a4
	lea	P50_temp3(pc),a5
	moveq	#Channel_Block_SIZE/2-2,d0
	moveq	#0,d1
.cl	move	d1,(a1)+
	move	d1,(a2)+
	move	d1,(a4)+
	move	d1,(a5)+
	dbf	d0,.cl

	moveq	#0,d0
	move.b	3(a0),d0
	mulu	#6,d0
	lea	4(a0,d0.l),a1
	move.l	a1,P50_positionbase(a3)

	move.b	2(a0),d1
	lsl	#3,d1
	lea	(a1,d1.l),a4
	move.l	a4,P50_possibase(a3)

	move.l	a4,a2
	moveq	#-1,d0
.search	cmp.b	(a2)+,d0
	bne.b	.search
	move.l	a2,P50_patternbase(a3)	

	ifd	start
	lea	start(a4),a4
	endc

	moveq	#0,d0
	move.b	(a4)+,d0
	move.l	a4,P50_spos(a3)
	lsl	#2,d0
	add.l	d0,a1

	move.l	a2,a4
	moveq	#0,d0	
	move	(a1)+,d0
	lea	(a4,d0.l),a2
	move.l	a2,P50_ChaPos+P50_temp0(a3)
	move	(a1)+,d0
	lea	(a4,d0.l),a2
	move.l	a2,P50_ChaPos+P50_temp1(a3)
	move	(a1)+,d0
	lea	(a4,d0.l),a2
	move.l	a2,P50_ChaPos+P50_temp2(a3)
	move	(a1)+,d0
	lea	(a4,d0.l),a2
	move.l	a2,P50_ChaPos+P50_temp3(a3)

	lea	P50_setrepeat(pc),a0
	move.l	a0,P50_intaddr(a3)

	move	#63,P50_rowpos(a3)
	move	#6,P50_speed(a3)
	move	#5,P50_speed2(a3)
	clr	P50_speedis1(a3)

	ifne	P50_pl
	clr	P50_plflag(a3)
	clr	P50_plcount(a3)
	endc

	ifne	P50_pde
	clr	P50_pdelay(a3)
	endc
	clr	(a3)

	bset	#1,$bfe001

	ifeq	system
	move.l	4.w,a6
	moveq	#0,d0
	btst	d0,297(a6)
	beq.b	.no68010

	lea	P50_liko(pc),a5
	jsr	-$1e(a6)

.no68010
	move.l	d0,P50_vektori(a3)
	move.l	d0,a0
	move.l	$78(a0),P50_oldlev6(a3)
	endc

	moveq	#0,d0
	lea	$dff000,a6
	move	d0,$a8(a6)
	move	d0,$b8(a6)
	move	d0,$c8(a6)
	move	d0,$d8(a6)
	move	#$f,$96(a6)

	ifeq	system
	move	#$2000,$9a(a6)
	lea	$bfd000,a0
	move.b	#$7f,$d00(a0)
	move.b	#8,$e00(a0)
	endc

	ifeq	CIA
	move.b	#$4a,$400(a0)
	move.b	#1,$500(a0)
.wati
	btst	d0,$d00(a0)
	beq.b	.wati
	move.b	#$81,$d00(a0)
	move	#$e000,$9a(a6)
	endc

	ifne	CIA
	move	(sp)+,d0
	subq	#1,d0
	beq.b	P50_ForcePAL
	subq	#1,d0
	beq.b	P50_NTSC
	move.l	4.w,a1
	cmp.b	#60,$212(a1)	;VBlankFrequency
	beq.b	P50_NTSC
P50_ForcePAL
	move.l	#1773447,d0	;PAL
	bra.b	P50_setcia
P50_NTSC
	move.l	#1789773,d0	;NTSC
P50_setcia
	move.l	d0,P50_timer(a3)
	divu	#125,d0
	move	d0,P50_thi2(a3)
	sub	#$1c8*2,d0
	move	d0,P50_thi(a3)

	ifeq	system
	move.b	d0,$400(a0)
	lsr	#8,d0
	move.b	d0,$500(a0)

	lea	P50_intti(pc),a1
	move.l	a1,P50_tintti(a3)
	move.l	P50_vektori(pc),a2
	move.l	a1,$78(a2)

	move.b	#$81,$d00(a0)
	move.b	#$19,$e00(a0)
	moveq	#0,d0
	endc
	endc

	ifeq	system
	move	#$e000,$9a(a6)
	rts

P50_liko
	dc.l	$4E7A0801		;MOVEC	VBR,d0
	rte
	endc

	ifne	system
	move.l	4.w,a6
	moveq	#-1,d0
	jsr	-$14a(a6)
	move.b	d0,P50_sigbit(a3)
	bmi	P50_err

	lea	P50_allocport(pc),a1
	move.l	a1,P50_portti(a3)
	move.b	d0,15(a1)
	move.l	a1,-(sp)
	suba.l	a1,a1
	jsr	-$126(a6)
	move.l	(sp)+,a1
	move.l	d0,16(a1)
	lea	P50_reqlist(pc),a0
	move.l	a0,(a0)
	addq.l	#4,(a0)
	clr.l	4(a0)
	move.l	a0,8(a0)

	lea	P50_dat(pc),a1
	move.l	a1,P50_reqdata(a3)
	lea	P50_allocreq(pc),a1
	lea	P50_audiodev(pc),a0
	moveq	#0,d0
	moveq	#0,d1
	move.l	4.w,a6
	jsr	-$1bc(a6)
	tst.b	d0
	bne	P50_err
	st.b	P50_audioopen(a3)

	lea	P50_timerint(pc),a1
	move.l	a1,P50_timerdata(a3)
	lea	P50_lev6server(pc),a1
	move.l	a1,P50_timerdata+8(a3)

	moveq	#8,d3
	lea	P50_cianame(pc),a1
	move.b	#'b',3(a1)
P50_openciares
	moveq	#0,d0
	jsr	-$1f2(a6)
	move.l	d0,P50_ciares(a3)
	beq.b	P50_tryCIAA
	move.l	d0,a6
	lea	P50_timerinterrupt(pc),a1
	moveq	#0,d0
	jsr	-6(a6)
	tst.l	d0
	beq.b	P50_gottimer
	addq.l	#4,d3
	lea	P50_timerinterrupt(pc),a1
	moveq	#1,d0
	jsr	-6(a6)
	tst.l	d0
	beq.b	P50_gottimer
P50_tryCIAA
	lea	P50_cianame(pc),a1
	cmp.b	#'b',3(a1)
	bne.b	P50_err
	subq.b	#1,3(a1)
	moveq	#0,d3
	bra	P50_openciares

P50_gottimer
	lea	P50_craddr+8(pc),a6
	move.l	P50_ciaaddr(pc,d3),d0
	move.l	d0,(a6)
	sub	#$100,d0
	move.l	d0,-(a6)
	moveq	#2,d3
	btst	#9,d0
	bne.b	P50_timerB
	subq.b	#1,d3
	add	#$100,d0
P50_timerB
	add	#$900,d0
	move.l	d0,-(a6)
	move.l	d0,a0
	and.b	#%10000000,(a0)
	move.b	d3,P50_timeropen(a3)
	moveq	#0,d0

	move.l	P50_craddr+4(pc),a1
	move.b	P50_tlo(pc),(a1)
	move.b	P50_thi(pc),$100(a1)
	or.b	#$19,(a0)
	rts

P50_err	moveq	#-1,d0
	rts

P50_ciaaddr
	dc.l	$bfe501,$bfe701,$bfd500,$bfd700
	endc

;
;     	Call P50_End to stop the music		
;   A6 --> Customchip baseaddress ($DFF000)	
;		  Uses D0/A0			
;
	
P50_End	moveq	#0,d0
	move	d0,$a8(a6)
	move	d0,$b8(a6)
	move	d0,$c8(a6)
	move	d0,$d8(a6)
	bclr	#1,$bfe001
	move	#$f,$96(a6)

	ifeq	system
	move	#$2000,$9a(a6)
	move.l	P50_vektori(pc),a0
	move.l	P50_oldlev6(pc),$78(a0)

	else
	lea	P50_cn(pc),a3
	moveq	#0,d0
	move.b	P50_timeropen(pc),d0
	beq.b	P50_rem1
	move.l	P50_ciares(pc),a6
	lea	P50_timerinterrupt(pc),a1
	subq.b	#1,d0
	jsr	-$c(a6)
P50_rem1
	move.l	4.w,a6
	tst.b	P50_audioopen(a3)
	beq.b	P50_rem2
	lea	P50_allocreq(a3),a1
	jsr	-$1c2(a6)
	clr.b	P50_audioopen(a3)
P50_rem2
	moveq	#0,d0
	move.b	P50_sigbit(pc),d0
	bmi.b	P50_rem3
	jsr	-$150(a6)
	st	P50_sigbit(a3)
P50_rem3
	endc
	rts

	ifne	fade
P50_mfade
	move	P50_master(pc),d0
	move	P50_temp0+P50_Shadow(pc),d1
	mulu	d0,d1
	lsr	#6,d1
	move	d1,$a8(a6)

	ifgt	channels-1
	move	P50_temp1+P50_Shadow(pc),d1
	mulu	d0,d1
	lsr	#6,d1
	move	d1,$b8(a6)
	endc

	ifgt	channels-2
	move	P50_temp2+P50_Shadow(pc),d1
	mulu	d0,d1
	lsr	#6,d1
	move	d1,$c8(a6)
	endc

	ifgt	channels-3
	move	P50_temp3+P50_Shadow(pc),d1
	mulu	d0,d1
	lsr	#6,d1
	move	d1,$d8(a6)
	endc
	rts
	endc
	
;
; Call P50_Music every frame to play the music	
; A6 --> Customchip baseaddress ($DFF000)	
;          	Uses A0-A5/D0-D7		
;

P50_Music
	lea	P50_cn(pc),a3

	tst	P50_play(a3)
	bne.b	P50_ohitaaa
	ifne	CIA
	ifeq	system
	move.l	P50_vektori(pc),a5
	move.l	P50_tintti(pc),$78(a5)
	move.b	P50_tlo2(pc),$bfd400
	move.b	P50_thi2(pc),$bfd500

	else
	clr	P50_server(a3)
	move.l	P50_craddr+4(pc),a0
	move.b	P50_tlo2(pc),(a0)
	move.b	P50_thi2(pc),$100(a0)
	endc
	endc
	rts

P50_ohitaaa
	ifne	fade
	pea	P50_mfade(pc)
	endc

	moveq	#Channel_Block_SIZE,d6
	moveq	#16,d7

	move	(a3),d4
	addq	#1,d4
	cmp	P50_speed(pc),d4
	beq	P50_playtime

	move	d4,(a3)

P50_delay
	ifne	CIA
	ifeq	system
	move.l	P50_vektori(pc),a5
	move.l	P50_tintti(pc),$78(a5)
	move.b	P50_tlo2(pc),$bfd400
	move.b	P50_thi2(pc),$bfd500

	else
	clr	P50_server(a3)
	move.l	P50_craddr+4(pc),a0
	move.b	P50_tlo2(pc),(a0)
	move.b	P50_thi2(pc),$100(a0)
	endc
	endc

	lea	P50_temp0(pc),a5
	lea	$a0(a6),a4

	moveq	#channels-1,d5
P50_lopas
	tst	P50_OnOff(a5)
	beq	P50_contfxdone
	moveq	#$f,d0
	and	(a5),d0
	add	d0,d0
	move	P50_jtab2(pc,d0),d0
	jmp	P50_jtab2(pc,d0)

P50_jtab2
	dc	P50_contfxdone-P50_jtab2

	ifne	P50_pu
	dc	P50_portup-P50_jtab2
	else
	dc	P50_contfxdone-P50_jtab2
	endc

	ifne	P50_pd
	dc	P50_portdwn-P50_jtab2
	else
	dc	P50_contfxdone-P50_jtab2
	endc

	ifne	P50_tp
	dc	P50_toneport-P50_jtab2
	else
	dc	P50_contfxdone-P50_jtab2
	endc

	ifne	P50_vib
	dc	P50_vib2-P50_jtab2
	else
	dc	P50_contfxdone-P50_jtab2
	endc

	ifne	P50_tpvs
	dc	P50_tpochvslide-P50_jtab2
	else
	dc	P50_contfxdone-P50_jtab2
	endc

	ifne	P50_vbvs
	dc	P50_vibochvslide-P50_jtab2
	else
	dc	P50_contfxdone-P50_jtab2
	endc

	ifne	P50_tre
	dc	P50_tremo-P50_jtab2
	else
	dc	P50_contfxdone-P50_jtab2
	endc

	ifne	P50_arp
	dc	P50_arpeggio-P50_jtab2
	else
	dc	P50_contfxdone-P50_jtab2
	endc

	dc	P50_contfxdone-P50_jtab2

	ifne	P50_vs
	dc	P50_volslide-P50_jtab2
	else
	dc	P50_contfxdone-P50_jtab2
	endc

	dc	P50_contfxdone-P50_jtab2
	dc	P50_contfxdone-P50_jtab2
	dc	P50_contfxdone-P50_jtab2

	ifne	P50_ec
	dc	P50_contecommands-P50_jtab2
	else
	dc	P50_contfxdone-P50_jtab2
	endc
	dc	P50_contfxdone-P50_jtab2

	ifne	P50_ec
P50_contecommands
	move.b	P50_Info(a5),d0
	and.b	#$f0,d0
	lsr	#3,d0
	move	P50_etab2(pc,d0),d0
	jmp	P50_etab2(pc,d0)

P50_etab2
	dc	P50_contfxdone-P50_etab2

	ifne	P50_fsu
	dc	P50_fineup2-P50_etab2
	else
	dc	P50_contfxdone-P50_etab2
	endc

	ifne	P50_fsd
	dc	P50_finedwn2-P50_etab2
	else
	dc	P50_contfxdone-P50_etab2
	endc

	dc	P50_contfxdone-P50_etab2
	dc	P50_contfxdone-P50_etab2

	dc	P50_contfxdone-P50_etab2
	dc	P50_contfxdone-P50_etab2

	dc	P50_contfxdone-P50_etab2
	dc	P50_contfxdone-P50_etab2

	ifne	P50_rt
	dc	P50_retrig-P50_etab2
	else
	dc	P50_contfxdone-P50_etab2
	endc

	ifne	P50_fvu
	dc	P50_finevup2-P50_etab2
	else
	dc	P50_contfxdone-P50_etab2
	endc

	ifne	P50_fvd
	dc	P50_finevdwn2-P50_etab2
	else
	dc	P50_contfxdone-P50_etab2
	endc

	dc	P50_notecut-P50_etab2

	ifne	P50_nd
	dc	P50_notedelay-P50_etab2
	else
	dc	P50_contfxdone-P50_etab2
	endc

	dc	P50_contfxdone-P50_etab2
	dc	P50_contfxdone-P50_etab2
	endc

	ifne	P50_fsu
P50_fineup2
	tst	(a3)
	bne	P50_contfxdone
	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	sub	d0,P50_Period(a5)
	moveq	#113,d0
	cmp	P50_Period(a5),d0
	ble	.jup
	move	d0,P50_Period(a5)
.jup	move	P50_Period(a5),6(a4)
	bra	P50_contfxdone
	endc

	ifne	P50_fsd
P50_finedwn2
	tst	(a3)
	bne	P50_contfxdone
	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	add	d0,P50_Period(a5)
	cmp	#856,P50_Period(a5)
	ble	.jup
	move	#856,P50_Period(a5)
.jup	move	P50_Period(a5),6(a4)
	bra	P50_contfxdone
	endc

	ifne	P50_fvu
P50_finevup2
	tst	(a3)
	bne	P50_contfxdone
	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	add	d0,P50_Volume(a5)
	moveq	#64,d0
	cmp	P50_Volume(a5),d0
	bge.b	.jup
	move	d0,P50_Volume(a5)
.jup	move	P50_Volume(a5),8(a4)
	bra	P50_contfxdone
	endc

	ifne	P50_fvd
P50_finevdwn2
	tst	(a3)
	bne	P50_contfxdone
	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	sub	d0,P50_Volume(a5)
	bpl.b	.jup
	clr	P50_Volume(a5)
.jup	move	P50_Volume(a5),8(a4)
	bra	P50_contfxdone
	endc

	ifne	P50_nc
P50_notecut
	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	cmp	(a3),d0
	bne	P50_contfxdone
	ifeq	fade
	clr	8(a4)
	else
	clr	P50_Shadow(a5)
	endc
	clr	P50_Volume(a5)
	bra	P50_contfxdone
	endc

	ifne	P50_nd
P50_notedelay
	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	cmp	(a3),d0
	bne	P50_contfxdone

	moveq	#$7e,d0
	and.b	(a5),d0
	beq	P50_contfxdone
	move	P50_DMABit(a5),d0
	move	d0,$96(a6)
	or	d0,P50_dma(a3)
	move.l	P50_Sample(a5),a1
	move.l	(a1)+,(a4)+
	move	(a1),(a4)+
	move	P50_Period(a5),(a4)
	subq.l	#6,a4
	ifeq	system
	lea	P50_dmason(pc),a1
	move.l	a1,d0
	move.l	P50_vektori(pc),a1
	move.l	d0,$78(a1)
	endc

	ifeq	CIA
	move.b	#$19,$bfde00
	else
	ifeq	system
	move.b	#$4a,$bfd400
	move.b	#1,$bfd500
	else
	move	#1,P50_server(a3)
	move.l	P50_craddr+4(pc),a1
	move.b	#$4a,(a1)
	move.b	#1,$100(a1)
	endc
	endc

	bra	P50_contfxdone
	endc

	ifne	P50_rt
P50_retrig
	subq	#1,P50_RetrigCount(a5)
	bne	P50_contfxdone
	move	P50_DMABit(a5),d0
	move	d0,$96(a6)
	or	d0,P50_dma(a3)
	move.l	P50_Sample(a5),a1
	move.l	(a1)+,(a4)
	move	(a1),4(a4)

	ifeq	system
	lea	P50_dmason(pc),a1
	move.l	a1,d0
	move.l	P50_vektori(pc),a1
	move.l	d0,$78(a1)
	endc

	ifeq	CIA
	move.b	#$19,$bfde00
	else
	ifeq	system
	move.b	#$4a,$bfd400
	move.b	#1,$bfd500
	else
	move	#1,P50_server(a3)
	move.l	P50_craddr+4(pc),a1
	move.b	#$4a,(a1)
	move.b	#1,$100(a1)
	endc
	endc

	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	move	d0,P50_RetrigCount(a5)
	bra	P50_contfxdone
	endc

	ifne	P50_arp
P50_arplist
	dc.b 0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1

P50_arpeggio
	move	(a3),d0
	move.b	P50_arplist(pc,d0),d0
	beq.b	.arp0
	ror.b	#1,d0
	bcc.b	P50_arp1
	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	bra.b	P50_arp3
.arp0
	move	P50_Note(a5),d0
	move	P50_periods(pc,d0),6(a4)
	bra	P50_contfxdone
P50_arp1
	move.b	P50_Info(a5),d0
	lsr	#4,d0
P50_arp3
	add	d0,d0
	add	P50_Note(a5),d0
	move	P50_periods(pc,d0),6(a4)
	bra	P50_contfxdone
	endc

P50_periods
	ifne	P50_ft
	incbin	periodtable
	else
	incbin	periods.nft
	endc

	ifne	P50_vs
P50_volslide
	move.b	P50_Info(a5),d0
	sub.b	d0,P50_Volume+1(a5)
	bpl.b	.test
	clr	P50_Volume(a5)
	ifeq	fade
	clr	8(a4)
	else
	clr	P50_Shadow(a5)
	endc
	bra	P50_contfxdone
.test	moveq	#64,d0
	cmp	P50_Volume(a5),d0
	bge.b	.ncs
	move	d0,P50_Volume(a5)
	ifeq	fade
	move	d0,8(a4)
	else
	move	d0,P50_Shadow(a5)
	endc
	bra.b	P50_contfxdone
.ncs	ifeq	fade
	move	P50_Volume(a5),8(a4)
	else
	move	P50_Volume(a5),P50_Shadow(a5)
	endc
	bra.b	P50_contfxdone
	endc

	ifne	P50_tpvs
P50_tpochvslide
	move.b	P50_Info(a5),d0
	sub.b	d0,P50_Volume+1(a5)
	bpl.b	.test
	clr	P50_Volume(a5)
	ifeq	fade
	clr	8(a4)
	else
	clr	P50_Shadow(a5)
	endc
	bra.b	P50_toneport
.test	moveq	#64,d0
	cmp	P50_Volume(a5),d0
	bge.b	.ncs
	move	d0,P50_Volume(a5)
.ncs	ifeq	fade
	move	P50_Volume(a5),8(a4)
	else
	move	P50_Volume(a5),P50_Shadow(a5)
	endc
	endc

	ifne	P50_tp
P50_toneport
	move	P50_ToPeriod(a5),d0
	beq.b	P50_contfxdone
	move	P50_TPSpeed(a5),d1
	cmp	P50_Period(a5),d0
	blt.b	.topoup

	add	d1,P50_Period(a5)
	cmp	P50_Period(a5),d0
	bgt.b	P50_toposetper
	move	d0,P50_Period(a5)
	clr	P50_ToPeriod(a5)
	move	d0,6(a4)
	bra.b	P50_contfxdone

.topoup
	sub	d1,P50_Period(a5)
	cmp	P50_Period(a5),d0
	blt.b	P50_toposetper
	move	d0,P50_Period(a5)
	clr	P50_ToPeriod(a5)
P50_toposetper
	move	P50_Period(a5),6(a4)
	else
	nop
	endc

P50_contfxdone
	add.l	d6,a5
	add.l	d7,a4
	dbf	d5,P50_lopas

	cmp	P50_speed2(pc),d4
	beq.b	P50_preplay
	rts

	ifne	P50_pu
P50_portup
	moveq	#0,D0
	move.b	P50_Info(a5),d0
	sub	d0,P50_Period(a5)
	moveq	#113,d0
	cmp	P50_Period(a5),d0
	ble.b	.skip
	move	d0,P50_Period(a5)
	move	d0,6(a4)
	bra.b	P50_contfxdone
.skip
	move	P50_Period(a5),6(a4)
	bra.b	P50_contfxdone
	endc

	ifne	P50_pd
P50_portdwn
	moveq	#0,d0
	move.b	P50_Info(a5),d0
	add	d0,P50_Period(a5)
	cmp	#856,P50_Period(a5)
	ble.b	.skip
	move	#856,d0
	move	d0,P50_Period(a5)
	move	d0,6(a4)
	bra.b	P50_contfxdone
.skip
	move	P50_Period(a5),6(a4)
	bra.b	P50_contfxdone
	endc

P50_preplay
	ifne	P50_pde
	tst	P50_pdelay(a3)
	beq.b	.djdj
	rts
.djdj
	endc

	lea	P50_temp0(pc),a5
	lea	P50_Samples-16(pc),a0

	moveq	#channels-1,d5
P50_loaps
	ifne	P50_pl
	move.l	(a5),P50_TData(a5)
	move.l	P50_ChaPos(a5),P50_TChaPos(a5)
	move.l	P50_TempPos(a5),P50_TTempPos(a5)
	move	P50_TempLen(a5),P50_TTempLen(a5)
	endc

	tst.b	P50_Pack(a5)
	beq.b	P50_takeone
	bmi.b	.keepsame

	subq.b	#1,P50_Pack(a5)
	clr	P50_OnOff(a5)
	add.l	d6,a5
	dbf	d5,P50_loaps
	rts

.keepsame
	addq.b	#1,P50_Pack(a5)
	bra.b	P50_dko

P50_takeone
	tst.b	P50_TempLen+1(a5)
	beq.b	P50_takenorm

	subq.b	#1,P50_TempLen+1(a5)
	move.l	P50_TempPos(a5),a2

P50_jedi
	move.l	(a5),P50_TData(a5)
	move.b	(a2)+,(a5)
	bpl.b	P50_normal
	not.b	(a5)+
	move.b	(a2)+,(a5)+
	move.b	(a2)+,(a5)+
	move.b	(a2)+,(a5)+
	subq.l	#4,a5
	move.l	a2,P50_TempPos(a5)
	bra.b	P50_dko
	
P50_normal
	move.b	(a2)+,1(a5)
	move.b	(a2)+,2(a5)
	move.l	a2,P50_TempPos(a5)
	bra.b	P50_dko

P50_takenorm
	move.l	P50_ChaPos(a5),a2
	move.b	(a2)+,(a5)
	bmi.b	P50_packed
	move.b	(a2)+,1(a5)
	move.b	(a2)+,2(a5)
	move.l	a2,P50_ChaPos(a5)
	bra.b	P50_dko

P50_kuiskus
	move.b	(a2)+,P50_TempLen+1(a5)
	moveq	#0,d0
	move.b	(a2)+,d0
	lsl	#8,d0
	move.b	(a2)+,d0

	move.l	a2,P50_ChaPos(a5)
	sub.l	d0,a2
	bra.b	P50_jedi

P50_packed
	cmp.b	#$80,(a5)
	beq.b	P50_kuiskus
	not.b	(a5)+
	move.b	(a2)+,(a5)+
	move.b	(a2)+,(a5)+
	move.b	(a2)+,(a5)+
	subq.l	#4,a5
	move.l	a2,P50_ChaPos(a5)

P50_dko	st	P50_OnOff(a5)
	move	(a5),d0
	and	#$1f0,d0
	beq.b	.koto
	lea	(a0,d0),a1
	move.l	a1,P50_Sample(a5)
	ifne	P50_ft
	move.l	P50_SampleVolume(a1),P50_Volume(a5)
	else
	move	P50_SampleVolume(a1),P50_Volume(a5)
	endc

.koto
	add.l	d6,a5
	dbf	d5,P50_loaps
	rts

P50_playtime
	clr	(a3)
	ifne	P50_pde
	tst	P50_pdelay(a3)
	beq.b	.djdj
	subq	#1,P50_pdelay(a3)
	bra	P50_delay
.djdj
	endc

	tst	P50_speedis1(a3)
	beq.b	.mo
	bsr	P50_preplay

.mo	lea	P50_temp0(pc),a5
	lea	$a0(a6),a4

	ifne	system
	moveq	#1,d4
	move	d4,P50_server(a3)
	move.l	P50_craddr+4(pc),a1
	move.b	#$4a,(a1)
	move.b	d4,$100(a1)
	else
	lea	P50_dmason(pc),a1
	move.l	P50_vektori(pc),a2
	move.l	a1,$78(a2)

	ifeq	CIA
	move.b	#$19,$bfde00
	else
	move.b	#$4a,$bfd400
	move.b	#1,$bfd500
	endc
	endc

	lea	P50_periods(pc),a2

	moveq	#0,d4
	moveq	#channels-1,d5
P50_los	tst	P50_OnOff(a5)
	beq	P50_nocha

	moveq	#$f,d0
	and	(a5),d0
	lea	P50_jtab(pc),a1
	add	d0,d0
	add.l	d0,a1
	add	(a1),a1
	jmp	(a1)

P50_fxdone
	moveq	#$7e,d0
	and.b	(a5),d0
	beq.b	P50_nocha
	ifne	P50_vib
	clr.b	P50_VibPos(a5)
	endc

 	ifne	P50_ft
	add	P50_Fine(a5),d0
	endc
	move	d0,P50_Note(a5)
	move	(a2,d0),P50_Period(a5)

P50_zample
	or	P50_DMABit(a5),d4
	move	d4,$96(a6)
	move.l	P50_Sample(a5),a1
	move.l	(a1)+,(a4)
	move	(a1),4(a4)

P50_nocha
	ifeq	fade
	move.l	P50_Period(a5),6(a4)
	else
	move	P50_Period(a5),6(a4)
	move	P50_Volume(a5),P50_Shadow(a5)
	endc

P50_skip
	add.l	d6,a5
	add.l	d7,a4
	dbf	d5,P50_los

	move.b	d4,P50_dma+1(a3)

	ifne	P50_pl
	tst.b	P50_plflag+1(a3)
	beq.b	P50_ohittaa

	lea	P50_temp0(pc),a1
	lea	P50_looppos(pc),a0
	moveq	#channels-1,d0
.talt	move.b	3(a0),3(a1)
	addq.l	#4,a0
	move.l	(a0)+,P50_ChaPos(a1)
	move.l	(a0)+,P50_TempPos(a1)
	move	(a0)+,P50_TempLen(a1)
	add.l	d6,a1
	dbf	d0,.talt

	move	P50_plrowpos(pc),P50_rowpos(a3)
	clr.b	P50_plflag+1(a3)
	rts
	endc

P50_ohittaa
	subq	#1,P50_rowpos(a3)
	bmi.b	P50_nextpattern
	rts

P50_nextpattern
	ifne	P50_pl
	clr	P50_plflag(a3)
	endc
	move.l	P50_patternbase(pc),a4
	moveq	#63,d0
	move	d0,P50_rowpos(a3)
	move.l	P50_spos(a3),a1
	move.b	(a1)+,d0
	bpl.b	P50_dk
	move.l	P50_possibase(pc),a1
	move.b	(a1)+,d0
P50_dk	move.l	a1,P50_spos(a3)
	lsl	#2,d0
	move.l	P50_positionbase(pc),a1
	add.l	d0,a1

	move	(a1)+,d0
	lea	(a4,d0.l),a2
	move	(a1)+,d0
	move.l	a2,P50_ChaPos+P50_temp0(a3)
	lea	(a4,d0.l),a2
	move.l	a2,P50_ChaPos+P50_temp1(a3)
	move	(a1)+,d0
	lea	(a4,d0.l),a2
	move.l	a2,P50_ChaPos+P50_temp2(a3)
	move	(a1),d0
	add.l	d0,a4
	move.l	a4,P50_ChaPos+P50_temp3(a3)
	rts

	ifne	P50_tp
P50_settoneport
	move.b	P50_Info(a5),d0
	beq.b	P50_toponochange
	move.b	d0,P50_TPSpeed+1(a5)
P50_toponochange
	moveq	#$7e,d0
	and.b	(a5),d0
	beq	P50_nocha
	add	P50_Fine(a5),d0
	move	d0,P50_Note(a5)
	move	(a2,d0),P50_ToPeriod(a5)
	bra	P50_nocha
	endc

	ifne	P50_sof
P50_sampleoffse
	moveq	#$7e,d0
	and.b	(a5),d0
	beq	P50_nocha
	ifne	P50_vib
	clr.b	P50_VibPos(a5)
	endc

	ifne	P50_ft
	add	P50_Fine(a5),d0
	endc
	move	d0,P50_Note(a5)
	move	(a2,d0),P50_Period(a5)

	or	P50_DMABit(a5),d4
	move	d4,$96(a6)
	moveq	#0,d1
	move	#$ff00,d1
	and	2(a5),d1
	bne.b	P50_djidd
	move	P50_Offset(a5),d1
P50_djidd
	move	d1,P50_Offset(a5)
	move.l	P50_Sample(a5),a1
	move.l	(a1)+,d0
	add.l	d1,d0
	move.l	d0,(a4)
	lsr	#1,d1
	move	(a1),d0
	sub	d1,d0
	bpl.b	P50_offok
	move.l	-4(a1),(a4)
	moveq	#1,d0
P50_offok
	move	d0,4(a4)
	bra	P50_nocha
	endc

	ifne	P50_vl
P50_volum
	move.b	P50_Info(a5),P50_Volume+1(a5)
	bra	P50_fxdone
	endc

	ifne	P50_pj
P50_posjmp
	moveq	#0,d0
	move.b	P50_Info(a5),d0
	add.l	P50_possibase(pc),d0
	move.l	d0,P50_spos(a3)
	endc

	ifne	P50_pb
P50_pattbreak
	moveq	#64,d0
	move	d0,P50_rowpos(a3)
	move.l	P50_spos(pc),a1
	move.l	P50_patternbase(pc),a0
	move.b	(a1)+,d0
	bpl.b	P50_dk2
	move.l	P50_possibase(pc),a1
	move.b	(a1)+,d0
P50_dk2	move.l	a1,P50_spos(a3)
	move.l	P50_positionbase(pc),a1
	lsl	#2,d0
	add.l	d0,a1
	movem	(a1)+,d0-d3
	lea	(a0,d0.l),a1
	move	d1,d0
	move.l	a1,P50_ChaPos+P50_temp0(a3)
	lea	(a0,d0.l),a1
	move.l	a1,P50_ChaPos+P50_temp1(a3)
	move	d2,d0
	lea	(a0,d0.l),a1
	move.l	a1,P50_ChaPos+P50_temp2(a3)
	move	d3,d0
	add.l	d0,a0
	move.l	a0,P50_ChaPos+P50_temp3(a3)
	bra	P50_fxdone
	endc

	ifne	P50_vib
P50_vibrato
	move.b	P50_Info(a5),d0
	beq	P50_fxdone
	move.b	d0,d1
	move.b	P50_VibCmd(a5),d2
	and.b	#$f,d0
	beq.b	P50_vibskip
	and.b	#$f0,d2
	or.b	d0,d2
P50_vibskip
	and.b	#$f0,d1
	beq.b	P50_vibskip2
	and.b	#$f,d2
	or.b	d1,d2
P50_vibskip2
	move.b	d2,P50_VibCmd(a5)
	bra	P50_fxdone
	endc

	ifne	P50_tre
P50_settremo
	move.b	P50_Info(a5),d0
	beq	P50_fxdone
	move.b	d0,d1
	move.b	P50_TreCmd(a5),d2
	moveq	#$f,d3
	and.b	d3,d0
	beq.b	P50_treskip
	and.b	#$f0,d2
	or.b	d0,d2
P50_treskip
	and.b	#$f0,d1
	beq.b	P50_treskip2
	and.b	d3,d2
	or.b	d1,d2
P50_treskip2
	move.b	d2,P50_TreCmd(a5)
	bra	P50_fxdone
	endc

	ifne	P50_ec
P50_ecommands
	move.b	P50_Info(a5),d0
	and.b	#$f0,d0
	lsr	#3,d0
	move	P50_etab(pc,d0),d0
	jmp	P50_etab(pc,d0)

P50_etab
	ifne	P50_fi
	dc	P50_filter-P50_etab
	else
	dc	P50_fxdone-P50_etab
	endc

	ifne	P50_fsu
	dc	P50_fineup-P50_etab
	else
	dc	P50_fxdone-P50_etab
	endc

	ifne	P50_fsd
	dc	P50_finedwn-P50_etab
	else
	dc	P50_fxdone-P50_etab
	endc

	dc	P50_fxdone-P50_etab
	dc	P50_fxdone-P50_etab

	ifne	P50_sft
	dc	P50_setfinetune-P50_etab
	else
	dc	P50_fxdone-P50_etab
	endc

	ifne	P50_pl
	dc	P50_patternloop-P50_etab
	else
	dc	P50_fxdone-P50_etab
	endc

	dc	P50_fxdone-P50_etab
	dc	P50_fxdone-P50_etab

	ifne	P50_rt
	dc	P50_setretrig-P50_etab
	else
	dc	P50_fxdone-P50_etab
	endc

	ifne	P50_fvu
	dc	P50_finevup-P50_etab
	else
	dc	P50_fxdone-P50_etab
	endc

	ifne	P50_fvd
	dc	P50_finevdwn-P50_etab
	else
	dc	P50_fxdone-P50_etab
	endc

	dc	P50_fxdone-P50_etab

	ifne	P50_nd
	dc	P50_ndelay-P50_etab
	else
	dc	P50_fxdone-P50_etab
	endc

	ifne	P50_pde
	dc	P50_pattdelay-P50_etab
	else
	dc	P50_fxdone-P50_etab
	endc
	dc	P50_fxdone-P50_etab
	endc

	ifne	P50_fi
P50_filter
	move.b	P50_Info(a5),d0
	and.b	#$fd,$bfe001
	or.b	d0,$bfe001
	bra	P50_fxdone
	endc

	ifne	P50_fsu
P50_fineup
	P50_getnote

	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	sub	d0,P50_Period(a5)
	moveq	#113,d0
	cmp	P50_Period(a5),d0
	ble	.jup
	move	d0,P50_Period(a5)
.jup	moveq	#$7e,d0
	and.b	(a5),d0
	bne	P50_zample
	bra	P50_nocha
	endc

	ifne	P50_fsd
P50_finedwn
	P50_getnote

	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	add	d0,P50_Period(a5)
	cmp	#856,P50_Period(a5)
	ble	.jup
	move	#856,P50_Period(a5)
.jup	moveq	#$7e,d0
	and.b	(a5),d0
	bne	P50_zample
	bra	P50_nocha
	endc

	ifne	P50_sft
P50_setfinetune
	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	add	d0,d0
	move	P50_mulutab(pc,d0),P50_Fine(a5)
	bra	P50_fxdone

P50_mulutab
	dc	0,74,148,222,296,370,444,518,592,666,740,814,888,962,1036,1110
	endc

	ifne	P50_pl
P50_patternloop
	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	beq.b	P50_setloop

	tst.b	P50_plflag(a3)
	bne.b	P50_noset

	move	d0,P50_plcount(a3)
	st.b	P50_plflag(a3)
P50_noset
	tst	P50_plcount(a3)
	bne.b	P50_looppaa
	clr.b	P50_plflag(a3)
	bra	P50_fxdone
	
P50_looppaa
	st.b	P50_plflag+1(a3)
	subq	#1,P50_plcount(a3)
	bra	P50_fxdone

P50_setloop
	tst.b	P50_plflag(a3)
	bne	P50_fxdone
	move	P50_rowpos(pc),P50_plrowpos(a3)
	lea	P50_temp0(pc),a1
	lea	P50_looppos(pc),a0
	moveq	#channels-1,d0
.talt	move.l	P50_TData(a1),(a0)+
	move.l	P50_TChaPos(a1),(a0)+
	move.l	P50_TTempPos(a1),(a0)+
	move	P50_TTempLen(a1),(a0)+
	add.l	d6,a1
	dbf	d0,.talt
	bra	P50_fxdone
	endc

	ifne	P50_fvu
P50_finevup
	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	add	d0,P50_Volume(a5)
	moveq	#64,d0
	cmp	P50_Volume(a5),d0
	bge	P50_fxdone
	move	d0,P50_Volume(a5)
	bra	P50_fxdone
	endc

	ifne	P50_fvd
P50_finevdwn
	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	sub	d0,P50_Volume(a5)
	bpl	P50_fxdone
	clr	P50_Volume(a5)
	bra	P50_fxdone
	endc

	ifne	P50_rt
P50_setretrig
	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	move	d0,P50_RetrigCount(a5)
	bra	P50_fxdone
	endc

	ifne	P50_nd
P50_ndelay
	moveq	#$7e,d0
	and.b	(a5),d0
	beq	P50_skip
	ifne	P50_vib
	clr.b	P50_VibPos(a5)
	endc
	ifne	P50_ft
	add	P50_Fine(a5),d0
	endc
	move	d0,P50_Note(a5)
	move	(a2,d0),P50_Period(a5)
	ifeq	fade
	move	P50_Volume(a5),8(a4)
	else
	move	P50_Volume(a5),P50_Shadow(a5)
	endc
	bra	P50_skip
	endc

	ifne	P50_pde
P50_pattdelay
	moveq	#$f,d0
	and.b	P50_Info(a5),d0
	move	d0,P50_pdelay(a3)
	bra	P50_fxdone
	endc

	ifne	P50_sd
P50_cspeed
	move.b	P50_Info(a5),d0

	ifne	CIA
	tst	P50_Tempo(a3)
	beq.b	P50_VBlank
	cmp.b	#32,d0
	bhs.b	P50_STempo
	endc

P50_VBlank
	cmp.b	#1,d0
	bne.b	P50_jkd

	move.b	d0,P50_speed+1(a3)
	move.b	d0,P50_speed2+1(a3)
	st	P50_speedis1(a3)
	bra	P50_fxdone
P50_jkd	move.b	d0,P50_speed+1(a3)
	subq.b	#1,d0
	move.b	d0,P50_speed2+1(a3)
	clr	P50_speedis1(a3)
	bra	P50_fxdone

	ifne	CIA
P50_STempo
	move.l	P50_timer(pc),d1
	divu	d0,d1
	move	d1,P50_thi2(a3)
	sub	#$1c8*2,d1
	move	d1,P50_thi(a3)
	bra	P50_fxdone
	endc
	endc

	ifne	P50_vbvs
P50_vibochvslide
	move.b	P50_Info(a5),d0
	sub.b	d0,P50_Volume+1(a5)
	bpl.b	P50_test62
	clr	P50_Volume(a5)
	ifeq	fade
	clr	8(a4)
	else
	clr	P50_Shadow(a5)
	endc
	bra.b	P50_vib2
P50_test62	moveq	#64,d0
	cmp	P50_Volume(a5),d0
	bge.b	.ncs2
	move	d0,P50_Volume(a5)
.ncs2
	ifeq	fade
	move	P50_Volume(a5),8(a4)
	else
	move	P50_Volume(a5),P50_Shadow(a5)
	endc
	endc

	ifne	P50_vib
P50_vib2
	move	#$f00,d0
	move	P50_VibCmd(a5),d1
	and	d1,d0
	lsr	#2,d0
	
	lsr	#1,d1
	and	#$3e,d1
	add	d1,d0

	move	P50_Period(a5),d1
	tst.b	P50_VibPos(a5)
	bmi.b	.vibneg
	add	P50_vibtab(pc,d0),d1
	bra.b	P50_vib4

.vibneg	sub	P50_vibtab(pc,d0),d1

P50_vib4
	move	d1,6(a4)
	move.b	P50_VibCmd(a5),d0
	lsr.b	#2,d0
	and	#$3c,d0
	add.b	d0,P50_VibPos(a5)
	bra	P50_contfxdone
	endc

	ifne	P50_tre
P50_tremo
	move	#$f00,d0
	move	P50_TreCmd(a5),d1
	and	d1,d0
	lsr	#2,d0
	
	lsr	#1,d1
	and	#$3e,d1
	add	d1,d0

	move	P50_Volume(a5),d1
	tst.b	P50_TrePos(a5)
	bmi.b	.treneg
	add	P50_vibtab(pc,d0),d1
	cmp	#64,d1
	ble.b	P50_tre4
	moveq	#64,d1
	bra.b	P50_tre4

.treneg	sub	P50_vibtab(pc,d0),d1
	bpl.b	P50_tre4
	moveq	#0,d1
P50_tre4
	ifeq	fade
	move	d1,8(a4)
	else
	move	d1,P50_Shadow(a5)
	endc

	move.b	P50_TreCmd(a5),d0
	lsr.b	#2,d0
	and	#$3c,d0
	add.b	d0,P50_TrePos(a5)
	bra	P50_contfxdone
	endc

	ifne	P50_vib!P50_tre
P50_vibtab	incbin	vibtab
	endc

P50_jtab
	dr	P50_fxdone
	dr	P50_fxdone
	dr	P50_fxdone

	ifne	P50_tp
	dr	P50_settoneport
	else
	dr	P50_fxdone
	endc

	ifne	P50_vib
	dr	P50_vibrato
	else
	dr	P50_fxdone
	endc

	ifne	P50_tpvs
	dr	P50_toponochange
	else
	dr	P50_fxdone
	endc

	dr	P50_fxdone

	ifne	P50_tre
	dr	P50_settremo
	else
	dr	P50_fxdone
	endc

	dr	P50_fxdone

	ifne	P50_sof
	dr	P50_sampleoffse
	else
	dr	P50_fxdone
	endc
	dr	P50_fxdone

	ifne	P50_pj
	dr	P50_posjmp
	else
	dr	P50_fxdone
	endc

	ifne	P50_vl
	dr	P50_volum
	else
	dr	P50_fxdone
	endc

	ifne	P50_pb
	dr	P50_pattbreak
	else
	dr	P50_fxdone
	endc

	ifne	P50_ec
	dr	P50_ecommands
	else
	dr	P50_fxdone
	endc
	
	ifne	P50_sd
	dr	P50_cspeed
	else
	dr	P50_fxdone
	endc

P50_dmason
	ifeq	system
	tst.b	$bfdd00
	move.l	a0,-(sp)
	move.l	P50_vektori(pc),a0
	move.l	P50_intaddr(pc),$78(a0)
	move.l	(sp)+,a0
	move	P50_dma(pc),$dff096
	move	#$2000,$dff09c
	move.b	#$19,$bfde00
	rte

	else
	move	P50_dma(pc),$96(a6)
	addq	#1,P50_server(a3)
	move.l	P50_craddr(pc),a0
	move.b	#$19,(a0)
	bra	P50_ohi
	endc


P50_setrepeat
	ifeq	system
	tst.b	$bfdd00
	movem.l	a0/a1,-(sp)
	lea	$dff0a0,a1
	else
	lea	$a0(a6),a1
	endc

	move.l	P50_Sample+P50_temp0(pc),a0
	addq.l	#6,a0
	move.l	(a0)+,(a1)+
	move	(a0),(a1)

	ifgt	channels-1
	move.l	P50_Sample+P50_temp1(pc),a0
	addq.l	#6,a0
	move.l	(a0)+,12(a1)
	move	(a0),16(a1)
	endc
	
	ifgt	channels-2
	move.l	P50_Sample+P50_temp2(pc),a0
	addq.l	#6,a0
	move.l	(a0)+,28(a1)
	move	(a0),32(a1)
	endc

	ifgt	channels-3
	move.l	P50_Sample+P50_temp3(pc),a0
	addq.l	#6,a0
	move.l	(a0)+,44(a1)
	move	(a0),48(a1)
	endc

	ifne	system
	clr	P50_server(a3)
	move.l	P50_craddr+4(pc),a0
	move.b	P50_tlo(pc),(a0)
	move.b	P50_thi(pc),$100(a0)
	bra	P50_ohi
	else

	move	#$2000,-8(a1)
	move.l	P50_vektori(pc),a0

	ifeq	CIA
	move.l	P50_oldlev6(pc),$78(a0)
	else
	move.l	P50_tintti(pc),$78(a0)
	move.b	P50_tlo(pc),$bfd400
	move.b	P50_thi(pc),$bfd500
	endc

	movem.l	(sp)+,a0/a1
	rte
	endc

P50_temp0
	dcb.b	Channel_Block_SIZE-2
	dc	1
P50_temp1
	dcb.b	Channel_Block_SIZE-2
	dc	2
P50_temp2
	dcb.b	Channel_Block_SIZE-2
	dc	4
P50_temp3
	dcb.b	Channel_Block_SIZE-2
	dc	8

P50_cn	dc	0
P50_dma	dc	$8200
P50_rowpos
	dc	63
P50_speed
	dc	6
P50_speed2
	dc	5
P50_speedis1
	dc	0
P50_spos
	dc.l	0
P50_vektori
	dc.l	0

	ifne	CIA
P50_tintti
	dc.l	0
P50_thi	dc.b	0
P50_tlo	dc.b	0
P50_thi2
	dc.b	0
P50_tlo2
	dc.b	0
P50_timer
	dc.l	0
	endc

	ifne	P50_pl
P50_plcount
	dc	0
P50_plflag
	dc	0
P50_plreset
	dc	0
P50_plrowpos
	dc	0
P50_looppos
	dcb.b	14*channels
	endc

	ifne	P50_pde
P50_pdelay
	dc	0
	endc
P50_Samples
	dcb.b	16*31
P50_positionbase
	dc.l	0
P50_possibase
	dc.l	0
P50_patternbase
	dc.l	0
P50_intaddr
	dc.l	0
P50_oldlev6
	dc.l	0
	ifne	system
P50_server
	dc	0
P50_miscbase	dc.l	0
P50_audioopen	dc.b	0
P50_sigbit	dc.b	-1
P50_ciares	dc.l	0
P50_craddr	dc.l	0,0,0

P50_dat		dc	$f00
P50_timerinterrupt
		dc	0,0,0,0,127
P50_timerdata	dc.l	0,0,0

P50_allocport	dc.l	0,0
		dc.b	4,0
		dc.l	0
		dc.b	0,0
		dc.l	0
P50_reqlist	dc.l	0,0,0
		dc.b	5,0
P50_allocreq	dc.l	0,0
		dc	127
		dc.l	0
P50_portti	dc.l	0
		dc	68
		dc.l	0,0,0
		dc	0
P50_reqdata	dc.l	0
		dc.l	1,0,0,0,0,0,0
		dc	0
P50_audiodev	dc.b	'audio.device',0

P50_cianame	dc.b	'ciax.resource',0
P50_timeropen	dc.b	0
P50_timerint	dc.b	'P50TimerInterrupt',0
	endc
P50_etu
	endb	a3

******** END OF BINARY FILE **************

	section	chip,data_c
P50_data	incbin	"modules/P50..huuliherpes."
P50_dend
;	section	smp,data_c
;samples	incbin	"ram:SMP.let there be funk2"
