NumEstrellas	=	256-1			;Numero de estrellas
ScreenH:	=	280
ScreenW:	=	44
BMapSize:	=	ScreenH*ScreenW
;------------------------------------------------------------------------

FX_Estrellas_Init:
	jsr	InicializaSprites
	jsr	InitAll
	jsr	GeneraMultiplosScreenW
	jsr	CalculaPosicionEstrellas

	move.l	#CopperList,COP1LCH+CustomBase	
	clr.w	CopJmp1+CustomBase

	rts

FX_Estrellas_Run:
	jsr	MainLoop
	rts

InicializaSprites:	
		lea.l	CopperList,a0
		move.l	#BlindSpr,d0
		moveq	#8-1,d7
SprLoop1:	
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		move.w	d0,6(a0)
		addq.l	#8,a0
		dbra	d7,SprLoop1
		rts

ClearScreen:	
	gblWaitBlitter 
	;rts	Si no se borra es curioso....
	move.l	#-1,BltAFwm+CustomBase
	move.w	d2,BltDMod+CustomBase
	move.l	#$01000000,BltCon0+CustomBase
	move.l	d0,BltDPth+CustomBase
	move.w	d1,BltSize+CustomBase
	rts


;-----------------------------------------------------------------------
;Para el calculo de las posiciones iniciales de las estrellas usamos
;el registro VHPosR, que nos indica la posicion Vertical y Horizontal
;del rayo de electrones, y le aplicamos la formula:
;
;	CoordAi = PosicionElectron * Delta2 * Delta1 (A = x,y,z)
;	Delta2  = Delta2 + Delta1
;	Delta1	= Delta1 + Delta3
;Se pueden variar estos numeros (Deltas) para obtener diferentes 
;configuraciones.
;-----------------------------------------------------------------------
CalculaPosicionEstrellas:	
		lea.l	StarAdr,a0
		move.w	#17,d1			;Delta1
		move.w	#0,d2		;Delta2
		move.w	#7,d3			;Delta3
		move.w	#NumEstrellas-1,d7		
RNDLoop:	moveq	#3-1,d6
RNDLoop2:	move.w	VHPosR(a6),d0		;PosicionVH del electron
		ext.w	d0
		muls	d2,d0			;PosRayo*Delta2*Delta1			
		muls	d1,d0
		and.w	#$1ff,d0		;Limpieza a 9 bits
		move.w	d0,(a0)+		;Guardamos el numero generado

		add.w	d1,d2			;Delta2=Delta2+Delta1
		add.w	d3,d1			;Delta1=Delta1+Delta3

		dbra	d6,RNDLoop2		;Siguiente coordenada (x,y o z)
		dbra	d7,RNDLoop		;Siguiente estrella
		rts

;------------------------------------------------------------------------


StarAdr:	dcb.w	$2000,0	;=	$6c000
OldAdr:		dcb.w	$2000,0 ;	$6d000
MulsAdr:	dcb.w	1000,0	;	$7d000

;--------------------------------------------

InitAll:	lea	Screen1,a0
		move.l	a0,Screen
		lea	Screen2,a0
		move.l	a0,Screen+4
		move.l	Screen,d0

		move.w	#280*64*2+22,d1
		moveq	#0,d2
		jsr	ClearScreen
		move.l	Screen+4,d0
		move.w	#280*64*2+22,d1
		moveq	#0,d2
		jsr	ClearScreen

		lea.l	BMap,a0
		moveq	#2-1,d7
BMapLoop:	swap	d0
		move.w	d0,2(a0)
		swap	d0
		move.w	d0,6(a0)
		addq.l	#8,a0
		add.l	#BMapSize,d0
		dbra	d7,BMapLoop

		move.l	#ZV,XSave
		move.l	#YV,YSave
		move.l	#ZV,ZSave
		rts

;------------------------------------------------------------------------
; Creamos una tabla con los multiplos de ScreenW para ahorrar hacer la
; multiplicacion. El numero de multiplos a calcular es de 380, pero para
; los superiores a ScreenH siempre seran ScreenH*ScreenW
;------------------------------------------------------------------------
GeneraMultiplosScreenW:	
		lea.l	MulsAdr,a0
		moveq	#0,d0
		move.w	#380-1,d7
MulsLoop:	move.w	d0,d1
		muls	#ScreenW,d1
		move.w	d1,(a0)+
		cmp.w	#ScreenH,d0
		beq.S	NoAdd
		addq.w	#1,d0
NoAdd:		dbra	d7,MulsLoop
		rts

;------------------------------------------------------------------------

MainLoop:	

		jsr	Stars

		rts

;------------------------------------------------------------------------

Stars:		
	jsr	Buffra
	jsr	ClearOld
	jsr	FixSpeed
	jsr	FixValues
	gblWaitBlitter
	jsr	PlotStars
	rts

Buffra:		
	move.l	Screen,d0
	move.l	Screen+4,Screen
	move.l	d0,Screen+4
	lea.l	BMap,a0
	moveq	#2-1,d7
BMapLoop2:	
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	move.w	d0,6(a0)
	addq.l	#8,a0
	add.l	#BMapSize,d0
	dbra	d7,BMapLoop2
	rts

ClearOld:	
	move.l	Screen,d0
	move.w	#280*64*2+22,d1
	moveq	#0,d2
	jsr	ClearScreen
	rts

FixValues:	lea.l	StarAdr,a0
		move.w	ZAdd,d2
		move.w	XAdd,d0
		move.w	YAdd,d1
		move.w	#NumEstrellas,d7
FixLoop:	move.w	(a0),d3
		add.w	d0,d3
		cmp.w	#-250,d3
		bge.S	NoLo
		add.w	#500,d3
NoLo:		cmp.w	#250,d3
		blt.S	NoHi
		sub.w	#500,d3
NoHi:		move.w	d3,(a0)+
		move.w	(a0),d3
		add.w	d1,d3
		add.w	#256,d3
		and.w	#$1ff,d3
		sub.w	#256,d3
		move.w	d3,(a0)+
		move.w	(a0),d3
		add.w	d2,d3
		and.w	#$1ff,d3
		move.w	d3,(a0)+
		dbra	d7,FixLoop
		rts

PlotStars:	lea.l	OldAdr,a1
		lea.l	StarAdr,a0
		move.l	Screen,a2
		lea.l	Djup,a3
		lea.l	MulsAdr,a4
		move.w	#352,a5
		move.w	#280,a6
		move.w	#172,d2
		move.w	#140,d4
		move.w	#BMapSize,d1
		move.w	#NumEstrellas,d7

PlotLoop:	move.w	4(a0),d5
		add.w	d5,d5
		move.w	(a3,d5.W),d6
		move.w	(a0)+,d0
		muls	d6,d0
		lsl.l	#4,d0
		swap	d0
		add.w	d2,d0
		muls	(a0)+,d6
		lsl.l	#4,d6
		swap	d6
		add.w	d4,d6
		cmp.w	a6,d6
		bhi.S	NoPlot2
		cmp.w	a5,d0
		bhi.S	NoPlot2
		move.w	d0,d3
		lsr.w	#3,d0
		add.w	d6,d6
		move.w	(a4,d6.W),d6
		add.w	d0,d6
		moveq	#7,d0
		sub.w	d3,d0
		btst	#8,d5
		beq.S	NoPlot1
		bset	d0,(a2,d6.W)
NoPlot1:	add.w	d1,d6
		btst	#9,d5
		beq.S	NoPlot2
		bset	d0,(a2,d6.W)
NoPlot2:	addq.w	#2,a0
		dbra	d7,PlotLoop

		lea.l	$dff000,a6
		rts

FixSpeed:	move.l	XSave,a0
		addq.l	#4,a0
		cmp.w	#60,(a0)
		bne.S	OO1
		move.l	#ZV,XSave
		move.l	XSave,a0

OO1:		move.w	(a0),XAdd
		move.l	a0,XSave
		move.l	YSave,a0
		addq.l	#2,a0
		cmp.w	#60,(a0)
		bne.S	OO2
		move.l	#YV,YSave
		move.l	YSave,a0

OO2:		move.w	(a0),YAdd
		move.l	a0,YSave
		move.l	ZSave,a0
		addq.l	#2,a0
		cmp.w	#60,(a0)
		bne.S	OO3
		move.l	#ZV,ZSave
		move.l	ZSave,a0

OO3:		move.w	(a0),ZAdd
		move.l	a0,ZSave
		rts



XV:		
	dc.w	-4,60

YV:	dc.w	10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,09,09,09,09,09,09,09,09,09
	dc.w	09,09,09,09,09,09,09,09,09,09,09,09,09,08,08,08,08,08,08,08,08,08,08,08,08,08,08,08,08,08,07,07,07,07,07,07,07,07,07,07
	dc.w    07,07,07,06,06,06,06,06,06,06,06,06,06,06,06,05,05,05,05,05,05,05,05,05,05,05,04,04,04,04,04,04,04,04,04,04,03,03,03,03
	dc.w	03,03,03,03,03,03,02,02,02,02,02,02,02,02,02,02,01,01,01,01,01,01,01,01,01,01,00,00,00,00,00,00,00,00,00,00,00,00,00,00
	dc.w	00,00,00,00,00,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4
	dc.w	-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-7,-7,-7
	dc.w	-7,-7,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9
	dc.w	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9
	dc.w	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-7
	dc.w	-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4
	dc.w	-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,00,00,00,00
	dc.w	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,01,01,01,01,01,01,01,01,01,01,02,02,02,02,02,02,02,02,02,02,03,03,03,03,03
	dc.w	03,03,03,03,03,04,04,04,04,04,04,04,04,04,04,05,05,05,05,05,05,05,05,05,05,05,06,06,06,06,06,06,06,06,06,06,06,06,07,07
	dc.w	07,07,07,07,07,07,07,07,07,07,07,08,08,08,08,08,08,08,08,08,08,08,08,08,08,08,08,08,09,09,09,09,09,09,09,09,09,09,09,09
	dc.w	09,09,09,09,09,09,09,09,09,09,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10
	dc.w    60

ZV:	dc.w	00,00,00,00,00,00,00,00,00,00,00,00,00,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3
	dc.w	-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-7
	dc.w	-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9
	dc.w	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9
	dc.w	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8
	dc.w	-8,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5
	dc.w	-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1
	dc.w	-1,-1,-1,-1,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,01,01,01,01,01,01,01,01,01,01,02,02,02,02,02,02,02
	dc.w	02,02,02,03,03,03,03,03,03,03,03,03,03,04,04,04,04,04,04,04,04,04,04,05,05,05,05,05,05,05,05,05,05,05,06,06,06,06,06,06
	dc.w	06,06,06,06,06,06,07,07,07,07,07,07,07,07,07,07,07,07,07,08,08,08,08,08,08,08,08,08,08,08,08,08,08,08,08,08,09,09,09,09
	dc.w	09,09,09,09,09,09,09,09,09,09,09,09,09,09,09,09,09,09,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10
	dc.w	10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,09
	dc.w	09,09,09,09,09,09,09,09,09,09,09,09,09,09,09,09,09,09,09,09,09,08,08,08,08,08,08,08,08,08,08,08,08,08,08,08,08,08,07,07
	dc.w	07,07,07,07,07,07,07,07,07,07,07,06,06,06,06,06,06,06,06,06,06,06,06,05,05,05,05,05,05,05,05,05,05,05,04,04,04,04,04,04
	dc.w	04,04,04,04,03,03,03,03,03,03,03,03,03,03,02,02,02,02,02,02,02,02,02,02,01,01,01,01,01,01,01,01,01,01,00,00,00,00,00,00
	dc.w 	60

;------------------------------------------------------------------------
BlindSpr:	dc.l	0
ZAdd:		dc.w	-8
XAdd:		dc.w	0
YAdd:		dc.w	0

XSave:		dc.l	0
YSave:		dc.l	0
ZSave:		dc.l	0
;------------------------------------------------------------------------
DJUP:
	dc.w    $6a00,$6000,$5a00,$5200,$4d00,$4800,$4400,$4000,$3D12,$3BF4,$3AE0,$39D6,$38D6,$37DE,$36EE,$3606,$3526,$344C,$337A,$32AE,$31E9,$3129,$306F,$2FBA
	DC.W	$2F0B,$2E60,$2DBB,$2D1A,$2C7D,$2BE4,$2B50,$2ABF,$2A32,$29A9,$2923,$28A0,$2821,$27A5,$272B,$26B5,$2641,$25D0,$2562,$24F6,$248C,$2425,$23C0,$235D
	DC.W	$22FD,$229E,$2241,$21E7,$218E,$2137,$20E1,$208E,$203C,$1FEB,$1F9C,$1F4F,$1F03,$1EB9,$1E70,$1E28,$1DE2,$1D9C,$1D59,$1D16,$1CD4,$1C94,$1C55,$1C17
	DC.W	$1BD9,$1B9D,$1B62,$1B28,$1AEF,$1AB7,$1A7F,$1A49,$1A13,$19DF,$19AB,$1978,$1946,$1914,$18E3,$18B3,$1884,$1855,$1827,$17FA,$17CE,$17A2,$1776,$174C
	DC.W	$1721,$16F8,$16CF,$16A7,$167F,$1658,$1631,$160B,$15E5,$15C0,$159B,$1577,$1553,$1530,$150D,$14EA,$14C8,$14A7,$1486,$1465,$1445,$1425,$1405,$13E6
	DC.W	$13C7,$13A9,$138B,$136D,$1350,$1333,$1316,$12FA,$12DE,$12C3,$12A7,$128C,$1271,$1257,$123D,$1223,$1209,$11F0,$11D7,$11BE,$11A6,$118E,$1176,$115E
	DC.W	$1147,$112F,$1118,$1102,$10EB,$10D5,$10BF,$10A9,$1094,$107E,$1069,$1054,$103F,$102B,$1017,$1002,$0FEF,$0FDB,$0FC7,$0FB4,$0FA1,$0F8E,$0F7B,$0F68
	DC.W	$0F56,$0F43,$0F31,$0F1F,$0F0E,$0EFC,$0EEB,$0ED9,$0EC8,$0EB7,$0EA6,$0E96,$0E85,$0E75,$0E64,$0E54,$0E44,$0E34,$0E25,$0E15,$0E06,$0DF6,$0DE7,$0DD8
	DC.W	$0DC9,$0DBA,$0DAC,$0D9D,$0D8F,$0D81,$0D72,$0D64,$0D56,$0D48,$0D3B,$0D2D,$0D20,$0D12,$0D05,$0CF8,$0CEB,$0CDE,$0CD1,$0CC4,$0CB7,$0CAB,$0C9E,$0C92
	DC.W	$0C86,$0C79,$0C6D,$0C61,$0C55,$0C49,$0C3E,$0C32,$0C26,$0C1B,$0C0F,$0C04,$0BF9,$0BEE,$0BE3,$0BD8,$0BCD,$0BC2,$0BB7,$0BAC,$0BA2,$0B97,$0B8D,$0B82
	DC.W	$0B78,$0B6E,$0B64,$0B5A,$0B50,$0B46,$0B3C,$0B32,$0B28,$0B1E,$0B15,$0B0B,$0B02,$0AF8,$0AEF,$0AE6,$0ADC,$0AD3,$0ACA,$0AC1,$0AB8,$0AAF,$0AA6,$0A9D
	DC.W	$0A95,$0A8C,$0A83,$0A7B,$0A72,$0A69,$0A61,$0A59,$0A50,$0A48,$0A40,$0A38,$0A2F,$0A27,$0A1F,$0A17,$0A0F,$0A08,$0A00,$09F8,$09F0,$09E8,$09E1,$09D9
	DC.W	$09D2,$09CA,$09C3,$09BB,$09B4,$09AD,$09A5,$099E,$0997,$0990,$0989,$0981,$097A,$0973,$096C,$0966,$095F,$0958,$0951,$094A,$0943,$093D,$0936,$0930
	DC.W	$0929,$0922,$091C,$0915,$090F,$0909,$0902,$08FC,$08F6,$08EF,$08E9,$08E3,$08DD,$08D7,$08D1,$08CB,$08C5,$08BF,$08B9,$08B3,$08AD,$08A7,$08A1,$089B
	DC.W	$0895,$0890,$088A,$0884,$087F,$0879,$0873,$086E,$0868,$0863,$085D,$0858,$0852,$084D,$0848,$0842,$083D,$0838,$0832,$082D,$0828,$0823,$081E,$0819
	DC.W	$0813,$080E,$0809,$0804,$07FF,$07FA,$07F5,$07F0,$07EB,$07E7,$07E2,$07DD,$07D8,$07D3,$07CE,$07CA,$07C5,$07C0,$07BC,$07B7,$07B2,$07AE,$07A9,$07A4
	DC.W	$07A0,$079B,$0797,$0792,$078E,$0789,$0785,$0781,$077C,$0778,$0774,$076F,$076B,$0767,$0762,$075E,$075A,$0756,$0751,$074D,$0749,$0745,$0741,$073D
	DC.W	$0739,$0735,$0731,$072C,$0728,$0724,$0720,$071D,$0719,$0715,$0711,$070D,$0709,$0705,$0701,$06FD,$06FA,$06F6,$06F2,$06EE,$06EB,$06E7,$06E3,$06DF
	DC.W	$06DC,$06D8,$06D4,$06D1,$06CD,$06CA,$06C6,$06C2,$06BF,$06BB,$06B8,$06B4,$06B1,$06AD,$06AA,$06A6,$06A3,$069F,$069C,$0699,$0695,$0692,$068E,$068B
	DC.W	$0688,$0684,$0681,$067E,$067A,$0677,$0674,$0671,$066D,$066A,$0667,$0664,$0661,$065D,$065A,$0657,$0654,$0651,$064E,$064B,$0648,$0645,$0641,$063E
	DC.W	$063B,$0638,$0635,$0632,$062F,$062C,$0629,$0626,$0623,$0620,$061E,$061B,$0618,$0615,$0612,$060F,$060C,$0609,$0607,$0604,$0601,$05FE,$05FB,$05F8
	DC.W	$05F6,$05F3,$05F0,$05ED,$05EB,$05E8,$05E5,$05E2,$05E0,$05DD,$05DA,$05D8,$05D5,$05D2,$05D0,$05CD,$05CA,$05C8,$05C5,$05C3,$05C0,$05BE,$05BB,$05B8
	DC.W	$05B6,$05B3,$05B1,$05AE,$05AC,$05A9,$05A7,$05A4,$05A2,$059F,$059D,$059A,$0598,$0595,$0593,$0591,$058E,$058C,$0589,$0587,$0585,$0582,$0580,$057D
	DC.W	$057B,$0579,$0576,$0574,$0572,$056F,$056D,$056B,$0569,$0566,$0564,$0562,$055F,$055D,$055B,$0559,$0556,$0554,$0552,$0550,$054E,$054B,$0549,$0547
	DC.W	$0545,$0543,$0541,$053E,$053C,$053A,$0538,$0536,$0534,$0532,$0530,$052D,$052B,$0529,$0527,$0525,$0523,$0521,$051F,$051D,$051B,$0519,$0517,$0515
	DC.W	$0513,$0511,$050F,$050D,$050B,$0509,$0507,$0505,$0503,$0501,$04FF,$04FD,$04FB,$04F9,$04F7,$04F5,$04F3,$04F1,$04F0,$04EE,$04EC,$04EA,$04E8,$04E6
	DC.W	$04E4,$04E2,$04E0,$04DF,$04DD,$04DB,$04D9,$04D7,$04D5,$04D4,$04D2,$04D0,$04CE,$04CC,$04CB,$04C9,$04C7,$04C5,$04C3,$04C2,$04C0,$04BE,$04BC,$04BB
	DC.W	$04B9,$04B7,$04B5,$04B4,$04B2,$04B0,$04AE,$04AD,$04AB,$04A9,$04A8,$04A6,$04A4,$04A3,$04A1,$049F,$049E,$049C,$049A,$0499,$0497,$0495,$0494,$0492
	DC.W	$0490,$048F,$048D,$048C,$048A,$0488,$0487,$0485,$0484,$0482,$0480,$047F,$047D,$047C,$047A,$0478,$0477,$0475,$0474,$0472,$0471,$046F,$046E,$046C
	DC.W	$046B,$0469,$0468,$0466,$0465,$0463,$0461,$0460,$045E,$045D,$045C,$045A,$0459,$0457,$0456,$0454,$0453,$0451,$0450,$044E,$044D,$044B,$044A,$0449
	DC.W	$0447,$0446,$0444,$0443,$0441,$0440,$043F,$043D,$043C,$043A,$0439,$0438,$0436,$0435,$0433,$0432,$0431,$042F,$042E,$042D,$042B,$042A,$0429,$0427
	DC.W	$0426,$0424,$0423,$0422,$0420,$041F,$041E,$041C,$041B,$041A,$0419,$0417,$0416,$0415,$0413,$0412,$0411,$040F,$040E,$040D,$040C,$040A,$0409,$0408
	DC.W	$0406,$0405,$0404,$0403,$0401,$0400,$03FF,$03FE,$03FC,$03FB,$03FA,$03F9,$03F7,$03F6,$03F5,$03F4,$03F3,$03F1,$03F0,$03EF,$03EE,$03ED,$03EB,$03EA
	DC.W	$03E9,$03E8,$03E7,$03E5,$03E4,$03E3,$03E2,$03E1,$03DF,$03DE,$03DD,$03DC,$03DB,$03DA,$03D8,$03D7,$03D6,$03D5,$03D4,$03D3,$03D2,$03D0,$03CF,$03CE
	DC.W	$03CD,$03CC,$03CB,$03CA,$03C9,$03C7,$03C6,$03C5,$03C4,$03C3,$03C2,$03C1,$03C0,$03BF,$03BD,$03BC,$03BB,$03BA,$03B9,$03B8,$03B7,$03B6,$03B5,$03B4
	DC.W	$03B3,$03B2,$03B1,$03AF,$03AE,$03AD,$03AC,$03AB,$03AA,$03A9,$03A8,$03A7,$03A6,$03A5,$03A4,$03A3,$03A2,$03A1,$03A0,$039F,$039E,$039D,$039C,$039B
	DC.W	$039A,$0399,$0398,$0397,$0396,$0395,$0394,$0393,$0392,$0391,$0390,$038F,$038E,$038D,$038C,$038B,$038A,$0389,$0388,$0387,$0386,$0385,$0384,$0383
	DC.W	$0382,$0381,$0380,$037F,$037E,$037D,$037C,$037B,$037A,$0379,$0378,$0378,$0377,$0376,$0375,$0374,$0373,$0372,$0371,$0370,$036F,$036E,$036D,$036C
	DC.W	$036B,$036B,$036A,$0369,$0368,$0367,$0366,$0365,$0364,$0363,$0362,$0362,$0361,$0360,$035F,$035E,$035D,$035C,$035B,$035A,$035A,$0359,$0358,$0357
	DC.W	$0356,$0355,$0354,$0353,$0353,$0352,$0351,$0350,$034F,$034E,$034D,$034D,$034C,$034B,$034A,$0349,$0348,$0347,$0347,$0346,$0345,$0344,$0343,$0342
	DC.W	$0342,$0341,$0340,$033F,$033E,$033E,$033D,$033C,$033B,$033A,$0339,$0339,$0338,$0337,$0336,$0335,$0335,$0334,$0333,$0332,$0331,$0331,$0330,$032F
	DC.W	$032E,$032D,$032D,$032C,$032B,$032A,$0329,$0329,$0328,$0327,$0326,$0326,$0325,$0324,$0323,$0323,$0322,$0321,$0320,$031F,$031F,$031E,$031D,$031C
	DC.W	$031C,$031B,$031A,$0319,$0319,$0318,$0317,$0316,$0316,$0315,$0314,$0313,$0313,$0312,$0311,$0310,$0310,$030F,$030E,$030E,$030D,$030C,$030B,$030B
	DC.W	$030A,$0309,$0308,$0308,$0307,$0306,$0306,$0305,$0304,$0303,$0303,$0302,$0301,$0301,$0300,$02FF,$02FF,$02FE,$02FD,$02FC,$02FC,$02FB,$02FA,$02FA
	DC.W	$02F9,$02F8,$02F8,$02F7,$02F6,$02F6,$02F5,$02F4,$02F3,$02F3,$02F2,$02F1,$02F1,$02F0,$02EF,$02EF,$02EE,$02ED,$02ED,$02EC,$02EB,$02EB,$02EA,$02E9
	DC.W	$02E9,$02E8,$02E7,$02E7,$02E6,$02E5,$02E5,$02E4,$02E3,$02E3,$02E2,$02E2,$02E1,$02E0,$02E0,$02DF,$02DE,$02DE,$02DD,$02DC,$02DC,$02DB,$02DA,$02DA
	DC.W	$02D9,$02D9,$02D8,$02D7,$02D7,$02D6,$02D5,$02D5,$02D4,$02D3,$02D3,$02D2,$02D2,$02D1,$02D0,$02D0,$02CF,$02CF,$02CE,$02CD,$02CD,$02CC,$02CB,$02CB
	DC.W	$02CA,$02CA,$02C9,$02C8,$02C8,$02C7,$02C7,$02C6,$02C5,$02C5,$02C4,$02C4,$02C3,$02C2,$02C2,$02C1,$02C1,$02C0,$02BF,$02BF,$02BE,$02BE,$02BD,$02BD
	DC.W	$02BC,$02BB,$02BB,$02BA,$02BA,$02B9,$02B8,$02B8,$02B7,$02B7,$02B6,$02B6,$02B5,$02B4,$02B4,$02B3,$02B3,$02B2,$02B2,$02B1,$02B0,$02B0,$02AF,$02AF
	DC.W	$02AE,$02AE,$02AD,$02AC,$02AC,$02AB,$02AB,$02AA,$02AA,$02A9,$02A9,$02A8,$02A7,$02A7,$02A6,$02A6,$02A5,$02A5,$02A4,$02A4,$02A3,$02A3,$02A2,$02A1
	DC.W	$02A1,$02A0,$02A0,$029F,$029F,$029E,$029E,$029D,$029D,$029C,$029C,$029B,$029B,$029A,$0299,$0299,$0298,$0298,$0297,$0297,$0296,$0296,$0295,$0295
	DC.W	$0294,$0294,$0293,$0293,$0292,$0292,$0291,$0291,$0290,$0290,$028F,$028F,$028E,$028E,$028D,$028C,$028C,$028B,$028B,$028A,$028A,$0289,$0289,$0288
	DC.W	$0288,$0287,$0287,$0286,$0286,$0285,$0285,$0284,$0284,$0283,$0283,$0282,$0282,$0281,$0281,$0281,$0280,$0280,$027F,$027F,$027E,$027E,$027D,$027D
	DC.W	$027C,$027C,$027B,$027B,$027A,$027A,$0279,$0279,$0278,$0278,$0277,$0277,$0276,$0276,$0275,$0275,$0274,$0274,$0274,$0273,$0273,$0272,$0272,$0271
	DC.W	$0271,$0270,$0270,$026F,$026F,$026E,$026E,$026D,$026D,$026D,$026C,$026C,$026B,$026B,$026A,$026A,$0269,$0269,$0268,$0268,$0268,$0267,$0267,$0266
	DC.W	$0266,$0265,$0265,$0264,$0264,$0264,$0263,$0263,$0262,$0262,$0261,$0261,$0260,$0260,$0260,$025F,$025F,$025E,$025E,$025D,$025D,$025C,$025C,$025C
	DC.W	$025B,$025B,$025A,$025A,$0259,$0259,$0259,$0258,$0258,$0257,$0257,$0256,$0256,$0256,$0255,$0255,$0254,$0254,$0253,$0253,$0253,$0252,$0252,$0251
	DC.W	$0251,$0250,$0250,$0250,$024F,$024F,$024E,$024E,$024E,$024D,$024D,$024C,$024C,$024B,$024B,$024B,$024A,$024A,$0249,$0249,$0249,$0248,$0248,$0247
	DC.W	$0247,$0247,$0246,$0246,$0245,$0245,$0245,$0244,$0244,$0243,$0243,$0243,$0242,$0242,$0241,$0241,$0241,$0240,$0240,$023F,$023F,$023F,$023E,$023E
	DC.W	$023D,$023D,$023D,$023C,$023C,$023B,$023B,$023B,$023A,$023A,$023A,$0239,$0239,$0238,$0238,$0238,$0237,$0237,$0236,$0236,$0236,$0235,$0235,$0235
	DC.W	$0234,$0234,$0233,$0233,$0233,$0232,$0232,$0231,$0231,$0231,$0230,$0230,$0230,$022F,$022F,$022E,$022E,$022E,$022D,$022D,$022D,$022C,$022C,$022C
	DC.W	$022B,$022B,$022A,$022A,$022A,$0229,$0229,$0229,$0228,$0228,$0228,$0227,$0227,$0226,$0226,$0226,$0225,$0225,$0225,$0224,$0224,$0224,$0223,$0223
	DC.W	$0222,$0222,$0222,$0221,$0221,$0221,$0220,$0220,$0220,$021F,$021F,$021F,$021E,$021E,$021E,$021D,$021D,$021C,$021C,$021C,$021B,$021B,$021B,$021A
	DC.W	$021A,$021A,$0219,$0219,$0219,$0218,$0218,$0218,$0217,$0217,$0217,$0216,$0216,$0216,$0215,$0215,$0215,$0214,$0214,$0214,$0213,$0213,$0213,$0212
	DC.W	$0212,$0212,$0211,$0211,$0211,$0210,$0210,$0210,$020F,$020F,$020F,$020E,$020E,$020E,$020D,$020D,$020D,$020C,$020C,$020C,$020B,$020B,$020B,$020A
	DC.W	$020A,$020A,$0209,$0209,$0209,$0208,$0208,$0208,$0207,$0207,$0207,$0206,$0206,$0206,$0205,$0205,$0205,$0204,$0204,$0204,$0204,$0203,$0203,$0203
	DC.W	$0202,$0202,$0202,$0201,$0201,$0201,$0200,$0200,$0200,$01FF,$01FF,$01FF,$01FE,$01FE,$01FE,$01FE,$01FD,$01FD,$01FD,$01FC,$01FC,$01FC,$01FB,$01FB
	DC.W	$01FB,$01FA,$01FA,$01FA,$01FA,$01F9,$01F9,$01F9,$01F8,$01F8,$01F8,$01F7,$01F7,$01F7,$01F7,$01F6,$01F6,$01F6,$01F5,$01F5,$01F5,$01F4,$01F4,$01F4
	DC.W	$01F4,$01F3,$01F3,$01F3,$01F2,$01F2,$01F2,$01F1,$01F1,$01F1,$01F1,$01F0,$01F0,$01F0,$01EF,$01EF,$01EF,$01EF,$01EE,$01EE,$01EE,$01ED,$01ED,$01ED
	DC.W	$01EC,$01EC,$01EC,$01EC,$01EB,$01EB,$01EB,$01EA,$01EA,$01EA,$01EA,$01E9,$01E9,$01E9,$01E8,$01E8,$01E8,$01E8,$01E7,$01E7,$01E7,$01E6,$01E6,$01E6
	DC.W	$01E6,$01E5,$01E5,$01E5,$01E4,$01E4,$01E4,$01E4,$01E3,$01E3,$01E3,$01E3,$01E2,$01E2,$01E2,$01E1,$01E1,$01E1,$01E1,$01E0,$01E0,$01E0,$01DF,$01DF
	DC.W	$01DF,$01DF,$01DE,$01DE,$01DE,$01DE,$01DD,$01DD,$01DD,$01DC,$01DC,$01DC,$01DC,$01DB,$01DB,$01DB,$01DB,$01DA,$01DA,$01DA,$01DA,$01D9,$01D9,$01D9
	DC.W	$01D8,$01D8,$01D8,$01D8,$01D7,$01D7,$01D7,$01D7,$01D6,$01D6,$01D6,$01D6,$01D5,$01D5,$01D5,$01D4,$01D4,$01D4,$01D4,$01D3,$01D3,$01D3,$01D3,$01D2
	DC.W	$01D2,$01D2,$01D2,$01D1,$01D1,$01D1,$01D1,$01D0,$01D0,$01D0,$01D0,$01CF,$01CF,$01CF,$01CF,$01CE,$01CE,$01CE,$01CE,$01CD,$01CD,$01CD,$01CD,$01CC
	DC.W	$01CC,$01CC,$01CB,$01CB,$01CB,$01CB,$01CA,$01CA,$01CA,$01CA,$01C9,$01C9,$01C9,$01C9,$01C8,$01C8,$01C8,$01C8,$01C7,$01C7,$01C7,$01C7,$01C6,$01C6
	DC.W	$01C6,$01C6,$01C6,$01C5,$01C5,$01C5,$01C5,$01C4,$01C4,$01C4,$01C4,$01C3,$01C3,$01C3,$01C3,$01C2,$01C2,$01C2,$01C2,$01C1,$01C1,$01C1,$01C1,$01C0
	DC.W	$01C0,$01C0,$01C0,$01BF,$01BF,$01BF,$01BF,$01BE,$01BE,$01BE,$01BE,$01BE,$01BD,$01BD,$01BD,$01BD,$01BC,$01BC,$01BC,$01BC,$01BB,$01BB,$01BB,$01BB
	DC.W	$01BA,$01BA,$01BA,$01BA,$01BA,$01B9,$01B9,$01B9,$01B9,$01B8,$01B8,$01B8,$01B8,$01B7,$01B7,$01B7,$01B7,$01B7,$01B6,$01B6,$01B6,$01B6,$01B5,$01B5
	DC.W	$01B5,$01B5,$01B4,$01B4,$01B4,$01B4,$01B4,$01B3,$01B3,$01B3,$01B3,$01B2,$01B2,$01B2,$01B2,$01B2,$01B1,$01B1,$01B1,$01B1,$01B0,$01B0,$01B0,$01B0
	DC.W	$01B0,$01AF,$01AF,$01AF,$01AF,$01AE,$01AE,$01AE,$01AE,$01AE,$01AD,$01AD,$01AD,$01AD,$01AC,$01AC,$01AC,$01AC,$01AC,$01AB,$01AB,$01AB,$01AB,$01AA
	DC.W	$01AA,$01AA,$01AA,$01AA,$01A9,$01A9,$01A9,$01A9,$01A9,$01A8,$01A8,$01A8,$01A8,$01A7,$01A7,$01A7,$01A7,$01A7,$01A6,$01A6,$01A6,$01A6,$01A6,$01A5
	DC.W	$01A5,$01A5,$01A5,$01A4,$01A4,$01A4,$01A4,$01A4,$01A3,$01A3,$01A3,$01A3,$01A3,$01A2,$01A2,$01A2,$01A2,$01A2,$01A1,$01A1,$01A1,$01A1,$01A1,$01A0
	DC.W	$01A0,$01A0,$01A0,$019F,$019F,$019F,$019F,$019F,$019E,$019E,$019E,$019E,$019E,$019D,$019D,$019D,$019D,$019D,$019C,$019C,$019C,$019C,$019C,$019B
	DC.W	$019B,$019B,$019B,$019B,$019A,$019A,$019A,$019A,$019A,$0199,$0199,$0199,$0199,$0199,$0198,$0198,$0198,$0198,$0198,$0197,$0197,$0197,$0197,$0197
	DC.W	$0197,$0197,$0197,$0197,$0197,$0197,$0197,$0197,$0197,$0197,$0197,$0197,$0196,$0196,$0196,$0196,$0196,$0196,$0196,$0196,$0196,$0196,$0196,$0196
	DC.W	$0196,$0196,$0196,$0196,$0196,$0196,$0196,$0196,$0196,$0196,$0196,$0196,$0196,$0196,$0196,$0196


