
***********************************************************

SCREEN_WIDTH		EQU	30
SCREEN_HEIGHT		EQU	200
RASTER_POS		EQU	$2c4dfffe

BOX_WIDTH		EQU	256
BOX_HEIGHT		EQU	256

USE_INTERRUPT
;USE_68020
COPMEMSIZE		EQU	112+(((4*SCREEN_WIDTH)+8)*SCREEN_HEIGHT)

***********************************************************
*	Main routine					  *
***********************************************************

Start:		
	bsr.w	CreateCopperList	; Create copper list in chip memory
	;move.l	#CopperList,cop1lch+CustomBase	; Install copperlist
	move.l	#buffer_general_1,cop1lch+CustomBase	; Install copperlist

	rts

Main:
	bsr.b	Chunky2Copper
	rts
***********************************************************

Chunky2Copper:		
	lea	AngleZoom(pc),a0
	addq.w	#1,(a0)			; AngleZoom += 0.5
	cmpi.w	#719,(a0)		; if AngleZoom = 360 
	bls.b	.NoAngleReset
	clr.w	(a0)			; then AngleZoom = 0
.NoAngleReset:
	move.w	(a0),d0			; Get integer part of angleZoom
	lea	SineData(pc),a0
	and.w	#$fffe,d0		; same as d0 = d0 / 2 * 2
	lea	CosineData(pc),a1
	move.w	0(a0,d0.w),d3		; d3 = Sin(AngleZoom)
	move.w	0(a1,d0.w),d4		; d4 = Cos(AngleZoom)

	move.w	d3,d5
	cmpi.w	#359,AngleZoom
	bls.s	.NoNegative
	move.w	#$ffff,d5
	sub.w	d3,d5
.NoNegative: 	
	lsr.w	#2,d5
	
	move.w	#BOX_WIDTH,d0		; Initialise map values
	muls.w	d5,d0
	lsr.l	#6,d0
	move.w	d0,Ax			
	
	move.w	#BOX_HEIGHT,d0
	muls.w	d5,d0
	lsr.l	#6,d0
	move.w	d0,Ay
	
	move.w	#BOX_WIDTH,d0		; Initialise map values
	muls.w	d5,d0
	lsr.l	#6,d0
	move.w	d0,Bx			
	
	move.w	#-BOX_HEIGHT,d0
	muls.w	d5,d0
	lsr.l	#6,d0
	move.w	d0,By
	
	move.w	#-BOX_WIDTH,d0		; Initialise map values
	muls.w	d5,d0
	lsr.l	#6,d0
	move.w	d0,d6			
	
	move.w	#BOX_HEIGHT,d0
	muls.w	d5,d0
	lsr.l	#6,d0
	move.w	d0,d7

	move.w	d4,d0			; Ax = (Ax * Cos - Ay * Sin)
	muls.w	Ax(pc),d0
	lsr.l	#8,d0
	move.w	d3,d1
	muls.w	Ay(pc),d1
	lsr.l	#8,d1
	sub.w	d1,d0
	move.w	d0,d2

	move.w	d3,d0			; Ay = (Ax * Sin + Ay * Cos)
	muls.w	Ax(pc),d0
	lsr.l	#8,d0
	move.w	d4,d1
	muls.w	Ay(pc),d1
	lsr.l	#8,d1
	add.w	d1,d0
	move.w	d0,Ay

	move.w	d2,Ax

	move.w	d4,d0			; Bx = (Bx * Cos - By * Sin)
	muls.w	Bx(pc),d0
	lsr.l	#8,d0
	move.w	d3,d1
	muls.w	By(pc),d1
	lsr.l	#8,d1
	sub.w	d1,d0
	move.w	d0,d2

	move.w	d3,d0			; By = (Bx * Sin + By * Cos)
	muls.w	Bx(pc),d0
	lsr.l	#8,d0
	move.w	d4,d1
	muls.w	By(pc),d1
	lsr.l	#8,d1
	add.w	d1,d0
	move.w	d0,By

	move.w	d2,Bx

	move.w	d4,d0			; Cx = (Cx * Cos - Cy * Sin)
	muls.w	d6,d0
	lsr.l	#8,d0
	move.w	d3,d1
	muls.w	d7,d1
	lsr.l	#8,d1
	sub.w	d1,d0
	move.w	d0,d2
	 
	move.w	d3,d0			; Cy = (Cx * Sin + Cy * Cos)
	muls.w	d6,d0
	lsr.l	#8,d0
	move.w	d4,d1
	muls.w	d7,d1
	lsr.l	#8,d1
	add.w	d1,d0
	move.w	d0,d7

	move.w	d2,d6

	move.w	Bx(pc),d0		; Delta BAx
	sub.w	Ax(pc),d0
	move.w	d0,d4

	move.w	By(pc),d0		; Delta BAy
	sub.w	Ay(pc),d0
	move.w	d0,d5

	move.w	d6,d0			; Delta CAx
	sub.w	Ax(pc),d0
	move.w	d0,CAx

	move.w	d7,d0			; Delta CAy
	sub.w	Ay(pc),d0
	move.w	d0,CAy

	;lea	CopperList+106,a0	; Set the pointer to the first pixel
	lea buffer_general_1+106,a0
; Chunky2Copper and rotozoom routine loop, this routine is optimized
; to dont access to memory (except for texture and copper list).

; d0 / d1 - Internal calculations
; d2 / d3 - PixelX and PixelY
; d4 / d5 - Delta BAx and Delta BAy
; d6 / d7 - Temporal Cx and Cy

	move.w	#SCREEN_HEIGHT-1,d3	; height - 1

	move.w	Ax(pc),a1
	move.w	Ay(pc),a2

	move.w	#7,lcount

.NextY:		
	move.w	a1,d6			; Cx (d6) = Ax 
	move.w	a2,d7			; Cy (d7) = Ay

	; Note: the loop has been unrolled 2 times (SCREEN_WIDTH must be even)

	moveq	#SCREEN_WIDTH/2-1,d2	; width
	
	lea	lineStore(pc),a3

	move.w	lcount,d1
	cmpi.w	#7,d1
	beq.s	.NextX
.copyNextX:
	move.w	(a3),(a0)
	move.w	4(a3),4(a0)
	lea	8(a0),a0		; Next pixel * 2
	lea	8(a3),a3
	dbf	d2,.copyNextX
	bne.s	.endScanLine

.NextX:
	add.w	d4,d6			; Cx += BAx
	add.w	d5,d7			; Cy += BAy
	move.w	d6,d1
	move.w	d7,d0
	lsr.w	#8,d1			; Offset (d0) = ((((Cy >> 8) & 31) * 32) + ((Cx >> 8) & 31)) * 2
	lsr.w	#8-5,d0
	and.w	#$1f,d1
	and.w	#$1f<<5,d0
	or.w	d1,d0
	IFD	USE_68020
	move.w	Texture(pc,d0.w*2),(a0)	; Write texture color on copper list
	ENDC
	IFND	USE_68020
	add.w	d0,d0
	move.w	Texture(pc,d0.w),(a0)	; Write texture color on copper list
	ENDC

	add.w	d4,d6			; Cx += BAx
	add.w	d5,d7			; Cy += BAy
	move.w	d6,d1
	move.w	d7,d0
	lsr.w	#8,d1			; Offset (d0) = ((((Cy >> 8) & 31) * 32) + ((Cx >> 8) & 31)) * 2
	lsr.w	#8-5,d0
	and.w	#$1f,d1
	and.w	#$1f<<5,d0
	or.w	d1,d0
	IFD	USE_68020
	move.w	Texture(pc,d0.w*2),4(a0) ; Write texture color on copper list
	ENDC
	IFND	USE_68020
	add.w	d0,d0
	move.w	Texture(pc,d0.w),4(a0)	; Write texture color on copper list
	ENDC
	
	move.w	(a0),(a3)
	move.w	4(a0),4(a3)

	lea	8(a0),a0		; Next pixel * 2
	lea	8(a3),a3
	dbf	d2,.NextX
.endScanLine:
	addq.l	#8,a0			; Skip end of line
		
	move.w	lcount,d1
	dbf	d1,.repeat

	add.w	CAx(pc),a1		; Ax += CAx
	add.w	CAy(pc),a2		; Ay += CAy

	moveq	#7,d1
.repeat
	move.w	d1,lcount
	dbf	d3,.NextY
	rts

	; Located here so that the code above can reach it directly.

	CNOP	0,4
Texture:	
		
	incbin  "CF0:IntroBirraRutinas/BackToFuture/Data/Rec_Rotozoom/chunky1.chk"

	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0ca9,$0b86,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fee,$0521,$0a76,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0efe,$0ddb,$0bb8,$08a5,$0785,$0685,$0a97,$0dbb,$0dcb,$0fee,$0ecc,$0ea9,$0eaa,$0966,$0510,$0ca9,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0ffe,$08a6,$0481,$0792,$0581,$0360,$0130,$0685,$0fff,$0fff,$0ecb,$0c43,$0d43,$0e54,$0c54,$0721,$0611,$0d75,$0d75,$0e76,$0e98,$0fed,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0ddc,$0582,$0360,$0360,$0360,$0350,$0130,$0030,$0cdc,$0fff,$0daa,$0c32,$0d32,$0d43,$0c54,$0932,$0932,$0732,$0b74,$0c65,$0e65,$0e54,$0d43,$0ebb,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0cdb,$0361,$0250,$0360,$0360,$0250,$0120,$0120,$0240,$0ded,$0ecc,$0c32,$0d32,$0e54,$0e54,$0e43,$0b42,$0921,$0a32,$0b53,$0d54,$0e54,$0f54,$0e54,$0d43,$0ecc,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0ded,$0471,$0360,$0470,$0360,$0370,$0250,$0130,$0240,$0251,$0fff,$0b43,$0b11,$0c22,$0e54,$0e44,$0e43,$0d33,$0d32,$0d32,$0d32,$0e53,$0e43,$0e43,$0d44,$0c22,$0c54,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0684,$0360,$0470,$0581,$0480,$0370,$0370,$0350,$0240,$0563,$0daa,$0a00,$0a00,$0b00,$0b11,$0c22,$0c32,$0c32,$0c32,$0c32,$0c32,$0c32,$0d43,$0c32,$0c21,$0b10,$0b21,$0ecc,$0fff
	dc.w	$0fff,$0fff,$0ab8,$0350,$0360,$0370,$0480,$0681,$0480,$0481,$0470,$0350,$0bca,$0b55,$0900,$0900,$0900,$0a00,$0a00,$0a00,$0a00,$0a00,$0a00,$0b00,$0b00,$0b10,$0b00,$0a00,$0a00,$0a10,$0c87,$0fff
	dc.w	$0fff,$0fff,$0462,$0360,$0360,$0360,$0470,$0471,$0471,$0470,$0581,$07a4,$0fff,$0922,$0800,$0800,$0800,$0800,$0900,$0900,$0900,$0900,$0900,$0900,$0a00,$0a00,$0900,$0900,$0900,$0900,$0b44,$0fff
	dc.w	$0fff,$0eed,$0250,$0350,$0370,$0360,$0360,$0360,$0360,$0360,$0471,$0bc9,$0fff,$0811,$0700,$0700,$0700,$0700,$0800,$0800,$0800,$0800,$0800,$0800,$0900,$0900,$0900,$0900,$0900,$0900,$0a33,$0fff
	dc.w	$0fff,$0cdc,$0360,$0471,$0370,$0360,$0350,$0360,$0360,$0471,$0bc9,$0fff,$0fff,$0922,$0800,$0700,$0600,$0600,$0600,$0700,$0700,$0700,$0800,$0800,$0800,$0800,$0800,$0800,$0800,$0800,$0a43,$0fff
	dc.w	$0fff,$0cdb,$0481,$0581,$0481,$0470,$0360,$0470,$0693,$0dec,$0fff,$0fff,$0fff,$0a55,$0800,$0700,$0600,$0600,$0600,$0600,$0700,$0700,$0800,$0800,$0800,$0800,$0800,$0800,$0800,$0800,$0b65,$0fff
	dc.w	$0fff,$0ddb,$0591,$0481,$0581,$0581,$0692,$0cda,$0fff,$0fff,$0fff,$0fff,$0fff,$0c99,$0911,$0800,$0600,$0600,$0600,$0600,$0700,$0800,$0800,$0900,$0910,$0900,$0900,$0800,$0800,$0810,$0ca9,$0fff
	dc.w	$0fff,$0dec,$0692,$09b7,$0eec,$0ffe,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0edd,$0b44,$0921,$0800,$0700,$0600,$0700,$0800,$0800,$0910,$0911,$0911,$0911,$0910,$0800,$0800,$0932,$0fee,$0fff
	dc.w	$0fff,$0ddc,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0c88,$0c76,$0921,$0800,$0800,$0800,$0800,$0900,$0911,$0911,$0911,$0911,$0910,$0910,$0921,$0c99,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fee,$0d98,$0c76,$0a22,$0900,$0800,$0800,$0900,$0910,$0910,$0910,$0911,$0910,$0921,$0b66,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fee,$0eba,$0c87,$0a22,$0900,$0900,$0900,$0900,$0900,$0910,$0910,$0922,$0c87,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fee,$0ecb,$0c76,$0a21,$0a11,$0a11,$0a11,$0911,$0921,$0a44,$0dbb,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fee,$0eba,$0d98,$0d98,$0d98,$0c88,$0ecb,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff
	dc.w	$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff,$0fff

***********************************************************

CreateCopperList:
	lea	CopperHeader(pc),a0
	;lea	CopperList,a1
	lea buffer_general_1,a1
	moveq	#25-1,d0
.CopyByte1:	
	move.l	(a0)+,(a1)+
	dbf	d0,.CopyByte1		; Copy header of copper list

	move.l	#RASTER_POS-$01000000,d2 ; Initial raster position

	move.w	#SCREEN_HEIGHT-1,d1

.NextByteLine:	
	add.l	#$01000000,d2		; 
	move.l	d2,(a1)+		; Write next WAIT copper instruction (next vert. line)

	moveq	#SCREEN_WIDTH-1,d0

.CopyByte2:	
	move.l	#$01800bbb,(a1)+	; Write 30 bytes of each vertical line
	dbf	d0,.CopyByte2

	move.l	#$01800000,(a1)+	; End of the horizontal line, set color black
	dbf	d1,.NextByteLine

	add.l	#$01000000,d2
	move.l	d2,(a1)+

	moveq	#-2,d0			; d0 = $fffffffe
	move.l	d0,(a1)+		; End of copper list
	move.l	d0,(a1)

	rts				; Done

***********************************************************

InstallSprites:	
	lea	SpritePtrs,a0
	lea	NullSprite,a1
	move.l	a1,d0
	moveq	#4-1,d1
.clr	
	clr.l	(a1)+
	dbf	d1,.clr
	move.w  d0,6(a0)
	move.w  d0,14(a0)
	move.w  d0,22(a0)
	move.w  d0,30(a0)
	move.w  d0,38(a0)
	move.w  d0,46(a0)
	move.w  d0,54(a0)
	move.w  d0,62(a0)
	swap    d0
	move.w  d0,2(a0)
	move.w  d0,10(a0)
	move.w  d0,18(a0)
	move.w  d0,26(a0)
	move.w  d0,34(a0)
	move.w  d0,42(a0)
	move.w  d0,50(a0)
	move.w  d0,58(a0)
	rts

***********************************************************
*	Constant Data					  *
***********************************************************

	CNOP	0,4
SineData:	
	dc.l	$00000004,$0008000D,$00110016,$001A001F,$00230028,$002C0030,$00350039
 	dc.l	$003D0042,$0046004A,$004F0053,$0057005B,$005F0064,$0068006C,$00700074
 	dc.l	$0078007C,$00800083,$0087008B,$008F0092,$0096009A,$009D00A1,$00A400A7
 	dc.l	$00AB00AE,$00B100B5,$00B800BB,$00BE00C1,$00C400C6,$00C900CC,$00CF00D1
 	dc.l	$00D400D6,$00D900DB,$00DD00DF,$00E200E4,$00E600E8,$00E900EB,$00ED00EE
 	dc.l	$00F000F2,$00F300F4,$00F600F7,$00F800F9,$00FA00FB,$00FC00FC,$00FD00FE
 	dc.l	$00FE00FF,$00FF00FF,$00FF00FF

CosineData:	
	dc.l	$010000FF,$00FF00FF,$00FF00FF,$00FE00FE,$00FD00FC,$00FC00FB,$00FA00F9
	dc.l	$00F800F7,$00F600F4,$00F300F2,$00F000EE,$00ED00EB,$00E900E8,$00E600E4
	dc.l	$00E200DF,$00DD00DB,$00D900D6,$00D400D1,$00CF00CC,$00C900C6,$00C400C1
	dc.l	$00BE00BB,$00B800B5,$00B100AE,$00AB00A7,$00A400A1,$009D009A,$00960092
	dc.l	$008F008B,$00870083,$007F007C,$00780074,$0070006C,$00680064,$005F005B
	dc.l	$00570053,$004F004A,$00460042,$003D0039,$00350030,$002C0028,$0023001F
	dc.l	$001A0016,$0011000D,$00080004,$FFFFFFFB,$FFF7FFF2,$FFEEFFE9,$FFE5FFE0
	dc.l	$FFDCFFD7,$FFD3FFCF,$FFCAFFC6,$FFC2FFBD,$FFB9FFB5,$FFB0FFAC,$FFA8FFA4
	dc.l	$FFA0FF9B,$FF97FF93,$FF8FFF8B,$FF87FF83,$FF7FFF7C,$FF78FF74,$FF70FF6D
	dc.l	$FF69FF65,$FF62FF5E,$FF5BFF58,$FF54FF51,$FF4EFF4A,$FF47FF44,$FF41FF3E
	dc.l	$FF3BFF39,$FF36FF33,$FF30FF2E,$FF2BFF29,$FF26FF24,$FF22FF20,$FF1DFF1B
	dc.l	$FF19FF17,$FF16FF14,$FF12FF11,$FF0FFF0D,$FF0CFF0B,$FF09FF08,$FF07FF06
	dc.l	$FF05FF04,$FF03FF03,$FF02FF01,$FF01FF00,$FF00FF00,$FF00FF00,$FF00FF00
	dc.l	$FF00FF00,$FF00FF00,$FF01FF01,$FF02FF03,$FF03FF04,$FF05FF06,$FF07FF08
	dc.l	$FF09FF0B,$FF0CFF0D,$FF0FFF11,$FF12FF14,$FF16FF17,$FF19FF1B,$FF1DFF20
	dc.l	$FF22FF24,$FF26FF29,$FF2BFF2E,$FF30FF33,$FF36FF39,$FF3BFF3E,$FF41FF44
	dc.l	$FF47FF4A,$FF4EFF51,$FF54FF58,$FF5BFF5E,$FF62FF65,$FF69FF6D,$FF70FF74
	dc.l	$FF78FF7C,$FF80FF83,$FF87FF8B,$FF8FFF93,$FF97FF9B,$FFA0FFA4,$FFA8FFAC
	dc.l	$FFB0FFB5,$FFB9FFBD,$FFC2FFC6,$FFCAFFCF,$FFD3FFD7,$FFDCFFE0,$FFE5FFE9
	dc.l	$FFEEFFF2,$FFF7FFFB,$00000004,$0008000D,$00110016,$001A001F,$00230028
	dc.l	$002C0030,$00350039,$003D0042,$0046004A,$004F0053,$0057005B,$005F0064
	dc.l	$0068006C,$00700074,$0078007C,$00800083,$0087008B,$008F0092,$0096009A
	dc.l	$009D00A1,$00A400A7,$00AB00AE,$00B100B5,$00B800BB,$00BE00C1,$00C400C6
	dc.l	$00C900CC,$00CF00D1,$00D400D6,$00D900DB,$00DD00DF,$00E200E4,$00E600E8
	dc.l	$00E900EB,$00ED00EE,$00F000F2,$00F300F4,$00F600F7,$00F800F9,$00FA00FB
 	dc.l	$00FC00FC,$00FD00FE,$00FE00FF,$00FF00FF,$00FF00FF
 
***********************************************************
*	Modified Data					  *
***********************************************************

		CNOP	0,4

lcount:		ds.w	1
lineStore:	ds.w	60
Ax:	ds.w    1
Ay: ds.w    1
Bx: ds.w    1
By: ds.w    1
Cx: ds.w    1
Cy: ds.w    1

CAx: ds.w    1
CAy: ds.w    1

AngleZoom: 
	ds.w    1

		CNOP	0,4
CopperHeader:	
	dc.w	$0100,$0000,$0102,$0000,$0104,$0000,$0108,$0000,$010a,$0000
	dc.w	$008e,$2d81,$0090,$f4c1,$0092,$0038,$0094,$00d0
SpritePtrs:	
	dc.w	$0120,$0000,$0122,$0000,$0124,$0000,$0126,$0000,$0128,$0000
	dc.w	$012a,$0000,$012c,$0000,$012e,$0000,$0130,$0000,$0132,$0000
	dc.w	$0134,$0000,$0136,$0000,$0138,$0000,$013a,$0000,$013c,$0000
	dc.w	$013e,$0000

***********************************************************

		section DemoChipBBS,BSS_C

NullSprite:	ds.l	4

;CopperList:	ds.b	COPMEMSIZE
