BTF3_Num_Planos_PlayField_1 = 3
BTF3_Num_Planos_PlayField_2 = 2
BTF3_Ancho_PlayField_1 = 40
BTF3_Ancho_PlayField_2 = 40
BTF3_Altura_PlayField_1 = 256
BTF3_Altura_PlayField_2 = 256

BTF3_BobNo		= 20
BTF3_Max_Bobs   = 200
BTF3_XSpeed		= 1
BTF3_YSpeed		= 1

BTF3_XSpace		= 5
BTF3_YSpace		= 7
BTF3_AltoNota	= 13

;1322  con iguales al final
;con igual las velocidades, circulo
;
;1 2 15 15 con 17
;3 2 15  5 con 40
;2 3  7  5 con 40
;2 3  5  7 con 128
;5 3  5  7 con 128

;--------------------------------------------------------------
; Inicializacion de la rutina. Se invoca una vez.
;--------------------------------------------------------------
BTF3_Init:
	;-------------------------------------------------------------------------------------
	; Descomprimir los graficos
	;-------------------------------------------------------------------------------------	

	;lea BTF3_Fondo_stc,a1
	;lea Buffer_General_11,a0	
	;jsr decrunch	

	bsr 	BTF3_Genera_Coordenadas

	move.l	BTF3_CurScrn,d0
	bsr		BTF3_Insert_PlayField2
	
	;move.l	#Buffer_General_11,d0
	move.l	#BTF3_Fondo,d0

	lea 	BTF3_PlayField_1,a0

	REPEAT d1,BTF3_Num_Planos_PlayField_1 TIMES
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		move.w	d0,6(a0)
	
		add.l	#8,a0
		add.l 	#BTF3_Ancho_PlayField_1,d0
	END_REPEAT	

	move.l  #BTF3_CopperList,Cop1lch+CustomBase
	clr.w 	CopJmp1+CustomBase

	rts

;--------------------------------------------------------------
; Rutina. invocada desde el VBG.
;--------------------------------------------------------------
BTF3_Run:

	bsr.b	BTF3_Swap_Buffers	
	bsr.b	BTF3_Draw_Bobs

	rts

;--------------------------------------------------------------
; Rutina para la gestion del doble buffer del playfield 2.
;--------------------------------------------------------------
BTF3_Swap_Buffers:	

	movem.l	BTF3_CurScrn,d0/d1
	exg.l	d0,d1
	movem.l	d0/d1,BTF3_CurScrn

BTF3_Insert_PlayField2:	

	lea 	BTF3_PlayField_2,a0
	clear 	d1
	REPEAT d1,BTF3_Num_Planos_PlayField_2 TIMES
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		move.w	d0,6(a0)
		
		add.l	#8,a0
		add.l 	#BTF3_Ancho_PlayField_2,d0
	END_REPEAT
	clr.w 	CopJmp1+CustomBase
	rts

BTF3_Genera_Coordenadas:
	
	lea BTF3_Coordenadas_Bob,a0
	clear d1

	REPEAT d0,BTF3_Max_Bobs TIMES
	
		move.w 	#BTF3_XSpace,d2
		move.w 	#BTF3_YSpace,d3

		mulu.w 	d1,d2
		mulu.w 	d1,d3
		add.w 	#64,d3
		move.w  d2,(a0)+
		move.w  d3,(a0)+

		addq 	#1,d1

	END_REPEAT
	
	rts

;--------------------------------------------------------------
; Pintado del playfield 2.
;--------------------------------------------------------------
BTF3_Draw_Bobs					;Borrado del frame
	;--------------------------------------------------------------
	; Borrado del frame backbuffer.
	;--------------------------------------------------------------
	gblWaitBlitter
	move.l	#$01000000,BltCon0+CustomBase	;BltCon0
	move.l	#$00000000,BltCon1+CustomBase	;BltCon1

	move.w	#$0000,BltDMod+CustomBase 		;bltDMod
	move.l	BTF3_WrkScrn,BltDPTH+CustomBase	;BltDPth
	move.w	#BTF3_Altura_PlayField_2*BTF3_Num_Planos_PlayField_2<<6+(BTF3_Ancho_PlayField_2/2),BltSize+CustomBase 	;199x(20x16)

	gblWaitBlitter

	move.l	#$ffffffff,BltAFwm+CustomBase	;Mask Bltafwm y BltALwm
	move.l	#$00240000,BltCMod+CustomBase	;Modulos C y B 
	move.l	#$00000024,BltAMod+CustomBase	;Modulos A y D

	move.l	BTF3_SpeedX,d0
	lea		BTF3_Coordenadas_Bob,a0
	lea		SinTble,a1

	move.l	BTF3_WrkScrn,a2

	REPEAT d7,BTF3_BobNo TIMES
		add.l	d0,(a0)				;suma speedx y speedy
		and.l	#$01ff00ff,(a0) 	;limitamos a 255 x e y

		moveq	#0,d1
		moveq	#0,d2

		move.w	(a0),d1
		move.b	(a1,d1.w),d1 		;sin(x)+64
		add.w 	#48,d1
		and.l	#$000000ff,d1

		move.w	2(a0),d2
		move.b	(a1,d2.w),d2 		;sin(y)   a1
		and.l	#$000000ff,d2

		move.w	d1,d3 			;copia de x
		and.w	#$f,d1			;limite 4 bits
		ror.w	#4,d1			;los ponemos los primeros

		gblWaitBlitter
		move.w	d1,BltCon1+CustomBase 		;Desplazamiento B
		
		or.w	#$0fca,d1
		move.w	d1,BltCon0+CustomBase 		;Desplazamiento A
		
		lsr.w	#3,d3			;x/8
		lea		(a2,d3.w),a3 		;Pos pantalla debida a x
		move.w	d2,d3			;d2=y
		lsl.w	#3,d2			;y*8
		lsl.w	#5,d3			;y*32
		add.w	d3,d2 			;d2=y*40*2 (bytes por linea)
		lsl.w	#1,d2
		lea		(a3,d2.w),a3 		;posicion para pintar el bob

		move.l	#$ffffffff,BltAFwm+CustomBase	;Mask Bltafwm y BltALwm
		move.l	#$00240000,BltCMod+CustomBase	;Modulos C y B 
		move.l	#$00000024,BltAMod+CustomBase	;Modulos A y D
		move.l	#BTF3_BobMask,BltBPtH+CustomBase	
		move.l	#BTF3_BobData,BltAPtH+CustomBase	
		move.l	a3,BltCPtH+CustomBase		
		move.l	a3,BltDPTH+CustomBase		
		move.w	#(BTF3_AltoNota*2)<<6+2,BltSize+CustomBase   	

		add.l	#4,a0
		

	END_REPEAT
	rts


	even

SinTble	
	dc.b	$00,$00,$00,$00,$01,$01,$01,$02,$02,$03,$03,$04,$04,$05,$06,$07
	dc.b	$08,$09,$0a,$0b,$0c,$0d,$0e,$10,$11,$12,$14,$15,$17,$18,$1a,$1b
	dc.b	$1d,$1f,$20,$22,$24,$26,$28,$2a,$2c,$2e,$30,$32,$34,$36,$38,$3a
	dc.b	$3c,$3f,$41,$43,$45,$48,$4a,$4c,$4e,$51,$53,$55,$58,$5a,$5c,$5f
	dc.b	$61,$64,$66,$68,$6b,$6d,$6f,$72,$74,$76,$78,$7b,$7d,$7f,$81,$84
	dc.b	$86,$88,$8a,$8c,$8e,$90,$92,$94,$96,$98,$9a,$9c,$9e,$a0,$a1,$a3
	dc.b	$a5,$a6,$a8,$a9,$ab,$ac,$ae,$af,$b0,$b2,$b3,$b4,$b5,$b6,$b7,$b8
	dc.b	$b9,$ba,$bb,$bc,$bc,$bd,$bd,$be,$be,$bf,$bf,$bf,$c0,$c0,$c0,$c0
	dc.b	$c0,$c0,$c0,$c0,$bf,$bf,$bf,$be,$be,$bd,$bd,$bc,$bc,$bb,$ba,$b9
	dc.b	$b8,$b7,$b6,$b5,$b4,$b3,$b2,$b0,$af,$ae,$ac,$ab,$a9,$a8,$a6,$a5
	dc.b	$a3,$a1,$a0,$9e,$9c,$9a,$98,$96,$94,$92,$90,$8e,$8c,$8a,$88,$86
	dc.b	$84,$81,$7f,$7d,$7b,$78,$76,$74,$72,$6f,$6d,$6b,$68,$66,$64,$61
	dc.b	$5f,$5c,$5a,$58,$55,$53,$51,$4e,$4c,$4a,$48,$45,$43,$41,$3f,$3c
	dc.b	$3a,$38,$36,$34,$32,$30,$2e,$2c,$2a,$28,$26,$24,$22,$20,$1f,$1d
	dc.b	$1b,$1a,$18,$17,$15,$14,$12,$11,$10,$0e,$0d,$0c,$0b,$0a,$09,$08
	dc.b	$07,$06,$05,$04,$04,$03,$03,$02,$02,$01,$01,$01,$00,$00,$00,$00
	
	dc.b	$00,$00,$00,$00,$01,$01,$01,$02,$02,$03,$03,$04,$04,$05,$06,$07
	dc.b	$08,$09,$0a,$0b,$0c,$0d,$0e,$10,$11,$12,$14,$15,$17,$18,$1a,$1b
	dc.b	$1d,$1f,$20,$22,$24,$26,$28,$2a,$2c,$2e,$30,$32,$34,$36,$38,$3a
	dc.b	$3c,$3f,$41,$43,$45,$48,$4a,$4c,$4e,$51,$53,$55,$58,$5a,$5c,$5f
	dc.b	$61,$64,$66,$68,$6b,$6d,$6f,$72,$74,$76,$78,$7b,$7d,$7f,$81,$84
	dc.b	$86,$88,$8a,$8c,$8e,$90,$92,$94,$96,$98,$9a,$9c,$9e,$a0,$a1,$a3
	dc.b	$a5,$a6,$a8,$a9,$ab,$ac,$ae,$af,$b0,$b2,$b3,$b4,$b5,$b6,$b7,$b8
	dc.b	$b9,$ba,$bb,$bc,$bc,$bd,$bd,$be,$be,$bf,$bf,$bf,$c0,$c0,$c0,$c0
	dc.b	$c0,$c0,$c0,$c0,$bf,$bf,$bf,$be,$be,$bd,$bd,$bc,$bc,$bb,$ba,$b9
	dc.b	$b8,$b7,$b6,$b5,$b4,$b3,$b2,$b0,$af,$ae,$ac,$ab,$a9,$a8,$a6,$a5
	dc.b	$a3,$a1,$a0,$9e,$9c,$9a,$98,$96,$94,$92,$90,$8e,$8c,$8a,$88,$86
	dc.b	$84,$81,$7f,$7d,$7b,$78,$76,$74,$72,$6f,$6d,$6b,$68,$66,$64,$61
	dc.b	$5f,$5c,$5a,$58,$55,$53,$51,$4e,$4c,$4a,$48,$45,$43,$41,$3f,$3c
	dc.b	$3a,$38,$36,$34,$32,$30,$2e,$2c,$2a,$28,$26,$24,$22,$20,$1f,$1d
	dc.b	$1b,$1a,$18,$17,$15,$14,$12,$11,$10,$0e,$0d,$0c,$0b,$0a,$09,$08
	dc.b	$07,$06,$05,$04,$04,$03,$03,$02,$02,$01,$01,$01,$00,$00,$00,$00

	dc.b	$00,$00,$00,$00,$01,$01,$01,$02,$02,$03,$03,$04,$04,$05,$06,$07
	dc.b	$08,$09,$0a,$0b,$0c,$0d,$0e,$10,$11,$12,$14,$15,$17,$18,$1a,$1b
	dc.b	$1d,$1f,$20,$22,$24,$26,$28,$2a,$2c,$2e,$30,$32,$34,$36,$38,$3a
	dc.b	$3c,$3f,$41,$43,$45,$48,$4a,$4c,$4e,$51,$53,$55,$58,$5a,$5c,$5f
	dc.b	$61,$64,$66,$68,$6b,$6d,$6f,$72,$74,$76,$78,$7b,$7d,$7f,$81,$84
	dc.b	$86,$88,$8a,$8c,$8e,$90,$92,$94,$96,$98,$9a,$9c,$9e,$a0,$a1,$a3
	dc.b	$a5,$a6,$a8,$a9,$ab,$ac,$ae,$af,$b0,$b2,$b3,$b4,$b5,$b6,$b7,$b8
	dc.b	$b9,$ba,$bb,$bc,$bc,$bd,$bd,$be,$be,$bf,$bf,$bf,$c0,$c0,$c0,$c0
	dc.b	$c0,$c0,$c0,$c0,$bf,$bf,$bf,$be,$be,$bd,$bd,$bc,$bc,$bb,$ba,$b9
	dc.b	$b8,$b7,$b6,$b5,$b4,$b3,$b2,$b0,$af,$ae,$ac,$ab,$a9,$a8,$a6,$a5
	dc.b	$a3,$a1,$a0,$9e,$9c,$9a,$98,$96,$94,$92,$90,$8e,$8c,$8a,$88,$86
	dc.b	$84,$81,$7f,$7d,$7b,$78,$76,$74,$72,$6f,$6d,$6b,$68,$66,$64,$61
	dc.b	$5f,$5c,$5a,$58,$55,$53,$51,$4e,$4c,$4a,$48,$45,$43,$41,$3f,$3c
	dc.b	$3a,$38,$36,$34,$32,$30,$2e,$2c,$2a,$28,$26,$24,$22,$20,$1f,$1d
	dc.b	$1b,$1a,$18,$17,$15,$14,$12,$11,$10,$0e,$0d,$0c,$0b,$0a,$09,$08
	dc.b	$07,$06,$05,$04,$04,$03,$03,$02,$02,$01,$01,$01,$00,$00,$00,$00

	dc.b	$00,$00,$00,$00,$01,$01,$01,$02,$02,$03,$03,$04,$04,$05,$06,$07
	dc.b	$08,$09,$0a,$0b,$0c,$0d,$0e,$10,$11,$12,$14,$15,$17,$18,$1a,$1b
	dc.b	$1d,$1f,$20,$22,$24,$26,$28,$2a,$2c,$2e,$30,$32,$34,$36,$38,$3a
	dc.b	$3c,$3f,$41,$43,$45,$48,$4a,$4c,$4e,$51,$53,$55,$58,$5a,$5c,$5f
	dc.b	$61,$64,$66,$68,$6b,$6d,$6f,$72,$74,$76,$78,$7b,$7d,$7f,$81,$84
	dc.b	$86,$88,$8a,$8c,$8e,$90,$92,$94,$96,$98,$9a,$9c,$9e,$a0,$a1,$a3
	dc.b	$a5,$a6,$a8,$a9,$ab,$ac,$ae,$af,$b0,$b2,$b3,$b4,$b5,$b6,$b7,$b8
	dc.b	$b9,$ba,$bb,$bc,$bc,$bd,$bd,$be,$be,$bf,$bf,$bf,$c0,$c0,$c0,$c0
	dc.b	$c0,$c0,$c0,$c0,$bf,$bf,$bf,$be,$be,$bd,$bd,$bc,$bc,$bb,$ba,$b9
	dc.b	$b8,$b7,$b6,$b5,$b4,$b3,$b2,$b0,$af,$ae,$ac,$ab,$a9,$a8,$a6,$a5
	dc.b	$a3,$a1,$a0,$9e,$9c,$9a,$98,$96,$94,$92,$90,$8e,$8c,$8a,$88,$86
	dc.b	$84,$81,$7f,$7d,$7b,$78,$76,$74,$72,$6f,$6d,$6b,$68,$66,$64,$61
	dc.b	$5f,$5c,$5a,$58,$55,$53,$51,$4e,$4c,$4a,$48,$45,$43,$41,$3f,$3c
	dc.b	$3a,$38,$36,$34,$32,$30,$2e,$2c,$2a,$28,$26,$24,$22,$20,$1f,$1d
	dc.b	$1b,$1a,$18,$17,$15,$14,$12,$11,$10,$0e,$0d,$0c,$0b,$0a,$09,$08
	dc.b	$07,$06,$05,$04,$04,$03,$03,$02,$02,$01,$01,$01,$00,$00,$00,$00

	even


BTF3_CurScrn	dc.l	BTF3_1 	;buffer_general_1
BTF3_WrkScrn	dc.l	BTF3_2 	;buffer_general_2

BTF3_SpeedX	dc.w	BTF3_XSpeed
BTF3_SpeedY	dc.w	BTF3_YSpeed



BTF3_Coordenadas_Bob:	
	dcb.w 	BTF3_Max_Bobs*2,0


