;--------------------------------------------------------------------
;
;(C) Goblins 2017. 
;
;------------------x-------------------------------------------------
	opt	c-,p=68020
	section demophase,code_c

X_MUSICA	= 1
X_SAM	 	= 1
X_LOGO	 	= 1
X_GARAJE	= 1
X_JEEP      	= 1
X_PLASMA	= 0
X_PARKING1	= 1
X_PARKING2	= 1
X_RELOJ		= 1
X_ROTOZOOM	= 1
X_Estrellas     = 1


X_Estrellas_Tiempo = 500

COMPATIBILITY	=	1
FASTMEM		=	1
RMBPAUSE	=	0
FPUINT		=	0
COPPER		=	1
BLITTER		=	1
SPRITE		=	0
TOPAZ		=	0	
SECTIONHACK	=	0

*******************************
*                             *
* Player 6.1 Playroutine 1.06 *
*           CIA mode          *
*                             *
*******************************

usecode		=$4600B75F	; Cambiar para cada modulo $2000BD5F
P61pl 		=usecode&$400000
split4 		=0		0 por defecto
splitchans 	=1
visuctrs 	=0
asmonereport=0
p61system 	=0
p61exec 	=0      	;1
p61fade 	=0		Volume fading
channels	=4
playflag	=0		1 enable music on/off to "pause" music in CIA mode
p61bigjtab	=0
opt020		=0		1 enable optimizations for 020+
p61jump		=0
C 		=0
clraudxdat	=0
optjmp 		=1
oscillo 	=0
quietstart 	=0
use1Fx 		=0
p61cia 		=1		Call P61_Music on the CIA interrupt instead of every frame
lev6 		=1
noshorts 	=0
dupedec 	=0
suppF01 	=1


	include cf0:IntroBirraRutinas/Includes/LooniesDemoStartup.s
	include cf0:IntroBirraRutinas/Includes/GoblinsExec.i
	include cf0:IntroBirraRutinas/Includes/GoblinsDosLibrary.i
	include cf0:IntroBirraRutinas/Includes/GoblinsGraphicsLibrary.i	
	include cf0:IntroBirraRutinas/Includes/GoblinsCustom.i
	include cf0:IntroBirraRutinas/Includes/GoblinsMacros.i
	include cf0:IntroBirraRutinas/IncludesPhx/Phdefs.i


EjecutaParteDemo macro
	move.l	#0,Contador
	move.w  #$ff,ParteDemo
	jsr	\2
	move.w	#\1,ParteDemo

	gblEsperaFinParte ParteDemo
	endM
	   
;-----------------------------------------------------------
; Precalculos de la demo. SinTables, etc.
; Invocada ANTES de tomar el siastema.
;-----------------------------------------------------------
_Precalc:
	;-----------------------------------------------------------
	; Inicializacion de la demo (inicio desde cli o wb)
	;-----------------------------------------------------------
	jsr	_initDemoSystem
	;-----------------------------------------------------------
	; Mensaje con informacion de la demo
	;-----------------------------------------------------------
	gblWriteShell ConsolaHandler,#InfoDemo,#FinInfo-InfoDemo
;-----------------------------------------------------------
; Fin de la fase de precalculos y mensajes iniciales.
;-----------------------------------------------------------	
	jsr FadeOutSystem			

	IFNE X_Estrellas
		jsr	GeneraMultiplosScreenW
		jsr	CalculaPosicionEstrellas	
	ENDC

	IFNE X_GARAJE
		;Copia del fondo del video
		lea BTF1_Imagen,a0
		lea BTF1_ImagenBackup,a1
	
		REPEAT d0,(BTF1_Bitplane_Width*BTF1_Bitplane_Height*BTF1_NumPlanosImagen)/4 TIMES	;320*256*5 planos
			move.l 	(a0)+,(a1)+
		END_REPEAT
	ENDC

	rts

;-----------------------------------------------------------
; Seccion principal
; Invocada por el demosystem. La demo termina cuando se sale
; de esta rutina.
;-----------------------------------------------------------
		
_Main:	
	;-------------------------------------------------------
	; Inicializacion de la rutina de musica. P61 en modo CIA
	;-------------------------------------------------------
	IFNE X_MUSICA
		lea	musica,a0
		cleara  a1
		cleara	a2
		move.l  4.w,a6
		clear	d0
		jsr	p61_init
	ENDC

	IIF X_SAM EjecutaParteDemo 0,SWT_Init		; Parte 0. Init. Imitacion de SAM COUPE
	
	IIF X_LOGO EjecutaParteDemo 1,SLG_Init 		; Parte 1. Intro. Logo de AmigaWave

	IIF X_GARAJE EjecutaParteDemo 2,BTF1_Init 	; Parte 2. Animacion Garaje y altavoz.
	
	IFNE X_PLASMA
		move.l	#PaletaRojos,SPL_PaletaEfecto
		EjecutaParteDemo 4,SPL_Init		; Parte 4. Plasma
	ENDC

	IIF X_Jeep EjecutaParteDemo 6,BTF2_Init		; Parte 6. Animacion jeep.
	
	IIF X_Reloj EjecutaParteDemo 7,BTF3_Init 	; Parte 7. Reloj bobs. 

	IIF X_PARKING1 EjecutaParteDemo 8,BTF4_Init 	; Parte 8. ParkingCC

	IIF X_PARKING2 EjecutaParteDemo 9,BTF5_Init 	; Parte 8. ParkingCC2

	IIF X_Estrellas EjecutaParteDemo $A,FX_Estrellas_Init

	IIF X_Rotozoom EjecutaParteDemo $F,Start 	; Parte 8. Rotozoom

	;-------------------------------------------------------
	; Fin de la demo.
	;-------------------------------------------------------	
	rts	

;-----------------------------------------------------------
; Finalizacion de la demo (respuesta a WB).
; Invocada tras la restauracion del sistema.
;-----------------------------------------------------------
_Exit:
	;-------------------------------------------------------
	; Finalizacion de la rutina de musica
	;-------------------------------------------------------		
	IFNE 	X_MUSICA
		jsr	p61_end
	ENDC
	
	;-------------------------------------------------------
	; Finalizacion del framework demosystem
	;-------------------------------------------------------			
	move.l	$4.w,a6
	jsr	_endDemoSystem	
	
	jsr 	FadeInSystem

	rts	

;-----------------------------------------------------------
; Invocado por la interrupcion vblank. Se invoca 50 veces
; por segundo.
;-----------------------------------------------------------
_Interrupt:

	iif X_SAM	jif.w	#$0,'=',ParteDemo,VBGapLocalSamCoupe 

	iif X_Logo 	jif.w	#$1,'=',ParteDemo,VBGapLocalShowLogo

	iif X_GARAJE 	jif.w	#$2,'=',ParteDemo,VBGapLocalGaraje
	
	iif X_Plasma 	jif.w	#$4,'=',ParteDemo,VBGapLocalPlasma
	
	iif X_Jeep 	jif.w	#$6,'=',ParteDemo,VBGapLocalJeep

	iif X_Reloj	jif.w	#$7,'=',ParteDemo,VBGapLocalReloj
	
	iif X_PARKING1 	jif.w 	#$8,'=',ParteDemo,VBGapLocalParkingCC

	iif X_PARKING2 	jif.w 	#$9,'=',ParteDemo,VBGapLocalParkingCC2
	
	iif X_Estrellas jif.w   #$A,'=',ParteDemo,VGGapLocalEstrellas
	
	iif X_ROTOZOOM 	jif.w	#$F,'=',ParteDemo,VBGapLocalRotoZoom
	
	rts

;-----------------------------------------------------------
; Invocacion de las VBG de cada parte
;-----------------------------------------------------------
	IFNE	X_SAM
VBGapLocalSamCoupe:

	add.l	#1,Contador	
	jif.b 	#0,'<>',SWT_Fin,SalirParte  
	jsr	SWT_Run

.fin:	rts
	ENDC

	IFNE 	X_LOGO
VBGapLocalShowLogo:

	add.l	#1,Contador
	jif.l 	#5*50,'<=',Contador,SalirParte
	jsr	SLG_Run

.fin:	rts
	ENDC

	
	IFNE	X_Estrellas
VGGapLocalEstrellas:

	add.l	#1,Contador
	jif.l 	#X_Estrellas_Tiempo,'<=',Contador,SalirParte
	jsr	FX_Estrellas_Run
.fin	rts	
	ENDC

	IFNE X_PLASMA
VBGapLocalPlasma:

	add.l	#1,Contador
	jif.l 	#7*50,'<=',Contador,SalirParte
	jsr	SPL_Run

.fin:	rts
	ENDC

	IFNE 	X_GARAJE
VBGapLocalGaraje:

	add.l	#1,Contador
	jif.l 	#14*50,'<=',Contador,SalirParte
	jsr	BTF1_Run

.fin:	rts
	ENDC

	IFNE X_JEEP
VBGapLocalJeep:

	add.l	#1,Contador
	jif.l 	#12*50,'<=',Contador,SalirParte
	jsr		BTF2_Run

.fin:	rts
	ENDC
	
	IFNE X_RELOJ
VBGapLocalReloj:

	add.l	#1,Contador
	jif.l 	#10*50,'<=',Contador,SalirParte
	jsr	BTF3_Run

.fin:	rts
	ENDC

	IFNE X_PARKING1
VBGapLocalParkingCC:

	add.l	#1,Contador
	jif.l 	#10*50,'<=',Contador,SalirParte
	jsr	BTF4_Run

.fin:	rts
	ENDC

	IFNE X_PARKING2
VBGapLocalParkingCC2:

	add.l	#1,Contador
	jif.l 	#50*50,'<=',Contador,SalirParte
	jsr	BTF5_Run

.fin:	rts
	ENDC

	IFNE X_ROTOZOOM
VBGapLocalRotoZoom:

	add.l	#1,Contador
	jif.l 	#12*50,'<=',Contador,SalirParte
	jsr	Main

.fin:	rts
	ENDC



SalirParte:
	move.l	#-1,ParteDemo
	rts			


;-----------------------------------------------------------
; Includes con otras rutinas,a excepcion de las de inicio de
; loonies que debe ir la primera y dentro de la seccion main
;-----------------------------------------------------------
	
	include cf0:IntroBirraRutinas/Includes/GoblinsRutines.s	
	include FX_Common/Section_Code.s	
	iif X_SAM	include FX_SamCoupe/Section_Code.s
	iif X_LOGO	include FX_ShowLogo/Section_Code.s
	iif X_PLASMA	include FX_Plasma/Section_Code.s
	iif X_GARAJE	include FX_Garaje/Section_Code.s
	iif X_JEEP	include FX_Jeep/Section_Code.s
	iif X_RELOJ	include FX_Reloj/Section_Code.s
	iif X_PARKING1	include FX_ParkingCC/Section_Code.s
	iif X_PARKING2	include FX_ParkingCC2/Section_Code.s
	iif X_Estrellas include FX_Estrellas/Section_Code.s
	
	iif X_ROTOZOOM	include FX_Rotozoom/Rotozoom.s
		
;-----------------------------------------------------------
; Includes con los datos graficos y musica que deben ir en 
; memoria CHIP
;-----------------------------------------------------------
	section datosgfx,data_c
	
	include FX_ShowLogo/Section_Data_Chip.s	
	iif X_SAM	include FX_SamCoupe/Section_Data_Chip.s	
	iif X_PLASMA	include FX_Plasma/Section_Data_Chip.s
	iif X_GARAJE	include FX_Garaje/Section_Data_Chip.s
	iif X_JEEP	include FX_Jeep/Section_Data_Chip.s
	iif X_RELOJ	include FX_Reloj/Section_Data_Chip.s
	iif X_PARKING1	include FX_ParkingCC/Section_Data_Chip.s
	iif X_PARKING2	include FX_ParkingCC2/Section_Data_Chip.s
	iif X_Estrellas include FX_Estrellas/Section_Data_Chip.s

	
;musica:	incbin "cf0:IntroBirraRutinas/BackToFuture/Data/p61.EpicSongCopia2" 
	IFNE	X_MUSICA
musica:	;incbin Data/p61.bf.mod
	incbin Data/p61.EpicSongCopia2
	ENDC
		
;-----------------------------------------------------------
; Datos varios
;-----------------------------------------------------------
	section datos,data
	iif X_LOGO	include FX_ShowLogo/Section_Data.s
	;include FX_Garaje/Section_Data.s
	iif X_RELOJ	include FX_Reloj/Section_Data.s

InfoDemo:
	dc.b 10,0,10,0,10,0
	dc.b $9b,"7;31;40mJojo073 Graphics Factory",10,0
	dc.b 10,0
	dc.b $9b,"0;31;40m(C) 2017 Birra / Goblins",10,0
	dc.b 10,0
	dc.b "",10,0
	dc.b "Nos vemos en #AmigaWave!"
	dc.b 10,0,10,0
	dc.b "Agur!",10,0
	dc.b 10,0,10,0,10,0
	dc.b ""
FinInfo:dc.b 0
		
	even

ParteDemo:	
	dc.w	0
	even
Contador:
	dc.l	0

;-----------------------------------------------------------
; Datos que tienen que ir en memoria CHIP.
; No debe haber mas secciones CHIP
;-----------------------------------------------------------
	section	chip,bss_c
Chip:
buffer_general_1:
	ds.b	40*256*1
buffer_general_10:
	ds.b	40*256*1
buffer_general_11:
	ds.b	40*256*1
buffer_general_12:
	ds.b	40*256*1
buffer_general_13:
	ds.b	40*256*1

buffer_general_2:
	ds.b	40*256*1
buffer_general_20:
	ds.b	40*256*1
buffer_general_21:
	ds.b	40*256*1
buffer_general_22:
	ds.b	40*256*1
buffer_general_23:
	ds.b	40*256*1


	iif X_PLASMA	include FX_Plasma/Section_Data_bss.s

	section rutinamus,code

	iif X_MUSICA include cf0:IntroBirraRutinas/includes/P6112-Play.i
