//*****************************************************************************
//	Plain light
//*****************************************************************************


//*****************************************************************************
//	Attributes
//*****************************************************************************
float4x4		g_ViewProjMatrix		: VIEWPROJ;
float4x4		g_ViewMatrix			: VIEW;
float			g_fTime					: TIME;

//*****************************************************************************
//	Constants
//*****************************************************************************

const float g_FocusDepth = -3.0f;
const float g_FocalLength = 0.9f;

//*****************************************************************************
//	Textures
//*****************************************************************************

texture Sprite1Texture : TEXTURE1
<
	string ResourceName = "ZineFonts.dds";
> ;


//*****************************************************************************
//  Texture Samplers
//*****************************************************************************

sampler Sprite1Sampler = sampler_state
{
    Texture = (Sprite1Texture) ;
    MinFilter = LINEAR  ;
    MagFilter = LINEAR  ;
		MipFilter = LINEAR;
} ;

//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
//  Bobs shaders
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************

struct bobsVS_In
{
	float4 Position		: POSITION0 ;
	float4 QuadPos		: POSITION1 ;
	float4 Color		: COLOR0 ;
	float2 TexCoord		: TEXCOORD0 ;
};

struct bobsVS_Out
{
	float4 Position		: POSITION ;
	float4 Color		: COLOR0 ;
	float4 TexCoord		: TEXCOORD0 ;
	float4 Pos			: TEXCOORD1 ;
} ;


bobsVS_Out bobsVS (bobsVS_In In)
{
	bobsVS_Out Out;

	float4 xyzOffset ;
	xyzOffset.xyz = In.QuadPos ;
	xyzOffset.w = 0.0f ;

	Out.Pos = Out.Position  = xyzOffset + mul(In.Position, g_ViewProjMatrix);

	float3 p = mul(In.Position, g_ViewMatrix);
	float dist = g_FocusDepth - p.z;
	Out.TexCoord.z = 0.0f;//-0.3f + 1.0f*(0.6f*abs(dist))/Out.Pos.w;

	Out.TexCoord.w = 1.0f/(1.0f +  0.2f*max(0.0f, g_FocusDepth - p.z));

	Out.TexCoord.xy = In.TexCoord;

	Out.Color = In.Color;
	return Out;
}

struct bobsPS_In
{
	float4 Color		: COLOR0 ;
	float4 TexCoord		: TEXCOORD0 ;
	float4 Pos			: TEXCOORD1 ;
} ;

struct bobsPS_Out
{
	float4 Color	: COLOR0 ;
} ;

bobsPS_Out bobsPS (bobsPS_In In)
{
	bobsPS_Out Out;
	float4 texVec;
	texVec.xy = In.TexCoord.xy;
	texVec.z = 0.0f;
	texVec.w = 0.9f;
	
	float4 col = tex2Dbias(Sprite1Sampler, texVec) ;

	col.a *= In.TexCoord.w;
	Out.Color = col;
	return Out;
}


//*****************************************************************
//*****************************************************************
//*****************************************************************
//
// Techniques
//
//*****************************************************************
//*****************************************************************
//*****************************************************************

technique Letter
{
	pass P0
    {
			ZEnable = false ;
			ZWriteEnable = false ;
			CullMode = NONE ;
			AlphaBlendEnable = true;
			SrcBlend = SrcAlpha;
			DestBlend = InvSrcAlpha;
			VertexShader = compile vs_2_0 bobsVS();
			PixelShader = compile ps_2_0 bobsPS();
    }
}
