<html>
<head>
<title>Bild hinzufgen</title>
<meta name="author" content="mados/WildMag">
</head>
<body>

<?php

//----------------------------------------------------------------------------
// Vollstndiges Einlesen aller Datenstze aus der Datendatei
//----------------------------------------------------------------------------

function db_laden()
{
  global $bild;

  if ($bild = @file('bilder.txt'))
  {
    for ($i = 0; $i < count($bild); $i++)
    {
      $bild[$i] = explode("\t", chop($bild[$i]));
    }
  }
  else unset($bild);
}

//----------------------------------------------------------------------------
// Vollstndiges Sichern aller Datenstze in die Datendatei
//----------------------------------------------------------------------------

function db_speichern()
{
  global $bild;

  //Datei zum Schreiben ffnen und neu anlegen, falls sie bereits existiert
  $zeiger = fopen('bilder.txt', 'w');

  //Aus Sicherheitsgrnden die Datei fr alle anderen Programme blockieren
  flock($zeiger, 2);

  for ($i = 0; $i < count($bild); $i++)
  {
    //Zeilenweise in die Datei schreiben
    fputs($zeiger, implode("\t", $bild[$i]) . "\n");
  }

  fclose($zeiger);
}

//----------------------------------------------------------------------------
// Darstellen des Formulares zum Hochladen eines neuen Bildes
//----------------------------------------------------------------------------

function formular()
{
  global $PHP_SELF;

  echo '<form enctype="multipart/form-data" action="' . $PHP_SELF . '" method=post>';
  echo 'Bild:<br>';
  echo '<input type=file name="neu" size=50><br>';
  echo 'Titel:<br>';
  echo '<input type=text name="titel" size=50><br>';
  echo 'Beschreibung:<br>';
  echo '<textarea name="beschr" cols=50 rows=5 wrap=virtual></textarea><br>';
  echo 'Autor:<br>';
  echo '<input type=text name="autor" size=50><br>';
  echo '<input type=submit value="Hinzufgen">';
  echo '</form>';
}

//----------------------------------------------------------------------------
// Generierung des Vorschaubildes und Speicherung des neuen Datensatzes
//----------------------------------------------------------------------------

function hinzufuegen()
{
  global $PHP_SELF, $bild, $neu, $neu_name, $titel, $beschr, $autor;

  //Die Verzeichnisse werden erstellt, falls sie noch nicht existierten
  if (! file_exists('bilder'))          mkdir('bilder', 0777);
  if (! file_exists('bilder/vorschau')) mkdir('bilder/vorschau', 0777);

  $neu_name = stripslashes($neu_name);

  //Kopieren des hochgeladenen Bildes in das endgltige Verzeichnis
  copy($neu, "bilder/$neu_name");

  //Auslesen der Bildgre des Originalbildes
  $groesse = GetImageSize($neu);

  //Generierung des Dateinamens des Vorschaubildes aus dem original Dateinamen
  $vorschauname = 'bilder/vorschau/' . preg_replace('/\.\w+/', '.jpg', $neu_name);

  //Erzeugen des Vorschaubildes mit Hilfe der GD-Bibliothek
  $verhaeltnis = min(160/$groesse[0], 120/$groesse[1], 1);
  $vorschaubreite = round($groesse[0] * $verhaeltnis);
  $vorschauhoehe = round($groesse[1] * $verhaeltnis);
  if (stristr($neu_name, '.jp')) $gross = ImageCreateFromJPEG($neu);
  elseif (stristr($neu_name, '.gif')) $gross = ImageCreateFromGIF($neu);
  elseif (stristr($neu_name, '.png')) $gross = ImageCreateFromPNG($neu);
  if (function_exists('ImageCreateTrueColor'))
    $klein = ImageCreateTrueColor($vorschaubreite, $vorschauhoehe);
  else
    $klein = ImageCreate($vorschaubreite, $vorschauhoehe);
  if (function_exists('ImageCopyResampled'))
    ImageCopyResampled($klein, $gross, 0,0,0,0, $vorschaubreite, $vorschauhoehe, $groesse[0], $groesse[1]);
  else
    ImageCopyResized($klein, $gross, 0,0,0,0, $vorschaubreite, $vorschauhoehe, $groesse[0], $groesse[1]);
  ImageJPEG($klein, $vorschauname);

/*
  //Erzeugen des Vorschaubildes mit Hilfe von ImageMagick's convert
  $convert = "/usr/X11R6/bin/convert -geometry 160x120\\> $neu $vorschauname";
  exec($convert);
  $klein = GetImageSize($vorschauname); 
  $vorschaubreite = $klein[0];
  $vorschauhoehe = $klein[1];
*/

  //Generierung des neuen Datensatzes fr die Datendatei
  $id = count($bild);
  $bild[$id][0] = $neu_name;
  $bild[$id][1] = $groesse[0];
  $bild[$id][2] = $groesse[1];
  $bild[$id][3] = $vorschaubreite;
  $bild[$id][4] = $vorschauhoehe;
  $bild[$id][5] = trim(stripslashes($titel));
  $bild[$id][6] = trim(stripslashes(preg_replace('/[ \n\r\t]+/', ' ', $beschr)));
  $bild[$id][7] = trim(stripslashes($autor));
  $bild[$id][8] = time();

  db_speichern();
}

//----------------------------------------------------------------------------
// Beginn des Hauptprogrammes
//----------------------------------------------------------------------------

db_laden();

if ($neu && file_exists($neu))
{
  //Wenn auf den Schalter "hinzufgen" geklickt wurde, dieses Bild abspeichern
  hinzufuegen();
}
else
{
  //Andernfalls das leere Formular zum Hochladen eines Bildes anzeigen
  formular();
}

?>

<p>[ <a href="bilder.php">Zurck</a> ]

</body>
</html>