<html>
<head>
<title>Administration</title>
<meta name="author" content="mados/WildMag">
</head>
<body>

<?php

//----------------------------------------------------------------------------
// Vollstndiges Einlesen aller Datenstze aus der Datendatei
//----------------------------------------------------------------------------

function db_laden()
{
  global $bild;

  if ($bild = @file('bilder.txt'))
  {
    for ($i = 0; $i < count($bild); $i++)
    {
      $bild[$i] = explode("\t", chop($bild[$i]));
    }
  }
  else unset($bild);
}

//----------------------------------------------------------------------------
// Vollstndiges Sichern aller Datenstze in die Datendatei
//----------------------------------------------------------------------------

function db_speichern()
{
  global $bild;

  $zeiger = fopen('bilder.txt', 'w');
  flock($zeiger, 2);
  for ($i = 0; $i < count($bild); $i++)
  {
    fputs($zeiger, implode("\t", $bild[$i]) . "\n");
  }
  fclose($zeiger);
}

//----------------------------------------------------------------------------
// Darstellung des Formulares zur Administration
//----------------------------------------------------------------------------

function administration($id)
{
  global $PHP_SELF, $bild;

  //Zeilennummer des aktuellen Datensatzes, beginnend bei Null
  $id = intval($id);

  echo '<form action="' . $PHP_SELF . '" method=post>';
  echo '<input type=hidden name="id" value="' . $id . '">';
  echo 'Bild:<br>' . $bild[$id][0] . '<br>';
  echo 'Titel:<br>';
  echo '<input type=text size=50 name="titel" value="' . htmlspecialchars($bild[$id][5]) . '"><br>';
  echo 'Beschreibung:<br>';
  echo '<textarea name="beschr" cols=50 rows=5 wrap=virtual>' . htmlspecialchars($bild[$id][6]) . '</textarea><br>';
  echo 'Autor:<br>';
  echo '<input type=text size=50 name="autor" value="' . htmlspecialchars($bild[$id][7]) . '"><br>';
  echo 'Datum:<br>';
  echo '<input type=text size=10 name="datum" value="' . date('d.m.Y', $bild[$id][8]) . '"><br>';
  echo '<input type=submit name="speichern" value="Speichern">';
  echo '<input type=submit name="loeschen" value="Lschen">';
  echo '</form>';

  //Links zum Blttern nach vorn beim ersten Datensatz deaktivieren
  if ($id > 0)
  {
    echo '<p>[ <a href="' . $PHP_SELF . '">ltestes</a> | ';
    echo '<a href="' . $PHP_SELF . '?id=' . ($id - 1) . '">Voriges</a> | ';
  }
  else
  {
    echo '<p>[ ltestes | Voriges | ';
  }

  //Links zum Blttern nach hinten beim letzten Datensatz deaktivieren
  if ($id < count($bild) - 1)
  {
    echo '<a href="' . $PHP_SELF . '?id=' . ($id + 1) . '">Nchstes</a> | ';
    echo '<a href="' . $PHP_SELF . '?id=' . (count($bild) - 1) . '">Jngstes</a> ]';
  }
  else
  {
    echo 'Nchstes | Jngstes ]';
  }
}

//----------------------------------------------------------------------------
// Hilfsfunktion fuer das benutzerdefinierte Sortieren mittels usort()
//----------------------------------------------------------------------------

function vergleich($a, $b)
{
  //Sortiert wird nach dem Datum, das im Feld Nummer 8 zu finden ist
  if ($a[8] == $b[8]) return 0;
  return $a[8] > $b[8] ? 1 : -1;
}

//----------------------------------------------------------------------------
// Sichern eines bearbeiteten Datensatzes in der Datendatei
//----------------------------------------------------------------------------

function bild_speichern($id)
{
  global $bild, $titel, $beschr, $autor, $datum;

  $bild[$id][5] = trim(stripslashes($titel));
  $bild[$id][6] = trim(stripslashes(preg_replace('/[ \n\r\t]+/', ' ', $beschr)));
  $bild[$id][7] = trim(stripslashes($autor));

  //Umwandeln des Datums aus der Textform in einen gltigen Zeitstempel
  preg_match('/(\d+).(\d+).(\d+)/', $datum, $match);
  $bild[$id][8] = mktime(12, 0, 0, $match[2], $match[1], $match[3]);

  //Benutzerdefiniertes Sortieren aller Datenstze nach dem Datum
  usort($bild, vergleich);

  db_speichern();
}

//----------------------------------------------------------------------------
// Lschen eines Bildes und Entfernen des Datensatzes aus der Datendatei
//----------------------------------------------------------------------------

function bild_loeschen($id)
{
  global $bild;

  unlink('bilder/' . $bild[$id][0]);
  $vorschauname = preg_replace('/\.\w+/', '.jpg', $bild[$id][0]);
  unlink('bilder/vorschau/' . $vorschauname);

  //Verschieben aller nachfolgenden Datenstze um eins nach vorn
  for ($i = $id + 1; $i < count($bild); $i++)
  {
    $bild[$i - 1] = $bild[$i];
  }
  unset($bild[count($bild) - 1]);

  db_speichern();
}

//----------------------------------------------------------------------------
// Beginn des Hauptprogrammes
//----------------------------------------------------------------------------

db_laden();

if ($speichern)
{
  //Vernderte Daten sichern, falls auf "speichern" geklickt wurde
  bild_speichern($id);
}
elseif ($loeschen)
{
  //Den aktuellen Datensatz entfernen, falls auf "lschen" geklickt wurde
  bild_loeschen($id);
}

//Das Formular zur Administration unabhngig davon immer anzeigen
administration($id);

?>

<p>[ <a href="bilder.php">Zurck</a> ]</p>

</body>
</html>