@echo off
@echo . Hi, this is the Win32 - Assembler - Coding - Tutorial Pt. 4k
@echo .
@echo . If compiling/linking does not work, check the paths and
@echo . set them accordingly, if necessary. Especially TLINK  
@echo . needs the direct path to the *.lib files in its 
@echo . command-line !
@echo . 
@echo . 

@echo . First the NASM version gets compiled with NASMW:
@echo . 
@echo . 
 
NASMW.EXE -fobj win005_n.asm

@echo . 
@echo . 
@echo . Now the NASM version gets linked with ALINK:
@echo . 
@echo . 

ALINK.EXE -c -oPE  -subsys gui win005_n

@echo . 
@echo . 
@echo . NASM version is ready - starting NASM version
@echo . 

win005_n

pause

@echo --------------------------------------------------------
@echo . 
@echo . 
@echo . Now the TASM version gets compiled with TASMX:
@echo . 
@echo . 
 
TASMX.EXE /s /r /ml /m4 win005.asm

@echo . 
@echo . 
@echo . Now the TASM version is linked together by TLINK32:
@echo . 
@echo . 

TLINK32.EXE -c -Tpe -aa win005,,,,,

@echo . 
@echo . 
@echo . TASM version is ready - starting TASM version
@echo . 

win005

pause

@echo --------------------------------------------------------

@echo . 
@echo . 
@echo . Now the MASM version gets compiled with MASM (ML.EXE):
@echo .  
@echo .  
 
ML.EXE /Dmasm /c /Cx /coff win005.asm

@echo . 
@echo . 
@echo . Now the MASM version gets linked with LINK:
@echo .  
@echo .  

LINK.EXE win005 /subsystem:windows

@echo . 
@echo . 
@echo . MASM version finished - starting MASM version
@echo . 

win005

pause

@echo .
@echo . End of minimal code / standard PE file sizes demo
@echo .
@echo . See result.txt for the resulting files using ALINK 1.6, MS-LINK 5.12 
@echo . and TLINK32 1.6 
@echo .
@echo .

