;
;  Title : Small Tunneling Engine
; Author : Dark Fiber [NuKE]
;  Birth : 21st August 1995
;    ASM : Originally for A86, but with slight mods, TASM + MASM
;



;== [ 80286+ | Priming the Tunnel code ] ======================================
; This code will save and hook INT 01h, and put the processor into single
; stepping mode.
;


Int_01v:        dd ?                            ;Old address for Int 01h
Int_21v:        dd ?


Tunnel:
        pusha                                   ;Save our registers,
        push    es                              ;Assume we are being called
        push    ds                              ;from an external source.

        mov     ax,03521h
        int     021h                            ;Get Int 21h
    cs: mov     word ptr [Int_21v],bx           ;Save Int 21h address
    cs: mov     word ptr [Int_21v + 2],es

        mov     al,01h                          ;Get Int 01h
        int     021h
    cs: mov     word ptr [Int_01v],bx           ;Save Int 01h address
    cs: mov     word ptr [Int_01v + 2],es

        push    cs
        pop     ds                              ;Set DS = CS for OUR Int 01
                                                ;address.
        mov     ah,025h
        mov     dx,offset Int_01Handler         ;Our Int 01h routine
        int     21h                             ;Set our Int 01h routine

        ;This first PUSHF, is used in conjunction with the CALL FAR [Int_21v]
        ;code, as we need a FLAGS on the stack that has not got the TF
        ;turned to ON.

        pushf


        pushf
        pop     ax                              ;Save the flag
        or      ax,0100                         ;Set the TF to ON
        push    ax
        popf                                    ;restore the flags

        ;The moment we POPF the flags, the trace mode is initiated
        ;Because of the way it works, the first instruction immediatly
        ;following the POPF is NOT traced, tracing begins with the
        ;second instruction AFTER the POPF.

        mov     ax,03306                        ;Set AX for INTERNAL_DOS_VERS.
        call    far [Int_21v]                   ;Call the Int 21.
                                                ;we are faking an INT 21 call.

        ;The Int_01Handler routine takes over from here until the trace
        ;is finished. Only when its finished will control pass back to this
        ;piece of code.

        ;When control is passed back, Int_21v will hold the segment:offset
        ;of the last cross segment jump before the trace ended.

        ;Restore the old Int_01h vector
        lds     dx,word ptr [Int_01v]
        mov     ax,02501
        int     21h

        pop     ds
        pop     es
        popa                                    ;Restore registers
        ret

;==============================================================================




;== [ 80286+ | Tunnel Engine ] ================================================
;This is the actual code that does all the hard work.
;It has been somewhat (20bytes) optimised from the engine I used in Lady Death

;These are our register offsets into the SS:SP[BP]

        _rfl    equ 01A
        _rcs    equ 018
        _rip    equ 016
        _ax     equ 014
        _cx     equ 012
        _dx     equ 010
        _bx     equ  0E
        _sp     equ  0C
        _bp     equ  0A
        _si     equ  08
        _di     equ  06
        _es     equ  04
        _ds     equ  02
        _ss     equ  00

Int_01Handler:
        pusha
        push    es
        push    ds                      ;Save ALL registers.
        push    ss                      ;Its not really nesecary to save SS ;)
        mov     bp,sp                   ;but this engine was built for expansion

        ;One thing to note, if you want to know the TRUE value of SP, that
        ;is, you must subtract 6 from it, which covers the calling cs, ip & f.
        ;and thats sub w[bp+_sp],6  not sub sp,6 ;)

        push    cs
        pop     ds

        test    b[_status],1
        je      RunNextTest_1
        xor     b[_status],1
        and     word ptr [bp+_rfl+2],0feff
        jmp     GetOpCode

RunNextTest_1:


GetOpCode:
        lds     si,word ptr [bp+22]     ;Get the seg:off of the next opcode

        cld                             ;clear direction
        lodsb                           ;get opcode

        ;AL now holds our bytevalue opcode.

        ;Check for a segment overide, and if not, assume its working in DS
        call    GetSegOveride           ;Get the segment overide
                                        ;bx = segment we will be using.

        ;Check the OPCode in AL
        cmp     al,09dh                 ;POPF?
        jne     ItsNotPOPF
        ;They are attempting to POP the flags.  Just incase they have tried
        ;to turn the TF off, we keep it turned on.
        or      word ptr [bp+_rfl+2],0100 ;Keep TRAPFLAG set to on.

ItsNotPOPF:
        cmp     al,09c
        jne     ItsNotPUSHF
    cs: or      byte ptr [_status],1

ItsNotPUSHF:
        cmp     al,0cf                          ;IRET
        jne     ItsNotIRET
        ;An IRET signals the end of our trace.
        ;So turn the TF to off.
        and     word ptr [bp+_rfl],0feff        ;Turn trace flag off

ItsNotIRET:
        cmp     al,0eah                 ;Jmp xxxx:yyyy
        jne     ItsNotFarJump

        ;A Cross segment jump!  Save the seg:offset its going to jump into.
        ;The data for the cross seg jump is contained in the CS: seg.
        ;So, no change is needed.

FarJumpData:
        lodsw
    cs: mov     word ptr [Int_21v+0],ax
        lodsw
    cs: mov     word ptr [Int_21v+2],ax
        jmp     RunNextOpCode


ItsNotFarJump:
        cmp     al,0ffh                 ;jmp d[xxxx]
        jne     ItsNotJmpD

        cmp     byte ptr [si],01eh      ;jmp d[xxxx], type 1
        jne     ItsJmpD
        cmp     byte ptr [si],02eh      ;jmp d[xxxx], type 2
        jne     ItsNotJmpD

ItsJmpD:
        inc     si                      ;skip jump type

        ;This opcode can use a segment override, so use it!
        mov     ds,bx                   ;segment override
        lodsw                           ;get storage offset of seg:offs
        mov     si,ax                   ;
        jmp     FarJumpData             ;treat it like jmp xxxx:yyyy


ItsNotJmpD:
        ;Next opcode here....
        ;Well, we dont need to monitor any more opcodes....

RunNextOpCode:
        pop     ss
        pop     ds
        pop     es                      ;Restore the flags
        popa
        iret                            ;Run the next opcode.



GetSegOveride:
        cmp     al,026h                 ;ES
        jne     NotSegES
        mov     bx,word ptr [bp+_es]
        lodsb                           ;Skip seg overide, to get next opcode
        ret

NotSegES:
        cmp     al,02eh                 ;CS
        jne     NotSegCS
        mov     bx,word ptr [bp+_rcs]
        lodsb                           ;Skip seg overide, to get next opcode
        ret
        db      'DF[NuKE]'

NotSegCS:
        cmp     al,036h                 ;SS
        jne     NotSegSS
        mov     bx,word ptr [bp+_ss]
        lodsb                           ;Skip seg overide, to get next opcode
        ret

NotSegSS:
        cmp     al,03eh                 ;DS
        jne     NotSegDS
        mov     bx,word ptr [bp+_ds]
        lodsb                           ;Skip seg overide, to get next opcode
        ret

NotSegDS:
        mov     bx,word ptr [bp+_ds]    ;DS
        ret                             ;No override, so assume DS

_status: db 0

;==============================================================================
