program Raster; { (c) Nmeth Akos }

uses Crt;

const
  LineNum = 480;
  ScanNum = 300;

var
  RedLine: Array[0..LineNum - 1] of Byte;
  GreenLine: Array[0..LineNum - 1] of Byte;
  BlueLine: Array[0..LineNum - 1] of Byte;
  RedLine2: Array[0..LineNum - 1] of Byte;
  GreenLine2: Array[0..LineNum - 1] of Byte;
  BlueLine2: Array[0..LineNum - 1] of Byte;
  A, I: Integer;
  S: Integer;
  SinTab: Array[0..99] of Word;

procedure MakeSin;
var
  I: Integer;
begin
  For I := 0 to 63 do
    SinTab[I] := Round(Sin((pi / 63) * I) * 63);
end;


procedure MakeRaster;
var
  R, G, B: Byte;
  R2, G2, B2: Byte;
  I: Integer;

begin
  {szinkronizls a fggleges visszafutshoz }
  asm
        CLI
        MOV DX, 03DAH
@@1:    IN AL, DX
        AND AL, 8
        JNE @@1
@@2:    IN AL, DX
        AND AL, 8
        JE @@2
        STI
  end;
  For I := 0 to ScanNum - 1 do
    begin
      R := RedLine[I];
      G := GreenLine[I];
      B := BlueLine[I];
      R2 := RedLine2[I];
      G2 := GreenLine2[I];
      B2 := BlueLine2[I];
      asm
        { A httrszn belltsa }
        MOV DX, 03C8H
        MOV AL, 0
        OUT DX, AL
        INC DX
        MOV AL, R
        OUT DX, AL
        MOV AL, G
        OUT DX, AL

        { Szinkronizls a vzszintes visszafutshoz }
        MOV DX, 03DAH
@@3:    IN AL, DX
        AND AL, 1
        JNE @@3
@@4:    IN AL, DX
        AND AL, 1
        JE @@4

        MOV DX, 03C9H
        MOV AL, B
        OUT DX, AL

        { A 7-es szinkd karakterszn belltsa }
        MOV DX, 03C8H
        MOV AL, 7
        OUT DX, AL
        INC DX
        MOV AL, R2
        OUT DX, AL
        MOV AL, G2
        OUT DX, AL
        MOV AL, B2
        OUT DX, AL
      end;
    end;
end;


var
  Start,
  Stop: Byte;
begin
  Port[$21] := Port[$21] or 1;
  ClrScr;
  TextColor(7);
  TextBackGround(0);
  S := 1;
  For I := 1 to 5 do WriteLn;
  WriteLn('                 ');
  WriteLn('                                          ');
  WriteLn('                                               ');
  WriteLn('                          ');
  WriteLn('                          ');
  WriteLn('                                                 ');
  WriteLn('                                              ');
  WriteLn('                          ');
  WriteLn;
  WriteLn('                                                      ');
  WriteLn('                                                              ');
  WriteLn('                                                        ');
  MakeSin;
  GotoXY(1, 23);
  TextColor(0);
  Write(' ');
  GotoXY(1, 23);
  repeat
    A := Round(Sin(S / 70) * 2000 + 2000);
    For I := 0 to 300 do BlueLine[I] := SinTab[((A * (I - 150)) div 1000 + S) and 63];
    For I := 0 to 300 do GreenLine[I] := BlueLine[I + 10];
    For I := 0 to 300 do RedLine[I] := BlueLine[I + 20];

    For I := 70 to 350 do BlueLine2[I] := SinTab[((A * (I - 150)) div 1000 + S + 20) and 63];
    For I := 70 to 350 do GreenLine2[I] := BlueLine2[I + 10];
    For I := 70 to 350 do RedLine2[I] := BlueLine2[I + 20];
    BlueLine[ScanNum - 1] := 0;
    Inc(S);
    If S = 0 then I := 1;
    MakeRaster;
  until Port[$60] = 1;
  Port[$21] := Port[$21] and $FE;
  TextMode(3);
end.