;;
;                     Advanced Gravis UltraSound Routines                    ;
;                         Coded by Jim Goer, (c) 1996                        ;
;;

;This file is subpart of PLAYUS module player.
;If you use it, please credit me in your productions.


;PlayVoice
;StopVoice
;SetVoiceVolume
;SetVoiceFrequency
;SetVoiceBalance
;u_Delay
;u_Poke
;u_Peek
;SearchBasePort
;CheckMemory
;RAM2DRAM
;DRAM2RAM
;ResetUltraSound


; Play voice ;

PlayVoice:

;Init

		call    StopVoice

	;Set LoopStart - offset from place in DRAM (repeat)
		mov     ebx,cs:VStart

		;START >> 7
		mov     dx,cs:u_Command
		mov     al,LoopStartLo
		out     dx,al
		mov     dx,cs:u_WordIO
		mov     eax,ebx
		shr     eax,7
		out     dx,ax
		;START << 9
		mov     dx,cs:u_Command
		mov     al,LoopStartHi
		out     dx,al
		mov     dx,cs:u_WordIO
		mov     eax,ebx
		shl     eax,9
		out     dx,ax


	;Set LoopBegin - place sample in DRAM
		mov     ebx,cs:VBegin

		;BEGIN >> 7
		mov     dx,cs:u_Command
		mov     al,LoopBeginLo
		out     dx,al
		mov     dx,cs:u_WordIO
		mov     eax,ebx
		shr     eax,7
		out     dx,ax
		;BEGIN << 9
		mov     dx,cs:u_Command
		mov     al,LoopBeginHi
		out     dx,al
		mov     dx,cs:u_WordIO
		mov     eax,ebx
		shl     eax,9
		out     dx,ax

	;Set LoopEnd
		mov     ebx,cs:VEnd

		;END >> 7
		mov     dx,cs:u_Command
		mov     al,LoopEndLo
		out     dx,al
		mov     dx,cs:u_WordIO
		mov     eax,ebx
		shr     eax,7
		out     dx,ax
		;END << 9
		mov     dx,cs:u_Command
		mov     al,LoopEndHi
		out     dx,al
		mov     dx,cs:u_WordIO
		mov     eax,ebx
		shl     eax,9
		out     dx,ax

	;Set voice mode
		mov     dx,cs:u_Command
		mov     al,VoiceMode
		out     dx,al
		mov     dx,cs:u_ByteIO
		mov     al,cs:Mode
		out     dx,al

		ret



; Stop voice ;

StopVoice:

	;Select voice
		mov     dx,cs:u_ActiveVoice
		mov     al,cs:Voice     ;voice
		out     dx,al

	;Stop voice
		mov     dx,cs:u_Command
		mov     al,R_VoiceMode  ;command #80h
		out     dx,al

		mov     dx,cs:u_ByteIO     ;u_DataHi
		in      ax,dx           ;can be: in al,dx
		mov     cx,ax

		mov     dx,cs:u_Command
		mov     al,VoiceMode    ;command #0
		out     dx,al
		mov     dx,cs:u_ByteIO
		and     cx,11011111b    ;0DFh
		or      cx,00000011b
		mov     ax,cx
		out     dx,ax
		call    u_Delay
		mov     dx,cs:u_Command
		mov     al,VoiceMode    ;command #0
		out     dx,al
		mov     dx,cs:u_ByteIO
		mov     ax,cx
		out     dx,ax

		ret



; Set volume ;
;bl => volume
SetVoiceVolume:
		mov     dx,cs:u_ActiveVoice
		mov     al,cs:Voice
		out     dx,al
		mov     dx,cs:u_Command
		mov     al,VoiceVolume
		out     dx,al
		mov     al,cs:MasterVolume
		xor     ah,ah
		xor     bh,bh
		xor     dx,dx
		mul     bx
		shr     ax,6    ; - 1
		adc     ax,0
		mov     bx,ax
		shl     bx,1
		mov     ax,word ptr cs:[GUSVolume][bx]
		mov     dx,cs:u_WordIO
		out     dx,ax

		ret



; Set frequency ;

SetVoiceFrequency:
		push    ax
		mov     dx,cs:u_ActiveVoice
		mov     al,cs:Voice
		out     dx,al
		mov     dx,cs:u_Command
		mov     al,VoiceFreq
		out     dx,al
		mov     dx,cs:u_WordIO
		;mov     ax,cs:Frequency
		pop     ax
		out     dx,ax

		ret
		   


; Set voice balance ;

SetVoiceBalance:
		mov     dx,cs:u_ActiveVoice
		mov     al,cs:Voice
		out     dx,al
		mov     dx,cs:u_Command
		mov     al,VoiceBalance
		out     dx,al
		mov     dx,cs:u_ByteIO
		mov     al,cs:Balance
		out     dx,al

		ret



; Delay ;
;Idle wait for the card

u_Delay         Proc

		push    ax dx
		mov     dx,300h
		Rept 7
		in      al,dx
		EndM
		pop    dx ax

		ret

u_Delay         EndP



; Poke UltraSound Memory ;
;Write one cell in DRAM memory
;In: BX:CX -> DRAM Address
;    AL -> OutByte

;10000h -> BX=0 , CX=1

u_Poke          Proc
	
		push    ax
		mov     dx,cs:u_Command
		mov     al,DRAMLo
		out     dx,al

		mov     dx,cs:u_WordIO
		mov     ax,bx
		out     dx,ax

		mov     dx,cs:u_Command
		mov     al,DRAMHi
		out     dx,al

		mov     dx,cs:u_ByteIO
		mov     al,cl
		out     dx,al
	
		mov     dx,cs:u_DRAMIO
		pop     ax
		out     dx,al

		ret

u_Poke          EndP



; Peek UltraSound Memory ;
;Returns one cell in DRAM memory
;In: BX:CX -> DRAM Address
;Out: AL -> InByte

u_Peek          Proc

		mov     dx,cs:u_Command
		mov     al,DRAMLo
		out     dx,al

		mov     dx,cs:u_WordIO
		mov     ax,bx
		out     dx,ax

		mov     dx,cs:u_Command
		mov     al,DRAMHi
		out     dx,al

		mov     dx,cs:u_ByteIO
		mov     al,cl
		out     dx,al
	
		mov     dx,cs:u_DRAMIO
		in      al,dx

		ret

u_Peek          EndP



; Setup addresses ;
;Sets all required values, i.e. port addresses

SetUpAddress    Proc

		mov     dx,cs:u_Base
		add     dx,6
		mov     cs:u_Status,dx

		mov     dx,cs:u_Base
		add     dx,102h
		mov     cs:u_ActiveVoice,dx

		mov     dx,cs:u_Base
		add     dx,103h
		mov     cs:u_Command,dx

		mov     dx,cs:u_Base
		add     dx,104h
		mov     cs:u_WordIO,dx

		mov     dx,cs:u_Base
		add     dx,105h
		mov     cs:u_ByteIO,dx

		mov     dx,cs:u_Base
		add     dx,107h
		mov     cs:u_DRAMIO,dx

		ret

SetUpAddress    EndP



; Check UltraSound Card ;
;Tests if UltraSound is installed
;Out: ZeroFlag = 0 -> UltraSound installed
;     ZeroFlag = 1 -> UltraSound not installed

CheckULTRA      Proc
	
		mov     dx,cs:u_Command
		mov     al,Initialize
		out     dx,al
		mov     dx,cs:u_ByteIO
		mov     al,0
		out     dx,al

		call    u_Delay
		call    u_Delay

		mov     dx,cs:u_Command
		mov     al,Initialize
		out     dx,al
		mov     dx,cs:u_ByteIO
		mov     al,1
		out     dx,al

		mov     bx,0
		mov     cx,0
		mov     al,0AAh
		call    U_Poke

		mov     bx,100h
		mov     cx,0
		mov     al,055h
		call    U_Poke

		mov     bx,0
		mov     cx,0
		call    U_Peek

		push    ax

		mov     dx,cs:u_Command
		mov     al,Initialize
		out     dx,al
		mov     dx,cs:u_ByteIO
		mov     al,0
		out     dx,al

		pop     ax

		cmp     al,0AAh

		ret

CheckULTRA      EndP



; Search UltraSound Baseport ;
;Out: DX,u_Base -> Baseport

SearchBasePort  Proc

		mov     dx,210h-10h
		mov     cx,6
SBPLP:
		add     dx,10h
		mov     cs:u_Base,dx
		push    cx dx
		call    SetUpAddress
		call    CheckUltra
		pop     dx cx
		loopnz  SBPLP

		ret

SearchBasePort  EndP



; Check UltraSound Memory ;
;Out: CX = 1 ->    0kB DRAM
;          2 ->  256kB DRAM
;          3 ->  512kB DRAM
;          4 ->  768kB DRAM
;          5 -> 1024kB DRAM

CheckMemory     Proc

		mov     dx,cs:u_Command
		mov     al,Initialize
		out     dx,al
		mov     dx,cs:u_ByteIO
		mov     al,1
		out     dx,al

		mov     al,0AAh
		mov     bx,0
		mov     cx,4
CMLoop:
		call    U_Poke
		call    U_Peek
		cmp     al,0AAh
		jnz     CMEnd
		add     cx,4
		cmp     cx,(5 shl 2)
		jb      CMLoop
CMEnd:
		shr     cx,2

		ret

CheckMemory     EndP



; Write data into DRAM ;
;In: DS:SI -> BASE RAM address of data
;    EBX   -> GUS DRAM address of data
;    CX    -> max 64kB size of data

RAM2DRAM        Proc

R2DLP:
		lodsb
		push    ebx cx
		mov     cx,bx
		shr     ebx,16
		xchg    bx,cx
		call    u_Poke
		pop     cx ebx
		inc     ebx
		dec     cx
		jnz     R2DLP

		ret

RAM2DRAM        EndP



; Read data from DRAM ;
;In: ES:DI -> BASE RAM address of data
;    EBX   -> GUS DRAM address of data
;    CX    -> max 64kB size of data

DRAM2RAM        Proc

D2RLP:
		push    ebx cx
		mov     cx,bx
		shr     ebx,16
		xchg    bx,cx
		call    u_Peek
		stosb
		pop     cx ebx
		inc     ebx
		dec     cx
		jnz     D2RLP
		ret

DRAM2RAM        EndP



; Reset UltraSound ;

ResetUltraSound Proc

		mov     dx,cs:u_Command
		mov     al,Initialize
		out     dx,al
		mov     dx,cs:u_ByteIO
		mov     al,0
		out     dx,al

		call    u_Delay

		mov     dx,cs:u_Command
		mov     al,Initialize           ;command #4Ch
		out     dx,al
		mov     dx,cs:u_ByteIO
		mov     al,1
		out     dx,al

		call    u_Delay

	;Clear any pending DMA IRQs
		mov     dx,cs:u_Command
		mov     al,DMAControl
		out     dx,al
		mov     dx,cs:u_ByteIO
		xor     al,al
		out     dx,al

		mov     dx,cs:u_Command
		mov     al,TimerControl
		out     dx,al
		mov     dx,cs:u_ByteIO
		xor     al,al
		out     dx,al

		mov     dx,cs:u_Command
		mov     al,SampleControl
		out     dx,al
		mov     dx,cs:u_ByteIO
		xor     al,al
		out     dx,al

		mov     dx,cs:u_Command
		mov     al,VoicesNumber
		out     dx,al
		mov     dx,cs:u_ByteIO
		mov     al,cs:NumberOfVoices
		dec     al
		or      al,0C0h                 ;it must be ORed with 0C0h
		out     dx,al

		mov     dx,cs:u_Status
		in      al,dx

		mov     dx,cs:u_Command
		mov     al,DMAControl
		out     dx,al
		mov     dx,cs:u_ByteIO
		in      al,dx

		mov     dx,cs:u_Command
		mov     al,SampleControl
		out     dx,al
		mov     dx,cs:u_ByteIO
		in      al,dx

		mov     dx,cs:u_Command
		mov     al,R_IRQStatus          ;command #8Fh
		out     dx,al
		mov     dx,cs:u_ByteIO
		in      al,dx


		mov     cx,32                   ;max available voices
VoiceClearLP:
		mov     dx,cs:u_ActiveVoice
		mov     al,cl
		dec     al
		out     dx,al

	;Voice off                
		mov     dx,cs:u_Command
		mov     al,VoiceMode            ;command #00h
		out     dx,al
		mov     dx,cs:u_ByteIO
		mov     al,11b
		out     dx,al

	;Ramp off
		mov     dx,cs:u_Command
		mov     al,VolumeMode           ;command #0Dh
		out     dx,al
		mov     dx,cs:u_ByteIO
		mov     al,11b
		out     dx,al

		loop    VoiceClearLP


		mov     dx,cs:u_Command
		mov     al,DMAControl
		out     dx,al
		mov     dx,cs:u_ByteIO
		in      al,dx

		mov     dx,cs:u_Command
		mov     al,SampleControl        ;command #49h
		out     dx,al
		mov     dx,cs:u_ByteIO
		in      al,dx

		mov     dx,cs:u_Command
		mov     al,R_IRQStatus          ;command #8Fh
		out     dx,al
		mov     dx,cs:u_ByteIO
		in      al,dx

	;UnMute
		mov     dx,cs:u_Command
		mov     al,Initialize
		out     dx,al
		mov     dx,cs:u_ByteIO
		mov     al,111b
		out     dx,al


		mov     cl,cs:NumberOfVoices
SetRampRateLoop:
		mov     dx,cs:u_ActiveVoice
		mov     al,cs:NumberOfVoices
		sub     al,cl
		out     dx,al

	;Set ramprate
		mov     dx,cs:u_Command
		mov     al,VolRampRate
		out     dx,al
		mov     al,00111111b
		mov     dx,cs:u_ByteIO
		out     dx,al

	;Set volume
		mov     dx,cs:u_Command
		mov     al,VoiceVolume
		out     dx,al
		mov     dx,cs:u_WordIO
		xor     ax,ax
		out     dx,ax
		dec     cl
		jnz     SetRampRateLoop

		mov     dx,cs:u_Base
		mov     ax,000b    ;line in on, output on, mic in off
		out     dx,ax

		ret

ResetUltraSound EndP



; UltraSound Commands ;

;Write
VoiceMode       Equ 0h
VoiceFreq       Equ 1h
LoopStartLo     Equ 2h
LoopStartHi     Equ 3h
LoopEndLo       Equ 4h
LoopEndHi       Equ 5h
VolRampRate     Equ 6h
VolRampStart    Equ 7h
VolRampEnd      Equ 8h
VoiceVolume     Equ 9h
LoopBeginLo     Equ 0Ah ;place of sample in DRAM 
LoopBeginHi     Equ 0Bh
VoiceBalance    Equ 0Ch
VolumeMode      Equ 0Dh
VoicesNumber    Equ 0Eh
DMAControl      Equ 41h
DRAMLo          Equ 43h
DRAMHi          Equ 44h
TimerControl    Equ 45h
TimerSpeed      Equ 46h
SamplingFreq    Equ 48h
SampleControl   Equ 49h
Initialize      Equ 4Ch ;very important

;Read
;it is added 80h to basic commands,
;f.example. Write BeginLocationsLo of sample is 0A
;           Read BeginLocationsLo of sample is 0A+80=8A
R_VoiceMode     Equ 80h
R_VoiceFreq     Equ 81h
R_LoopStartLo   Equ 82h
R_LoopStartHi   Equ 83h
R_LoopEndLo     Equ 84h
R_LoopEndHi     Equ 85h
R_VolRampRate   Equ 86h
R_VolRampStart  Equ 87h
R_VolRampEnd    Equ 88h
R_Volume        Equ 89h
R_LoopBeginLo   Equ 8Ah
R_LoopBeginHi   Equ 8Bh
R_VoiceBalance  Equ 8Ch
R_VolumeMode    Equ 8Dh
R_NumberVoices  Equ 8Eh
R_IRQStatus     Equ 8Fh


; Divisors values ;

Voice14         Equ 43 ;for 14 active voices
Voice15         Equ 40
Voice16         Equ 37
Voice17         Equ 35
Voice18         Equ 33
Voice19         Equ 31
Voice20         Equ 30
Voice21         Equ 28
Voice22         Equ 27
Voice23         Equ 26
Voice24         Equ 25
Voice25         Equ 24
Voice26         Equ 23
Voice27         Equ 22
Voice28         Equ 21
Voice29         Equ 20
Voice30         Equ 20
Voice31         Equ 19
Voice32         Equ 18


; Log Volume 0..64 ;

GUSVolume       Label
	dw      0
	dw      09300h,0A900h,0B400h,0BC00h,0C180h,0C580h,0C980h,0CD80h
	dw      0CF40h,0D240h,0D440h,0D640h,0D840h,0DA40h,0DC40h,0DE40h
	dw      0DEF0h,0DFA0h,0E1A0h,0E2A0h,0E3A0h,0E4A0h,0E5A0h,0E6A0h
	dw      0E7A0h,0E8A0h,0E9A0h,0EAA0h,0EBA0h,0ECA0h,0EDA0h,0EEA0h
	dw      0EEF0h,0EFE0h,0EF60h,0F1E0h,0F160h,0F1E0h,0F260h,0F2E0h
	dw      0F360h,0F3E0h,0F460h,0F4E0h,0F560h,0F5E0h,0F660h,0F6E0h
	dw      0F760h,0F7E0h,0F860h,0F8E0h,0F960h,0F9E0h,0FA60h,0FAF0h
	dw      0FB70h,0FBF0h,0FC70h,0FCF0h,0FD70h,0FD90h,0FDB0h,0FDD0h



; Channels Balances ;

Bal4Ch          db  4,11,11, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0      ;4
Bal6Ch          db  4, 4,11,11,11, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0      ;6
Bal8Ch          db  4, 4, 4,11,11, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0      ;8
Bal10Ch         db  4, 4, 4,11,11,11,11, 4, 4, 4, 0, 0, 0, 0, 0, 0      ;10
Bal12Ch         db  4, 4, 4, 4,11,11,11,11, 4, 4, 4, 4, 0, 0, 0, 0      ;12
Bal14Ch         db  4, 4, 4, 4,11,11,11,11,11,11, 4, 4, 4, 4, 0, 0      ;14

ChanBal         Label   Byte
		dw 0            ;0
		dw 0            ;1
		dw 0            ;2
		dw 0            ;3
		dw Bal4Ch       ;4
		dw 0            ;5
		dw Bal6Ch       ;6
		dw 0            ;7
		dw Bal8Ch       ;8
		dw 0            ;9
		dw Bal10Ch      ;10
		dw 0            ;11
		dw Bal12Ch      ;12
		dw 0            ;13
		dw Bal14Ch      ;14


u_Base          dw 0    ;base
u_Status        dw 0    ;base+6
u_ActiveVoice   dw 0    ;base+102h
u_Command       dw 0    ;base+103h
u_WordIO        dw 0    ;base+104h
u_ByteIO        dw 0    ;base+105h
u_DRAMIO        dw 0    ;base+107h

u_Divisor       dw Voice14
NumberOfVoices  db 14

;current voice - information
Voice           db ?
VStart          dd ?
VBegin          dd ?
VEnd            dd ?
Mode            db ?
Balance         db ?
MasterVolume    db ?
Volume          db ?

;;
;                     Advanced Gravis UltraSound Routines                    ;
;                         Coded by Jim Goer, (c) 1996                        ;
;;
